/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.diskimages;

import java.util.Arrays;

public class DiskIDAlgorithm {
    long chainingStateA;
    long chainingStateB;
    long chainingStateC;
    long chainingStateD;
    long modifiersA = 32L;
    long modifiersB = -4323455642275676160L;
    byte[] partialBuffer = new byte[32];
    boolean nonzeroFlag;
    int partialBufferFill = 0;
    int dataSoFar = 0;
    private static final int BUFFER = 32;

    public DiskIDAlgorithm() {
        this.partialBuffer[0] = 83;
        this.partialBuffer[1] = 72;
        this.partialBuffer[2] = 65;
        this.partialBuffer[3] = 51;
        this.partialBuffer[4] = 1;
        this.partialBuffer[8] = -128;
        this.transform();
        if (this.chainingStateA != 3472133073007534817L || this.chainingStateB != -5916489410377714389L || this.chainingStateC != -7539875978113668342L || this.chainingStateD != 3095303997187290459L) {
            System.err.println("PANIC: IV calculated value incorrect.");
        }
    }

    private void transform() {
        long l;
        int n;
        long[] lArray = new long[4];
        for (n = 0; n < 32; ++n) {
            l = (long)this.partialBuffer[n] & 0xFFL;
            int n2 = n / 8;
            lArray[n2] = lArray[n2] | l << 8 * (n % 8);
        }
        l = lArray[0];
        long l2 = lArray[1];
        long l3 = lArray[2];
        long l4 = lArray[3];
        long l5 = this.chainingStateA;
        long l6 = this.chainingStateB;
        long l7 = this.chainingStateC;
        long l8 = this.chainingStateD;
        long l9 = l5 ^ l6 ^ l7 ^ l8 ^ 0x5555555555555555L;
        long l10 = this.modifiersA;
        long l11 = this.modifiersB;
        long l12 = l10 ^ l11;
        int n3 = 0;
        l += l5;
        l2 += l6 + l10;
        l3 += l7 + l11;
        l4 += l8 + (long)n3;
        for (n = 0; n < 9; ++n) {
            l += l2;
            l2 = l2 << 5 | l2 >>> 59;
            l2 ^= l;
            l3 += l4;
            l4 = l4 << 56 | l4 >>> 8;
            l += (l4 ^= l3);
            l4 = l4 << 36 | l4 >>> 28;
            l4 ^= l;
            l3 += l2;
            l2 = l2 << 28 | l2 >>> 36;
            l += (l2 ^= l3);
            l2 = l2 << 13 | l2 >>> 51;
            l2 ^= l;
            l3 += l4;
            l4 = l4 << 46 | l4 >>> 18;
            l += (l4 ^= l3);
            l4 = l4 << 58 | l4 >>> 6;
            l4 ^= l;
            l3 += l2;
            l2 = l2 << 44 | l2 >>> 20;
            l2 ^= l3;
            l += l6;
            l3 += l8 + l12;
            l += (l2 += l7 + l11);
            l2 = l2 << 26 | l2 >>> 38;
            l2 ^= l;
            l3 += (l4 += l9 + (long)(++n3));
            l4 = l4 << 20 | l4 >>> 44;
            l += (l4 ^= l3);
            l4 = l4 << 53 | l4 >>> 11;
            l4 ^= l;
            l3 += l2;
            l2 = l2 << 35 | l2 >>> 29;
            l += (l2 ^= l3);
            l2 = l2 << 11 | l2 >>> 53;
            l2 ^= l;
            l3 += l4;
            l4 = l4 << 42 | l4 >>> 22;
            l += (l4 ^= l3);
            l4 = l4 << 59 | l4 >>> 5;
            l4 ^= l;
            l3 += l2;
            l2 = l2 << 50 | l2 >>> 14;
            l2 ^= l3;
            l += l7;
            l2 += l8 + l12;
            l3 += l9 + l10;
            l4 += l5 + (long)(++n3);
            long l13 = l12;
            l12 = l11;
            l11 = l10;
            l10 = l13;
            l13 = l8;
            l8 = l5;
            l5 = l7;
            l7 = l9;
            l9 = l6;
            l6 = l13;
        }
        this.chainingStateA = lArray[0] ^ l;
        this.chainingStateB = lArray[1] ^ l2;
        this.chainingStateC = lArray[2] ^ l3;
        this.chainingStateD = lArray[3] ^ l4;
        Arrays.fill(this.partialBuffer, (byte)0);
        this.nonzeroFlag = false;
    }

    private void transformZeroes() {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = this.chainingStateA;
        long l6 = this.chainingStateB;
        long l7 = this.chainingStateC;
        long l8 = this.chainingStateD;
        long l9 = l5 ^ l6 ^ l7 ^ l8 ^ 0x5555555555555555L;
        long l10 = this.modifiersA;
        long l11 = this.modifiersB;
        long l12 = l10 ^ l11;
        int n = 0;
        l += l5;
        l2 += l6 + l10;
        l3 += l7 + l11;
        l4 += l8 + (long)n;
        for (int i = 0; i < 9; ++i) {
            l += l2;
            l2 = l2 << 5 | l2 >>> 59;
            l2 ^= l;
            l3 += l4;
            l4 = l4 << 56 | l4 >>> 8;
            l += (l4 ^= l3);
            l4 = l4 << 36 | l4 >>> 28;
            l4 ^= l;
            l3 += l2;
            l2 = l2 << 28 | l2 >>> 36;
            l += (l2 ^= l3);
            l2 = l2 << 13 | l2 >>> 51;
            l2 ^= l;
            l3 += l4;
            l4 = l4 << 46 | l4 >>> 18;
            l += (l4 ^= l3);
            l4 = l4 << 58 | l4 >>> 6;
            l4 ^= l;
            l3 += l2;
            l2 = l2 << 44 | l2 >>> 20;
            l2 ^= l3;
            l += l6;
            l3 += l8 + l12;
            l += (l2 += l7 + l11);
            l2 = l2 << 26 | l2 >>> 38;
            l2 ^= l;
            l3 += (l4 += l9 + (long)(++n));
            l4 = l4 << 20 | l4 >>> 44;
            l += (l4 ^= l3);
            l4 = l4 << 53 | l4 >>> 11;
            l4 ^= l;
            l3 += l2;
            l2 = l2 << 35 | l2 >>> 29;
            l += (l2 ^= l3);
            l2 = l2 << 11 | l2 >>> 53;
            l2 ^= l;
            l3 += l4;
            l4 = l4 << 42 | l4 >>> 22;
            l += (l4 ^= l3);
            l4 = l4 << 59 | l4 >>> 5;
            l4 ^= l;
            l3 += l2;
            l2 = l2 << 50 | l2 >>> 14;
            l2 ^= l3;
            l += l7;
            l2 += l8 + l12;
            l3 += l9 + l10;
            l4 += l5 + (long)(++n);
            long l13 = l12;
            l12 = l11;
            l11 = l10;
            l10 = l13;
            l13 = l8;
            l8 = l5;
            l5 = l7;
            l7 = l9;
            l9 = l6;
            l6 = l13;
        }
        this.chainingStateA = l;
        this.chainingStateB = l2;
        this.chainingStateC = l3;
        this.chainingStateD = l4;
    }

    private void collapse(boolean bl) {
        boolean bl2 = this.dataSoFar == 0;
        this.dataSoFar += this.partialBufferFill;
        this.partialBufferFill = 0;
        this.modifiersB = 0x3000000000000000L;
        this.modifiersA = this.dataSoFar;
        if (bl2) {
            this.modifiersB |= 0x4000000000000000L;
        }
        if (bl) {
            this.modifiersB |= Long.MIN_VALUE;
        }
        if (this.nonzeroFlag) {
            this.transform();
        } else {
            this.transformZeroes();
        }
    }

    private void outputTransform() {
        this.modifiersB = -72057594037927936L;
        this.modifiersA = 8L;
        this.transformZeroes();
    }

    public void addBuffer(byte[] byArray) {
        this.addBuffer(byArray, 0, byArray.length);
    }

    public void addBuffer(byte[] byArray, int n, int n2) {
        while (n2 > 0) {
            if (this.partialBufferFill == 32) {
                this.collapse(false);
            }
            if (this.partialBufferFill + n2 <= 32) {
                System.arraycopy(byArray, n, this.partialBuffer, this.partialBufferFill, n2);
                n += n2;
                this.partialBufferFill += n2;
                n2 = 0;
                this.nonzeroFlag = true;
                continue;
            }
            System.arraycopy(byArray, n, this.partialBuffer, this.partialBufferFill, 32 - this.partialBufferFill);
            n += 32 - this.partialBufferFill;
            n2 -= 32 - this.partialBufferFill;
            this.partialBufferFill = 32;
            this.nonzeroFlag = true;
        }
    }

    public void addZeroes(int n) {
        while (n > 0) {
            if (this.partialBufferFill == 32) {
                this.collapse(false);
            }
            if (this.partialBufferFill + n <= 32) {
                if (this.nonzeroFlag) {
                    Arrays.fill(this.partialBuffer, this.partialBufferFill, this.partialBufferFill + n, (byte)0);
                }
                this.partialBufferFill += n;
                n = 0;
                continue;
            }
            if (this.nonzeroFlag) {
                Arrays.fill(this.partialBuffer, this.partialBufferFill, 32, (byte)0);
            }
            n -= 32 - this.partialBufferFill;
            this.partialBufferFill = 32;
        }
    }

    public byte[] getFinalOutput() {
        this.collapse(true);
        this.outputTransform();
        byte[] byArray = new byte[16];
        for (int i = 0; i < 8; ++i) {
            byArray[i] = (byte)(this.chainingStateA >>> 8 * (i % 8));
            byArray[i + 8] = (byte)(this.chainingStateB >>> 8 * (i % 8));
        }
        return byArray;
    }

    public String getFinalOutputString() {
        byte[] byArray = this.getFinalOutput();
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        StringBuffer stringBuffer = new StringBuffer(32);
        for (int i = 0; i < 16; ++i) {
            int n = byArray[i] & 0xFF;
            stringBuffer.append(cArray[n / 16]);
            stringBuffer.append(cArray[n % 16]);
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        byte[] byArray = new byte[1024];
        long l = System.currentTimeMillis();
        DiskIDAlgorithm diskIDAlgorithm = new DiskIDAlgorithm();
        for (int i = 0; i < 131072; ++i) {
            diskIDAlgorithm.addBuffer(byArray);
        }
        long l2 = System.currentTimeMillis();
        System.err.println("Answer " + diskIDAlgorithm.getFinalOutputString() + " calculated in " + (l2 - l) + "ms.");
        l = System.currentTimeMillis();
        diskIDAlgorithm = new DiskIDAlgorithm();
        for (int i = 0; i < 131072; ++i) {
            diskIDAlgorithm.addZeroes(1024);
        }
        l2 = System.currentTimeMillis();
        System.err.println("Answer " + diskIDAlgorithm.getFinalOutputString() + " calculated in " + (l2 - l) + "ms.");
    }
}

