/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.diskimages;

import java.io.IOException;
import org.jpc.diskimages.BlockDevice;
import org.jpc.diskimages.DiskImage;
import org.jpc.emulator.SRDumpable;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;

public class DiskImageSet
implements SRDumpable {
    private DiskImage[] disks;
    private int diskCount;
    private int lowestGap;

    public DiskImageSet() {
        this.disks = new DiskImage[5];
        this.diskCount = 0;
        this.lowestGap = 0;
    }

    public int addDisk(DiskImage diskImage) {
        if (diskImage == null) {
            return -1;
        }
        int n = this.lowestGap;
        if (this.diskCount == this.disks.length) {
            DiskImage[] diskImageArray = new DiskImage[2 * this.disks.length];
            System.arraycopy(this.disks, 0, diskImageArray, 0, this.disks.length);
            this.disks = diskImageArray;
            n = this.diskCount;
        }
        int n2 = n;
        while (n2 < this.disks.length) {
            if (this.disks[n2] == null) {
                this.disks[n2] = diskImage;
                ++this.diskCount;
                this.lowestGap = n2 + 1;
                return n2;
            }
            this.lowestGap = n2++;
        }
        return -1;
    }

    public void addDisk(int n, DiskImage diskImage) {
        while (n >= this.disks.length) {
            DiskImage[] diskImageArray = new DiskImage[2 * this.disks.length];
            System.arraycopy(this.disks, 0, diskImageArray, 0, this.disks.length);
            this.disks = diskImageArray;
        }
        if (this.disks[n] == null && diskImage != null) {
            ++this.diskCount;
        }
        if (this.lowestGap == n && diskImage != null) {
            ++this.lowestGap;
        } else if (this.lowestGap > n && diskImage == null) {
            this.lowestGap = n;
        }
        this.disks[n] = diskImage;
    }

    public DiskImage lookupDisk(int n) {
        if (n == -1) {
            return null;
        }
        try {
            return this.disks[n];
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int[] diskIndicesByType(BlockDevice.Type type) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.disks.length; ++i) {
            if (this.disks[i] == null || this.disks[i].getType() != type) continue;
            ++n;
        }
        int[] nArray = new int[n];
        for (int i = 0; i < this.disks.length; ++i) {
            if (this.disks[i] == null || this.disks[i].getType() != type) continue;
            nArray[n2++] = i;
        }
        return nArray;
    }

    public int getDiskCount() {
        return this.diskCount;
    }

    public int highestDiskIndex() {
        return this.disks.length - 1;
    }

    public void dumpStatusPartial(StatusDumper statusDumper) {
        statusDumper.println("\tdiskCount " + this.diskCount + " lowestGap " + this.lowestGap);
        for (int i = 0; i < this.disks.length; ++i) {
            statusDumper.println("\tdisks[" + i + "] <object #" + statusDumper.objectNumber(this.disks[i]) + ">");
            if (this.disks[i] == null) continue;
            this.disks[i].dumpStatus(statusDumper);
        }
    }

    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": DiskImageSet:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        sRDumper.dumpInt(this.diskCount);
        sRDumper.dumpInt(this.lowestGap);
        sRDumper.dumpInt(this.disks.length);
        for (int i = 0; i < this.disks.length; ++i) {
            sRDumper.dumpObject(this.disks[i]);
        }
    }

    public DiskImageSet(SRLoader sRLoader) throws IOException {
        sRLoader.objectCreated(this);
        this.diskCount = sRLoader.loadInt();
        this.lowestGap = sRLoader.loadInt();
        this.disks = new DiskImage[sRLoader.loadInt()];
        for (int i = 0; i < this.disks.length; ++i) {
            this.disks[i] = (DiskImage)sRLoader.loadObject();
        }
    }
}

