/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.diskimages;

import java.io.IOException;
import org.jpc.diskimages.BlockDevice;
import org.jpc.diskimages.DiskImage;
import org.jpc.emulator.SRDumpable;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;

public class GenericBlockDevice
implements BlockDevice,
SRDumpable {
    private DiskImage image;
    private boolean isLocked;
    private BlockDevice.Type diskType;

    public void dumpStatusPartial(StatusDumper statusDumper) {
        statusDumper.println("\tdiskType " + (Object)((Object)this.diskType) + " isLocked " + this.isLocked);
        statusDumper.println("\timage <object #" + statusDumper.objectNumber(this.image) + ">");
        if (this.image != null) {
            this.image.dumpStatus(statusDumper);
        }
    }

    @Override
    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": GenericBlockDevice:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        sRDumper.dumpObject(this.image);
        sRDumper.dumpBoolean(this.isLocked);
        switch (this.diskType) {
            case FLOPPY: {
                sRDumper.dumpByte((byte)0);
                break;
            }
            case HARDDRIVE: {
                sRDumper.dumpByte((byte)1);
                break;
            }
            case CDROM: {
                sRDumper.dumpByte((byte)2);
            }
        }
    }

    public GenericBlockDevice(SRLoader sRLoader) throws IOException {
        sRLoader.objectCreated(this);
        this.image = (DiskImage)sRLoader.loadObject();
        this.isLocked = sRLoader.loadBoolean();
        byte by = sRLoader.loadByte();
        switch (by) {
            case 0: {
                this.diskType = BlockDevice.Type.FLOPPY;
                break;
            }
            case 1: {
                this.diskType = BlockDevice.Type.HARDDRIVE;
                break;
            }
            case 2: {
                this.diskType = BlockDevice.Type.CDROM;
                break;
            }
            case 3: {
                throw new IOException("Invalid disk type in GenericBlockDevice.");
            }
        }
    }

    public GenericBlockDevice(BlockDevice.Type type) {
        this.diskType = type;
        this.isLocked = false;
        this.image = null;
    }

    public GenericBlockDevice(DiskImage diskImage) throws IOException {
        this.diskType = diskImage.getType();
        this.isLocked = false;
        this.image = diskImage;
        this.image.use();
    }

    public GenericBlockDevice(DiskImage diskImage, BlockDevice.Type type) throws IOException {
        if (diskImage != null && diskImage.getType() != type) {
            throw new IOException("Disk is of wrong type.");
        }
        this.diskType = type;
        this.isLocked = false;
        this.image = diskImage;
        if (this.image != null) {
            this.image.use();
        }
    }

    public byte[] getImageID() {
        if (this.image != null) {
            return this.image.getImageID();
        }
        return null;
    }

    @Override
    public void close() {
        this.image.unuse();
        this.image = null;
    }

    @Override
    public int read(long l, byte[] byArray, int n) {
        if (this.image != null) {
            return this.image.read(l, byArray, n);
        }
        return -1;
    }

    @Override
    public int write(long l, byte[] byArray, int n) {
        if (this.image != null) {
            return this.image.write(l, byArray, n);
        }
        return -1;
    }

    @Override
    public boolean isInserted() {
        return this.image != null;
    }

    @Override
    public boolean isLocked() {
        return this.isLocked;
    }

    @Override
    public boolean isReadOnly() {
        if (this.image != null) {
            return this.image.isReadOnly();
        }
        return false;
    }

    @Override
    public void setLock(boolean bl) {
        this.isLocked = bl;
    }

    @Override
    public long getTotalSectors() {
        if (this.image != null) {
            return this.image.getTotalSectors();
        }
        return 0L;
    }

    @Override
    public int getCylinders() {
        if (this.image != null) {
            return this.image.getCylinders();
        }
        return 0;
    }

    @Override
    public int getHeads() {
        if (this.image != null) {
            return this.image.getHeads();
        }
        return 0;
    }

    @Override
    public int getSectors() {
        if (this.image != null) {
            return this.image.getSectors();
        }
        return 0;
    }

    @Override
    public BlockDevice.Type getType() {
        return this.diskType;
    }

    public String getImageFileName() {
        if (this.image != null) {
            return this.image.getImageFileName();
        }
        return null;
    }

    @Override
    public void configure(String string) throws IOException {
        DiskImage diskImage = new DiskImage(string, false);
        this.configure(diskImage);
    }

    public void configure(DiskImage diskImage) throws IOException {
        if (diskImage != null && diskImage.getType() != this.diskType) {
            throw new IOException("Trying to put disk of wrong type to drive.");
        }
        if (this.isLocked) {
            throw new IOException("Can not change disk in locked drive.");
        }
        if (this.image != null) {
            this.image.unuse();
        }
        this.image = diskImage;
        if (this.image != null) {
            this.image.use();
        }
    }

    @Override
    public DiskImage getImage() {
        return this.image;
    }
}

