/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.diskimages;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.jpc.diskimages.RawDiskImage;

public class ImageFormats {
    static DiskImageType[] savers = new DiskImageType[]{new NormalDiskImage(), new SectorMapDiskImage(), new ExtentDiskImage(), new ExtentDiskImage()};

    static class ExtentDiskImage
    extends DiskImageType {
        ExtentDiskImage() {
        }

        @Override
        public int saveSize(int n, int[] nArray, int n2, int n3) throws Exception {
            if ((n & 1) != (nArray[0] & 1)) {
                throw new Exception("Sector 0 wrong type for method.");
            }
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = -1;
            n5 = 4;
            if (n3 <= 0x1000000) {
                n5 = 3;
            }
            if (n3 <= 65536) {
                n5 = 2;
            }
            if (n3 <= 256) {
                n5 = 1;
            }
            for (int i = 0; i < n3; ++i) {
                boolean bl;
                boolean bl2 = bl = (nArray[i / 31] & 1 << i % 31) != 0;
                if (bl) {
                    ++n6;
                }
                if (bl && n7 != 1) {
                    n4 += n5;
                    n7 = 1;
                }
                if (bl || n7 == 0) continue;
                n4 += n5;
                n7 = 0;
            }
            return 512 * n6 + n4;
        }

        @Override
        public void save(int n, int[] nArray, RawDiskImage rawDiskImage, int n2, int n3, RandomAccessFile randomAccessFile) throws IOException {
            if ((n & 1) != (nArray[0] & 1)) {
                throw new IOException("Sector 0 wrong type for method.");
            }
            int n4 = 0;
            n4 = 4;
            if (n3 <= 0x1000000) {
                n4 = 3;
            }
            if (n3 <= 65536) {
                n4 = 2;
            }
            if (n3 <= 256) {
                n4 = 1;
            }
            byte[] byArray = new byte[n4];
            int n5 = 0;
            byte[] byArray2 = new byte[512];
            for (int i = 0; i < n3; ++i) {
                if (i == n5) {
                    int n6;
                    int n7 = i;
                    boolean bl = (nArray[i / 31] & 1 << i % 31) != 0;
                    n5 = n3;
                    for (n6 = i + 1; n6 < n3; ++n6) {
                        boolean bl2;
                        boolean bl3 = bl2 = (nArray[n6 / 31] & 1 << n6 % 31) != 0;
                        if (bl2 == bl) continue;
                        n5 = n6;
                        break;
                    }
                    n6 = n5 - n7 - 1;
                    byArray[0] = (byte)(n6 & 0xFF);
                    if (n4 > 1) {
                        byArray[1] = (byte)(n6 >>> 8 & 0xFF);
                    }
                    if (n4 > 2) {
                        byArray[2] = (byte)(n6 >>> 16 & 0xFF);
                    }
                    if (n4 > 3) {
                        byArray[3] = (byte)(n6 >>> 24 & 0xFF);
                    }
                    randomAccessFile.write(byArray);
                }
                if ((nArray[i / 31] & 1 << i % 31) == 0) continue;
                rawDiskImage.readSector(i, byArray2);
                randomAccessFile.write(byArray2);
            }
        }

        @Override
        public int[] loadSectorMap(RandomAccessFile randomAccessFile, int n, int n2, int[] nArray) throws IOException {
            int n3 = nArray[0];
            int[] nArray2 = new int[n2];
            randomAccessFile.seek(n3);
            boolean bl = (n & 1) == 0;
            int n4 = 0;
            n4 = 4;
            if (n2 <= 0x1000000) {
                n4 = 3;
            }
            if (n2 <= 65536) {
                n4 = 2;
            }
            if (n2 <= 256) {
                n4 = 1;
            }
            byte[] byArray = new byte[n4];
            int n5 = 0;
            for (int i = 0; i < n2; ++i) {
                if (i == n5) {
                    randomAccessFile.seek(n3);
                    if (randomAccessFile.read(byArray) != byArray.length) {
                        throw new IOException("Can't read disk image extent.");
                    }
                    n5 = i + 1 + (byArray[0] & 0xFF);
                    if (n4 > 1) {
                        n5 += (byArray[1] & 0xFF) << 8;
                    }
                    if (n4 > 2) {
                        n5 += (byArray[2] & 0xFF) << 16;
                    }
                    if (n4 > 3) {
                        n5 += (byArray[3] & 0xFF) << 24;
                    }
                    n3 += n4;
                    boolean bl2 = bl = !bl;
                }
                if (!bl) continue;
                nArray2[i] = n3;
                n3 += 512;
            }
            nArray[0] = n3;
            return nArray2;
        }
    }

    static class SectorMapDiskImage
    extends DiskImageType {
        SectorMapDiskImage() {
        }

        @Override
        public int saveSize(int n, int[] nArray, int n2, int n3) throws Exception {
            int n4 = (n3 + 7) / 8;
            int n5 = 0;
            for (int i = 0; i < n3; ++i) {
                if ((nArray[i / 31] & 1 << i % 31) == 0) continue;
                ++n5;
            }
            return 512 * n5 + n4;
        }

        @Override
        public void save(int n, int[] nArray, RawDiskImage rawDiskImage, int n2, int n3, RandomAccessFile randomAccessFile) throws IOException {
            byte[] byArray = new byte[(n3 + 7) / 8];
            for (int i = 0; i < n3; ++i) {
                if ((nArray[i / 31] & 1 << i % 31) == 0) continue;
                int n4 = i / 8;
                byArray[n4] = (byte)(byArray[n4] | (byte)(1 << i % 8));
            }
            randomAccessFile.write(byArray);
            byte[] byArray2 = new byte[512];
            for (int i = 0; i < n3; ++i) {
                if ((nArray[i / 31] & 1 << i % 31) == 0) continue;
                rawDiskImage.readSector(i, byArray2);
                randomAccessFile.write(byArray2);
            }
        }

        @Override
        public int[] loadSectorMap(RandomAccessFile randomAccessFile, int n, int n2, int[] nArray) throws IOException {
            int n3 = nArray[0];
            byte[] byArray = new byte[(n2 + 7) / 8];
            randomAccessFile.seek(n3);
            if (randomAccessFile.read(byArray) != byArray.length) {
                throw new IOException("Can't read disk image sector map.");
            }
            n3 += byArray.length;
            int[] nArray2 = new int[n2];
            for (int i = 0; i < n2; ++i) {
                if ((byArray[i / 8] & 1 << i % 8) == 0) continue;
                nArray2[i] = n3;
                n3 += 512;
            }
            nArray[0] = n3;
            return nArray2;
        }
    }

    static class NormalDiskImage
    extends DiskImageType {
        NormalDiskImage() {
        }

        @Override
        public int saveSize(int n, int[] nArray, int n2, int n3) throws Exception {
            return 512 * n3;
        }

        @Override
        public void save(int n, int[] nArray, RawDiskImage rawDiskImage, int n2, int n3, RandomAccessFile randomAccessFile) throws IOException {
            byte[] byArray = new byte[512];
            for (int i = 0; i < n3; ++i) {
                rawDiskImage.readSector(i, byArray);
                randomAccessFile.write(byArray);
            }
        }

        @Override
        public int[] loadSectorMap(RandomAccessFile randomAccessFile, int n, int n2, int[] nArray) throws IOException {
            int n3 = nArray[0];
            int[] nArray2 = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray2[i] = 512 * i + n3;
            }
            nArray[0] = nArray[0] + 512 * n2;
            return nArray2;
        }
    }

    static abstract class DiskImageType {
        DiskImageType() {
        }

        public abstract int saveSize(int var1, int[] var2, int var3, int var4) throws Exception;

        public abstract void save(int var1, int[] var2, RawDiskImage var3, int var4, int var5, RandomAccessFile var6) throws IOException;

        public abstract int[] loadSectorMap(RandomAccessFile var1, int var2, int var3, int[] var4) throws IOException;
    }
}

