/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.diskimages;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ImageLibrary {
    private String directoryPrefix;
    HashMap<ByteArray, String> idToFile = new HashMap();
    HashMap<String, ByteArray> fileToID = new HashMap();
    HashMap<ByteArray, Byte> idToType = new HashMap();

    public String getPathPrefix() {
        return this.directoryPrefix;
    }

    public ImageLibrary() {
    }

    private void recursiveHandleDirectory(String string, String string2, File file) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            String string3 = this.directoryPrefix + string2 + file2.getName();
            String string4 = string + file2.getName();
            try {
                if (file2.isDirectory()) {
                    this.recursiveHandleDirectory(string + file2.getName() + "/", string2 + file2.getName() + File.separator, file2);
                    continue;
                }
                if (!file2.isFile()) continue;
                this.insertFileName(null, string3, string4);
                continue;
            }
            catch (IOException iOException) {
                System.err.println("Can't load \"" + file2.getName() + "\": " + iOException.getMessage());
            }
        }
    }

    public ImageLibrary(String string) throws IOException {
        File file = new File(string);
        if (!file.exists()) {
            throw new IOException("Libary directory \"" + string + "\" does not exist.");
        }
        if (!file.isDirectory()) {
            throw new IOException("Libary directory \"" + string + "\" is not directory.");
        }
        this.directoryPrefix = file.getAbsolutePath() + File.separator;
        this.recursiveHandleDirectory("", "", file);
    }

    public String lookupFileName(String string) {
        if (!this.fileToID.containsKey(string)) {
            return null;
        }
        return this.directoryPrefix + string;
    }

    public String lookupFileName(byte[] byArray) {
        ByteArray byteArray = new ByteArray(byArray);
        if (!this.idToFile.containsKey(byteArray)) {
            return null;
        }
        return this.idToFile.get(byteArray);
    }

    private boolean validHexChar(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return true;
            }
        }
        return false;
    }

    public String searchFileName(String string) {
        String string2 = null;
        boolean bl = true;
        if ((string.length() & 1) == 0) {
            byte[] byArray = new byte[string.length() / 2];
            for (int i = 0; i < string.length() / 2; ++i) {
                char c = string.charAt(2 * i);
                char c2 = string.charAt(2 * i);
                if (!this.validHexChar(c)) {
                    bl = false;
                }
                if (!this.validHexChar(c2)) {
                    bl = false;
                }
                byArray[i] = (byte)(Character.digit(string.charAt(2 * i), 16) * 16 + Character.digit(string.charAt(2 * i + 1), 16));
            }
            if (bl) {
                string2 = this.lookupFileName(byArray);
            }
            if (string2 != null) {
                return string2;
            }
        }
        return this.lookupFileName(string);
    }

    public byte[] canonicalNameFor(String string) {
        if (string == null) {
            return null;
        }
        if (this.fileToID.containsKey(string)) {
            return this.fileToID.get(string).toByteArray();
        }
        if ((string.length() & 1) != 0) {
            return null;
        }
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < string.length() / 2; ++i) {
            byArray[i] = (byte)(Character.digit(string.charAt(2 * i), 16) * 16 + Character.digit(string.charAt(2 * i + 1), 16));
        }
        ByteArray byteArray = new ByteArray(byArray);
        if (!this.idToFile.containsKey(byteArray)) {
            return null;
        }
        return byArray;
    }

    public void insertFileName(ByteArray byteArray, String string, String string2) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
        ByteArray byteArray2 = ImageLibrary.getIdentifierForImageAsArray(randomAccessFile, string);
        if (byteArray == null) {
            byteArray = byteArray2;
        }
        this.idToFile.put(byteArray, string);
        this.fileToID.put(string2, byteArray);
        byte by = ImageLibrary.getTypeForImage(randomAccessFile, string);
        this.idToType.put(byteArray2, new Byte(by));
        randomAccessFile.close();
        System.err.println("Notice: " + string2 + " -> " + byteArray.toString() + " -> " + string + ".");
    }

    public static byte[] getIdentifierForImage(RandomAccessFile randomAccessFile, String string) throws IOException {
        byte[] byArray = new byte[21];
        randomAccessFile.seek(0L);
        if (randomAccessFile.read(byArray) < 21 || byArray[0] != 73 || byArray[1] != 77 || byArray[2] != 65 || byArray[3] != 71 || byArray[4] != 69) {
            throw new IOException(string + " is not image file.");
        }
        byte[] byArray2 = new byte[16];
        for (int i = 0; i < 16; ++i) {
            byArray2[i] = byArray[i + 5];
        }
        return byArray2;
    }

    public static ByteArray getIdentifierForImageAsArray(RandomAccessFile randomAccessFile, String string) throws IOException {
        return new ByteArray(ImageLibrary.getIdentifierForImage(randomAccessFile, string));
    }

    public static byte getTypeForImage(RandomAccessFile randomAccessFile, String string) throws IOException {
        byte[] byArray = new byte[1];
        randomAccessFile.seek(21L);
        if (randomAccessFile.read(byArray) < 1) {
            throw new IOException(string + " is not image file.");
        }
        return byArray[0];
    }

    public String[] imagesByType(long l) {
        String[] stringArray = new String[10];
        int n = 0;
        if ((l & 1L) != 0L) {
            if (n == stringArray.length) {
                stringArray = Arrays.copyOf(stringArray, 2 * stringArray.length);
            }
            stringArray[n++] = "";
        }
        for (Map.Entry<String, ByteArray> entry : this.fileToID.entrySet()) {
            byte by = this.idToType.get(entry.getValue());
            if ((l & (long)(2 << by)) == 0L) continue;
            if (n == stringArray.length) {
                stringArray = Arrays.copyOf(stringArray, 2 * stringArray.length);
            }
            stringArray[n++] = entry.getKey();
        }
        if (n == 0) {
            return null;
        }
        stringArray = Arrays.copyOf(stringArray, n);
        Arrays.sort(stringArray, null);
        return stringArray;
    }

    public static class ByteArray {
        private byte[] content;

        public ByteArray(byte[] byArray) {
            this.content = byArray;
        }

        public byte[] toByteArray() {
            return this.content;
        }

        public int hashCode() {
            if (this.content == null) {
                return 1;
            }
            if (this.content.length > 3) {
                return 256 * (256 * (256 * this.content[0] + this.content[1]) + this.content[2]) + this.content[3];
            }
            if (this.content.length == 3) {
                return 256 * (256 * this.content[0] + this.content[1]) + this.content[2];
            }
            if (this.content.length == 2) {
                return 256 * this.content[0] + this.content[1];
            }
            if (this.content.length == 1) {
                return this.content[0];
            }
            return 0;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ByteArray byteArray = (ByteArray)object;
            if (this.content == null && byteArray.content == null) {
                return true;
            }
            if (this.content == null && byteArray.content != null) {
                return false;
            }
            if (this.content != null && byteArray.content == null) {
                return false;
            }
            if (this.content.length != byteArray.content.length) {
                return false;
            }
            for (int i = 0; i < this.content.length; ++i) {
                if (this.content[i] == byteArray.content[i]) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            if (this.content == null) {
                return "(null)";
            }
            StringBuffer stringBuffer = new StringBuffer(2 * this.content.length);
            for (int i = 0; i < this.content.length; ++i) {
                int n = this.content[i] & 0xFF;
                stringBuffer.append(Character.forDigit(n / 16, 16));
                stringBuffer.append(Character.forDigit(n % 16, 16));
            }
            return stringBuffer.toString();
        }
    }
}

