/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.diskimages;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jpc.Misc;
import org.jpc.diskimages.DiskIDAlgorithm;
import org.jpc.diskimages.FileRawDiskImage;
import org.jpc.diskimages.ImageFormats;
import org.jpc.diskimages.ImageLibrary;
import org.jpc.diskimages.RawDiskImage;
import org.jpc.diskimages.TreeDirectoryFile;
import org.jpc.diskimages.TreeRawDiskImage;

public class ImageMaker {
    private static void usage() {
        System.err.println("java ImageMaker <imagefile>");
        System.err.println("java ImageMaker [<options>...] <format> <destination> <source>");
        System.err.println("Valid formats are:");
        System.err.println("--BIOS                           BIOS image.");
        System.err.println("--CDROM                          CD-ROM image.");
        System.err.println("--HDD=cylinders,sectors,heads    Hard disk with specified geometry.");
        System.err.println("                                 Cylinders allowed: 1-1024.");
        System.err.println("                                 Sectors allowed:   1-63.");
        System.err.println("                                 Heads allowed:     1-16.");
        System.err.println("--floppy=tracks,sectors,sides    Floppy disk with specified geometry.");
        System.err.println("                                 Tracks allowed:    1-256.");
        System.err.println("                                 Sectors allowed:   1-255.");
        System.err.println("                                 Sides allowed:     1 or 2.");
        System.err.println("--floppy160                      160KiB floppy (40 tracks, 8 sectors, Single sided).");
        System.err.println("--floppy180                      180KiB floppy (40 tracks, 9 sectors, Single sided).");
        System.err.println("--floppy320                      320KiB floppy (40 tracks, 8 sectors, Double sided).");
        System.err.println("--floppy360                      360KiB floppy (40 tracks, 9 sectors, Double sided).");
        System.err.println("--floppy410                      410KiB floppy (41 tracks, 10 sectors, Double sided).");
        System.err.println("--floppy420                      420KiB floppy (42 tracks, 10 sectors, Double sided).");
        System.err.println("--floppy720                      720KiB floppy (80 tracks, 9 sectors, Double sided).");
        System.err.println("--floppy800                      800KiB floppy (80 tracks, 10 sectors, Double sided).");
        System.err.println("--floppy820                      820KiB floppy (82 tracks, 10 sectors, Double sided).");
        System.err.println("--floppy830                      830KiB floppy (83 tracks, 10 sectors, Double sided).");
        System.err.println("--floppy880                      880KiB floppy (80 tracks, 11 sectors, Double sided).");
        System.err.println("--floppy1040                     1040KiB floppy (80 tracks, 13 sectors, Double sided).");
        System.err.println("--floppy1120                     1120KiB floppy (80 tracks, 14 sectors, Double sided).");
        System.err.println("--floppy1200                     1200KiB floppy (80 tracks, 15 sectors, Double sided).");
        System.err.println("--floppy1440                     1440KiB floppy (80 tracks, 18 sectors, Double sided).");
        System.err.println("--floppy1476                     1476KiB floppy (82 tracks, 18 sectors, Double sided).");
        System.err.println("--floppy1494                     1494KiB floppy (83 tracks, 18 sectors, Double sided).");
        System.err.println("--floppy1600                     1600KiB floppy (80 tracks, 20 sectors, Double sided).");
        System.err.println("--floppy1680                     1680KiB floppy (80 tracks, 21 sectors, Double sided).");
        System.err.println("--floppy1722                     1722KiB floppy (82 tracks, 21 sectors, Double sided).");
        System.err.println("--floppy1743                     1743KiB floppy (83 tracks, 21 sectors, Double sided).");
        System.err.println("--floppy1760                     1760KiB floppy (80 tracks, 22 sectors, Double sided).");
        System.err.println("--floppy1840                     1840KiB floppy (80 tracks, 23 sectors, Double sided).");
        System.err.println("--floppy1920                     1920KiB floppy (80 tracks, 24 sectors, Double sided).");
        System.err.println("--floppy2880                     2880KiB floppy (80 tracks, 36 sectors, Double sided).");
        System.err.println("--floppy3120                     3120KiB floppy (80 tracks, 39 sectors, Double sided).");
        System.err.println("--floppy3200                     3200KiB floppy (80 tracks, 40 sectors, Double sided).");
        System.err.println("--floppy3520                     3520KiB floppy (80 tracks, 44 sectors, Double sided).");
        System.err.println("--floppy3840                     3840KiB floppy (80 tracks, 48 sectors, Double sided).");
        System.err.println("Valid options are:");
        System.err.println("--timestamp=value                Timestamp for files in form YYYYMMDDHHMMSS");
        System.err.println("                                 (default is 19900101000000Z).");
        System.err.println("--volumelabel=label              Volume label (default is no label).");
    }

    static int[] scanSectorMap(RawDiskImage rawDiskImage, int n) throws IOException {
        if (n != rawDiskImage.getSectorCount()) {
            throw new IOException("The image has " + rawDiskImage.getSectorCount() + " sectors while it should have " + n + " according to selected geometry.");
        }
        int[] nArray = new int[(n + 30) / 31];
        for (int i = 0; i < n; ++i) {
            if (rawDiskImage.isSectorEmpty(i)) continue;
            int n2 = i / 31;
            nArray[n2] = nArray[n2] | 1 << i % 31;
        }
        return nArray;
    }

    public static void writeImageHeader(RandomAccessFile randomAccessFile, byte[] byArray, byte[] byArray2) throws IOException {
        byte[] byArray3 = new byte[]{73, 77, 65, 71, 69};
        randomAccessFile.write(byArray3);
        randomAccessFile.write(byArray);
        randomAccessFile.write(byArray2);
        randomAccessFile.write(new byte[]{0, 0});
    }

    public static byte[] computeDiskID(RawDiskImage rawDiskImage, byte[] byArray, byte[] byArray2) throws IOException {
        DiskIDAlgorithm diskIDAlgorithm = new DiskIDAlgorithm();
        byte[] byArray3 = new byte[512];
        int n = rawDiskImage.getSectorCount();
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        if (byArray2 != null) {
            if (byArray2[0] > 63) {
                throw new IOException("Invalid geometry to be written.");
            }
            n2 = 1 + ((byArray2[0] & 3) << 8 | byArray2[1] & 0xFF);
            n3 = 1 + (byArray2[2] & 0xFF);
            n4 = 1 + (byArray2[0] >> 2 & 0xF);
        }
        diskIDAlgorithm.addBuffer(byArray);
        if (byArray2 != null) {
            diskIDAlgorithm.addBuffer(byArray2);
        }
        int n5 = byArray2 != null ? n2 * n3 * n4 : n;
        for (int i = 0; i < n5; ++i) {
            if (rawDiskImage.readSector(i, byArray3)) {
                diskIDAlgorithm.addBuffer(byArray3);
                continue;
            }
            diskIDAlgorithm.addZeroes(512);
        }
        byte[] byArray4 = diskIDAlgorithm.getFinalOutput();
        return byArray4;
    }

    private static int countSectors(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length * 31; ++i) {
            if ((nArray[i / 31] & 1 << i % 31) == 0) continue;
            n = i + 1;
        }
        return n;
    }

    public static void imageInfo(String string) {
        try {
            Object object;
            Object object2;
            String string2;
            ParsedImage parsedImage = new ParsedImage(string);
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
            switch (parsedImage.typeCode) {
                case 0: {
                    string2 = "floppy";
                    break;
                }
                case 1: {
                    string2 = "HDD";
                    break;
                }
                case 2: {
                    string2 = "CD-ROM";
                    break;
                }
                case 3: {
                    string2 = "BIOS";
                    break;
                }
                default: {
                    string2 = "<Unknown>";
                }
            }
            System.out.println("Type               : " + string2);
            if (parsedImage.typeCode == 0 || parsedImage.typeCode == 1) {
                object2 = new byte[512];
                System.out.println("Tracks             : " + parsedImage.tracks);
                System.out.println("Sides              : " + parsedImage.sides);
                System.out.println("Sectors            : " + parsedImage.sectors);
                System.out.println("Total sectors      : " + parsedImage.totalSectors);
                System.out.println("Primary extent size: " + parsedImage.sectorsPresent);
                System.out.println("Storage Method     : " + parsedImage.method);
                int n = 0;
                object = new DiskIDAlgorithm();
                ((DiskIDAlgorithm)object).addBuffer(new byte[]{(byte)parsedImage.typeCode});
                ((DiskIDAlgorithm)object).addBuffer(parsedImage.geometry);
                for (int i = 0; i < parsedImage.totalSectors; ++i) {
                    if (i < parsedImage.sectorOffsetMap.length && parsedImage.sectorOffsetMap[i] > 0) {
                        randomAccessFile.seek(parsedImage.sectorOffsetMap[i]);
                        if (randomAccessFile.read((byte[])object2) < 512) {
                            throw new IOException("Failed to read sector from image file.");
                        }
                        ((DiskIDAlgorithm)object).addBuffer((byte[])object2);
                        ++n;
                        continue;
                    }
                    ((DiskIDAlgorithm)object).addZeroes(512);
                }
                System.out.println("Sectors present    : " + n);
                System.out.println("Calculated Disk ID : " + ((DiskIDAlgorithm)object).getFinalOutputString());
            } else if (parsedImage.typeCode == 2) {
                object2 = new byte[512];
                System.out.println("Total sectors      : " + parsedImage.totalSectors);
                DiskIDAlgorithm diskIDAlgorithm = new DiskIDAlgorithm();
                diskIDAlgorithm.addBuffer(new byte[]{(byte)parsedImage.typeCode});
                for (int i = 0; i < parsedImage.totalSectors; ++i) {
                    if (i < parsedImage.sectorOffsetMap.length && parsedImage.sectorOffsetMap[i] > 0) {
                        randomAccessFile.seek(parsedImage.sectorOffsetMap[i]);
                        if (randomAccessFile.read((byte[])object2) < 512) {
                            throw new IOException("Failed to read sector from image file.");
                        }
                        diskIDAlgorithm.addBuffer((byte[])object2);
                        continue;
                    }
                    diskIDAlgorithm.addZeroes(512);
                }
                System.out.println("Calculated Disk ID : " + diskIDAlgorithm.getFinalOutputString());
            } else if (parsedImage.typeCode == 3) {
                System.out.println("Image Size         : " + parsedImage.rawImage.length);
                object2 = new DiskIDAlgorithm();
                ((DiskIDAlgorithm)object2).addBuffer(new byte[]{3});
                ((DiskIDAlgorithm)object2).addBuffer(parsedImage.rawImage);
                System.out.println("Calculated Disk ID : " + ((DiskIDAlgorithm)object2).getFinalOutputString());
            }
            System.out.println("Claimed Disk ID    : " + new ImageLibrary.ByteArray(parsedImage.diskID));
            object2 = parsedImage.comments;
            if (object2 != null) {
                System.out.println("");
                System.out.println("Comments section:");
                System.out.println("");
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    object = (String)iterator.next();
                    System.out.println((String)object);
                }
            }
        }
        catch (IOException iOException) {
            Misc.errorDialog(iOException, "Failed to read image", null, "Quit");
        }
    }

    public static byte[] makeBIOSImage(RandomAccessFile randomAccessFile, RandomAccessFile randomAccessFile2, IFormat iFormat) throws IOException {
        int n = (int)randomAccessFile2.length();
        byte[] byArray = new byte[n];
        if (randomAccessFile2.read(byArray) < n) {
            throw new IOException("Can't read raw bios image file.");
        }
        DiskIDAlgorithm diskIDAlgorithm = new DiskIDAlgorithm();
        byte[] byArray2 = new byte[]{3};
        diskIDAlgorithm.addBuffer(byArray2);
        diskIDAlgorithm.addBuffer(byArray);
        byte[] byArray3 = diskIDAlgorithm.getFinalOutput();
        ImageMaker.writeImageHeader(randomAccessFile, byArray3, byArray2);
        byte[] byArray4 = new byte[]{(byte)(n >>> 24 & 0xFF), (byte)(n >>> 16 & 0xFF), (byte)(n >>> 8 & 0xFF), (byte)(n & 0xFF)};
        randomAccessFile.write(byArray4);
        randomAccessFile.write(byArray);
        randomAccessFile.close();
        return byArray3;
    }

    public static byte[] makeCDROMImage(RandomAccessFile randomAccessFile, FileRawDiskImage fileRawDiskImage, IFormat iFormat) throws IOException {
        byte[] byArray = new byte[]{(byte)iFormat.typeCode};
        byte[] byArray2 = ImageMaker.computeDiskID(fileRawDiskImage, byArray, null);
        ImageMaker.writeImageHeader(randomAccessFile, byArray2, byArray);
        int n = fileRawDiskImage.getSectorCount();
        byte[] byArray3 = new byte[]{(byte)(n >>> 24 & 0xFF), (byte)(n >>> 16 & 0xFF), (byte)(n >>> 8 & 0xFF), (byte)(n & 0xFF)};
        randomAccessFile.write(byArray3);
        ImageFormats.savers[0].save(0, null, fileRawDiskImage, n, n, randomAccessFile);
        randomAccessFile.close();
        return byArray2;
    }

    public static byte[] makeFloppyHDDImage(RandomAccessFile randomAccessFile, RawDiskImage rawDiskImage, IFormat iFormat) throws IOException {
        byte[] byArray = new byte[]{(byte)(iFormat.tracks - 1 >> 8 & 3 | (iFormat.sides - 1 & 0xF) << 2), (byte)(iFormat.tracks - 1 & 0xFF), (byte)(iFormat.sectors - 1 & 0xFF)};
        int[] nArray = ImageMaker.scanSectorMap(rawDiskImage, iFormat.tracks * iFormat.sectors * iFormat.sides);
        byte[] byArray2 = new byte[]{(byte)iFormat.typeCode};
        byte[] byArray3 = ImageMaker.computeDiskID(rawDiskImage, byArray2, byArray);
        ImageMaker.writeImageHeader(randomAccessFile, byArray3, byArray2);
        randomAccessFile.write(byArray);
        ImageFormats.DiskImageType diskImageType = null;
        int n = 0;
        int n2 = ImageMaker.countSectors(nArray);
        int n3 = Integer.MAX_VALUE;
        for (int i = 0; i < ImageFormats.savers.length; ++i) {
            try {
                int n4 = ImageFormats.savers[i].saveSize(i, nArray, iFormat.tracks * iFormat.sectors * iFormat.sides, n2);
                if (n3 <= n4) continue;
                diskImageType = ImageFormats.savers[i];
                n3 = n4;
                n = i;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        byte[] byArray4 = new byte[]{(byte)n, (byte)(n2 >>> 24 & 0xFF), (byte)(n2 >>> 16 & 0xFF), (byte)(n2 >>> 8 & 0xFF), (byte)(n2 & 0xFF)};
        randomAccessFile.write(byArray4);
        diskImageType.save(n, nArray, rawDiskImage, iFormat.tracks * iFormat.sectors * iFormat.sides, n2, randomAccessFile);
        List<String> list = rawDiskImage.getComments();
        if (list != null) {
            for (String string : list) {
                ByteBuffer byteBuffer;
                try {
                    byteBuffer = Charset.forName("UTF-8").newEncoder().encode(CharBuffer.wrap(string));
                }
                catch (CharacterCodingException characterCodingException) {
                    throw new IOException("Invalid comment (Should not happen!).");
                }
                int n5 = byteBuffer.remaining() + 1;
                byte[] byArray5 = new byte[n5 + 1];
                byArray5[0] = (byte)(n5 >>> 8 & 0xFF);
                byArray5[1] = (byte)(n5 & 0xFF);
                byteBuffer.get(byArray5, 2, n5 - 1);
                randomAccessFile.write(byArray5);
            }
        }
        randomAccessFile.write(new byte[]{0, 0});
        randomAccessFile.close();
        return byArray3;
    }

    public static void main(String[] stringArray) {
        IFormat iFormat;
        int n = -1;
        int n2 = -1;
        String string = null;
        String string2 = null;
        if (stringArray.length == 1) {
            ImageMaker.imageInfo(stringArray[0]);
            return;
        }
        try {
            iFormat = new IFormat(null);
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].startsWith("--")) {
                    try {
                        iFormat.addArgument(stringArray[i]);
                        continue;
                    }
                    catch (Exception exception) {
                        System.err.println("Error: Invalid option \"" + stringArray[i] + "\".");
                        ImageMaker.usage();
                        return;
                    }
                }
                if (n < 0) {
                    n = i;
                    continue;
                }
                if (n2 < 0) {
                    n2 = i;
                    continue;
                }
                System.err.println("Error: Third non-option argument not allowed.");
                return;
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
            ImageMaker.usage();
            return;
        }
        if (n2 < 0) {
            System.err.println("Error: Two non-option arguments required.");
            ImageMaker.usage();
            return;
        }
        string = iFormat.volumeLabel;
        string2 = iFormat.timestamp;
        try {
            File file = new File(stringArray[n2]);
            if (!file.exists()) {
                System.err.println("Error: \"" + stringArray[n2] + "\" does not exist.");
                return;
            }
            if (!file.isFile() && !file.isDirectory()) {
                System.err.println("Error: \"" + stringArray[n2] + "\" is neither regular file nor a directory.");
                return;
            }
            String string3 = Misc.tempname(stringArray[n]);
            File file2 = new File(string3);
            while (file2.exists()) {
                string3 = Misc.tempname(stringArray[n]);
                file2 = new File(string3);
            }
            file2.deleteOnExit();
            RandomAccessFile randomAccessFile = new RandomAccessFile(file2, "rw");
            if (iFormat.typeCode == 3) {
                if (!file.isFile()) {
                    System.err.println("Error: BIOS images can only be made out of regular files.");
                    return;
                }
                RandomAccessFile randomAccessFile2 = new RandomAccessFile(stringArray[n2], "r");
                System.out.println(new ImageLibrary.ByteArray(ImageMaker.makeBIOSImage(randomAccessFile, randomAccessFile2, iFormat)));
            } else if (iFormat.typeCode == 2) {
                if (!file.isFile()) {
                    System.err.println("Error: CD images can only be made out of regular files.");
                    return;
                }
                FileRawDiskImage fileRawDiskImage = new FileRawDiskImage(stringArray[n2]);
                System.out.println(new ImageLibrary.ByteArray(ImageMaker.makeCDROMImage(randomAccessFile, fileRawDiskImage, iFormat)));
            } else if (iFormat.typeCode == 0 || iFormat.typeCode == 1) {
                RawDiskImage rawDiskImage;
                if (file.isFile()) {
                    rawDiskImage = new FileRawDiskImage(stringArray[n2]);
                } else if (file.isDirectory()) {
                    TreeDirectoryFile treeDirectoryFile = TreeDirectoryFile.importTree(stringArray[n2], string, string2);
                    rawDiskImage = new TreeRawDiskImage(treeDirectoryFile, iFormat, string);
                } else {
                    System.err.println("BUG: Internal error: Didn't I check this is regular or directory?");
                    return;
                }
                System.out.println(new ImageLibrary.ByteArray(ImageMaker.makeFloppyHDDImage(randomAccessFile, rawDiskImage, iFormat)));
            } else {
                System.err.println("Error: Format for image required.");
                ImageMaker.usage();
                return;
            }
            file2.renameTo(new File(stringArray[n]));
        }
        catch (IOException iOException) {
            System.err.println("Error: " + iOException.getMessage());
        }
    }

    public static class IFormat {
        public int typeCode = -1;
        public int tracks = -1;
        public int sectors = -1;
        public int sides = -1;
        public String timestamp;
        public String volumeLabel;

        private void parseSpec(String string) throws Exception {
            String[] stringArray = string.split(",");
            if (stringArray.length != 3) {
                throw new Exception("Invalid spec " + string + " in parseSpec");
            }
            try {
                this.tracks = Integer.decode(stringArray[0]);
                this.sectors = Integer.decode(stringArray[1]);
                this.sides = Integer.decode(stringArray[2]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new Exception("Invalid spec " + string + " in parseSpec");
            }
        }

        public IFormat(String string) throws Exception {
            if (string != null) {
                this.addArgument(string);
            }
        }

        public void addArgument(String string) throws Exception {
            if (string.startsWith("--HDD=")) {
                this.typeCode = 1;
                try {
                    this.parseSpec(string.substring(6));
                }
                catch (Exception exception) {
                    throw new Exception("Invalid format specifier " + string + ".");
                }
                if (this.tracks < 1 || this.tracks > 1024 || this.sectors < 1 || this.sectors > 63 || this.sides < 1 || this.sides > 16) {
                    throw new Exception("Invalid HDD geometry. Heads must be 1-16, Sectors 1-63 and cylinders 1-1024.");
                }
            } else if (string.startsWith("--floppy=")) {
                this.typeCode = 0;
                try {
                    this.parseSpec(string.substring(9));
                }
                catch (Exception exception) {
                    throw new Exception("Invalid format specifier " + string + ".");
                }
                if (this.tracks < 1 || this.tracks > 256 || this.sectors < 1 || this.sectors > 255 || this.sides < 1 || this.sides > 2) {
                    throw new Exception("Invalid floppy geometry. Sides must be 1 or 2, Sectors 1-255 and tracks 1-256.");
                }
            } else if (string.startsWith("--timestamp=")) {
                this.timestamp = string.substring(12);
            } else if (string.startsWith("--volumelabel=")) {
                this.volumeLabel = string.substring(14);
            } else if (string.equals("--BIOS")) {
                this.typeCode = 3;
            } else if (string.equals("--CDROM")) {
                this.typeCode = 2;
            } else if (string.equals("--floppy160")) {
                this.typeCode = 0;
                this.tracks = 40;
                this.sectors = 8;
                this.sides = 1;
            } else if (string.equals("--floppy180")) {
                this.typeCode = 0;
                this.tracks = 40;
                this.sectors = 9;
                this.sides = 1;
            } else if (string.equals("--floppy320")) {
                this.typeCode = 0;
                this.tracks = 40;
                this.sectors = 8;
                this.sides = 2;
            } else if (string.equals("--floppy360")) {
                this.typeCode = 0;
                this.tracks = 40;
                this.sectors = 9;
                this.sides = 2;
            } else if (string.equals("--floppy410")) {
                this.typeCode = 0;
                this.tracks = 41;
                this.sectors = 10;
                this.sides = 2;
            } else if (string.equals("--floppy420")) {
                this.typeCode = 0;
                this.tracks = 42;
                this.sectors = 10;
                this.sides = 2;
            } else if (string.equals("--floppy720")) {
                this.typeCode = 0;
                this.tracks = 80;
                this.sectors = 9;
                this.sides = 2;
            } else if (string.equals("--floppy800")) {
                this.typeCode = 0;
                this.tracks = 80;
                this.sectors = 10;
                this.sides = 2;
            } else if (string.equals("--floppy820")) {
                this.typeCode = 0;
                this.tracks = 82;
                this.sectors = 10;
                this.sides = 2;
            } else if (string.equals("--floppy830")) {
                this.typeCode = 0;
                this.tracks = 83;
                this.sectors = 10;
                this.sides = 2;
            } else if (string.equals("--floppy880")) {
                this.typeCode = 0;
                this.tracks = 80;
                this.sectors = 11;
                this.sides = 2;
            } else if (string.equals("--floppy1040")) {
                this.typeCode = 0;
                this.tracks = 80;
                this.sectors = 13;
                this.sides = 2;
            } else if (string.equals("--floppy1120")) {
                this.typeCode = 0;
                this.tracks = 80;
                this.sectors = 14;
                this.sides = 2;
            } else if (string.equals("--floppy1200")) {
                this.typeCode = 0;
                this.tracks = 80;
                this.sectors = 15;
                this.sides = 2;
            } else if (string.equals("--floppy1440")) {
                this.typeCode = 0;
                this.tracks = 80;
                this.sectors = 18;
                this.sides = 2;
            } else if (string.equals("--floppy1476")) {
                this.typeCode = 0;
                this.tracks = 82;
                this.sectors = 18;
                this.sides = 2;
            } else if (string.equals("--floppy1494")) {
                this.typeCode = 0;
                this.tracks = 83;
                this.sectors = 18;
                this.sides = 2;
            } else if (string.equals("--floppy1600")) {
                this.typeCode = 0;
                this.tracks = 80;
                this.sectors = 20;
                this.sides = 2;
            } else if (string.equals("--floppy1680")) {
                this.typeCode = 0;
                this.tracks = 80;
                this.sectors = 20;
                this.sides = 2;
            } else if (string.equals("--floppy1722")) {
                this.typeCode = 0;
                this.tracks = 82;
                this.sectors = 21;
                this.sides = 2;
            } else if (string.equals("--floppy1743")) {
                this.typeCode = 0;
                this.tracks = 83;
                this.sectors = 21;
                this.sides = 2;
            } else if (string.equals("--floppy1760")) {
                this.typeCode = 0;
                this.tracks = 80;
                this.sectors = 22;
                this.sides = 2;
            } else if (string.equals("--floppy1840")) {
                this.typeCode = 0;
                this.tracks = 80;
                this.sectors = 23;
                this.sides = 2;
            } else if (string.equals("--floppy1920")) {
                this.typeCode = 0;
                this.tracks = 80;
                this.sectors = 24;
                this.sides = 2;
            } else if (string.equals("--floppy2880")) {
                this.typeCode = 0;
                this.tracks = 80;
                this.sectors = 36;
                this.sides = 2;
            } else if (string.equals("--floppy3120")) {
                this.typeCode = 0;
                this.tracks = 80;
                this.sectors = 39;
                this.sides = 2;
            } else if (string.equals("--floppy3200")) {
                this.typeCode = 0;
                this.tracks = 80;
                this.sectors = 40;
                this.sides = 2;
            } else if (string.equals("--floppy3520")) {
                this.typeCode = 0;
                this.tracks = 80;
                this.sectors = 44;
                this.sides = 2;
            } else if (string.equals("--floppy3840")) {
                this.typeCode = 0;
                this.tracks = 80;
                this.sectors = 48;
                this.sides = 2;
            } else {
                throw new Exception("Invalid format specifier/option " + string + ".");
            }
        }
    }

    public static class ParsedImage {
        public int typeCode;
        public int tracks;
        public int sectors;
        public int sides;
        public int totalSectors;
        public int sectorsPresent;
        public int method;
        public byte[] geometry;
        public int[] sectorOffsetMap;
        public byte[] rawImage;
        public byte[] diskID;
        public List<String> comments;

        public ParsedImage(String string) throws IOException {
            int n;
            byte[] byArray;
            int n2 = -1;
            this.comments = new ArrayList<String>();
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
            this.tracks = -1;
            this.sectors = -1;
            this.sides = -1;
            this.totalSectors = -1;
            this.sectorsPresent = -1;
            this.method = -1;
            byte[] byArray2 = new byte[24];
            if (randomAccessFile.read(byArray2) < 24 || byArray2[0] != 73 || byArray2[1] != 77 || byArray2[2] != 65 || byArray2[3] != 71 || byArray2[4] != 69) {
                throw new IOException(string + " is Not a valid image file file (unable to read header or " + "bad magic).");
            }
            this.diskID = new byte[16];
            System.arraycopy(byArray2, 5, this.diskID, 0, 16);
            this.typeCode = byArray2[21];
            int n3 = (byArray2[22] & 0xFF) * 256 + (byArray2[23] & 0xFF);
            byte[] byArray3 = new byte[n3];
            if (randomAccessFile.read(byArray3) < n3) {
                throw new IOException(string + " is Not a valid image file file (unable to read comment field).");
            }
            if (this.typeCode == 3) {
                byArray = new byte[4];
                if (randomAccessFile.read(byArray) < 4) {
                    throw new IOException(string + " is Not a valid image file file (unable to read BIOS image " + "length).");
                }
                n = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
                this.rawImage = new byte[n];
                if (randomAccessFile.read(this.rawImage) < n) {
                    throw new IOException(string + " is Not a valid image file file (unable to read BIOS image " + "data.");
                }
                n2 = 24 + n3 + 4 + n;
            } else if (this.typeCode == 0 || this.typeCode == 1) {
                this.geometry = new byte[3];
                if (randomAccessFile.read(this.geometry) < 3) {
                    throw new IOException(string + " is Not a valid image file file (unable to read geometry " + "data.");
                }
                this.tracks = 1 + ((this.geometry[0] & 3) << 8 | this.geometry[1] & 0xFF);
                this.sectors = 1 + (this.geometry[2] & 0xFF);
                this.sides = 1 + (this.geometry[0] >> 2 & 0xF);
                int n4 = (this.geometry[0] & 0xFF) >> 6;
                if (n4 != 0) {
                    throw new IOException(string + " has unrecognized geometry " + (this.geometry[0] & 0xFF) + " " + (this.geometry[1] & 0xFF) + " " + (this.geometry[2] & 0xFF) + ".");
                }
                if (this.typeCode == 0 && (this.tracks > 256 || this.sectors > 255 || this.sides > 2)) {
                    throw new IOException(string + " claims to be floppy with illegal geometry: " + this.tracks + " tracks, " + this.sides + " sides and " + this.sectors + " sectors.");
                }
                if (this.typeCode == 1 && (this.tracks > 1024 || this.sectors > 63 || this.sides > 16)) {
                    throw new IOException(string + " claims to be HDD with illegal geometry: " + this.tracks + " cylinders, " + this.sides + " heads and " + this.sectors + " sectors.");
                }
                this.totalSectors = this.tracks * this.sides * this.sectors;
                byte[] byArray4 = new byte[5];
                if (randomAccessFile.read(byArray4) < 5) {
                    throw new IOException(string + " is Not a valid image file (unknown compression).");
                }
                this.method = byArray4[0] & 0xFF;
                this.sectorsPresent = (byArray4[1] & 0xFF) << 24 | (byArray4[2] & 0xFF) << 16 | (byArray4[3] & 0xFF) << 8 | byArray4[4] & 0xFF;
                int[] nArray = new int[]{n3 + 32};
                this.sectorOffsetMap = ImageFormats.savers[this.method].loadSectorMap(randomAccessFile, this.method, this.sectorsPresent, nArray);
                n2 = nArray[0];
            } else if (this.typeCode == 2) {
                byArray = new byte[4];
                if (randomAccessFile.read(byArray) < 4) {
                    throw new IOException(string + " is Not a valid image file (unable to read sector count).");
                }
                this.sectorsPresent = this.totalSectors = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
                int[] nArray = new int[]{n3 + 28};
                this.sectorOffsetMap = ImageFormats.savers[0].loadSectorMap(randomAccessFile, this.method, this.sectorsPresent, nArray);
                n2 = nArray[0];
            } else {
                throw new IOException(string + " is image of unknown type.");
            }
            randomAccessFile.seek(n2);
            byArray = new byte[2];
            n = randomAccessFile.read(byArray);
            if (n <= 0) {
                this.comments = null;
                randomAccessFile.close();
                return;
            }
            if (n < 2) {
                throw new IOException(string + " is Not a valid image file (unable to read comment length).");
            }
            while (byArray[0] != 0 || byArray[1] != 0) {
                int n5 = byArray[0] * 256 + byArray[1] - 1;
                if (n5 > 0) {
                    byte[] byArray5 = new byte[n5];
                    if (randomAccessFile.read(byArray5) < n5) {
                        throw new IOException(string + " is Not a valid image file (unable to read comment).");
                    }
                    String string2 = Charset.forName("UTF-8").newDecoder().decode(ByteBuffer.wrap(byArray5)).toString();
                    this.comments.add(string2);
                } else {
                    this.comments.add("");
                }
                if ((n = randomAccessFile.read(byArray)) >= 2) continue;
                throw new IOException(string + " is Not a valid image file (unable to read comment length).");
            }
            randomAccessFile.close();
        }
    }
}

