/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator;

import java.io.IOException;
import org.jpc.emulator.Clock;
import org.jpc.emulator.SRDumpable;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.Timer;
import org.jpc.emulator.TimerResponsive;

public class EventPoller
implements SRDumpable,
TimerResponsive {
    private Clock timingSource;
    private Timer callback;
    private static final long CALLBACK_INTERVAL = 20000L;

    public EventPoller(Clock clock) {
        this.timingSource = clock;
        this.callback = clock.newTimer(this);
        this.callback.setExpiry(20000L);
    }

    public void dumpStatusPartial(StatusDumper statusDumper) {
        statusDumper.println("\ttimingSource <object #" + statusDumper.objectNumber(this.timingSource) + ">");
        if (this.timingSource != null) {
            this.timingSource.dumpStatus(statusDumper);
        }
        statusDumper.println("\tcallback <object #" + statusDumper.objectNumber(this.callback) + ">");
        if (this.callback != null) {
            this.callback.dumpStatus(statusDumper);
        }
    }

    @Override
    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": EventPoller:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        sRDumper.dumpObject(this.timingSource);
        sRDumper.dumpObject(this.callback);
    }

    public EventPoller(SRLoader sRLoader) throws IOException {
        sRLoader.objectCreated(this);
        this.timingSource = (Clock)sRLoader.loadObject();
        this.callback = (Timer)sRLoader.loadObject();
    }

    @Override
    public void callback() {
        this.callback.setExpiry(this.timingSource.getTime() + 20000L);
    }

    @Override
    public int getTimerType() {
        return 73;
    }
}

