/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.jpc.Misc;
import org.jpc.diskimages.BlockDevice;
import org.jpc.diskimages.DiskImage;
import org.jpc.diskimages.DiskImageSet;
import org.jpc.diskimages.GenericBlockDevice;
import org.jpc.diskimages.ImageLibrary;
import org.jpc.diskimages.ImageMaker;
import org.jpc.emulator.AbstractHardwareComponent;
import org.jpc.emulator.Clock;
import org.jpc.emulator.DisplayController;
import org.jpc.emulator.DriveSet;
import org.jpc.emulator.EventDispatchTarget;
import org.jpc.emulator.EventPoller;
import org.jpc.emulator.EventRecorder;
import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.SRDumpable;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.SoundOutputDevice;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.TraceTrap;
import org.jpc.emulator.memory.LinearAddressSpace;
import org.jpc.emulator.memory.PhysicalAddressSpace;
import org.jpc.emulator.memory.codeblock.CodeBlockManager;
import org.jpc.emulator.motherboard.DMAController;
import org.jpc.emulator.motherboard.GateA20Handler;
import org.jpc.emulator.motherboard.IOPortHandler;
import org.jpc.emulator.motherboard.InterruptController;
import org.jpc.emulator.motherboard.IntervalTimer;
import org.jpc.emulator.motherboard.RTC;
import org.jpc.emulator.motherboard.SystemBIOS;
import org.jpc.emulator.motherboard.VGABIOS;
import org.jpc.emulator.pci.PCIBus;
import org.jpc.emulator.pci.PCIHostBridge;
import org.jpc.emulator.pci.PCIISABridge;
import org.jpc.emulator.pci.peripheral.PIIX3IDEInterface;
import org.jpc.emulator.pci.peripheral.VGACard;
import org.jpc.emulator.peripheral.FloppyController;
import org.jpc.emulator.peripheral.Keyboard;
import org.jpc.emulator.peripheral.PCSpeaker;
import org.jpc.emulator.processor.ModeSwitchException;
import org.jpc.emulator.processor.Processor;
import org.jpc.emulator.processor.ProcessorException;
import org.jpc.emulator.processor.fpu64.FpuState;
import org.jpc.jrsr.FourToFiveDecoder;
import org.jpc.jrsr.FourToFiveEncoder;
import org.jpc.jrsr.JRSRArchiveReader;
import org.jpc.jrsr.JRSRArchiveWriter;
import org.jpc.jrsr.UTFInputLineStream;
import org.jpc.jrsr.UTFOutputLineStream;
import org.jpc.output.Output;
import org.jpc.output.OutputChannelDummy;
import org.jpc.output.OutputChannelGameinfo;

public class PC
implements SRDumpable {
    public int sysRAMSize;
    public int cpuClockDivider;
    private PCHardwareInfo hwInfo;
    public static volatile boolean compile = true;
    private final Processor processor;
    private final PhysicalAddressSpace physicalAddr;
    private final LinearAddressSpace linearAddr;
    private final Clock vmClock;
    private final Set<HardwareComponent> parts;
    private final CodeBlockManager manager;
    private DiskImageSet images;
    private final ResetButton brb;
    private final DiskChanger diskChanger;
    private final EventPoller poller;
    private Output outputs;
    private OutputChannelDummy dummyChannel;
    private OutputChannelGameinfo gameChannel;
    private TraceTrap traceTrap;
    private boolean hitTraceTrap;
    private boolean tripleFaulted;
    private boolean rebootRequest;
    private int cdromIndex;

    public Output getOutputs() {
        return this.outputs;
    }

    public HardwareComponent loadHardwareModule(String string, String string2) throws IOException {
        HardwareComponent hardwareComponent;
        Class<?> clazz;
        if ("".equals(string2)) {
            string2 = null;
        }
        try {
            clazz = Class.forName(string);
        }
        catch (Exception exception) {
            throw new IOException("Unable to find extension module \"" + string + "\".");
        }
        if (!HardwareComponent.class.isAssignableFrom(clazz)) {
            throw new IOException("Extension module \"" + string + "\" is not valid hardware module.");
        }
        try {
            boolean bl = string2.equals("");
            bl &= bl;
            Constructor<?> constructor = clazz.getConstructor(String.class);
            hardwareComponent = (HardwareComponent)constructor.newInstance(string2);
        }
        catch (NullPointerException nullPointerException) {
            try {
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                hardwareComponent = (HardwareComponent)constructor.newInstance(new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof Error) {
                    IOException iOException = new IOException("Error while invoking constructor: " + throwable);
                    iOException.setStackTrace(throwable.getStackTrace());
                    throw iOException;
                }
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                IOException iOException = new IOException("Unknown exception while invoking module constructor: " + throwable);
                iOException.setStackTrace(throwable.getStackTrace());
                throw iOException;
            }
            catch (Exception exception) {
                throw new IOException("Unable to instantiate extension module \"" + string + "\".");
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                IOException iOException = new IOException("Error while invoking constructor: " + throwable);
                iOException.setStackTrace(throwable.getStackTrace());
                throw iOException;
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            IOException iOException = new IOException("Unknown exception while invoking module constructor: " + throwable);
            iOException.setStackTrace(throwable.getStackTrace());
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException("Unable to instantiate extension module \"" + string + "\": " + exception.getMessage());
        }
        return hardwareComponent;
    }

    public PC(DriveSet driveSet, int n, int n2, String string, String string2, long l, DiskImageSet diskImageSet, Map<String, Set<String>> map, String string3, Map<String, Boolean> map2, Map<String, Integer> map3) throws IOException {
        this.parts = new LinkedHashSet<HardwareComponent>();
        this.cdromIndex = -1;
        for (int i = 0; i < 4; ++i) {
            BlockDevice object22 = driveSet.getHardDrive(i);
            if (object22 == null || object22.getType() != BlockDevice.Type.CDROM) continue;
            this.cdromIndex = i;
        }
        this.cpuClockDivider = n2;
        this.sysRAMSize = n * 4096;
        this.vmClock = new Clock();
        if (map != null) {
            for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
                String string4 = entry.getKey();
                for (String string5 : entry.getValue()) {
                    System.err.println("Informational: Loading module \"" + string4 + "\".");
                    this.parts.add(this.loadHardwareModule(string4, string5));
                }
            }
        }
        this.parts.add(this.vmClock);
        System.err.println("Informational: Creating Outputs...");
        this.outputs = new Output();
        this.dummyChannel = new OutputChannelDummy(this.outputs, "<DUMMY>");
        this.gameChannel = new OutputChannelGameinfo(this.outputs, "<GAMEINFO>");
        System.err.println("Informational: Creating CPU...");
        this.processor = new Processor(this.vmClock, this.cpuClockDivider);
        this.parts.add(this.processor);
        this.manager = new CodeBlockManager();
        System.err.println("Informational: Creating FPU...");
        try {
            if (string3 != null) {
                Object obj = Class.forName(string3).getConstructor(Processor.class).newInstance(this.processor);
                this.processor.setFPU((FpuState)obj);
            }
        }
        catch (ClassCastException classCastException) {
            throw new IOException("Bad FPU emulator class " + string3 + ": " + classCastException.getMessage() + ".");
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IOException("Bad FPU emulator class " + string3 + ": " + invocationTargetException.getMessage() + ".");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IOException("Bad FPU emulator class " + string3 + ": " + noSuchMethodException.getMessage() + ".");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException("Bad FPU emulator class " + string3 + ": " + illegalAccessException.getMessage() + ".");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("No such class: " + string3 + ".");
        }
        catch (InstantiationException instantiationException) {
            throw new IOException("Can't instantiate FPU emulator: " + instantiationException.getMessage() + ".");
        }
        System.err.println("Informational: Creating Reset Button...");
        this.brb = new ResetButton(this);
        this.parts.add(this.brb);
        System.err.println("Informational: Creating Disk Changer..");
        this.diskChanger = new DiskChanger(this);
        this.parts.add(this.diskChanger);
        System.err.println("Informational: Creating physical address space...");
        this.physicalAddr = new PhysicalAddressSpace(this.manager, this.sysRAMSize);
        this.parts.add(this.physicalAddr);
        System.err.println("Informational: Creating linear address space...");
        this.linearAddr = new LinearAddressSpace();
        this.parts.add(this.linearAddr);
        this.parts.add(driveSet);
        System.err.println("Informational: Creating I/O port handler...");
        this.parts.add(new IOPortHandler());
        System.err.println("Informational: Creating IRQ controller...");
        this.parts.add(new InterruptController());
        System.err.println("Informational: Creating primary DMA controller...");
        this.parts.add(new DMAController(false, true));
        System.err.println("Informational: Creating secondary DMA controller...");
        this.parts.add(new DMAController(false, false));
        System.err.println("Informational: Creating real time clock...");
        this.parts.add(new RTC(112, 8, this.sysRAMSize, l));
        System.err.println("Informational: Creating interval timer...");
        this.parts.add(new IntervalTimer(64, 0));
        System.err.println("Informational: Creating A20 Handler...");
        this.parts.add(new GateA20Handler());
        this.images = diskImageSet;
        System.err.println("Informational: Creating IDE interface...");
        this.parts.add(new PIIX3IDEInterface());
        System.err.println("Informational: Creating Keyboard...");
        this.parts.add(new Keyboard());
        System.err.println("Informational: Creating floppy disk controller...");
        this.parts.add(new FloppyController());
        System.err.println("Informational: Creating PC speaker...");
        this.parts.add(new PCSpeaker(this.outputs, "org.jpc.emulator.peripheral.PCSpeaker-0"));
        System.err.println("Informational: Creating PCI Host Bridge...");
        this.parts.add(new PCIHostBridge());
        System.err.println("Informational: Creating PCI-to-ISA Bridge...");
        this.parts.add(new PCIISABridge());
        System.err.println("Informational: Creating PCI Bus...");
        this.parts.add(new PCIBus());
        System.err.println("Informational: Creating system BIOS...");
        this.parts.add(new SystemBIOS(string));
        System.err.println("Informational: Creating VGA BIOS...");
        this.parts.add(new VGABIOS(string2));
        System.err.println("Informational: Creating trace trap...");
        this.traceTrap = new TraceTrap();
        this.parts.add(this.traceTrap);
        System.err.println("Informational: Creating event poller...");
        this.poller = new EventPoller(this.vmClock);
        System.err.println("Informational: Creating hardware info...");
        this.hwInfo = new PCHardwareInfo();
        DisplayController object4 = null;
        for (HardwareComponent hardwareComponent : this.parts) {
            if (!(hardwareComponent instanceof DisplayController)) continue;
            if (object4 == null) {
                object4 = (DisplayController)((Object)hardwareComponent);
                continue;
            }
            throw new IOException("Can not have multiple display controllers: \"" + hardwareComponent.getClass().getName() + "\" and \"" + object4.getClass().getName() + "\" are both display controllers.");
        }
        if (object4 == null) {
            System.err.println("Informational: Creating VGA card...");
            VGACard vGACard = new VGACard();
            this.parts.add(vGACard);
            object4 = vGACard;
        }
        object4.getOutputDevice().setSink(this.outputs, "<VIDEO>");
        System.err.println("Informational: Creating sound outputs...");
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (HardwareComponent hardwareComponent : this.parts) {
            if (!(hardwareComponent instanceof SoundOutputDevice)) continue;
            SoundOutputDevice soundOutputDevice = (SoundOutputDevice)((Object)hardwareComponent);
            int n3 = soundOutputDevice.requestedSoundChannels();
            int n4 = 0;
            if (hashMap.containsKey(hardwareComponent.getClass().getName())) {
                n4 = (Integer)hashMap.get(hardwareComponent.getClass().getName());
            }
            for (int i = 0; i < n3; ++i) {
                String string6 = hardwareComponent.getClass().getName() + "-" + (n4 + i);
                soundOutputDevice.soundChannelCallback(this.outputs, string6);
            }
            hashMap.put(hardwareComponent.getClass().getName(), n4 + n3);
        }
        System.err.println("Informational: Setting system flags...");
        HashSet<String> hashSet = new HashSet<String>();
        for (HardwareComponent hardwareComponent : this.parts) {
            Field[] fieldArray;
            Class<?> clazz = hardwareComponent.getClass();
            for (Field field : fieldArray = clazz.getDeclaredFields()) {
                if (!field.getName().startsWith("SYSFLAG_")) continue;
                String string7 = field.getName().substring(8);
                hashSet.add(string7);
                Boolean bl = null;
                Integer n5 = null;
                if (map2 != null) {
                    bl = map2.get(string7);
                }
                if (map3 != null) {
                    n5 = map3.get(string7);
                }
                if (bl != null && bl.booleanValue()) {
                    try {
                        field.setBoolean(hardwareComponent, true);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new IOException("System flag field for " + string7 + " is of wrong type");
                    }
                }
                if (n5 == null || n5 == 0) continue;
                try {
                    field.setInt(hardwareComponent, n5);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new IOException("System flag field for " + string7 + " is of wrong type");
                }
            }
        }
        if (map2 != null) {
            for (Map.Entry<String, Boolean> entry : map2.entrySet()) {
                if (hashSet.contains(entry.getKey())) continue;
                throw new IOException("Unrecognized system flag " + entry.getKey() + " encountered");
            }
        }
        if (map3 != null) {
            for (Map.Entry<String, Integer> entry : map3.entrySet()) {
                if (hashSet.contains(entry.getKey())) continue;
                throw new IOException("Unrecognized system flag " + entry.getKey() + " encountered");
            }
        }
        System.err.println("Informational: Configuring components...");
        if (!this.configure()) {
            throw new IllegalStateException("Can't initialize components (cyclic dependency?)");
        }
        System.err.println("Informational: PC initialization done.");
    }

    public int getCDROMIndex() {
        return this.cdromIndex;
    }

    public DriveSet getDrives() {
        for (HardwareComponent hardwareComponent : this.parts) {
            if (!(hardwareComponent instanceof DriveSet)) continue;
            return (DriveSet)hardwareComponent;
        }
        return null;
    }

    public void dumpStatusPartial(StatusDumper statusDumper) {
        statusDumper.println("\tsysRAMSize " + this.sysRAMSize + " cpuClockDivider " + this.cpuClockDivider);
        statusDumper.println("\ttripleFaulted " + this.tripleFaulted + " cdromIndex " + this.cdromIndex);
        statusDumper.println("\tprocessor <object #" + statusDumper.objectNumber(this.processor) + ">");
        if (this.processor != null) {
            this.processor.dumpStatus(statusDumper);
        }
        statusDumper.println("\tphysicalAddr <object #" + statusDumper.objectNumber(this.physicalAddr) + ">");
        if (this.physicalAddr != null) {
            this.physicalAddr.dumpStatus(statusDumper);
        }
        statusDumper.println("\tlinearAddr <object #" + statusDumper.objectNumber(this.linearAddr) + ">");
        if (this.linearAddr != null) {
            this.linearAddr.dumpStatus(statusDumper);
        }
        statusDumper.println("\tvmClock <object #" + statusDumper.objectNumber(this.vmClock) + ">");
        if (this.vmClock != null) {
            this.vmClock.dumpStatus(statusDumper);
        }
        statusDumper.println("\timages <object #" + statusDumper.objectNumber(this.images) + ">");
        if (this.images != null) {
            this.images.dumpStatus(statusDumper);
        }
        statusDumper.println("\ttraceTrap <object #" + statusDumper.objectNumber(this.traceTrap) + ">");
        if (this.traceTrap != null) {
            this.traceTrap.dumpStatus(statusDumper);
        }
        statusDumper.println("\thwInfo <object #" + statusDumper.objectNumber(this.hwInfo) + ">");
        if (this.hwInfo != null) {
            this.hwInfo.dumpStatus(statusDumper);
        }
        statusDumper.println("\toutputs <object #" + statusDumper.objectNumber(this.outputs) + ">");
        if (this.outputs != null) {
            this.outputs.dumpStatus(statusDumper);
        }
        statusDumper.println("\tbrb <object #" + statusDumper.objectNumber(this.brb) + ">");
        if (this.brb != null) {
            this.brb.dumpStatus(statusDumper);
        }
        statusDumper.println("\tpoller <object #" + statusDumper.objectNumber(this.poller) + ">");
        if (this.poller != null) {
            this.poller.dumpStatus(statusDumper);
        }
        statusDumper.println("\tdummyChannel <object #" + statusDumper.objectNumber(this.dummyChannel) + ">");
        if (this.dummyChannel != null) {
            this.dummyChannel.dumpStatus(statusDumper);
        }
        statusDumper.println("\tgameChannel <object #" + statusDumper.objectNumber(this.gameChannel) + ">");
        if (this.gameChannel != null) {
            this.gameChannel.dumpStatus(statusDumper);
        }
        int n = 0;
        for (HardwareComponent hardwareComponent : this.parts) {
            statusDumper.println("\tparts[" + n++ + "] <object #" + statusDumper.objectNumber(hardwareComponent) + ">");
            if (hardwareComponent == null) continue;
            hardwareComponent.dumpStatus(statusDumper);
        }
    }

    public long getTime() {
        return this.vmClock.getTime();
    }

    public PC(SRLoader sRLoader) throws IOException {
        sRLoader.objectCreated(this);
        this.cdromIndex = sRLoader.loadInt();
        this.sysRAMSize = sRLoader.loadInt();
        this.cpuClockDivider = sRLoader.loadInt();
        this.processor = (Processor)sRLoader.loadObject();
        this.physicalAddr = (PhysicalAddressSpace)sRLoader.loadObject();
        this.linearAddr = (LinearAddressSpace)sRLoader.loadObject();
        this.vmClock = (Clock)sRLoader.loadObject();
        this.images = (DiskImageSet)sRLoader.loadObject();
        this.traceTrap = (TraceTrap)sRLoader.loadObject();
        this.manager = (CodeBlockManager)sRLoader.loadObject();
        this.hwInfo = (PCHardwareInfo)sRLoader.loadObject();
        this.outputs = (Output)sRLoader.loadObject();
        this.hitTraceTrap = sRLoader.loadBoolean();
        this.tripleFaulted = sRLoader.loadBoolean();
        boolean bl = sRLoader.loadBoolean();
        this.parts = new LinkedHashSet<HardwareComponent>();
        while (bl) {
            this.parts.add((HardwareComponent)sRLoader.loadObject());
            bl = sRLoader.loadBoolean();
        }
        this.rebootRequest = sRLoader.loadBoolean();
        this.brb = (ResetButton)sRLoader.loadObject();
        this.diskChanger = (DiskChanger)sRLoader.loadObject();
        this.poller = (EventPoller)sRLoader.loadObject();
        this.dummyChannel = (OutputChannelDummy)sRLoader.loadObject();
        this.gameChannel = !sRLoader.objectEndsHere() ? (OutputChannelGameinfo)sRLoader.loadObject() : new OutputChannelGameinfo(this.outputs, "<GAMEINFO>");
    }

    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": PC:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    public PCHardwareInfo getHardwareInfo() {
        return this.hwInfo;
    }

    public boolean getAndClearTripleFaulted() {
        boolean bl = this.tripleFaulted;
        this.tripleFaulted = false;
        return bl;
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        sRDumper.dumpInt(this.cdromIndex);
        sRDumper.dumpInt(this.sysRAMSize);
        sRDumper.dumpInt(this.cpuClockDivider);
        sRDumper.dumpObject(this.processor);
        sRDumper.dumpObject(this.physicalAddr);
        sRDumper.dumpObject(this.linearAddr);
        sRDumper.dumpObject(this.vmClock);
        sRDumper.dumpObject(this.images);
        sRDumper.dumpObject(this.traceTrap);
        sRDumper.dumpObject(this.manager);
        sRDumper.dumpObject(this.hwInfo);
        sRDumper.dumpObject(this.outputs);
        sRDumper.dumpBoolean(this.hitTraceTrap);
        sRDumper.dumpBoolean(this.tripleFaulted);
        for (HardwareComponent hardwareComponent : this.parts) {
            sRDumper.dumpBoolean(true);
            sRDumper.dumpObject(hardwareComponent);
        }
        sRDumper.dumpBoolean(false);
        sRDumper.dumpBoolean(this.rebootRequest);
        sRDumper.dumpObject(this.brb);
        sRDumper.dumpObject(this.diskChanger);
        sRDumper.dumpObject(this.poller);
        sRDumper.dumpObject(this.dummyChannel);
        sRDumper.dumpObject(this.gameChannel);
    }

    public static Map<String, Set<String>> parseHWModules(String string) throws IOException {
        LinkedHashMap<String, Set<String>> linkedHashMap = new LinkedHashMap<String, Set<String>>();
        while (string != null && !string.equals("")) {
            String string2;
            int n = 0;
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            int n5 = string.length();
            boolean bl = false;
            int n6 = 0;
            while (true) {
                int n7;
                if (n6 < n5) {
                    n7 = string.codePointAt(n6);
                } else if (n == 0) {
                    n7 = 44;
                } else {
                    throw new IOException("Error in module string: unclosed '('.");
                }
                if (n7 >= 65536) {
                    ++n6;
                }
                if (n7 >= 55296 && n7 < 57344 || (n7 & 0xFFFE) == 65534 || n7 >>> 16 > 16 || n7 < 0) {
                    throw new IOException("Error In module string: invalid Unicode character.");
                }
                if (bl && n7 != 44) {
                    throw new IOException("Error in module string: Expected ',' after ')' closing parameter list.");
                }
                if (n7 == 44 && n6 == 0) {
                    throw new IOException("Error in module string: Blank module name not allowed.");
                }
                if (n7 == 40) {
                    if (n == 0) {
                        n3 = n6 + 1;
                        n2 = n6 - 1;
                    }
                    ++n;
                } else if (n7 == 41) {
                    if (n == 0) {
                        throw new IOException("Error in module string: Unpaired ')'.");
                    }
                    if (n == 1) {
                        n4 = n6 - 1;
                        bl = true;
                    }
                    --n;
                } else if (n7 == 44 && n == 0) {
                    if (n2 < 0) {
                        n2 = n6 - 1;
                    }
                    string2 = string.substring(0, n6);
                    if (n6 < n5) {
                        if (!(string = string.substring(n6 + 1)).equals("")) break;
                        throw new IOException("Error in module string: Blank module name not allowed.");
                    }
                    string = "";
                    break;
                }
                ++n6;
            }
            String string3 = string2.substring(0, n2 + 1);
            String string4 = null;
            if (n3 >= 0) {
                string4 = string2.substring(n3, n4 + 1);
            }
            if (linkedHashMap.containsKey(string3)) {
                ((Set)linkedHashMap.get(string3)).add(string4);
                continue;
            }
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            linkedHashSet.add(string4);
            linkedHashMap.put(string3, linkedHashSet);
        }
        return linkedHashMap;
    }

    private static GenericBlockDevice blockdeviceFor(String string) throws IOException {
        if (string == null) {
            return null;
        }
        return new GenericBlockDevice(new DiskImage(string, false));
    }

    public static PC createPC(PCHardwareInfo pCHardwareInfo) throws IOException {
        SRDumpable sRDumpable;
        String string = Misc.arrayToString(pCHardwareInfo.biosID);
        String string2 = Misc.arrayToString(pCHardwareInfo.vgaBIOSID);
        GenericBlockDevice genericBlockDevice = PC.blockdeviceFor(Misc.arrayToString(pCHardwareInfo.hdaID));
        GenericBlockDevice genericBlockDevice2 = PC.blockdeviceFor(Misc.arrayToString(pCHardwareInfo.hdbID));
        GenericBlockDevice genericBlockDevice3 = PC.blockdeviceFor(Misc.arrayToString(pCHardwareInfo.hdcID));
        GenericBlockDevice genericBlockDevice4 = PC.blockdeviceFor(Misc.arrayToString(pCHardwareInfo.hddID));
        if (genericBlockDevice3 == null) {
            genericBlockDevice3 = new GenericBlockDevice(BlockDevice.Type.CDROM);
        }
        DriveSet driveSet = new DriveSet(pCHardwareInfo.bootType, genericBlockDevice, genericBlockDevice2, genericBlockDevice3, genericBlockDevice4);
        PC pC = new PC(driveSet, pCHardwareInfo.memoryPages, pCHardwareInfo.cpuDivider, string, string2, pCHardwareInfo.initRTCTime, pCHardwareInfo.images, pCHardwareInfo.hwModules, pCHardwareInfo.fpuEmulator, pCHardwareInfo.booleanOptions, pCHardwareInfo.intOptions);
        FloppyController floppyController = (FloppyController)pC.getComponent(FloppyController.class);
        DiskImage diskImage = pC.getDisks().lookupDisk(pCHardwareInfo.initFDAIndex);
        floppyController.changeDisk(diskImage, 0);
        DiskImage diskImage2 = pC.getDisks().lookupDisk(pCHardwareInfo.initFDBIndex);
        floppyController.changeDisk(diskImage2, 1);
        if (genericBlockDevice3.getType() == BlockDevice.Type.CDROM) {
            sRDumpable = pC.getDisks().lookupDisk(pCHardwareInfo.initCDROMIndex);
            genericBlockDevice3.configure((DiskImage)sRDumpable);
        }
        sRDumpable = pC.getHardwareInfo();
        sRDumpable.biosID = pCHardwareInfo.biosID;
        sRDumpable.vgaBIOSID = pCHardwareInfo.vgaBIOSID;
        sRDumpable.hdaID = pCHardwareInfo.hdaID;
        sRDumpable.hdbID = pCHardwareInfo.hdbID;
        sRDumpable.hdcID = pCHardwareInfo.hdcID;
        sRDumpable.hddID = pCHardwareInfo.hddID;
        sRDumpable.images = pCHardwareInfo.images;
        sRDumpable.initFDAIndex = pCHardwareInfo.initFDAIndex;
        sRDumpable.initFDBIndex = pCHardwareInfo.initFDBIndex;
        sRDumpable.initCDROMIndex = pCHardwareInfo.initCDROMIndex;
        sRDumpable.initRTCTime = pCHardwareInfo.initRTCTime;
        sRDumpable.cpuDivider = pCHardwareInfo.cpuDivider;
        sRDumpable.memoryPages = pCHardwareInfo.memoryPages;
        sRDumpable.bootType = pCHardwareInfo.bootType;
        sRDumpable.hwModules = pCHardwareInfo.hwModules;
        sRDumpable.fpuEmulator = pCHardwareInfo.fpuEmulator;
        sRDumpable.booleanOptions = pCHardwareInfo.booleanOptions;
        sRDumpable.intOptions = pCHardwareInfo.intOptions;
        return pC;
    }

    public void start() {
        this.vmClock.resume();
    }

    public void stop() {
        this.dummyChannel.addFrameDummy(this.vmClock.getTime());
        this.vmClock.pause();
    }

    private void changeFloppyDisk(DiskImage diskImage, int n) throws IOException {
        ((FloppyController)this.getComponent(FloppyController.class)).changeDisk(diskImage, n);
    }

    public void changeFloppyDisk(int n, int n2) throws IOException {
        this.diskChanger.changeFloppyDisk(n, n2);
    }

    public void wpFloppyDisk(int n, boolean bl) throws IOException {
        this.diskChanger.wpFloppyDisk(n, bl);
    }

    public DiskImageSet getDisks() {
        return this.images;
    }

    private boolean configure() {
        boolean bl;
        int n = 0;
        do {
            bl = true;
            for (HardwareComponent hardwareComponent : this.parts) {
                if (hardwareComponent.initialised()) continue;
                for (HardwareComponent hardwareComponent2 : this.parts) {
                    hardwareComponent.acceptComponent(hardwareComponent2);
                }
                bl &= hardwareComponent.initialised();
            }
        } while (!bl && ++n < 100);
        if (!bl) {
            for (HardwareComponent hardwareComponent : this.parts) {
                if (hardwareComponent.initialised()) continue;
                System.err.println("Error: Component of type " + hardwareComponent.getClass() + " failed to initialize.");
            }
            System.err.println("Critical error: PC component initialization failed.");
            return false;
        }
        for (HardwareComponent hardwareComponent : this.parts) {
            if (!(hardwareComponent instanceof PCIBus)) continue;
            ((PCIBus)hardwareComponent).biosInit();
        }
        return true;
    }

    public void setFPUHack() {
        this.physicalAddr.setFPUHack();
    }

    public void setVGADrawHack() {
        HardwareComponent hardwareComponent = this.getComponent(VGACard.class);
        if (hardwareComponent != null) {
            ((VGACard)hardwareComponent).setVGADrawHack();
        }
    }

    public void setVGAScroll2Hack() {
        HardwareComponent hardwareComponent = this.getComponent(VGACard.class);
        if (hardwareComponent != null) {
            ((VGACard)hardwareComponent).setVGAScroll2Hack();
        }
    }

    protected void reset() {
        for (HardwareComponent hardwareComponent : this.parts) {
            hardwareComponent.reset();
        }
        this.configure();
    }

    public void reboot() {
        this.brb.reboot();
    }

    public HardwareComponent getComponent(Class<?> clazz) {
        for (HardwareComponent hardwareComponent : this.parts) {
            if (!clazz.isInstance(hardwareComponent)) continue;
            return hardwareComponent;
        }
        return null;
    }

    public Set<HardwareComponent> allComponents() {
        return this.parts;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public final int execute() {
        if (this.processor.isProtectedMode()) {
            if (this.processor.isVirtual8086Mode()) {
                return this.executeVirtual8086();
            }
            return this.executeProtected();
        }
        return this.executeReal();
    }

    public final int executeReal() {
        int n = 0;
        if (this.rebootRequest) {
            this.reset();
            this.rebootRequest = false;
        }
        try {
            for (int i = 0; i < 100; ++i) {
                int n2;
                try {
                    n2 = this.physicalAddr.executeReal(this.processor, this.processor.getInstructionPointer());
                }
                catch (Processor.TripleFault tripleFault) {
                    this.reset();
                    this.hitTraceTrap = true;
                    this.tripleFaulted = true;
                    break;
                }
                n += n2;
                this.processor.instructionsExecuted += (long)n2;
                if (!this.processor.eflagsLastAborted) {
                    this.processor.processRealModeInterrupts(1);
                }
                if (this.traceTrap.getAndClearTrapActive()) {
                    this.hitTraceTrap = true;
                } else {
                    if (!this.rebootRequest) continue;
                    this.reset();
                    this.rebootRequest = false;
                }
                break;
            }
        }
        catch (ProcessorException processorException) {
            this.processor.handleRealModeException(processorException);
        }
        catch (ModeSwitchException modeSwitchException) {
            // empty catch block
        }
        return n;
    }

    public TraceTrap getTraceTrap() {
        return this.traceTrap;
    }

    public boolean getHitTraceTrap() {
        boolean bl = this.hitTraceTrap;
        this.hitTraceTrap = false;
        return bl;
    }

    public final int executeProtected() {
        int n = 0;
        if (this.rebootRequest) {
            this.reset();
            this.rebootRequest = false;
        }
        try {
            for (int i = 0; i < 100; ++i) {
                int n2;
                try {
                    n2 = this.linearAddr.executeProtected(this.processor, this.processor.getInstructionPointer());
                }
                catch (Processor.TripleFault tripleFault) {
                    this.reset();
                    this.hitTraceTrap = true;
                    this.tripleFaulted = true;
                    break;
                }
                n += n2;
                this.processor.instructionsExecuted += (long)n2;
                if (!this.processor.eflagsLastAborted) {
                    this.processor.processProtectedModeInterrupts(1);
                }
                if (this.traceTrap.getAndClearTrapActive()) {
                    this.hitTraceTrap = true;
                } else {
                    if (!this.rebootRequest) continue;
                    this.reset();
                    this.rebootRequest = false;
                }
                break;
            }
        }
        catch (ProcessorException processorException) {
            this.processor.handleProtectedModeException(processorException);
        }
        catch (ModeSwitchException modeSwitchException) {
            // empty catch block
        }
        return n;
    }

    public final int executeVirtual8086() {
        int n = 0;
        if (this.rebootRequest) {
            this.reset();
            this.rebootRequest = false;
        }
        try {
            for (int i = 0; i < 100; ++i) {
                int n2;
                try {
                    n2 = this.linearAddr.executeVirtual8086(this.processor, this.processor.getInstructionPointer());
                }
                catch (Processor.TripleFault tripleFault) {
                    this.reset();
                    this.hitTraceTrap = true;
                    this.tripleFaulted = true;
                    break;
                }
                n += n2;
                this.processor.instructionsExecuted += (long)n2;
                if (!this.processor.eflagsLastAborted) {
                    this.processor.processVirtual8086ModeInterrupts(1);
                }
                if (this.traceTrap.getAndClearTrapActive()) {
                    this.hitTraceTrap = true;
                } else {
                    if (!this.rebootRequest) continue;
                    this.reset();
                    this.rebootRequest = false;
                }
                break;
            }
        }
        catch (ProcessorException processorException) {
            this.processor.handleVirtual8086ModeException(processorException);
        }
        catch (ModeSwitchException modeSwitchException) {
            // empty catch block
        }
        return n;
    }

    public void refreshGameinfo(PCFullStatus pCFullStatus) {
        EventRecorder eventRecorder = pCFullStatus.events;
        long l = eventRecorder.getLastEventTime();
        long l2 = eventRecorder.getAttachTime();
        long l3 = 0L;
        if (l2 < l) {
            l3 = l - l2;
        }
        this.gameChannel.addFrameLength(pCFullStatus.pc.getTime(), l3);
        System.err.println("Updated game info: Length: " + l3 + ".");
        this.gameChannel.addFrameRerecords(pCFullStatus.pc.getTime(), eventRecorder.getRerecordCount());
        System.err.println("Updated game info: Rerecords: " + eventRecorder.getRerecordCount() + ".");
        String string = null;
        if (pCFullStatus.extraHeaders != null) {
            for (String[] stringArray : pCFullStatus.extraHeaders) {
                if (stringArray.length == 2 && "GAMENAME".equals(stringArray[0])) {
                    this.gameChannel.addFrameGamename(pCFullStatus.pc.getTime(), stringArray[1]);
                    System.err.println("Updated game info: Name: " + stringArray[1] + ".");
                }
                if (stringArray.length == 3 && "AUTHORFULL".equals(stringArray[0])) {
                    string = PC.addName(string, stringArray[2]);
                }
                if (stringArray.length <= 1 || !"AUTHORS".equals(stringArray[0]) && !"AUTHORNICKS".equals(stringArray[0])) continue;
                for (int i = 1; i < stringArray.length; ++i) {
                    string = PC.addName(string, stringArray[i]);
                }
            }
        }
        if (string != null) {
            this.gameChannel.addFrameAuthors(pCFullStatus.pc.getTime(), string);
            System.err.println("Updated game info: Authors: " + string + ".");
        } else {
            this.gameChannel.addFrameAuthors(pCFullStatus.pc.getTime(), "(unknown)");
            System.err.println("Updated game info: Authors: (unknown).");
        }
    }

    private static String addName(String string, String string2) {
        if (string == null) {
            return string2;
        }
        return string + ", " + string2;
    }

    private static void saveDiskInfo(UTFOutputLineStream uTFOutputLineStream, byte[] byArray) {
        ImageLibrary imageLibrary = DiskImage.getLibrary();
        String string = imageLibrary.lookupFileName(byArray);
        if (string == null) {
            System.err.println("Warning: Can't find used disk from library (SHOULD NOT HAPPEN!).");
            return;
        }
        try {
            Object object;
            Object object2;
            Object object3;
            ImageMaker.ParsedImage parsedImage = new ImageMaker.ParsedImage(string);
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
            switch (parsedImage.typeCode) {
                case 0: {
                    uTFOutputLineStream.encodeLine("TYPE", "FLOPPY");
                    break;
                }
                case 1: {
                    uTFOutputLineStream.encodeLine("TYPE", "HDD");
                    break;
                }
                case 2: {
                    uTFOutputLineStream.encodeLine("TYPE", "CDROM");
                    break;
                }
                case 3: {
                    uTFOutputLineStream.encodeLine("TYPE", "BIOS");
                    break;
                }
                default: {
                    uTFOutputLineStream.encodeLine("TYPE", "UNKNOWN");
                }
            }
            uTFOutputLineStream.encodeLine("ID", new ImageLibrary.ByteArray(parsedImage.diskID));
            switch (parsedImage.typeCode) {
                case 0: 
                case 1: {
                    uTFOutputLineStream.encodeLine("TRACKS", parsedImage.tracks);
                    uTFOutputLineStream.encodeLine("SIDES", parsedImage.sides);
                    uTFOutputLineStream.encodeLine("SECTORS", parsedImage.sectors);
                }
                case 2: {
                    uTFOutputLineStream.encodeLine("TOTALSECTORS", parsedImage.totalSectors);
                    object3 = new byte[512];
                    object2 = new byte[512];
                    object = MessageDigest.getInstance("MD5");
                    for (int i = 0; i < parsedImage.totalSectors; ++i) {
                        if (i < parsedImage.sectorOffsetMap.length && parsedImage.sectorOffsetMap[i] > 0) {
                            randomAccessFile.seek(parsedImage.sectorOffsetMap[i]);
                            if (randomAccessFile.read((byte[])object3) < 512) {
                                throw new IOException("Failed to read sector from image file.");
                            }
                            ((MessageDigest)object).update((byte[])object3);
                            continue;
                        }
                        ((MessageDigest)object).update((byte[])object2);
                    }
                    uTFOutputLineStream.encodeLine("IMAGEMD5", new ImageLibrary.ByteArray(((MessageDigest)object).digest()));
                    break;
                }
                case 3: {
                    uTFOutputLineStream.encodeLine("IMAGELENGTH", parsedImage.rawImage.length);
                    object = MessageDigest.getInstance("MD5");
                    ((MessageDigest)object).update(parsedImage.rawImage);
                    uTFOutputLineStream.encodeLine("IMAGEMD5", new ImageLibrary.ByteArray(((MessageDigest)object).digest()));
                }
            }
            object3 = parsedImage.comments;
            if (object3 != null) {
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    uTFOutputLineStream.encodeLine("COMMENT", object);
                }
            }
            randomAccessFile.close();
        }
        catch (Exception exception) {
            System.err.println("Warning: Can't lookup disk information: " + exception.getMessage() + "[" + exception.getClass().getName() + "].");
        }
    }

    private static void saveDiskInfo(JRSRArchiveWriter jRSRArchiveWriter, DiskImage diskImage, Set<ImageLibrary.ByteArray> set) throws IOException {
        if (diskImage == null) {
            return;
        }
        PC.saveDiskInfo(jRSRArchiveWriter, diskImage.getImageID(), set);
    }

    private static void saveDiskInfo(JRSRArchiveWriter jRSRArchiveWriter, byte[] byArray, Set<ImageLibrary.ByteArray> set) throws IOException {
        if (byArray == null) {
            return;
        }
        ImageLibrary.ByteArray byteArray = new ImageLibrary.ByteArray(byArray);
        if (set.contains(byteArray)) {
            return;
        }
        set.add(byteArray);
        UTFOutputLineStream uTFOutputLineStream = new UTFOutputLineStream(jRSRArchiveWriter.addMember("diskinfo-" + Misc.arrayToString(byArray)));
        PC.saveDiskInfo(uTFOutputLineStream, byArray);
        uTFOutputLineStream.close();
    }

    public static void saveSavestate(JRSRArchiveWriter jRSRArchiveWriter, PCFullStatus pCFullStatus, boolean bl, boolean bl2) throws IOException {
        Object object;
        Object object2;
        pCFullStatus.savestateID = Misc.randomHexes(24);
        pCFullStatus.events.markSave(pCFullStatus.savestateID, pCFullStatus.rerecords);
        UTFOutputLineStream uTFOutputLineStream = new UTFOutputLineStream(jRSRArchiveWriter.addMember("header"));
        uTFOutputLineStream.writeLine("PROJECTID " + pCFullStatus.projectID);
        if (!bl) {
            uTFOutputLineStream.writeLine("SAVESTATEID " + pCFullStatus.savestateID);
        }
        uTFOutputLineStream.writeLine("RERECORDS " + pCFullStatus.rerecords);
        uTFOutputLineStream.writeLine("SYSTEM PC-JPC-RR-r10");
        if (pCFullStatus.extraHeaders != null) {
            for (int i = 0; i < pCFullStatus.extraHeaders.length; ++i) {
                object2 = new Object[pCFullStatus.extraHeaders[i].length];
                System.arraycopy(pCFullStatus.extraHeaders[i], 0, object2, 0, ((Object[])object2).length);
                uTFOutputLineStream.encodeLine((Object[])object2);
            }
        }
        uTFOutputLineStream.close();
        uTFOutputLineStream = new UTFOutputLineStream(jRSRArchiveWriter.addMember("initialization"));
        pCFullStatus.pc.getHardwareInfo().makeHWInfoSegment(uTFOutputLineStream, pCFullStatus.pc.diskChanger);
        uTFOutputLineStream.close();
        if (!bl) {
            FourToFiveEncoder fourToFiveEncoder = new FourToFiveEncoder(jRSRArchiveWriter.addMember("savestate"));
            Deflater deflater = new Deflater(bl2 ? 0 : -1);
            object = object2 = new DeflaterOutputStream((OutputStream)fourToFiveEncoder, deflater);
            SRDumper sRDumper = new SRDumper((OutputStream)object);
            sRDumper.dumpObject(pCFullStatus.pc);
            sRDumper.flush();
            ((DeflaterOutputStream)object2).close();
            JRSRArchiveWriter.JRSRArchiveOutputStream jRSRArchiveOutputStream = jRSRArchiveWriter.addMember("manifest");
            sRDumper.writeConstructorManifest(jRSRArchiveOutputStream);
            ((OutputStream)jRSRArchiveOutputStream).close();
        }
        uTFOutputLineStream = new UTFOutputLineStream(jRSRArchiveWriter.addMember("events"));
        pCFullStatus.events.saveEvents(uTFOutputLineStream);
        uTFOutputLineStream.close();
        PCHardwareInfo pCHardwareInfo = pCFullStatus.pc.getHardwareInfo();
        object2 = pCHardwareInfo.images;
        int n = 1 + ((DiskImageSet)object2).highestDiskIndex();
        object = new HashSet();
        for (int i = 0; i < n; ++i) {
            PC.saveDiskInfo(jRSRArchiveWriter, ((DiskImageSet)object2).lookupDisk(i), (Set<ImageLibrary.ByteArray>)object);
        }
        PC.saveDiskInfo(jRSRArchiveWriter, pCHardwareInfo.biosID, (Set<ImageLibrary.ByteArray>)object);
        PC.saveDiskInfo(jRSRArchiveWriter, pCHardwareInfo.vgaBIOSID, (Set<ImageLibrary.ByteArray>)object);
        PC.saveDiskInfo(jRSRArchiveWriter, pCHardwareInfo.hdaID, (Set<ImageLibrary.ByteArray>)object);
        PC.saveDiskInfo(jRSRArchiveWriter, pCHardwareInfo.hdbID, (Set<ImageLibrary.ByteArray>)object);
        PC.saveDiskInfo(jRSRArchiveWriter, pCHardwareInfo.hdcID, (Set<ImageLibrary.ByteArray>)object);
        PC.saveDiskInfo(jRSRArchiveWriter, pCHardwareInfo.hddID, (Set<ImageLibrary.ByteArray>)object);
    }

    public static PCFullStatus loadSavestate(JRSRArchiveReader jRSRArchiveReader, boolean bl, boolean bl2, PCFullStatus pCFullStatus) throws IOException {
        Object object;
        PCFullStatus pCFullStatus2 = new PCFullStatus();
        boolean bl3 = false;
        UTFInputLineStream uTFInputLineStream = new UTFInputLineStream(jRSRArchiveReader.readMember("header"));
        pCFullStatus2.rerecords = -1L;
        String[] stringArray = Misc.nextParseLine(uTFInputLineStream);
        while (stringArray != null) {
            block27: {
                if ("SAVESTATEID".equals(stringArray[0])) {
                    if (stringArray.length != 2) {
                        throw new IOException("Bad " + stringArray[0] + " line in header segment: " + "expected 2 components, got " + stringArray.length);
                    }
                    bl3 = true;
                    pCFullStatus2.savestateID = stringArray[1];
                } else if ("PROJECTID".equals(stringArray[0])) {
                    if (stringArray.length != 2) {
                        throw new IOException("Bad " + stringArray[0] + " line in header segment: " + "expected 2 components, got " + stringArray.length);
                    }
                    pCFullStatus2.projectID = stringArray[1];
                } else {
                    if ("RERECORDS".equals(stringArray[0])) {
                        if (stringArray.length != 2) {
                            throw new IOException("Bad " + stringArray[0] + " line in header segment: " + "expected 2 components, got " + stringArray.length);
                        }
                        try {
                            pCFullStatus2.rerecords = Long.parseLong(stringArray[1]);
                            if (pCFullStatus2.rerecords < 0L) {
                                throw new IOException("Invalid rerecord count");
                            }
                            break block27;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new IOException("Invalid rerecord count");
                        }
                    }
                    if ("SYSTEM".equals(stringArray[0])) {
                        if (stringArray.length != 2) {
                            throw new IOException("Bad " + stringArray[0] + " line in header segment: " + "expected 2 components, got " + stringArray.length);
                        }
                        if (!"PC-JPC-RR-r10".equals(stringArray[1])) {
                            throw new IOException("Invalid system type '" + stringArray[1] + "'");
                        }
                    } else if (pCFullStatus2.extraHeaders == null) {
                        pCFullStatus2.extraHeaders = new String[1][];
                        pCFullStatus2.extraHeaders[0] = stringArray;
                    } else {
                        object = new String[pCFullStatus2.extraHeaders.length + 1][];
                        System.arraycopy(pCFullStatus2.extraHeaders, 0, object, 0, pCFullStatus2.extraHeaders.length);
                        object[pCFullStatus2.extraHeaders.length] = stringArray;
                        pCFullStatus2.extraHeaders = object;
                    }
                }
            }
            stringArray = Misc.nextParseLine(uTFInputLineStream);
        }
        if (pCFullStatus2.projectID == null) {
            throw new IOException("PROJECTID header missing");
        }
        if (pCFullStatus2.rerecords < 0L) {
            throw new IOException("RERECORDS header missing");
        }
        if (bl3 && !bl2) {
            object = jRSRArchiveReader.readMember("manifest");
            if (!SRLoader.checkConstructorManifest((InputStream)object)) {
                throw new IOException("Wrong savestate version");
            }
            object.close();
            object = new FourToFiveDecoder(jRSRArchiveReader.readMember("savestate"));
            SRLoader sRLoader = new SRLoader(new InflaterInputStream((InputStream)object));
            pCFullStatus2.pc = (PC)sRLoader.loadObject();
            object.close();
        } else {
            uTFInputLineStream = new UTFInputLineStream(jRSRArchiveReader.readMember("initialization"));
            object = PCHardwareInfo.parseHWInfoSegment(uTFInputLineStream);
            pCFullStatus2.pc = PC.createPC((PCHardwareInfo)object);
        }
        if (bl) {
            pCFullStatus2.events = pCFullStatus.events;
        } else {
            uTFInputLineStream = new UTFInputLineStream(jRSRArchiveReader.readMember("events"));
            pCFullStatus2.events = new EventRecorder(uTFInputLineStream);
        }
        if (bl && (pCFullStatus == null || !pCFullStatus2.projectID.equals(pCFullStatus.projectID))) {
            throw new IOException("Savestate is not from current movie");
        }
        pCFullStatus2.events.attach(pCFullStatus2.pc, bl2 ? null : pCFullStatus2.savestateID);
        if (!bl) {
            pCFullStatus2.events.setHeaders(pCFullStatus2.extraHeaders);
            pCFullStatus2.events.setRerecordCount(pCFullStatus2.rerecords);
        }
        pCFullStatus2.rerecords = pCFullStatus == null || !pCFullStatus2.projectID.equals(pCFullStatus.projectID) ? ++pCFullStatus2.rerecords : (pCFullStatus != null && pCFullStatus.rerecords > pCFullStatus2.rerecords ? pCFullStatus.rerecords + 1L : ++pCFullStatus2.rerecords);
        pCFullStatus2.pc.refreshGameinfo(pCFullStatus2);
        return pCFullStatus2;
    }

    public static class PCFullStatus {
        public PC pc;
        public EventRecorder events;
        public String projectID;
        public String savestateID;
        public long rerecords;
        public String[][] extraHeaders;
    }

    public static class ResetButton
    extends AbstractHardwareComponent
    implements SRDumpable,
    EventDispatchTarget {
        private EventRecorder eRecorder;
        private PC upperBackref;

        public EventRecorder getRecorder() {
            return this.eRecorder;
        }

        public void reboot() {
            try {
                this.eRecorder.addEvent(-1L, this.getClass(), null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void startEventCheck() {
        }

        @Override
        public void doEvent(long l, String[] stringArray, int n) throws IOException {
            if (stringArray != null) {
                throw new IOException("Invalid reboot event");
            }
            if (n == 3) {
                ((PC)this.upperBackref).processor.eflagsMachineHalt = true;
                this.upperBackref.rebootRequest = true;
            }
        }

        @Override
        public void endEventCheck() throws IOException {
        }

        public ResetButton(PC pC) {
            this.upperBackref = pC;
        }

        public ResetButton(SRLoader sRLoader) throws IOException {
            super(sRLoader);
            this.upperBackref = (PC)sRLoader.loadObject();
        }

        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            super.dumpSRPartial(sRDumper);
            sRDumper.dumpObject(this.upperBackref);
        }

        @Override
        public long getEventTimeLowBound(long l, String[] stringArray) throws IOException {
            return -1L;
        }

        @Override
        public void setEventRecorder(EventRecorder eventRecorder) {
            this.eRecorder = eventRecorder;
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": ResetButton:");
            statusDumper.endObject();
        }
    }

    public static class DiskChanger
    extends AbstractHardwareComponent
    implements SRDumpable,
    EventDispatchTarget {
        private EventRecorder eRecorder;
        private PC upperBackref;
        private int currentDriveA;
        private int currentDriveB;
        private int currentCDROM;
        private Set<Integer> usedDisks;

        private void checkFloppyChange(int n, int n2) throws IOException {
            if (n == 2 && this.upperBackref.cdromIndex < 0) {
                throw new IOException("No CD-ROM drive available");
            }
            if (n2 < -1) {
                throw new IOException("Illegal disk number");
            }
            DiskImage diskImage = this.upperBackref.images.lookupDisk(n2);
            if (n < 0 || n > 2) {
                throw new IOException("Illegal drive number");
            }
            if (n2 >= 0 && (n2 == this.currentDriveA || n2 == this.currentDriveB || n2 == this.currentCDROM)) {
                throw new IOException("Specified disk is already in some drive");
            }
            if (n2 < 0 && n == 0 && this.currentDriveA < 0) {
                throw new IOException("No disk present in drive A");
            }
            if (n2 < 0 && n == 1 && this.currentDriveB < 0) {
                throw new IOException("No disk present in drive B");
            }
            if (n2 < 0 && n == 2 && this.currentCDROM < 0) {
                throw new IOException("No disk present in CD-ROM Drive");
            }
            if (n2 > 0 && n < 2 && (diskImage == null || diskImage.getType() != BlockDevice.Type.FLOPPY)) {
                throw new IOException("Attempt to put non-floppy into drive A or B");
            }
            if (n2 > 0 && n == 2 && (diskImage == null || diskImage.getType() != BlockDevice.Type.CDROM)) {
                throw new IOException("Attempt to put non-CDROM into CDROM drive");
            }
            if (n2 > 0) {
                this.usedDisks.add(new Integer(n2));
            }
        }

        private void checkFloppyWP(int n, boolean bl) throws IOException {
            if (n < 0) {
                throw new IOException("Illegal floppy disk number");
            }
            if (n == this.currentDriveA || n == this.currentDriveB) {
                throw new IOException("Can not manipulate WP of disk in drive");
            }
            DiskImage diskImage = this.upperBackref.images.lookupDisk(n);
            if (diskImage == null || diskImage.getType() != BlockDevice.Type.FLOPPY) {
                throw new IOException("Can not manipulate WP of non-floppy disk");
            }
        }

        public synchronized void changeFloppyDisk(int n, int n2) throws IOException {
            this.checkFloppyChange(n, n2);
            this.upperBackref.images.lookupDisk(n2);
            try {
                if (n == 0) {
                    this.eRecorder.addEvent(-1L, this.getClass(), new String[]{"FDA", "" + n2});
                } else if (n == 1) {
                    this.eRecorder.addEvent(-1L, this.getClass(), new String[]{"FDB", "" + n2});
                } else if (n == 2) {
                    this.eRecorder.addEvent(-1L, this.getClass(), new String[]{"CDROM", "" + n2});
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public synchronized void wpFloppyDisk(int n, boolean bl) throws IOException {
            this.checkFloppyWP(n, bl);
            DiskImage diskImage = this.upperBackref.images.lookupDisk(n);
            try {
                if (bl && !diskImage.isReadOnly()) {
                    this.eRecorder.addEvent(-1L, this.getClass(), new String[]{"WRITEPROTECT", "" + n});
                } else if (!bl && diskImage.isReadOnly()) {
                    this.eRecorder.addEvent(-1L, this.getClass(), new String[]{"WRITEUNPROTECT", "" + n});
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void doEvent(long l, String[] stringArray, int n) throws IOException {
            int n2;
            if (stringArray == null || stringArray.length != 2) {
                throw new IOException("Invalid disk event parameters");
            }
            try {
                n2 = Integer.parseInt(stringArray[1]);
            }
            catch (Exception exception) {
                throw new IOException("Invalid disk number");
            }
            DiskImage diskImage = this.upperBackref.images.lookupDisk(n2);
            if ("FDA".equals(stringArray[0])) {
                if (n <= 2) {
                    this.checkFloppyChange(0, n2);
                    this.currentDriveA = n2;
                }
                if (n == 3) {
                    this.upperBackref.changeFloppyDisk(diskImage, 0);
                }
            } else if ("FDB".equals(stringArray[0])) {
                if (n <= 2) {
                    this.checkFloppyChange(1, n2);
                    this.currentDriveB = n2;
                }
                if (n == 3) {
                    this.upperBackref.changeFloppyDisk(diskImage, 1);
                }
            } else if ("CDROM".equals(stringArray[0])) {
                if (n <= 2) {
                    this.checkFloppyChange(2, n2);
                    this.currentCDROM = n2;
                }
                DriveSet driveSet = (DriveSet)this.upperBackref.getComponent(DriveSet.class);
                if (n == 3) {
                    try {
                        ((GenericBlockDevice)driveSet.getHardDrive(this.upperBackref.cdromIndex)).configure(diskImage);
                    }
                    catch (Exception exception) {
                        System.err.println("Warning: Unable to change disk in CD-ROM drive");
                    }
                }
            } else if ("WRITEPROTECT".equals(stringArray[0])) {
                if (n <= 2) {
                    this.checkFloppyWP(n2, true);
                }
                if (n == 3) {
                    diskImage.setWP(true);
                }
            } else if ("WRITEUNPROTECT".equals(stringArray[0])) {
                if (n <= 2) {
                    this.checkFloppyWP(n2, false);
                }
                if (n == 3) {
                    diskImage.setWP(false);
                }
            } else {
                throw new IOException("Invalid disk event type");
            }
        }

        @Override
        public void startEventCheck() {
            this.currentDriveA = ((PC)this.upperBackref).hwInfo.initFDAIndex;
            this.currentDriveB = ((PC)this.upperBackref).hwInfo.initFDBIndex;
            this.currentCDROM = ((PC)this.upperBackref).hwInfo.initCDROMIndex;
            this.usedDisks = new HashSet<Integer>();
            if (this.currentDriveA >= 0) {
                this.usedDisks.add(this.currentDriveA);
            }
            if (this.currentDriveB >= 0) {
                this.usedDisks.add(this.currentDriveB);
            }
            if (this.currentCDROM >= 0) {
                this.usedDisks.add(this.currentCDROM);
            }
        }

        private Set<Integer> usedDiskSet() {
            return this.usedDisks;
        }

        @Override
        public void endEventCheck() throws IOException {
        }

        public DiskChanger(PC pC) {
            this.upperBackref = pC;
        }

        public DiskChanger(SRLoader sRLoader) throws IOException {
            super(sRLoader);
            this.upperBackref = (PC)sRLoader.loadObject();
        }

        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            super.dumpSRPartial(sRDumper);
            sRDumper.dumpObject(this.upperBackref);
        }

        @Override
        public long getEventTimeLowBound(long l, String[] stringArray) throws IOException {
            return -1L;
        }

        @Override
        public void setEventRecorder(EventRecorder eventRecorder) {
            this.eRecorder = eventRecorder;
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": DiskChanger:");
            statusDumper.endObject();
        }
    }

    public static class PCHardwareInfo
    implements SRDumpable {
        public byte[] biosID;
        public byte[] vgaBIOSID;
        public byte[] hdaID;
        public byte[] hdbID;
        public byte[] hdcID;
        public byte[] hddID;
        public DiskImageSet images;
        public int initFDAIndex;
        public int initFDBIndex;
        public int initCDROMIndex;
        public long initRTCTime;
        public int cpuDivider;
        public int memoryPages;
        public String fpuEmulator;
        public Map<String, Set<String>> hwModules;
        public DriveSet.BootType bootType;
        public Map<String, Boolean> booleanOptions;
        public Map<String, Integer> intOptions;

        public void dumpStatusPartial(StatusDumper statusDumper) throws IOException {
            if (statusDumper != null) {
                return;
            }
            PrintStream printStream = System.err;
            printStream.println("BIOS " + Misc.arrayToString(this.biosID));
            printStream.println("VGABIOS " + Misc.arrayToString(this.vgaBIOSID));
            if (this.hdaID != null) {
                printStream.println("HDA " + Misc.arrayToString(this.hdaID));
            }
            if (this.hdbID != null) {
                printStream.println("HDB " + Misc.arrayToString(this.hdbID));
            }
            if (this.hdcID != null) {
                printStream.println("HDC " + Misc.arrayToString(this.hdcID));
            }
            if (this.hddID != null) {
                printStream.println("HDD " + Misc.arrayToString(this.hddID));
            }
            int n = 1 + this.images.highestDiskIndex();
            for (int i = 0; i < n; ++i) {
                DiskImage entry = this.images.lookupDisk(i);
                if (entry == null) continue;
                printStream.println("DISK " + i + " " + Misc.arrayToString(entry.getImageID()));
            }
            if (this.initFDAIndex >= 0) {
                printStream.println("FDA " + this.initFDAIndex);
            }
            if (this.initFDBIndex >= 0) {
                printStream.println("FDB " + this.initFDBIndex);
            }
            if (this.initCDROMIndex >= 0) {
                printStream.println("CDROM " + this.initCDROMIndex);
            }
            printStream.println("INITIALTIME " + this.initRTCTime);
            printStream.println("CPUDIVIDER " + (this.cpuDivider - 1));
            if (this.fpuEmulator != null) {
                printStream.println("FPU " + this.fpuEmulator);
            }
            if (this.bootType == DriveSet.BootType.FLOPPY) {
                printStream.println("BOOT FLOPPY");
            } else if (this.bootType == DriveSet.BootType.HARD_DRIVE) {
                printStream.println("BOOT HDD");
            } else if (this.bootType == DriveSet.BootType.CDROM) {
                printStream.println("BOOT CDROM");
            } else if (this.bootType != null) {
                throw new IOException("Unknown boot type");
            }
            if (this.hwModules != null && !this.hwModules.isEmpty()) {
                for (Map.Entry<String, Set<String>> entry : this.hwModules.entrySet()) {
                    for (String string : entry.getValue()) {
                        if (string != null) {
                            printStream.println("LOADMODULEA " + entry.getKey() + "(" + string + ")");
                            continue;
                        }
                        printStream.println("LOADMODULE " + entry.getKey());
                    }
                }
            }
            if (this.booleanOptions != null) {
                for (Map.Entry<String, Boolean> entry : this.booleanOptions.entrySet()) {
                    if (!entry.getValue().booleanValue()) continue;
                    printStream.println(entry.getKey());
                }
            }
            if (this.intOptions != null) {
                for (Map.Entry<String, Integer> entry : this.intOptions.entrySet()) {
                    if (entry.getValue() == 0) continue;
                    printStream.println(entry.getKey() + " " + entry.getValue());
                }
            }
        }

        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": PCHardwareInfo:");
            try {
                this.dumpStatusPartial(statusDumper);
            }
            catch (Exception exception) {
                // empty catch block
            }
            statusDumper.endObject();
        }

        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            sRDumper.dumpArray(this.biosID);
            sRDumper.dumpArray(this.vgaBIOSID);
            sRDumper.dumpArray(this.hdaID);
            sRDumper.dumpArray(this.hdbID);
            sRDumper.dumpArray(this.hdcID);
            sRDumper.dumpArray(this.hddID);
            sRDumper.dumpObject(this.images);
            sRDumper.dumpInt(this.initFDAIndex);
            sRDumper.dumpInt(this.initFDBIndex);
            sRDumper.dumpInt(this.initCDROMIndex);
            sRDumper.dumpLong(this.initRTCTime);
            sRDumper.dumpInt(this.cpuDivider);
            sRDumper.dumpInt(this.memoryPages);
            sRDumper.dumpString(this.fpuEmulator);
            if (this.hwModules != null) {
                sRDumper.dumpBoolean(true);
                for (Map.Entry<String, Set<String>> entry : this.hwModules.entrySet()) {
                    sRDumper.dumpBoolean(true);
                    sRDumper.dumpString(entry.getKey());
                    for (String string : entry.getValue()) {
                        sRDumper.dumpBoolean(true);
                        sRDumper.dumpString(string);
                    }
                    sRDumper.dumpBoolean(false);
                }
                sRDumper.dumpBoolean(false);
            } else {
                sRDumper.dumpBoolean(false);
            }
            sRDumper.dumpByte(DriveSet.BootType.toNumeric(this.bootType));
            sRDumper.dumpBoolean(false);
            sRDumper.dumpBoolean(false);
            sRDumper.dumpBoolean(false);
            if (this.intOptions != null) {
                for (Map.Entry<String, Object> entry : this.booleanOptions.entrySet()) {
                    if (!((Boolean)entry.getValue()).booleanValue()) continue;
                    sRDumper.dumpBoolean(true);
                    sRDumper.dumpString(entry.getKey());
                }
            }
            sRDumper.dumpBoolean(false);
            if (this.intOptions != null) {
                for (Map.Entry<String, Object> entry : this.intOptions.entrySet()) {
                    if ((Integer)entry.getValue() == 0) continue;
                    sRDumper.dumpBoolean(true);
                    sRDumper.dumpString(entry.getKey());
                    sRDumper.dumpInt((Integer)entry.getValue());
                }
            }
            sRDumper.dumpBoolean(false);
        }

        public PCHardwareInfo() {
            this.images = new DiskImageSet();
        }

        public PCHardwareInfo(SRLoader sRLoader) throws IOException {
            boolean bl;
            sRLoader.objectCreated(this);
            this.biosID = sRLoader.loadArrayByte();
            this.vgaBIOSID = sRLoader.loadArrayByte();
            this.hdaID = sRLoader.loadArrayByte();
            this.hdbID = sRLoader.loadArrayByte();
            this.hdcID = sRLoader.loadArrayByte();
            this.hddID = sRLoader.loadArrayByte();
            this.images = (DiskImageSet)sRLoader.loadObject();
            this.initFDAIndex = sRLoader.loadInt();
            this.initFDBIndex = sRLoader.loadInt();
            this.initCDROMIndex = sRLoader.loadInt();
            this.initRTCTime = sRLoader.loadLong();
            this.cpuDivider = sRLoader.loadInt();
            this.memoryPages = sRLoader.loadInt();
            this.fpuEmulator = sRLoader.loadString();
            boolean bl2 = sRLoader.loadBoolean();
            if (bl2) {
                this.hwModules = new LinkedHashMap<String, Set<String>>();
                bl2 = sRLoader.loadBoolean();
                while (bl2) {
                    String string = sRLoader.loadString();
                    this.hwModules.put(string, new LinkedHashSet());
                    bl = sRLoader.loadBoolean();
                    while (bl) {
                        String string2 = sRLoader.loadString();
                        bl = sRLoader.loadBoolean();
                        this.hwModules.get(string).add(string2);
                    }
                    bl2 = sRLoader.loadBoolean();
                }
            }
            this.bootType = DriveSet.BootType.fromNumeric(sRLoader.loadByte());
            boolean bl3 = sRLoader.loadBoolean();
            bl = sRLoader.loadBoolean();
            boolean bl4 = sRLoader.loadBoolean();
            this.booleanOptions = new TreeMap<String, Boolean>();
            this.intOptions = new TreeMap<String, Integer>();
            if (bl3) {
                this.booleanOptions.put("IOPORTDELAY", true);
            }
            if (bl) {
                this.booleanOptions.put("VGAHRETRACE", true);
            }
            if (bl4) {
                this.booleanOptions.put("FLUSHONMODIFY", true);
            }
            while (sRLoader.loadBoolean()) {
                this.booleanOptions.put(sRLoader.loadString(), true);
            }
            while (sRLoader.loadBoolean()) {
                String string = sRLoader.loadString();
                int n = sRLoader.loadInt();
                this.intOptions.put(string, n);
            }
        }

        public void makeHWInfoSegment(UTFOutputLineStream uTFOutputLineStream, DiskChanger diskChanger) throws IOException {
            uTFOutputLineStream.encodeLine("BIOS", Misc.arrayToString(this.biosID));
            uTFOutputLineStream.encodeLine("VGABIOS", Misc.arrayToString(this.vgaBIOSID));
            uTFOutputLineStream.encodeLine("HDA", Misc.arrayToString(this.hdaID));
            uTFOutputLineStream.encodeLine("HDB", Misc.arrayToString(this.hdbID));
            uTFOutputLineStream.encodeLine("HDC", Misc.arrayToString(this.hdcID));
            uTFOutputLineStream.encodeLine("HDD", Misc.arrayToString(this.hddID));
            Set set = diskChanger.usedDiskSet();
            int n = 1 + this.images.highestDiskIndex();
            for (int i = 0; i < n; ++i) {
                DiskImage entry = this.images.lookupDisk(i);
                if (entry == null || !set.contains(i)) continue;
                uTFOutputLineStream.encodeLine("DISK", i, Misc.arrayToString(entry.getImageID()));
                uTFOutputLineStream.encodeLine("DISKNAME", i, entry.getName());
            }
            if (this.initFDAIndex >= 0) {
                uTFOutputLineStream.encodeLine("FDA", this.initFDAIndex);
            }
            if (this.initFDBIndex >= 0) {
                uTFOutputLineStream.encodeLine("FDB", this.initFDBIndex);
            }
            if (this.initCDROMIndex >= 0) {
                uTFOutputLineStream.encodeLine("CDROM", this.initCDROMIndex);
            }
            uTFOutputLineStream.encodeLine("INITIALTIME", this.initRTCTime);
            uTFOutputLineStream.encodeLine("CPUDIVIDER", this.cpuDivider);
            uTFOutputLineStream.encodeLine("MEMORYSIZE", this.memoryPages);
            uTFOutputLineStream.encodeLine("FPU", this.fpuEmulator);
            if (this.bootType == DriveSet.BootType.FLOPPY) {
                uTFOutputLineStream.encodeLine("BOOT", "FLOPPY");
            } else if (this.bootType == DriveSet.BootType.HARD_DRIVE) {
                uTFOutputLineStream.encodeLine("BOOT", "HDD");
            } else if (this.bootType == DriveSet.BootType.CDROM) {
                uTFOutputLineStream.encodeLine("BOOT", "CDROM");
            } else if (this.bootType != null) {
                throw new IOException("Unknown boot type");
            }
            if (this.hwModules != null && !this.hwModules.isEmpty()) {
                for (Map.Entry<String, Set<String>> entry : this.hwModules.entrySet()) {
                    for (String string : entry.getValue()) {
                        if (string != null) {
                            uTFOutputLineStream.encodeLine("LOADMODULEA", entry.getKey(), string);
                            continue;
                        }
                        uTFOutputLineStream.encodeLine("LOADMODULE", entry.getKey());
                    }
                }
            }
            if (this.booleanOptions != null) {
                for (Map.Entry<String, Boolean> entry : this.booleanOptions.entrySet()) {
                    if (!entry.getValue().booleanValue()) continue;
                    uTFOutputLineStream.encodeLine(entry.getKey());
                }
            }
            if (this.intOptions != null) {
                for (Map.Entry<String, Integer> entry : this.intOptions.entrySet()) {
                    if (entry.getValue() == 0) continue;
                    uTFOutputLineStream.encodeLine(entry.getKey(), entry.getValue().toString());
                }
            }
        }

        public static int componentsForLine(String string) {
            if ("BIOS".equals(string)) {
                return 2;
            }
            if ("VGABIOS".equals(string)) {
                return 2;
            }
            if ("HDA".equals(string)) {
                return 2;
            }
            if ("HDB".equals(string)) {
                return 2;
            }
            if ("HDC".equals(string)) {
                return 2;
            }
            if ("HDD".equals(string)) {
                return 2;
            }
            if ("FDA".equals(string)) {
                return 2;
            }
            if ("FDB".equals(string)) {
                return 2;
            }
            if ("CDROM".equals(string)) {
                return 2;
            }
            if ("INITIALTIME".equals(string)) {
                return 2;
            }
            if ("CPUDIVIDER".equals(string)) {
                return 2;
            }
            if ("MEMORYSIZE".equals(string)) {
                return 2;
            }
            if ("FPU".equals(string)) {
                return 2;
            }
            if ("BOOT".equals(string)) {
                return 2;
            }
            if ("LOADMODULE".equals(string)) {
                return 2;
            }
            if ("LOADMODULEA".equals(string)) {
                return 3;
            }
            if ("DISK".equals(string)) {
                return 3;
            }
            if ("DISKNAME".equals(string)) {
                return 3;
            }
            return 0;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static PCHardwareInfo parseHWInfoSegment(UTFInputLineStream uTFInputLineStream) throws IOException {
            PCHardwareInfo pCHardwareInfo = new PCHardwareInfo();
            pCHardwareInfo.booleanOptions = new TreeMap<String, Boolean>();
            pCHardwareInfo.intOptions = new TreeMap<String, Integer>();
            pCHardwareInfo.initFDAIndex = -1;
            pCHardwareInfo.initFDBIndex = -1;
            pCHardwareInfo.initCDROMIndex = -1;
            pCHardwareInfo.images = new DiskImageSet();
            pCHardwareInfo.hwModules = new LinkedHashMap<String, Set<String>>();
            String[] stringArray = Misc.nextParseLine(uTFInputLineStream);
            while (stringArray != null) {
                if (PCHardwareInfo.componentsForLine(stringArray[0]) == 0 && stringArray.length == 1) {
                    pCHardwareInfo.booleanOptions.put(stringArray[0], true);
                    stringArray = Misc.nextParseLine(uTFInputLineStream);
                    continue;
                }
                if (PCHardwareInfo.componentsForLine(stringArray[0]) == 0 && stringArray.length == 2) {
                    try {
                        pCHardwareInfo.intOptions.put(stringArray[0], Integer.parseInt(stringArray[1]));
                    }
                    catch (Exception exception) {
                        throw new IOException("Bad " + stringArray[0] + " line in initialization segment");
                    }
                    stringArray = Misc.nextParseLine(uTFInputLineStream);
                    continue;
                }
                if (stringArray.length != PCHardwareInfo.componentsForLine(stringArray[0])) {
                    throw new IOException("Bad " + stringArray[0] + " line in ininitialization segment: " + "expected " + PCHardwareInfo.componentsForLine(stringArray[0]) + " components, got " + stringArray.length);
                }
                if ("BIOS".equals(stringArray[0])) {
                    pCHardwareInfo.biosID = Misc.stringToArray(stringArray[1]);
                } else if ("VGABIOS".equals(stringArray[0])) {
                    pCHardwareInfo.vgaBIOSID = Misc.stringToArray(stringArray[1]);
                } else if ("HDA".equals(stringArray[0])) {
                    pCHardwareInfo.hdaID = Misc.stringToArray(stringArray[1]);
                } else if ("HDB".equals(stringArray[0])) {
                    pCHardwareInfo.hdbID = Misc.stringToArray(stringArray[1]);
                } else if ("HDC".equals(stringArray[0])) {
                    pCHardwareInfo.hdcID = Misc.stringToArray(stringArray[1]);
                } else if ("HDD".equals(stringArray[0])) {
                    pCHardwareInfo.hddID = Misc.stringToArray(stringArray[1]);
                } else if ("DISK".equals(stringArray[0])) {
                    int n;
                    try {
                        n = Integer.parseInt(stringArray[1]);
                        if (n < 0) {
                            throw new NumberFormatException("Bad id");
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IOException("Bad DISK line in initialization segment");
                    }
                    pCHardwareInfo.images.addDisk(n, new DiskImage(stringArray[2], false));
                } else {
                    if ("DISKNAME".equals(stringArray[0])) {
                        try {
                            int n = Integer.parseInt(stringArray[1]);
                            if (n < 0) {
                                throw new NumberFormatException("Bad id");
                            }
                            pCHardwareInfo.images.lookupDisk(n).setName(stringArray[2]);
                        }
                        catch (Exception exception) {
                            throw new IOException("Bad DISKNAME line in initialization segment");
                        }
                    }
                    if ("FDA".equals(stringArray[0])) {
                        int n;
                        try {
                            n = Integer.parseInt(stringArray[1]);
                            if (n < 0) {
                                throw new NumberFormatException("Bad id");
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new IOException("Bad FDA line in initialization segment");
                        }
                        pCHardwareInfo.initFDAIndex = n;
                    } else if ("FDB".equals(stringArray[0])) {
                        int n;
                        try {
                            n = Integer.parseInt(stringArray[1]);
                            if (n < 0) {
                                throw new NumberFormatException("Bad id");
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new IOException("Bad FDB line in initialization segment");
                        }
                        pCHardwareInfo.initFDBIndex = n;
                    } else if ("CDROM".equals(stringArray[0])) {
                        int n;
                        try {
                            n = Integer.parseInt(stringArray[1]);
                            if (n < 0) {
                                throw new NumberFormatException("Bad id");
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new IOException("Bad CDROM line in initialization segment");
                        }
                        pCHardwareInfo.initCDROMIndex = n;
                    } else if ("INITIALTIME".equals(stringArray[0])) {
                        long l;
                        try {
                            l = Long.parseLong(stringArray[1]);
                            if (l < 0L || l > 4102444799999L) {
                                throw new NumberFormatException("Bad id");
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new IOException("Bad INITIALTIME line in initialization segment");
                        }
                        pCHardwareInfo.initRTCTime = l;
                    } else if ("CPUDIVIDER".equals(stringArray[0])) {
                        int n;
                        try {
                            n = Integer.parseInt(stringArray[1]);
                            if (n < 1 || n > 256) {
                                throw new NumberFormatException("Bad id");
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new IOException("Bad CPUDIVIDER line in initialization segment");
                        }
                        pCHardwareInfo.cpuDivider = n;
                    } else if ("MEMORYSIZE".equals(stringArray[0])) {
                        int n;
                        try {
                            n = Integer.parseInt(stringArray[1]);
                            if (n < 256 || n > 262144) {
                                throw new NumberFormatException("Bad id");
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new IOException("Bad MEMORYSIZE line in initialization segment");
                        }
                        pCHardwareInfo.memoryPages = n;
                    } else if ("FPU".equals(stringArray[0])) {
                        pCHardwareInfo.fpuEmulator = stringArray[1];
                    } else if ("BOOT".equals(stringArray[0])) {
                        if ("FLOPPY".equals(stringArray[1])) {
                            pCHardwareInfo.bootType = DriveSet.BootType.FLOPPY;
                        } else if ("HDD".equals(stringArray[1])) {
                            pCHardwareInfo.bootType = DriveSet.BootType.HARD_DRIVE;
                        } else {
                            if (!"CDROM".equals(stringArray[1])) throw new IOException("Bad BOOT line in initialization segment");
                            pCHardwareInfo.bootType = DriveSet.BootType.CDROM;
                        }
                    } else if ("LOADMODULE".equals(stringArray[0])) {
                        if (!pCHardwareInfo.hwModules.containsKey(stringArray[1])) {
                            pCHardwareInfo.hwModules.put(stringArray[1], new LinkedHashSet());
                        }
                        pCHardwareInfo.hwModules.get(stringArray[1]).add(null);
                    } else if ("LOADMODULEA".equals(stringArray[0])) {
                        if (!pCHardwareInfo.hwModules.containsKey(stringArray[1])) {
                            pCHardwareInfo.hwModules.put(stringArray[1], new LinkedHashSet());
                        }
                        pCHardwareInfo.hwModules.get(stringArray[1]).add(stringArray[2]);
                    }
                }
                stringArray = Misc.nextParseLine(uTFInputLineStream);
            }
            return pCHardwareInfo;
        }
    }
}

