/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Stack;
import org.jpc.emulator.SRDumpable;

public final class SRDumper {
    public static final byte TYPE_BOOLEAN = 1;
    public static final byte TYPE_BYTE = 2;
    public static final byte TYPE_SHORT = 3;
    public static final byte TYPE_INT = 4;
    public static final byte TYPE_LONG = 5;
    public static final byte TYPE_STRING = 6;
    public static final byte TYPE_BOOLEAN_ARRAY = 7;
    public static final byte TYPE_BYTE_ARRAY = 8;
    public static final byte TYPE_SHORT_ARRAY = 9;
    public static final byte TYPE_INT_ARRAY = 10;
    public static final byte TYPE_LONG_ARRAY = 11;
    public static final byte TYPE_DOUBLE_ARRAY = 12;
    public static final byte TYPE_OBJECT = 13;
    public static final byte TYPE_OBJECT_START = 14;
    public static final byte TYPE_OBJECT_END = 15;
    public static final byte TYPE_SPECIAL_OBJECT = 16;
    public static final byte TYPE_OBJECT_NOT_PRESENT = 19;
    public static final byte TYPE_DOUBLE = 20;
    OutputStream underlyingOutput;
    int nextObjectNumber = 0;
    static final Boolean FALSE = new Boolean(false);
    static final Boolean TRUE = new Boolean(true);
    private Stack<Integer> objectStack;
    private int firstUnseenObject;
    HashMap<Integer, ObjectListEntry> chainingLists;
    HashSet<String> constructors;
    int objectsCount;
    private int bufferStart;
    private byte[] buffer;
    private static final int BUFFER_MAXSIZE = 4096;

    public void writeConstructorManifest(OutputStream outputStream) throws IOException {
        for (String string : this.constructors) {
            ByteBuffer byteBuffer;
            try {
                byteBuffer = Charset.forName("UTF-8").newEncoder().encode(CharBuffer.wrap(string));
            }
            catch (CharacterCodingException characterCodingException) {
                throw new IOException("WTF??? UTF-8 can't encode String???");
            }
            byte[] byArray = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray);
            if (byArray.length > 1024) {
                throw new IOException("Class name length of 1024 bytes exceeded");
            }
            outputStream.write(byArray);
            outputStream.write(10);
        }
    }

    private void ensureBufferSpace(int n) throws IOException {
        if (n > 4096) {
            throw new IllegalStateException("ensureBufferSpace: The amount requested is too large.");
        }
        while (n > 4096 - this.bufferStart) {
            this.underlyingOutput.write(this.buffer, 0, this.bufferStart);
            this.bufferStart = 0;
        }
    }

    public SRDumper(OutputStream outputStream) {
        this.underlyingOutput = outputStream;
        this.firstUnseenObject = 0;
        this.chainingLists = new HashMap();
        this.objectStack = new Stack();
        this.objectsCount = 0;
        this.constructors = new HashSet();
        this.bufferStart = 0;
        this.buffer = new byte[4096];
    }

    public void flush() throws IOException {
        this.ensureBufferSpace(4096);
    }

    public void dumpBoolean(boolean bl) throws IOException {
        this.ensureBufferSpace(2);
        this.buffer[this.bufferStart++] = 1;
        this.buffer[this.bufferStart++] = bl ? (byte)1 : 0;
    }

    public void dumpByte(byte by) throws IOException {
        this.ensureBufferSpace(2);
        this.buffer[this.bufferStart++] = 2;
        this.buffer[this.bufferStart++] = by;
    }

    public void dumpShort(short s, boolean bl) throws IOException {
        if (bl) {
            this.ensureBufferSpace(2);
        }
        this.buffer[this.bufferStart++] = (byte)(s >>> 8);
        this.buffer[this.bufferStart++] = (byte)s;
    }

    public void dumpShort(short s) throws IOException {
        this.ensureBufferSpace(3);
        this.buffer[this.bufferStart++] = 3;
        this.dumpShort(s, false);
    }

    public void dumpInt(int n, boolean bl) throws IOException {
        if (bl) {
            this.ensureBufferSpace(4);
        }
        this.buffer[this.bufferStart++] = (byte)(n >>> 24);
        this.buffer[this.bufferStart++] = (byte)(n >>> 16);
        this.buffer[this.bufferStart++] = (byte)(n >>> 8);
        this.buffer[this.bufferStart++] = (byte)n;
    }

    public void dumpInt(int n) throws IOException {
        this.ensureBufferSpace(5);
        this.buffer[this.bufferStart++] = 4;
        this.dumpInt(n, false);
    }

    public void dumpLong(long l, boolean bl) throws IOException {
        if (bl) {
            this.ensureBufferSpace(8);
        }
        this.buffer[this.bufferStart++] = (byte)(l >>> 56);
        this.buffer[this.bufferStart++] = (byte)(l >>> 48);
        this.buffer[this.bufferStart++] = (byte)(l >>> 40);
        this.buffer[this.bufferStart++] = (byte)(l >>> 32);
        this.buffer[this.bufferStart++] = (byte)(l >>> 24);
        this.buffer[this.bufferStart++] = (byte)(l >>> 16);
        this.buffer[this.bufferStart++] = (byte)(l >>> 8);
        this.buffer[this.bufferStart++] = (byte)l;
    }

    public void dumpLong(long l) throws IOException {
        this.ensureBufferSpace(9);
        this.buffer[this.bufferStart++] = 5;
        this.dumpLong(l, false);
    }

    public void dumpDouble(double d) throws IOException {
        this.ensureBufferSpace(9);
        this.buffer[this.bufferStart++] = 20;
        this.dumpLong(Double.doubleToLongBits(d), false);
    }

    public void dumpString(String string) throws IOException {
        this.ensureBufferSpace(2);
        this.buffer[this.bufferStart++] = 6;
        if (string != null) {
            char c;
            int n;
            this.buffer[this.bufferStart++] = 1;
            int n2 = 0;
            int n3 = string.length();
            for (n = 0; n < n3; ++n) {
                c = string.charAt(n);
                if (c == '\u0000') {
                    n2 += 2;
                    continue;
                }
                if (c < '\u0080') {
                    ++n2;
                    continue;
                }
                if (c < '\u0800') {
                    n2 += 2;
                    continue;
                }
                n2 += 3;
            }
            this.dumpShort((short)n2, true);
            for (n = 0; n < n3; ++n) {
                c = string.charAt(n);
                if (c == '\u0000') {
                    this.ensureBufferSpace(2);
                    this.buffer[this.bufferStart++] = -64;
                    this.buffer[this.bufferStart++] = -128;
                    continue;
                }
                if (c < '\u0080') {
                    this.ensureBufferSpace(1);
                    this.buffer[this.bufferStart++] = (byte)c;
                    continue;
                }
                if (c < '\u0800') {
                    this.ensureBufferSpace(2);
                    this.buffer[this.bufferStart++] = (byte)((c >> 6) + 192);
                    this.buffer[this.bufferStart++] = (byte)(128 + c & 0x3F);
                    continue;
                }
                this.ensureBufferSpace(3);
                this.buffer[this.bufferStart++] = (byte)((c >> 12) + 224);
                this.buffer[this.bufferStart++] = (byte)(128 + (c >> 6) & 0x3F);
                this.buffer[this.bufferStart++] = (byte)(128 + c & 0x3F);
            }
        } else {
            this.buffer[this.bufferStart++] = 0;
        }
    }

    public void dumpArray(boolean[] blArray) throws IOException {
        this.ensureBufferSpace(2);
        this.buffer[this.bufferStart++] = 7;
        if (blArray != null) {
            this.buffer[this.bufferStart++] = 1;
            this.dumpInt(blArray.length, true);
            for (int i = 0; i < blArray.length; ++i) {
                if (this.bufferStart > 4095) {
                    this.ensureBufferSpace(1);
                }
                this.buffer[this.bufferStart++] = blArray[i] ? (byte)1 : 0;
            }
        } else {
            this.buffer[this.bufferStart++] = 0;
        }
    }

    public void dumpArray(byte[] byArray) throws IOException {
        this.ensureBufferSpace(2);
        this.buffer[this.bufferStart++] = 8;
        if (byArray != null) {
            this.buffer[this.bufferStart++] = 1;
            this.dumpInt(byArray.length, true);
            int n = byArray.length;
            int n2 = 0;
            while (n > 0) {
                int n3 = n;
                if (n3 > 4096) {
                    n3 = 4096;
                }
                this.ensureBufferSpace(n3);
                System.arraycopy(byArray, n2, this.buffer, this.bufferStart, n3);
                this.bufferStart += n3;
                n -= n3;
                n2 += n3;
            }
        } else {
            this.buffer[this.bufferStart++] = 0;
        }
    }

    public void dumpArray(short[] sArray) throws IOException {
        this.ensureBufferSpace(2);
        this.buffer[this.bufferStart++] = 9;
        if (sArray != null) {
            this.buffer[this.bufferStart++] = 1;
            this.dumpInt(sArray.length, true);
            int n = sArray.length;
            int n2 = 0;
            while (n > 0) {
                int n3 = n;
                if (n3 > 2048) {
                    n3 = 2048;
                }
                this.ensureBufferSpace(2 * n3);
                for (int i = 0; i < n3; ++i) {
                    this.dumpShort(sArray[n2 + i], false);
                }
                n -= n3;
                n2 += n3;
            }
        } else {
            this.buffer[this.bufferStart++] = 0;
        }
    }

    public void dumpArray(int[] nArray) throws IOException {
        this.ensureBufferSpace(2);
        this.buffer[this.bufferStart++] = 10;
        if (nArray != null) {
            this.buffer[this.bufferStart++] = 1;
            this.dumpInt(nArray.length, true);
            int n = nArray.length;
            int n2 = 0;
            while (n > 0) {
                int n3 = n;
                if (n3 > 1024) {
                    n3 = 1024;
                }
                this.ensureBufferSpace(4 * n3);
                for (int i = 0; i < n3; ++i) {
                    this.dumpInt(nArray[n2 + i], false);
                }
                n -= n3;
                n2 += n3;
            }
        } else {
            this.buffer[this.bufferStart++] = 0;
        }
    }

    public void dumpArray(long[] lArray) throws IOException {
        this.ensureBufferSpace(2);
        this.buffer[this.bufferStart++] = 11;
        if (lArray != null) {
            this.buffer[this.bufferStart++] = 1;
            this.dumpInt(lArray.length, true);
            int n = lArray.length;
            int n2 = 0;
            while (n > 0) {
                int n3 = n;
                if (n3 > 512) {
                    n3 = 512;
                }
                this.ensureBufferSpace(8 * n3);
                for (int i = 0; i < n3; ++i) {
                    this.dumpLong(lArray[n2 + i], false);
                }
                n -= n3;
                n2 += n3;
            }
        } else {
            this.buffer[this.bufferStart++] = 0;
        }
    }

    public void dumpArray(double[] dArray) throws IOException {
        this.ensureBufferSpace(2);
        this.buffer[this.bufferStart++] = 12;
        if (dArray != null) {
            this.buffer[this.bufferStart++] = 1;
            this.dumpInt(dArray.length, true);
            int n = dArray.length;
            int n2 = 0;
            while (n > 0) {
                int n3 = n;
                if (n3 > 512) {
                    n3 = 512;
                }
                this.ensureBufferSpace(8 * n3);
                for (int i = 0; i < n3; ++i) {
                    this.dumpLong(Double.doubleToLongBits(dArray[n2 + i]), false);
                }
                n -= n3;
                n2 += n3;
            }
        } else {
            this.buffer[this.bufferStart++] = 0;
        }
    }

    public void dumpObject(SRDumpable sRDumpable) throws IOException {
        this.ensureBufferSpace(1);
        this.buffer[this.bufferStart++] = 13;
        this.dumpInt(this.objectNumber(sRDumpable));
        if (sRDumpable != null) {
            this.builtinDumpSR(sRDumpable);
        }
    }

    public void specialObject(SRDumpable sRDumpable) throws IOException {
        int n = this.objectNumber(sRDumpable);
        this.ensureBufferSpace(1);
        this.buffer[this.bufferStart++] = 16;
        this.dumpInt(n);
        this.firstUnseenObject = n + 1;
    }

    private void builtinDumpSR(SRDumpable sRDumpable) throws IOException {
        try {
            if (this.dumped(sRDumpable)) {
                return;
            }
            sRDumpable.dumpSRPartial(this);
            this.endObject();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable.getCause();
            if (throwable2 instanceof RuntimeException) {
                throw (RuntimeException)throwable2;
            }
            if (throwable2 instanceof Error) {
                throw (Error)throwable2;
            }
            if (throwable2 instanceof IOException) {
                throw (IOException)throwable2;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new IOException("Unknown exception while invoking dumper: " + throwable2);
        }
    }

    public int dumpedObjects() {
        return this.objectsCount;
    }

    private void addObject(Object object, int n) {
        Integer n2 = new Integer(System.identityHashCode(object));
        ObjectListEntry objectListEntry = new ObjectListEntry();
        objectListEntry.object = object;
        objectListEntry.num = n;
        objectListEntry.next = null;
        if (!this.chainingLists.containsKey(n2)) {
            this.chainingLists.put(n2, objectListEntry);
        } else {
            objectListEntry.next = this.chainingLists.get(n2);
            this.chainingLists.put(n2, objectListEntry);
        }
    }

    private int lookupObject(Object object) {
        Integer n = new Integer(System.identityHashCode(object));
        if (!this.chainingLists.containsKey(n)) {
            return -1;
        }
        ObjectListEntry objectListEntry = this.chainingLists.get(n);
        while (objectListEntry != null) {
            if (objectListEntry.object == object) {
                return objectListEntry.num;
            }
            objectListEntry = objectListEntry.next;
        }
        return -1;
    }

    public int objectNumber(Object object) {
        boolean bl = false;
        if (object == null) {
            return -1;
        }
        int n = this.lookupObject(object);
        if (n == -1) {
            bl = true;
        }
        if (bl) {
            n = this.nextObjectNumber++;
            this.addObject(object, n);
        }
        return n;
    }

    public boolean dumped(Object object) throws IOException {
        int n = this.objectNumber(object);
        Integer n2 = new Integer(n);
        if (n >= this.firstUnseenObject) {
            this.firstUnseenObject = n + 1;
            ++this.objectsCount;
            this.ensureBufferSpace(1);
            this.buffer[this.bufferStart++] = 14;
            this.dumpString(object.getClass().getName());
            this.constructors.add(object.getClass().getName());
            this.objectStack.push(n2);
            return false;
        }
        this.ensureBufferSpace(1);
        this.buffer[this.bufferStart++] = 19;
        return true;
    }

    public void endObject() throws IOException {
        this.ensureBufferSpace(1);
        this.buffer[this.bufferStart++] = 15;
    }

    static class ObjectListEntry {
        public Object object;
        public int num;
        public ObjectListEntry next;

        ObjectListEntry() {
        }
    }
}

