/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator;

import java.io.IOException;
import org.jpc.emulator.Clock;
import org.jpc.emulator.SRDumpable;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.TimerResponsive;

public class Timer
implements Comparable<Timer>,
SRDumpable {
    private long expireTime;
    private TimerResponsive callback;
    private boolean enabled;
    private Clock myOwner;

    public Timer(TimerResponsive timerResponsive, Clock clock) {
        this.myOwner = clock;
        this.callback = timerResponsive;
        this.enabled = false;
    }

    public void dumpStatusPartial(StatusDumper statusDumper) {
        statusDumper.println("\texpireTime " + this.expireTime + " enabled " + this.enabled);
        statusDumper.println("\tcallback <object #" + statusDumper.objectNumber(this.callback) + ">");
        if (this.callback != null) {
            this.callback.dumpStatus(statusDumper);
        }
        statusDumper.println("\tmyOwner <object #" + statusDumper.objectNumber(this.myOwner) + ">");
        if (this.myOwner != null) {
            this.myOwner.dumpStatus(statusDumper);
        }
    }

    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": Timer:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        sRDumper.dumpLong(this.expireTime);
        sRDumper.dumpBoolean(this.enabled);
        sRDumper.dumpObject(this.callback);
        sRDumper.dumpObject(this.myOwner);
    }

    public Timer(SRLoader sRLoader) throws IOException {
        sRLoader.objectCreated(this);
        this.expireTime = sRLoader.loadLong();
        this.enabled = sRLoader.loadBoolean();
        this.callback = (TimerResponsive)sRLoader.loadObject();
        this.myOwner = (Clock)sRLoader.loadObject();
    }

    public int getTimerType() {
        return this.callback.getTimerType();
    }

    public synchronized boolean enabled() {
        return this.enabled;
    }

    public synchronized void disable() {
        this.setStatus(false);
    }

    public synchronized void setExpiry(long l) {
        this.expireTime = l;
        this.setStatus(true);
    }

    public synchronized boolean check(long l) {
        if (this.enabled && l >= this.expireTime) {
            this.disable();
            this.callback.callback();
            return true;
        }
        return false;
    }

    private void setStatus(boolean bl) {
        this.enabled = bl;
        this.myOwner.update(this);
    }

    public long getExpiry() {
        return this.expireTime;
    }

    public String toString() {
        if (this.enabled) {
            return "Timer for " + this.callback.toString() + " [" + this.expireTime + "]";
        }
        return "Timer for " + this.callback.toString() + " [Disabled]";
    }

    @Override
    public int compareTo(Timer timer) {
        if (this.getExpiry() - timer.getExpiry() < 0L) {
            return -1;
        }
        if (this.getExpiry() == timer.getExpiry()) {
            return 0;
        }
        return 1;
    }

    public int hashCode() {
        int n = 7;
        n = 67 * n + (int)(this.expireTime ^ this.expireTime >>> 32);
        n = 67 * n + (this.enabled ? 1 : 0);
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Timer)) {
            return false;
        }
        Timer timer = (Timer)object;
        return timer.enabled() == this.enabled() && timer.getExpiry() == this.getExpiry();
    }
}

