/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator;

import java.io.IOException;
import org.jpc.emulator.AbstractHardwareComponent;
import org.jpc.emulator.Clock;
import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.Timer;
import org.jpc.emulator.TimerResponsive;
import org.jpc.emulator.processor.Processor;

public class TraceTrap
extends AbstractHardwareComponent
implements TimerResponsive {
    private long traceFlags;
    private boolean trapActive;
    private Timer trapTimer;
    private Processor processor;
    public static final long TRACE_STOP_VRETRACE_START = 1L;
    public static final long TRACE_STOP_VRETRACE_END = 2L;
    public static final long TRACE_STOP_IMMEDIATE = Integer.MIN_VALUE;

    public TraceTrap() {
        this.traceFlags = 0L;
        this.trapActive = false;
        this.trapTimer = null;
    }

    public void setTrapTime(long l) {
        this.trapTimer.setExpiry(l);
    }

    public void clearTrapTime() {
        this.trapTimer.disable();
    }

    public synchronized boolean getAndClearTrapActive() {
        boolean bl = this.trapActive;
        this.trapActive = false;
        this.processor.eflagsMachineHalt = false;
        return bl;
    }

    public synchronized void setTrapFlag(long l, boolean bl) {
        this.traceFlags = bl ? (this.traceFlags |= l) : (this.traceFlags &= l ^ 0xFFFFFFFFFFFFFFFFL);
        System.err.println("Informational: Trap flags now " + this.traceFlags + ".");
    }

    public synchronized void setTrapFlags(long l) {
        long l2 = this.traceFlags;
        this.traceFlags = l;
        if (l2 != this.traceFlags) {
            System.err.println("Informational: Trap flags now " + this.traceFlags + ".");
        }
    }

    public synchronized long getTrapFlags() {
        return this.traceFlags;
    }

    public synchronized void doPotentialTrap(long l) {
        if (((this.traceFlags | Integer.MIN_VALUE) & l) != 0L) {
            System.err.println("Informational: Doing trap because of " + (this.traceFlags & l) + ".");
            this.trapActive = true;
            this.processor.eflagsMachineHalt = true;
        }
    }

    @Override
    public boolean initialised() {
        return this.trapTimer != null && this.processor != null;
    }

    public boolean updated() {
        return this.trapTimer != null && this.processor != null;
    }

    public void updateComponent(HardwareComponent hardwareComponent) {
    }

    @Override
    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof Clock && hardwareComponent.initialised()) {
            this.trapTimer = ((Clock)hardwareComponent).newTimer(this);
        }
        if (hardwareComponent instanceof Processor && hardwareComponent.initialised()) {
            this.processor = (Processor)hardwareComponent;
        }
    }

    @Override
    public void dumpStatusPartial(StatusDumper statusDumper) {
        super.dumpStatusPartial(statusDumper);
    }

    @Override
    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": TraceTrap:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        super.dumpSRPartial(sRDumper);
        sRDumper.dumpObject(this.processor);
        sRDumper.dumpObject(this.trapTimer);
    }

    public TraceTrap(SRLoader sRLoader) throws IOException {
        super(sRLoader);
        this.processor = (Processor)sRLoader.loadObject();
        this.trapTimer = (Timer)sRLoader.loadObject();
    }

    @Override
    public void callback() {
        this.doPotentialTrap(Integer.MIN_VALUE);
    }

    @Override
    public int getTimerType() {
        return 8;
    }
}

