/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator;

import java.io.IOException;
import org.jpc.emulator.SRDumpable;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;
import org.jpc.output.Output;
import org.jpc.output.OutputChannelVideo;

public class VGADigitalOut
implements SRDumpable {
    private int width;
    private int height;
    private int dirtyXMin;
    private int dirtyXMax;
    private int dirtyYMin;
    private int dirtyYMax;
    private int[] buffer;
    private OutputChannelVideo chan;

    public void holdOutput(long l) {
        this.chan.addFrameVideo(l, (short)this.width, (short)this.height, this.buffer);
    }

    public void setSink(Output output, String string) {
        this.chan = new OutputChannelVideo(output, string);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getDirtyXMin() {
        return this.dirtyXMin;
    }

    public int getDirtyXMax() {
        return this.dirtyXMax;
    }

    public int getDirtyYMin() {
        return this.dirtyYMin;
    }

    public int getDirtyYMax() {
        return this.dirtyYMax;
    }

    public int[] getBuffer() {
        return this.buffer;
    }

    public void dumpStatusPartial(StatusDumper statusDumper) {
        statusDumper.println("\twidth " + this.width + " height " + this.height);
        statusDumper.println("\tdirty area: (" + this.dirtyXMin + "," + this.dirtyYMin + ")-(" + this.dirtyXMax + "," + this.dirtyYMax + ")");
    }

    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": VGADigitalOut:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        sRDumper.dumpInt(this.width);
        sRDumper.dumpInt(this.height);
        sRDumper.dumpInt(this.dirtyXMin);
        sRDumper.dumpInt(this.dirtyXMax);
        sRDumper.dumpInt(this.dirtyYMin);
        sRDumper.dumpInt(this.dirtyYMax);
        sRDumper.dumpArray(this.buffer);
        sRDumper.dumpObject(this.chan);
    }

    public VGADigitalOut(SRLoader sRLoader) throws IOException {
        sRLoader.objectCreated(this);
        this.width = sRLoader.loadInt();
        this.height = sRLoader.loadInt();
        this.dirtyXMin = sRLoader.loadInt();
        this.dirtyXMax = sRLoader.loadInt();
        this.dirtyYMin = sRLoader.loadInt();
        this.dirtyYMax = sRLoader.loadInt();
        this.buffer = sRLoader.loadArrayInt();
        this.chan = (OutputChannelVideo)sRLoader.loadObject();
    }

    public VGADigitalOut() {
        this.buffer = new int[1];
        this.chan = null;
    }

    public int rgbToPixel(int n, int n2, int n3) {
        return (0xFF & n) << 16 | (0xFF & n2) << 8 | 0xFF & n3;
    }

    public void resizeDisplay(int n, int n2) {
        int n3 = n * n2;
        if (n3 == 0) {
            n3 = 1;
        }
        this.buffer = new int[n3];
        this.width = n;
        this.height = n2;
        this.dirtyXMin = 0;
        this.dirtyYMin = 0;
        this.dirtyXMax = this.width;
        this.dirtyYMax = this.height;
    }

    public int[] getDisplayBuffer() {
        return this.buffer;
    }

    public final void dirtyDisplayRegion(int n, int n2, int n3, int n4) {
        this.dirtyXMin = Math.min(n, this.dirtyXMin);
        this.dirtyXMax = Math.max(n + n3, this.dirtyXMax);
        this.dirtyYMin = Math.min(n2, this.dirtyYMin);
        this.dirtyYMax = Math.max(n2 + n4, this.dirtyYMax);
    }

    public void resetDirtyRegion() {
        this.dirtyXMin = this.width;
        this.dirtyYMin = this.height;
        this.dirtyXMax = 0;
        this.dirtyYMax = 0;
    }
}

