/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.memory;

import java.io.IOException;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.memory.Memory;

public abstract class AbstractMemory
implements Memory {
    @Override
    public abstract long getSize();

    @Override
    public abstract byte getByte(int var1);

    @Override
    public abstract void setByte(int var1, byte var2);

    public void dumpStatusPartial(StatusDumper statusDumper) {
    }

    @Override
    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": AbstractMemory:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
    }

    public AbstractMemory(SRLoader sRLoader) throws IOException {
        sRLoader.objectCreated(this);
    }

    public AbstractMemory() {
    }

    @Override
    public void clear() {
        int n = 0;
        while ((long)n < this.getSize()) {
            this.setByte(n, (byte)0);
            ++n;
        }
    }

    @Override
    public void clear(int n, int n2) {
        int n3 = n + n2;
        if ((long)n3 > this.getSize()) {
            throw new ArrayIndexOutOfBoundsException("Attempt to clear outside of memory bounds");
        }
        for (int i = n; i < n3; ++i) {
            this.setByte(i, (byte)0);
        }
    }

    @Override
    public void copyContentsIntoArray(int n, byte[] byArray, int n2, int n3) {
        int n4 = n2;
        while (n4 < n2 + n3) {
            byArray[n4] = this.getByte(n);
            ++n4;
            ++n;
        }
    }

    @Override
    public void copyArrayIntoContents(int n, byte[] byArray, int n2, int n3) {
        int n4 = n2;
        while (n4 < n2 + n3) {
            this.setByte(n, byArray[n4]);
            ++n4;
            ++n;
        }
    }

    protected final short getWordInBytes(int n) {
        int n2 = 0xFF & this.getByte(n + 1);
        n2 <<= 8;
        return (short)(n2 |= 0xFF & this.getByte(n));
    }

    protected final int getDoubleWordInBytes(int n) {
        int n2 = 0xFFFF & this.getWordInBytes(n + 2);
        n2 <<= 16;
        return n2 |= 0xFFFF & this.getWordInBytes(n);
    }

    protected final long getQuadWordInBytes(int n) {
        long l = 0xFFFFFFFFL & (long)this.getDoubleWordInBytes(n + 4);
        l <<= 32;
        return l |= 0xFFFFFFFFL & (long)this.getDoubleWordInBytes(n);
    }

    @Override
    public short getWord(int n) {
        return this.getWordInBytes(n);
    }

    @Override
    public int getDoubleWord(int n) {
        return this.getDoubleWordInBytes(n);
    }

    @Override
    public long getQuadWord(int n) {
        return this.getQuadWordInBytes(n);
    }

    @Override
    public long getLowerDoubleQuadWord(int n) {
        return this.getQuadWordInBytes(n);
    }

    @Override
    public long getUpperDoubleQuadWord(int n) {
        return this.getQuadWordInBytes(n + 8);
    }

    protected final void setWordInBytes(int n, short s) {
        this.setByte(n, (byte)s);
        this.setByte(++n, (byte)(s >> 8));
    }

    protected final void setDoubleWordInBytes(int n, int n2) {
        this.setByte(n, (byte)n2);
        this.setByte(++n, (byte)(n2 >>= 8));
        this.setByte(++n, (byte)(n2 >>= 8));
        this.setByte(++n, (byte)(n2 >>= 8));
    }

    protected final void setQuadWordInBytes(int n, long l) {
        this.setDoubleWordInBytes(n, (int)l);
        this.setDoubleWordInBytes(n + 4, (int)(l >> 32));
    }

    @Override
    public void setWord(int n, short s) {
        this.setWordInBytes(n, s);
    }

    @Override
    public void setDoubleWord(int n, int n2) {
        this.setDoubleWordInBytes(n, n2);
    }

    @Override
    public void setQuadWord(int n, long l) {
        this.setQuadWordInBytes(n, l);
    }

    @Override
    public void setLowerDoubleQuadWord(int n, long l) {
        this.setQuadWordInBytes(n, l);
    }

    @Override
    public void setUpperDoubleQuadWord(int n, long l) {
        this.setQuadWordInBytes(n + 8, l);
    }

    public static final void clearArray(Object[] objectArray, Object object) {
        if (objectArray == null) {
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = object;
        }
    }

    public static final void clearArray(byte[] byArray, byte by) {
        if (byArray == null) {
            return;
        }
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = by;
        }
    }
}

