/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.memory;

import java.io.IOException;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.memory.AddressSpace;
import org.jpc.emulator.memory.Memory;
import org.jpc.emulator.processor.Processor;
import org.jpc.emulator.processor.ProcessorException;

public class AlignmentCheckedAddressSpace
extends AddressSpace {
    private final AddressSpace addressSpace;

    public AlignmentCheckedAddressSpace(AddressSpace addressSpace) {
        this.addressSpace = addressSpace;
    }

    @Override
    public void dumpStatusPartial(StatusDumper statusDumper) {
        super.dumpStatusPartial(statusDumper);
        statusDumper.println("\taddressSpace <object #" + statusDumper.objectNumber(this.addressSpace) + ">");
        if (this.addressSpace != null) {
            this.addressSpace.dumpStatus(statusDumper);
        }
    }

    @Override
    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": AlignmentCheckedAddressSpace:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        super.dumpSRPartial(sRDumper);
        sRDumper.dumpObject(this.addressSpace);
    }

    public AlignmentCheckedAddressSpace(SRLoader sRLoader) throws IOException {
        super(sRLoader);
        this.addressSpace = (AddressSpace)sRLoader.loadObject();
    }

    @Override
    protected Memory getReadMemoryBlockAt(int n) {
        return this.addressSpace.getReadMemoryBlockAt(n);
    }

    @Override
    protected Memory getWriteMemoryBlockAt(int n) {
        return this.addressSpace.getWriteMemoryBlockAt(n);
    }

    @Override
    protected void replaceBlocks(Memory memory, Memory memory2) {
        this.addressSpace.replaceBlocks(memory, memory2);
    }

    @Override
    public int executeReal(Processor processor, int n) {
        return this.addressSpace.executeReal(processor, n);
    }

    @Override
    public int executeProtected(Processor processor, int n) {
        return this.addressSpace.executeReal(processor, n);
    }

    @Override
    public int executeVirtual8086(Processor processor, int n) {
        return this.addressSpace.executeReal(processor, n);
    }

    @Override
    public void clear() {
        this.addressSpace.clear();
    }

    @Override
    public byte getByte(int n) {
        return this.addressSpace.getByte(n);
    }

    @Override
    public void setByte(int n, byte by) {
        this.addressSpace.setByte(n, by);
    }

    @Override
    public short getWord(int n) {
        if ((n & 1) != 0) {
            throw ProcessorException.ALIGNMENT_CHECK_0;
        }
        return this.addressSpace.getWord(n);
    }

    @Override
    public int getDoubleWord(int n) {
        if ((n & 3) != 0) {
            throw ProcessorException.ALIGNMENT_CHECK_0;
        }
        return this.addressSpace.getDoubleWord(n);
    }

    @Override
    public long getQuadWord(int n) {
        if ((n & 7) != 0) {
            throw ProcessorException.ALIGNMENT_CHECK_0;
        }
        return this.addressSpace.getQuadWord(n);
    }

    @Override
    public long getLowerDoubleQuadWord(int n) {
        if ((n & 0xF) != 0) {
            throw ProcessorException.ALIGNMENT_CHECK_0;
        }
        return this.addressSpace.getLowerDoubleQuadWord(n);
    }

    @Override
    public long getUpperDoubleQuadWord(int n) {
        return this.addressSpace.getUpperDoubleQuadWord(n);
    }

    @Override
    public void setWord(int n, short s) {
        if ((n & 1) != 0) {
            throw ProcessorException.ALIGNMENT_CHECK_0;
        }
        this.addressSpace.setWord(n, s);
    }

    @Override
    public void setDoubleWord(int n, int n2) {
        if ((n & 3) != 0) {
            throw ProcessorException.ALIGNMENT_CHECK_0;
        }
        this.addressSpace.setDoubleWord(n, n2);
    }

    @Override
    public void setQuadWord(int n, long l) {
        if ((n & 7) != 0) {
            throw ProcessorException.ALIGNMENT_CHECK_0;
        }
        this.addressSpace.setQuadWord(n, l);
    }

    @Override
    public void setLowerDoubleQuadWord(int n, long l) {
        if ((n & 0xF) != 0) {
            throw ProcessorException.GENERAL_PROTECTION_0;
        }
        this.addressSpace.setLowerDoubleQuadWord(n, l);
    }

    @Override
    public void setUpperDoubleQuadWord(int n, long l) {
        this.addressSpace.setUpperDoubleQuadWord(n, l);
    }

    @Override
    public void copyArrayIntoContents(int n, byte[] byArray, int n2, int n3) {
        this.addressSpace.copyArrayIntoContents(n, byArray, n2, n3);
    }

    @Override
    public void copyContentsIntoArray(int n, byte[] byArray, int n2, int n3) {
        this.addressSpace.copyContentsIntoArray(n, byArray, n2, n3);
    }

    @Override
    public void loadInitialContents(int n, byte[] byArray, int n2, int n3) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

