/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.memory;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.memory.AddressSpace;
import org.jpc.emulator.memory.Memory;
import org.jpc.emulator.memory.PhysicalAddressSpace;
import org.jpc.emulator.processor.Processor;
import org.jpc.emulator.processor.ProcessorException;

public final class LinearAddressSpace
extends AddressSpace
implements HardwareComponent {
    private static final PageFaultWrapper PF_NOT_PRESENT_RU = new PageFaultWrapper(4);
    private static final PageFaultWrapper PF_NOT_PRESENT_RS = new PageFaultWrapper(0);
    private static final PageFaultWrapper PF_NOT_PRESENT_WU = new PageFaultWrapper(6);
    private static final PageFaultWrapper PF_NOT_PRESENT_WS = new PageFaultWrapper(2);
    private static final PageFaultWrapper PF_PROTECTION_VIOLATION_RU = new PageFaultWrapper(5);
    private static final PageFaultWrapper PF_PROTECTION_VIOLATION_WU = new PageFaultWrapper(7);
    private static final PageFaultWrapper PF_PROTECTION_VIOLATION_WS = new PageFaultWrapper(3);
    private static final byte FOUR_M = 1;
    private static final byte FOUR_K = 0;
    private boolean isSupervisor;
    private boolean globalPagesEnabled;
    private boolean pagingDisabled;
    private boolean pageCacheEnabled;
    private boolean writeProtectUserPages;
    private boolean pageSizeExtensions;
    private int baseAddress;
    private int lastAddress;
    private PhysicalAddressSpace target;
    private byte[] pageSize;
    private final Set<Integer> nonGlobalPages;
    private Memory[] readUserIndex;
    private Memory[] readSupervisorIndex;
    private Memory[] writeUserIndex;
    private Memory[] writeSupervisorIndex;
    private Memory[] readIndex;
    private Memory[] writeIndex;

    public LinearAddressSpace() {
        this.baseAddress = 0;
        this.lastAddress = 0;
        this.pagingDisabled = true;
        this.globalPagesEnabled = false;
        this.writeProtectUserPages = false;
        this.pageSizeExtensions = false;
        this.nonGlobalPages = new HashSet<Integer>();
        this.pageSize = new byte[0x100000];
        for (int i = 0; i < 0x100000; ++i) {
            this.pageSize[i] = 0;
        }
    }

    @Override
    public void dumpStatusPartial(StatusDumper statusDumper) {
        super.dumpStatusPartial(statusDumper);
        statusDumper.println("\tisSupervisor " + this.isSupervisor + " globalPagesEnabled " + this.globalPagesEnabled);
        statusDumper.println("\tpagingDisabled " + this.pagingDisabled + " pageCacheEnabled " + this.pageCacheEnabled);
        statusDumper.println("\twriteProtectUserPages " + this.writeProtectUserPages + " pageSizeExtensions " + this.pageSizeExtensions);
        statusDumper.println("\tbaseAddress " + this.baseAddress + " lastAddress " + this.lastAddress);
        statusDumper.println("\ttarget <object #" + statusDumper.objectNumber(this.target) + ">");
        if (this.target != null) {
            this.target.dumpStatus(statusDumper);
        }
        statusDumper.println("\tpageSize:");
        statusDumper.printArray(this.pageSize, "pageSize");
        statusDumper.println("\tnonGlobalPages:");
        for (Integer n : this.nonGlobalPages) {
            statusDumper.println("\t\t" + n);
        }
        this.dumpMemoryTableStatus(statusDumper, this.readUserIndex, "readUserIndex");
        this.dumpMemoryTableStatus(statusDumper, this.readSupervisorIndex, "readSupervisorIndex");
        this.dumpMemoryTableStatus(statusDumper, this.readIndex, "readIndex");
        this.dumpMemoryTableStatus(statusDumper, this.writeUserIndex, "writeUserIndex");
        this.dumpMemoryTableStatus(statusDumper, this.writeSupervisorIndex, "writeSupervisorIndex");
        this.dumpMemoryTableStatus(statusDumper, this.writeIndex, "writeIndex");
    }

    @Override
    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": LinearAddressSpace:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        super.dumpSRPartial(sRDumper);
        sRDumper.specialObject(PF_NOT_PRESENT_RU);
        sRDumper.specialObject(PF_NOT_PRESENT_RS);
        sRDumper.specialObject(PF_NOT_PRESENT_WU);
        sRDumper.specialObject(PF_NOT_PRESENT_WS);
        sRDumper.specialObject(PF_PROTECTION_VIOLATION_RU);
        sRDumper.specialObject(PF_PROTECTION_VIOLATION_WU);
        sRDumper.specialObject(PF_PROTECTION_VIOLATION_WS);
        sRDumper.dumpBoolean(this.isSupervisor);
        sRDumper.dumpBoolean(this.globalPagesEnabled);
        sRDumper.dumpBoolean(this.pagingDisabled);
        sRDumper.dumpBoolean(this.pageCacheEnabled);
        sRDumper.dumpBoolean(this.writeProtectUserPages);
        sRDumper.dumpBoolean(this.pageSizeExtensions);
        sRDumper.dumpInt(this.baseAddress);
        sRDumper.dumpInt(this.lastAddress);
        sRDumper.dumpObject(this.target);
        sRDumper.dumpArray(this.pageSize);
        for (Integer n : this.nonGlobalPages) {
            sRDumper.dumpBoolean(true);
            sRDumper.dumpInt(n);
        }
        sRDumper.dumpBoolean(false);
        this.dumpMemoryTableSR(sRDumper, this.readUserIndex);
        this.dumpMemoryTableSR(sRDumper, this.readSupervisorIndex);
        this.dumpMemoryTableSR(sRDumper, this.writeUserIndex);
        this.dumpMemoryTableSR(sRDumper, this.writeSupervisorIndex);
    }

    public LinearAddressSpace(SRLoader sRLoader) throws IOException {
        super(sRLoader);
        sRLoader.specialObject(PF_NOT_PRESENT_RU);
        sRLoader.specialObject(PF_NOT_PRESENT_RS);
        sRLoader.specialObject(PF_NOT_PRESENT_WU);
        sRLoader.specialObject(PF_NOT_PRESENT_WS);
        sRLoader.specialObject(PF_PROTECTION_VIOLATION_RU);
        sRLoader.specialObject(PF_PROTECTION_VIOLATION_WU);
        sRLoader.specialObject(PF_PROTECTION_VIOLATION_WS);
        this.isSupervisor = sRLoader.loadBoolean();
        this.globalPagesEnabled = sRLoader.loadBoolean();
        this.pagingDisabled = sRLoader.loadBoolean();
        this.pageCacheEnabled = sRLoader.loadBoolean();
        this.writeProtectUserPages = sRLoader.loadBoolean();
        this.pageSizeExtensions = sRLoader.loadBoolean();
        this.baseAddress = sRLoader.loadInt();
        this.lastAddress = sRLoader.loadInt();
        this.target = (PhysicalAddressSpace)sRLoader.loadObject();
        this.pageSize = sRLoader.loadArrayByte();
        this.nonGlobalPages = new HashSet<Integer>();
        boolean bl = sRLoader.loadBoolean();
        while (bl) {
            Integer n = new Integer(sRLoader.loadInt());
            this.nonGlobalPages.add(n);
            bl = sRLoader.loadBoolean();
        }
        this.readUserIndex = this.loadMemoryTableSR(sRLoader);
        this.readSupervisorIndex = this.loadMemoryTableSR(sRLoader);
        this.writeUserIndex = this.loadMemoryTableSR(sRLoader);
        this.writeSupervisorIndex = this.loadMemoryTableSR(sRLoader);
        if (this.isSupervisor) {
            this.readIndex = this.readSupervisorIndex;
            this.writeIndex = this.writeSupervisorIndex;
        } else {
            this.readIndex = this.readUserIndex;
            this.writeIndex = this.writeUserIndex;
        }
    }

    private Memory[] loadMemoryTableSR(SRLoader sRLoader) throws IOException {
        boolean bl = sRLoader.loadBoolean();
        if (!bl) {
            return null;
        }
        Memory[] memoryArray = new Memory[sRLoader.loadInt()];
        byte[] byArray = sRLoader.loadArrayByte();
        for (int i = 0; i < memoryArray.length; ++i) {
            if ((byArray[i / 8] & 1 << i % 8) == 0) continue;
            memoryArray[i] = (Memory)sRLoader.loadObject();
        }
        return memoryArray;
    }

    private void dumpMemoryTableSR(SRDumper sRDumper, Memory[] memoryArray) throws IOException {
        if (memoryArray == null) {
            sRDumper.dumpBoolean(false);
        } else {
            int n;
            sRDumper.dumpBoolean(true);
            sRDumper.dumpInt(memoryArray.length);
            byte[] byArray = new byte[(memoryArray.length + 7) / 8];
            for (n = 0; n < memoryArray.length; ++n) {
                if (memoryArray[n] == null) continue;
                int n2 = n / 8;
                byArray[n2] = (byte)(byArray[n2] | 1 << n % 8);
            }
            sRDumper.dumpArray(byArray);
            for (n = 0; n < memoryArray.length; ++n) {
                if (memoryArray[n] == null) continue;
                sRDumper.dumpObject(memoryArray[n]);
            }
        }
    }

    private void dumpMemoryTableStatus(StatusDumper statusDumper, Memory[] memoryArray, String string) {
        if (memoryArray == null) {
            statusDumper.println("\t" + string + " null");
        } else {
            for (int i = 0; i < memoryArray.length; ++i) {
                if (memoryArray[i] != null) {
                    statusDumper.println("\t" + string + "[" + i + "] <object #" + statusDumper.objectNumber(memoryArray[i]) + ">");
                }
                if (memoryArray[i] == null) continue;
                memoryArray[i].dumpStatus(statusDumper);
            }
        }
    }

    private Memory[] createReadIndex() {
        if (this.isSupervisor) {
            this.readSupervisorIndex = new Memory[0x100000];
            this.readIndex = this.readSupervisorIndex;
            return this.readSupervisorIndex;
        }
        this.readUserIndex = new Memory[0x100000];
        this.readIndex = this.readUserIndex;
        return this.readUserIndex;
    }

    private Memory[] createWriteIndex() {
        if (this.isSupervisor) {
            this.writeSupervisorIndex = new Memory[0x100000];
            this.writeIndex = this.writeSupervisorIndex;
            return this.writeSupervisorIndex;
        }
        this.writeUserIndex = new Memory[0x100000];
        this.writeIndex = this.writeUserIndex;
        return this.writeUserIndex;
    }

    private void setReadIndexValue(int n, Memory memory) {
        try {
            this.readIndex[n] = memory;
        }
        catch (NullPointerException nullPointerException) {
            this.createReadIndex()[n] = memory;
        }
    }

    private Memory getReadIndexValue(int n) {
        try {
            return this.readIndex[n];
        }
        catch (NullPointerException nullPointerException) {
            return this.createReadIndex()[n];
        }
    }

    private void setWriteIndexValue(int n, Memory memory) {
        try {
            this.writeIndex[n] = memory;
        }
        catch (NullPointerException nullPointerException) {
            this.createWriteIndex()[n] = memory;
        }
    }

    private Memory getWriteIndexValue(int n) {
        try {
            return this.writeIndex[n];
        }
        catch (NullPointerException nullPointerException) {
            return this.createWriteIndex()[n];
        }
    }

    public int getLastWalkedAddress() {
        return this.lastAddress;
    }

    public boolean isSupervisor() {
        return this.isSupervisor;
    }

    public void setSupervisor(boolean bl) {
        this.isSupervisor = bl;
        if (this.isSupervisor) {
            this.readIndex = this.readSupervisorIndex;
            this.writeIndex = this.writeSupervisorIndex;
        } else {
            this.readIndex = this.readUserIndex;
            this.writeIndex = this.writeUserIndex;
        }
    }

    public boolean isPagingEnabled() {
        return !this.pagingDisabled;
    }

    public void setPagingEnabled(boolean bl) {
        if (bl && !this.target.getGateA20State()) {
            System.err.println("Emulated: Paging enabled with A20 masked.");
        }
        this.pagingDisabled = !bl;
        this.flush();
    }

    public void setPageCacheEnabled(boolean bl) {
        this.pageCacheEnabled = bl;
    }

    public void setPageSizeExtensionsEnabled(boolean bl) {
        this.pageSizeExtensions = bl;
        this.flush();
    }

    public void setPageWriteThroughEnabled(boolean bl) {
    }

    public void setGlobalPagesEnabled(boolean bl) {
        if (this.globalPagesEnabled == bl) {
            return;
        }
        this.globalPagesEnabled = bl;
        this.flush();
    }

    public void setWriteProtectUserPages(boolean bl) {
        if (bl && this.writeSupervisorIndex != null) {
            for (int i = 0; i < 0x100000; ++i) {
                LinearAddressSpace.nullIndex(this.writeSupervisorIndex, i);
            }
        }
        this.writeProtectUserPages = bl;
    }

    public void flush() {
        for (int i = 0; i < 0x100000; ++i) {
            this.pageSize[i] = 0;
        }
        this.nonGlobalPages.clear();
        this.readUserIndex = null;
        this.writeUserIndex = null;
        this.readSupervisorIndex = null;
        this.writeSupervisorIndex = null;
    }

    private void partialFlush() {
        if (this.globalPagesEnabled) {
            for (Integer n : this.nonGlobalPages) {
                int n2 = n;
                LinearAddressSpace.nullIndex(this.readSupervisorIndex, n2);
                LinearAddressSpace.nullIndex(this.writeSupervisorIndex, n2);
                LinearAddressSpace.nullIndex(this.readUserIndex, n2);
                LinearAddressSpace.nullIndex(this.writeUserIndex, n2);
                this.pageSize[n2] = 0;
            }
            this.nonGlobalPages.clear();
        } else {
            this.flush();
        }
    }

    private static void nullIndex(Memory[] memoryArray, int n) {
        try {
            memoryArray[n] = null;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void setPageDirectoryBaseAddress(int n) {
        this.baseAddress = n & 0xFFFFF000;
        this.partialFlush();
    }

    public void invalidateTLBEntry(int n) {
        int n2 = n >>> 12;
        if (this.pageSize[n2] == 0) {
            LinearAddressSpace.nullIndex(this.readSupervisorIndex, n2);
            LinearAddressSpace.nullIndex(this.writeSupervisorIndex, n2);
            LinearAddressSpace.nullIndex(this.readUserIndex, n2);
            LinearAddressSpace.nullIndex(this.writeUserIndex, n2);
            this.nonGlobalPages.remove(n2);
        } else {
            n2 &= 0xFFC00;
            int n3 = 0;
            while (n3 < 1024) {
                LinearAddressSpace.nullIndex(this.readSupervisorIndex, n2);
                LinearAddressSpace.nullIndex(this.writeSupervisorIndex, n2);
                LinearAddressSpace.nullIndex(this.readUserIndex, n2);
                LinearAddressSpace.nullIndex(this.writeUserIndex, n2);
                this.nonGlobalPages.remove(n2);
                ++n3;
                ++n2;
            }
        }
    }

    private Memory validateTLBEntryRead(int n) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        int n2 = n >>> 12;
        if (this.pagingDisabled) {
            this.setReadIndexValue(n2, this.target.getReadMemoryBlockAt(n));
            return this.readIndex[n2];
        }
        this.lastAddress = n;
        int n3 = this.baseAddress | 0xFFC & n >>> 20;
        int n4 = this.target.getDoubleWord(n3);
        boolean bl5 = bl4 = (1 & n4) != 0;
        if (!bl4) {
            if (this.isSupervisor) {
                return PF_NOT_PRESENT_RS;
            }
            return PF_NOT_PRESENT_RU;
        }
        boolean bl6 = this.globalPagesEnabled && (0x100 & n4) != 0;
        boolean bl7 = (4 & n4) != 0;
        boolean bl8 = bl3 = (0x80 & n4) != 0 && this.pageSizeExtensions;
        if (bl3) {
            if (!bl7 && !this.isSupervisor) {
                return PF_PROTECTION_VIOLATION_RU;
            }
            if ((n4 & 0x20) == 0) {
                this.target.setDoubleWord(n3, n4 |= 0x20);
            }
            int n5 = 0xFFC00000 & n4;
            if (!this.pageCacheEnabled) {
                return this.target.getReadMemoryBlockAt(n5 | n & 0x3FFFFF);
            }
            int n6 = (0xFFC00000 & n) >>> 12;
            for (int i = 0; i < 1024; ++i) {
                Memory memory = this.target.getReadMemoryBlockAt(n5);
                n5 += 4096;
                this.pageSize[n6] = 1;
                this.setReadIndexValue(n6++, memory);
                if (bl6) continue;
                this.nonGlobalPages.add(i);
            }
            return this.readIndex[n2];
        }
        int n7 = n4 & 0xFFFFF000;
        int n8 = n7 | n >>> 10 & 0xFFC;
        int n9 = this.target.getDoubleWord(n8);
        boolean bl9 = bl2 = (1 & n9) != 0;
        if (!bl2) {
            if (this.isSupervisor) {
                return PF_NOT_PRESENT_RS;
            }
            return PF_NOT_PRESENT_RU;
        }
        boolean bl10 = this.globalPagesEnabled && (0x100 & n9) != 0;
        boolean bl11 = (4 & n9) != 0;
        boolean bl12 = bl = bl11 && bl7;
        if (!bl && !this.isSupervisor) {
            return PF_PROTECTION_VIOLATION_RU;
        }
        if ((n9 & 0x20) == 0) {
            this.target.setDoubleWord(n8, n9 |= 0x20);
        }
        int n10 = n9 & 0xFFFFF000;
        if (!this.pageCacheEnabled) {
            return this.target.getReadMemoryBlockAt(n10);
        }
        this.pageSize[n2] = 0;
        if (!bl10) {
            this.nonGlobalPages.add(n2);
        }
        this.setReadIndexValue(n2, this.target.getReadMemoryBlockAt(n10));
        return this.readIndex[n2];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Memory validateTLBEntryWrite(int n) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        int n2 = n >>> 12;
        if (this.pagingDisabled) {
            this.setWriteIndexValue(n2, this.target.getWriteMemoryBlockAt(n));
            return this.writeIndex[n2];
        }
        this.lastAddress = n;
        int n3 = this.baseAddress | 0xFFC & n >>> 20;
        int n4 = this.target.getDoubleWord(n3);
        boolean bl5 = bl4 = (1 & n4) != 0;
        if (!bl4) {
            if (!this.isSupervisor) return PF_NOT_PRESENT_WU;
            return PF_NOT_PRESENT_WS;
        }
        boolean bl6 = this.globalPagesEnabled && (0x100 & n4) != 0;
        boolean bl7 = (2 & n4) != 0;
        boolean bl8 = (4 & n4) != 0;
        boolean bl9 = bl3 = (0x80 & n4) != 0 && this.pageSizeExtensions;
        if (bl3) {
            if (bl8) {
                if (!bl7) {
                    if (!this.isSupervisor) return PF_PROTECTION_VIOLATION_WU;
                    if (this.writeProtectUserPages) {
                        return PF_PROTECTION_VIOLATION_WS;
                    }
                }
            } else if (bl7) {
                if (!this.isSupervisor) {
                    return PF_PROTECTION_VIOLATION_WU;
                }
            } else {
                if (!this.isSupervisor) return PF_PROTECTION_VIOLATION_WU;
                return PF_PROTECTION_VIOLATION_WS;
            }
            if ((n4 & 0x60) != 96) {
                this.target.setDoubleWord(n3, n4 |= 0x60);
            }
            int n5 = 0xFFC00000 & n4;
            if (!this.pageCacheEnabled) {
                return this.target.getWriteMemoryBlockAt(n5 | n & 0x3FFFFF);
            }
            int n6 = (0xFFC00000 & n) >>> 12;
            for (int i = 0; i < 1024; ++i) {
                Memory memory = this.target.getWriteMemoryBlockAt(n5);
                n5 += 4096;
                this.pageSize[n6] = 1;
                this.setWriteIndexValue(n6++, memory);
                if (bl6) continue;
                this.nonGlobalPages.add(i);
            }
            return this.writeIndex[n2];
        }
        int n7 = n4 & 0xFFFFF000;
        int n8 = n7 | n >>> 10 & 0xFFC;
        int n9 = this.target.getDoubleWord(n8);
        boolean bl10 = bl2 = (1 & n9) != 0;
        if (!bl2) {
            if (!this.isSupervisor) return PF_NOT_PRESENT_WU;
            return PF_NOT_PRESENT_WS;
        }
        boolean bl11 = this.globalPagesEnabled && (0x100 & n9) != 0;
        boolean bl12 = (2 & n9) != 0;
        boolean bl13 = (4 & n9) != 0;
        boolean bl14 = bl13 && bl8;
        boolean bl15 = bl = bl12 || bl7;
        if (bl14) {
            boolean bl16 = bl = bl12 && bl7;
        }
        if (bl14) {
            if (!bl) {
                if (!this.isSupervisor) return PF_PROTECTION_VIOLATION_WU;
                if (this.writeProtectUserPages) {
                    return PF_PROTECTION_VIOLATION_WS;
                }
            }
        } else if (bl) {
            if (!this.isSupervisor) {
                return PF_PROTECTION_VIOLATION_WU;
            }
        } else {
            if (!this.isSupervisor) return PF_PROTECTION_VIOLATION_WU;
            return PF_PROTECTION_VIOLATION_WS;
        }
        if ((n9 & 0x60) != 96) {
            this.target.setDoubleWord(n8, n9 |= 0x60);
        }
        int n10 = n9 & 0xFFFFF000;
        if (!this.pageCacheEnabled) {
            return this.target.getWriteMemoryBlockAt(n10);
        }
        this.pageSize[n2] = 0;
        if (!bl11) {
            this.nonGlobalPages.add(n2);
        }
        this.setWriteIndexValue(n2, this.target.getWriteMemoryBlockAt(n10));
        return this.writeIndex[n2];
    }

    @Override
    protected Memory getReadMemoryBlockAt(int n) {
        return this.getReadIndexValue(n >>> 12);
    }

    @Override
    protected Memory getWriteMemoryBlockAt(int n) {
        return this.getWriteIndexValue(n >>> 12);
    }

    @Override
    protected void replaceBlocks(Memory memory, Memory memory2) {
        int n;
        try {
            for (n = 0; n < 0x100000; ++n) {
                if (this.readUserIndex[n] != memory) continue;
                this.readUserIndex[n] = memory2;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            for (n = 0; n < 0x100000; ++n) {
                if (this.writeUserIndex[n] != memory) continue;
                this.writeUserIndex[n] = memory2;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            for (int i = 0; i < 0x100000; ++i) {
                if (this.readSupervisorIndex[i] != memory) continue;
                this.readSupervisorIndex[i] = memory2;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            for (int i = 0; i < 0x100000; ++i) {
                if (this.writeSupervisorIndex[i] != memory) continue;
                this.writeSupervisorIndex[i] = memory2;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public byte getByte(int n) {
        try {
            return super.getByte(n);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ProcessorException processorException) {
            // empty catch block
        }
        return this.validateTLBEntryRead(n).getByte(n & 0xFFF);
    }

    @Override
    public short getWord(int n) {
        try {
            return super.getWord(n);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ProcessorException processorException) {
            // empty catch block
        }
        Memory memory = this.validateTLBEntryRead(n);
        try {
            return memory.getWord(n & 0xFFF);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return this.getWordInBytes(n);
        }
    }

    @Override
    public int getDoubleWord(int n) {
        try {
            return super.getDoubleWord(n);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ProcessorException processorException) {
            // empty catch block
        }
        Memory memory = this.validateTLBEntryRead(n);
        try {
            return memory.getDoubleWord(n & 0xFFF);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return this.getDoubleWordInBytes(n);
        }
    }

    @Override
    public void setByte(int n, byte by) {
        try {
            super.setByte(n, by);
            return;
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ProcessorException processorException) {
            // empty catch block
        }
        this.validateTLBEntryWrite(n).setByte(n & 0xFFF, by);
    }

    @Override
    public void setWord(int n, short s) {
        try {
            super.setWord(n, s);
            return;
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ProcessorException processorException) {
            // empty catch block
        }
        Memory memory = this.validateTLBEntryWrite(n);
        try {
            memory.setWord(n & 0xFFF, s);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.setWordInBytes(n, s);
        }
    }

    @Override
    public void setDoubleWord(int n, int n2) {
        try {
            super.setDoubleWord(n, n2);
            return;
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ProcessorException processorException) {
            // empty catch block
        }
        Memory memory = this.validateTLBEntryWrite(n);
        try {
            memory.setDoubleWord(n & 0xFFF, n2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.setDoubleWordInBytes(n, n2);
        }
    }

    @Override
    public void clear() {
        this.target.clear();
    }

    @Override
    public int executeReal(Processor processor, int n) {
        System.err.println("Critical error: Trying to run Real mode block in linear memory.");
        throw new IllegalStateException("Cannot execute a Real Mode block in linear memory");
    }

    @Override
    public int executeProtected(Processor processor, int n) {
        Memory memory = this.getReadMemoryBlockAt(n);
        try {
            return memory.executeProtected(processor, n & 0xFFF);
        }
        catch (NullPointerException nullPointerException) {
            memory = this.validateTLBEntryRead(n);
        }
        catch (ProcessorException processorException) {
            memory = this.validateTLBEntryRead(n);
        }
        try {
            return memory.executeProtected(processor, n & 0xFFF);
        }
        catch (ProcessorException processorException) {
            processor.handleProtectedModeException(processorException);
            return 1;
        }
        catch (IllegalStateException illegalStateException) {
            System.err.println("Critical error: Execute failed, Current eip = " + Integer.toHexString(processor.eip));
            throw illegalStateException;
        }
    }

    @Override
    public int executeVirtual8086(Processor processor, int n) {
        Memory memory = this.getReadMemoryBlockAt(n);
        try {
            return memory.executeVirtual8086(processor, n & 0xFFF);
        }
        catch (NullPointerException nullPointerException) {
            memory = this.validateTLBEntryRead(n);
        }
        catch (ProcessorException processorException) {
            memory = this.validateTLBEntryRead(n);
        }
        try {
            return memory.executeVirtual8086(processor, n & 0xFFF);
        }
        catch (ProcessorException processorException) {
            processor.handleProtectedModeException(processorException);
            return 1;
        }
    }

    @Override
    public void reset() {
        this.flush();
        this.baseAddress = 0;
        this.lastAddress = 0;
        this.pagingDisabled = true;
        this.globalPagesEnabled = false;
        this.writeProtectUserPages = false;
        this.pageSizeExtensions = false;
        this.readUserIndex = null;
        this.writeUserIndex = null;
        this.readSupervisorIndex = null;
        this.writeSupervisorIndex = null;
    }

    @Override
    public boolean initialised() {
        return this.target != null;
    }

    @Override
    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof PhysicalAddressSpace) {
            this.target = (PhysicalAddressSpace)hardwareComponent;
        }
    }

    public String toString() {
        return "Linear Address Space";
    }

    @Override
    public void loadInitialContents(int n, byte[] byArray, int n2, int n3) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static final class PageFaultWrapper
    implements Memory {
        private final ProcessorException pageFault;

        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            sRDumper.dumpObject(this.pageFault);
        }

        public PageFaultWrapper(SRLoader sRLoader) throws IOException {
            sRLoader.objectCreated(this);
            this.pageFault = (ProcessorException)sRLoader.loadObject();
        }

        public void dumpStatusPartial(StatusDumper statusDumper) {
            statusDumper.println("\tpageFault <object #" + statusDumper.objectNumber(this.pageFault) + ">");
            if (this.pageFault != null) {
                this.pageFault.dumpStatus(statusDumper);
            }
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": PageFaultWrapper:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        private PageFaultWrapper(int n) {
            this.pageFault = new ProcessorException(ProcessorException.Type.PAGE_FAULT, n, true);
        }

        public ProcessorException getException() {
            return this.pageFault;
        }

        private void fill() {
        }

        @Override
        public boolean isAllocated() {
            return false;
        }

        @Override
        public void clear() {
        }

        @Override
        public void clear(int n, int n2) {
        }

        @Override
        public void copyContentsIntoArray(int n, byte[] byArray, int n2, int n3) {
            this.fill();
            throw this.pageFault;
        }

        @Override
        public void copyArrayIntoContents(int n, byte[] byArray, int n2, int n3) {
            this.fill();
            throw this.pageFault;
        }

        @Override
        public long getSize() {
            return 0L;
        }

        @Override
        public byte getByte(int n) {
            this.fill();
            throw this.pageFault;
        }

        @Override
        public short getWord(int n) {
            this.fill();
            throw this.pageFault;
        }

        @Override
        public int getDoubleWord(int n) {
            this.fill();
            throw this.pageFault;
        }

        @Override
        public long getQuadWord(int n) {
            this.fill();
            throw this.pageFault;
        }

        @Override
        public long getLowerDoubleQuadWord(int n) {
            this.fill();
            throw this.pageFault;
        }

        @Override
        public long getUpperDoubleQuadWord(int n) {
            this.fill();
            throw this.pageFault;
        }

        @Override
        public void setByte(int n, byte by) {
            this.fill();
            throw this.pageFault;
        }

        @Override
        public void setWord(int n, short s) {
            this.fill();
            throw this.pageFault;
        }

        @Override
        public void setDoubleWord(int n, int n2) {
            this.fill();
            throw this.pageFault;
        }

        @Override
        public void setQuadWord(int n, long l) {
            this.fill();
            throw this.pageFault;
        }

        @Override
        public void setLowerDoubleQuadWord(int n, long l) {
            this.fill();
            throw this.pageFault;
        }

        @Override
        public void setUpperDoubleQuadWord(int n, long l) {
            this.fill();
            throw this.pageFault;
        }

        @Override
        public int executeReal(Processor processor, int n) {
            System.err.println("Critical error: Trying to run Real mode block in linear memory.");
            throw new IllegalStateException("Cannot execute a Real Mode block in linear memory");
        }

        @Override
        public int executeProtected(Processor processor, int n) {
            this.fill();
            throw this.pageFault;
        }

        @Override
        public int executeVirtual8086(Processor processor, int n) {
            this.fill();
            throw this.pageFault;
        }

        public String toString() {
            return "PF " + this.pageFault;
        }

        @Override
        public void loadInitialContents(int n, byte[] byArray, int n2, int n3) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

