/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.memory.codeblock;

import java.io.IOException;
import org.jpc.emulator.SRDumpable;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.memory.Memory;
import org.jpc.emulator.memory.codeblock.ByteSourceWrappedMemory;
import org.jpc.emulator.memory.codeblock.CodeBlockFactory;
import org.jpc.emulator.memory.codeblock.DefaultCodeBlockFactory;
import org.jpc.emulator.memory.codeblock.ProtectedModeCodeBlock;
import org.jpc.emulator.memory.codeblock.RealModeCodeBlock;
import org.jpc.emulator.memory.codeblock.SpanningProtectedModeCodeBlock;
import org.jpc.emulator.memory.codeblock.SpanningRealModeCodeBlock;
import org.jpc.emulator.memory.codeblock.SpanningVirtual8086ModeCodeBlock;
import org.jpc.emulator.memory.codeblock.Virtual8086ModeCodeBlock;
import org.jpc.emulator.memory.codeblock.optimised.OptimisedCompiler;
import org.jpc.emulator.memory.codeblock.optimised.ProtectedModeUDecoder;
import org.jpc.emulator.memory.codeblock.optimised.RealModeUDecoder;

public class CodeBlockManager
implements SRDumpable {
    public static volatile int BLOCK_LIMIT = 1000;
    private CodeBlockFactory realModeChain;
    private CodeBlockFactory protectedModeChain;
    private CodeBlockFactory virtual8086ModeChain;
    private ByteSourceWrappedMemory byteSource = new ByteSourceWrappedMemory();

    public CodeBlockManager() {
        this.realModeChain = new DefaultCodeBlockFactory(new RealModeUDecoder(), new OptimisedCompiler(), BLOCK_LIMIT);
        this.protectedModeChain = new DefaultCodeBlockFactory(new ProtectedModeUDecoder(), new OptimisedCompiler(), BLOCK_LIMIT);
        this.virtual8086ModeChain = new DefaultCodeBlockFactory(new RealModeUDecoder(), new OptimisedCompiler(), BLOCK_LIMIT);
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
    }

    public CodeBlockManager(SRLoader sRLoader) {
        this();
        sRLoader.objectCreated(this);
    }

    private RealModeCodeBlock tryRealModeFactory(CodeBlockFactory codeBlockFactory, Memory memory, int n) {
        try {
            this.byteSource.set(memory, n);
            return codeBlockFactory.getRealModeCodeBlock(this.byteSource);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return new SpanningRealModeCodeBlock(new CodeBlockFactory[]{this.realModeChain});
        }
    }

    private ProtectedModeCodeBlock tryProtectedModeFactory(CodeBlockFactory codeBlockFactory, Memory memory, int n, boolean bl) {
        try {
            this.byteSource.set(memory, n);
            return codeBlockFactory.getProtectedModeCodeBlock(this.byteSource, bl);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return new SpanningProtectedModeCodeBlock(new CodeBlockFactory[]{this.protectedModeChain});
        }
    }

    private Virtual8086ModeCodeBlock tryVirtual8086ModeFactory(CodeBlockFactory codeBlockFactory, Memory memory, int n) {
        try {
            this.byteSource.set(memory, n);
            return codeBlockFactory.getVirtual8086ModeCodeBlock(this.byteSource);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return new SpanningVirtual8086ModeCodeBlock(new CodeBlockFactory[]{this.virtual8086ModeChain});
        }
    }

    public RealModeCodeBlock getRealModeCodeBlockAt(Memory memory, int n) {
        RealModeCodeBlock realModeCodeBlock = this.tryRealModeFactory(this.realModeChain, memory, n);
        if (realModeCodeBlock == null) {
            System.err.println("Critical error: Can't find nor make suitable real mode codeblock.");
            throw new IllegalStateException("Couldn't find/make suitable realmode block");
        }
        return realModeCodeBlock;
    }

    public ProtectedModeCodeBlock getProtectedModeCodeBlockAt(Memory memory, int n, boolean bl) {
        ProtectedModeCodeBlock protectedModeCodeBlock = this.tryProtectedModeFactory(this.protectedModeChain, memory, n, bl);
        if (protectedModeCodeBlock == null) {
            System.err.println("Critical error: Can't find nor make suitable protected mode codeblock.");
            throw new IllegalStateException("Couldn't find/make suitable pmode block");
        }
        return protectedModeCodeBlock;
    }

    public Virtual8086ModeCodeBlock getVirtual8086ModeCodeBlockAt(Memory memory, int n) {
        Virtual8086ModeCodeBlock virtual8086ModeCodeBlock = this.tryVirtual8086ModeFactory(this.virtual8086ModeChain, memory, n);
        if (virtual8086ModeCodeBlock == null) {
            System.err.println("Critical error: Can't find nor make suitable VM8086 mode codeblock.");
            throw new IllegalStateException("Couldn't find/make suitable VM86 block");
        }
        return virtual8086ModeCodeBlock;
    }
}

