/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.memory.codeblock;

import org.jpc.emulator.memory.LinearAddressSpace;
import org.jpc.emulator.memory.codeblock.ByteSourceWrappedMemory;
import org.jpc.emulator.memory.codeblock.CodeBlock;
import org.jpc.emulator.memory.codeblock.CodeBlockFactory;
import org.jpc.emulator.memory.codeblock.ProtectedModeCodeBlock;
import org.jpc.emulator.memory.codeblock.SpanningCodeBlock;
import org.jpc.emulator.processor.Processor;

class SpanningProtectedModeCodeBlock
extends SpanningCodeBlock
implements ProtectedModeCodeBlock {
    private ByteSourceWrappedMemory byteSource = new ByteSourceWrappedMemory();
    private CodeBlockFactory[] factories;
    private int length;

    public SpanningProtectedModeCodeBlock(CodeBlockFactory[] codeBlockFactoryArray) {
        this.factories = codeBlockFactoryArray;
    }

    @Override
    public int getX86Length() {
        return this.length;
    }

    @Override
    protected CodeBlock decode(Processor processor) {
        CodeBlock codeBlock = null;
        LinearAddressSpace linearAddressSpace = processor.linearMemory;
        int n = processor.getInstructionPointer();
        boolean bl = processor.cs.getDefaultSizeFlag();
        for (int i = 0; i < this.factories.length && codeBlock == null; ++i) {
            try {
                this.byteSource.set(linearAddressSpace, n);
                codeBlock = this.factories[i].getProtectedModeCodeBlock(this.byteSource, bl);
                continue;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this.length = codeBlock.getX86Length();
        this.byteSource.set(null, 0);
        return codeBlock;
    }

    public String toString() {
        return "Spanning Protected Mode CodeBlock";
    }
}

