/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.memory.codeblock;

import org.jpc.emulator.memory.PhysicalAddressSpace;
import org.jpc.emulator.memory.codeblock.ByteSourceWrappedMemory;
import org.jpc.emulator.memory.codeblock.CodeBlock;
import org.jpc.emulator.memory.codeblock.CodeBlockFactory;
import org.jpc.emulator.memory.codeblock.RealModeCodeBlock;
import org.jpc.emulator.memory.codeblock.SpanningCodeBlock;
import org.jpc.emulator.processor.Processor;

class SpanningRealModeCodeBlock
extends SpanningCodeBlock
implements RealModeCodeBlock {
    private ByteSourceWrappedMemory byteSource = new ByteSourceWrappedMemory();
    private CodeBlockFactory[] factories;

    public SpanningRealModeCodeBlock(CodeBlockFactory[] codeBlockFactoryArray) {
        this.factories = codeBlockFactoryArray;
    }

    @Override
    protected CodeBlock decode(Processor processor) {
        RealModeCodeBlock realModeCodeBlock = null;
        PhysicalAddressSpace physicalAddressSpace = processor.physicalMemory;
        int n = processor.getInstructionPointer();
        for (int i = 0; i < this.factories.length && realModeCodeBlock == null; ++i) {
            try {
                this.byteSource.set(physicalAddressSpace, n);
                realModeCodeBlock = this.factories[i].getRealModeCodeBlock(this.byteSource);
                continue;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this.byteSource.set(null, 0);
        return realModeCodeBlock;
    }

    public String toString() {
        return "Spanning Real Mode CodeBlock";
    }
}

