/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.motherboard;

import java.io.IOException;
import org.jpc.emulator.AbstractHardwareComponent;
import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.memory.PhysicalAddressSpace;
import org.jpc.emulator.motherboard.IOPortCapable;
import org.jpc.emulator.motherboard.IOPortHandler;
import org.jpc.emulator.processor.Processor;

public class GateA20Handler
extends AbstractHardwareComponent
implements IOPortCapable {
    private Processor cpu;
    private PhysicalAddressSpace physicalAddressSpace;
    private boolean ioportRegistered;

    public GateA20Handler() {
        this.ioportRegistered = false;
        this.cpu = null;
        this.physicalAddressSpace = null;
    }

    @Override
    public void dumpStatusPartial(StatusDumper statusDumper) {
        super.dumpStatusPartial(statusDumper);
        statusDumper.println("\tioportRegistered " + this.ioportRegistered);
        statusDumper.println("\tcpu <object #" + statusDumper.objectNumber(this.cpu) + ">");
        if (this.cpu != null) {
            this.cpu.dumpStatus(statusDumper);
        }
        statusDumper.println("\tphysicalAddressSpace <object #" + statusDumper.objectNumber(this.physicalAddressSpace) + ">");
        if (this.physicalAddressSpace != null) {
            this.physicalAddressSpace.dumpStatus(statusDumper);
        }
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        sRDumper.dumpBoolean(this.ioportRegistered);
        sRDumper.dumpObject(this.cpu);
        sRDumper.dumpObject(this.physicalAddressSpace);
    }

    public GateA20Handler(SRLoader sRLoader) throws IOException {
        super(sRLoader);
        this.ioportRegistered = sRLoader.loadBoolean();
        this.cpu = (Processor)sRLoader.loadObject();
        this.physicalAddressSpace = (PhysicalAddressSpace)sRLoader.loadObject();
    }

    @Override
    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": GateA20Handler:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    private void setGateA20State(boolean bl) {
        this.physicalAddressSpace.setGateA20State(bl);
    }

    @Override
    public void ioPortWriteByte(int n, int n2) {
        this.setGateA20State((n2 & 2) != 0);
        if ((n2 & 1) != 0) {
            this.cpu.reset();
        }
    }

    @Override
    public void ioPortWriteWord(int n, int n2) {
        this.ioPortWriteByte(n, n2);
    }

    @Override
    public void ioPortWriteLong(int n, int n2) {
        this.ioPortWriteByte(n, n2);
    }

    @Override
    public int ioPortReadByte(int n) {
        return this.physicalAddressSpace.getGateA20State() ? 2 : 0;
    }

    @Override
    public int ioPortReadWord(int n) {
        return this.ioPortReadByte(n) | 0xFF00;
    }

    @Override
    public int ioPortReadLong(int n) {
        return this.ioPortReadByte(n) | 0xFFFFFF00;
    }

    @Override
    public int[] ioPortsRequested() {
        return new int[]{146};
    }

    @Override
    public boolean initialised() {
        return this.ioportRegistered && this.cpu != null && this.physicalAddressSpace != null;
    }

    @Override
    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof IOPortHandler && hardwareComponent.initialised()) {
            ((IOPortHandler)hardwareComponent).registerIOPortCapable(this);
            this.ioportRegistered = true;
        }
        if (hardwareComponent instanceof PhysicalAddressSpace) {
            this.physicalAddressSpace = (PhysicalAddressSpace)hardwareComponent;
        }
        if (hardwareComponent instanceof Processor && hardwareComponent.initialised()) {
            this.cpu = (Processor)hardwareComponent;
        }
    }

    @Override
    public void reset() {
        this.ioportRegistered = false;
        this.physicalAddressSpace = null;
        this.cpu = null;
    }
}

