/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.motherboard;

import java.io.IOException;
import org.jpc.emulator.AbstractHardwareComponent;
import org.jpc.emulator.Clock;
import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.Timer;
import org.jpc.emulator.TimerResponsive;
import org.jpc.emulator.motherboard.IOPortCapable;
import org.jpc.emulator.motherboard.IOPortHandler;
import org.jpc.emulator.motherboard.InterruptController;
import org.jpc.emulator.peripheral.PCSpeaker;

public class IntervalTimer
extends AbstractHardwareComponent
implements IOPortCapable {
    private static final int RW_STATE_LSB = 1;
    private static final int RW_STATE_MSB = 2;
    private static final int RW_STATE_WORD = 3;
    private static final int RW_STATE_WORD_2 = 4;
    private static final int MODE_INTERRUPT_ON_TERMINAL_COUNT = 0;
    private static final int MODE_HARDWARE_RETRIGGERABLE_ONE_SHOT = 1;
    private static final int MODE_RATE_GENERATOR = 2;
    private static final int MODE_SQUARE_WAVE = 3;
    private static final int MODE_SOFTWARE_TRIGGERED_STROBE = 4;
    private static final int MODE_HARDWARE_TRIGGERED_STROBE = 5;
    public static final int PIT_FREQ = 1193182;
    private TimerChannel[] channels;
    private InterruptController irqDevice;
    private Clock timingSource;
    private PCSpeaker speaker;
    private boolean madeNewTimer;
    private boolean ioportRegistered;
    private int ioPortBase;
    private int irq;

    private static final long scale64(long l, int n, int n2) {
        long l2 = (0xFFFFFFFFL & l) * (long)n;
        long l3 = (l >>> 32) * (long)n;
        long l4 = 0xFFFFFFFFL & (l3 += l2 >> 32) / (long)n2;
        long l5 = 0xFFFFFFFFL & ((l3 % (long)n2 << 32) + (l2 & 0xFFFFFFFFL)) / (long)n2;
        return l4 << 32 | l5;
    }

    public IntervalTimer(int n, int n2) {
        this.irq = n2;
        this.ioPortBase = n;
    }

    @Override
    public void dumpStatusPartial(StatusDumper statusDumper) {
        super.dumpStatusPartial(statusDumper);
        statusDumper.println("\tmadeNewTimer " + this.madeNewTimer + " ioportRegistered " + this.ioportRegistered);
        statusDumper.println("\tioPortBase " + this.ioPortBase + " irq " + this.irq);
        statusDumper.println("\tspeaker <object #" + statusDumper.objectNumber(this.speaker) + ">");
        if (this.speaker != null) {
            this.speaker.dumpStatus(statusDumper);
        }
        statusDumper.println("\tirqDevice <object #" + statusDumper.objectNumber(this.irqDevice) + ">");
        if (this.irqDevice != null) {
            this.irqDevice.dumpStatus(statusDumper);
        }
        statusDumper.println("\ttimingSource <object #" + statusDumper.objectNumber(this.timingSource) + ">");
        if (this.timingSource != null) {
            this.timingSource.dumpStatus(statusDumper);
        }
        for (int i = 0; i < this.channels.length; ++i) {
            statusDumper.println("\tchannels[" + i + "] <object #" + statusDumper.objectNumber(this.channels[i]) + ">");
            if (this.channels[i] == null) continue;
            this.channels[i].dumpStatus(statusDumper);
        }
    }

    @Override
    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": IntervalTimer:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        super.dumpSRPartial(sRDumper);
        sRDumper.dumpBoolean(this.madeNewTimer);
        sRDumper.dumpBoolean(this.ioportRegistered);
        sRDumper.dumpInt(this.ioPortBase);
        sRDumper.dumpInt(this.irq);
        sRDumper.dumpObject(this.irqDevice);
        sRDumper.dumpObject(this.timingSource);
        sRDumper.dumpObject(this.speaker);
        sRDumper.dumpInt(this.channels.length);
        for (int i = 0; i < this.channels.length; ++i) {
            sRDumper.dumpObject(this.channels[i]);
        }
    }

    public IntervalTimer(SRLoader sRLoader) throws IOException {
        super(sRLoader);
        this.madeNewTimer = sRLoader.loadBoolean();
        this.ioportRegistered = sRLoader.loadBoolean();
        this.ioPortBase = sRLoader.loadInt();
        this.irq = sRLoader.loadInt();
        this.irqDevice = (InterruptController)sRLoader.loadObject();
        this.timingSource = (Clock)sRLoader.loadObject();
        this.speaker = (PCSpeaker)sRLoader.loadObject();
        this.channels = new TimerChannel[sRLoader.loadInt()];
        for (int i = 0; i < this.channels.length; ++i) {
            this.channels[i] = (TimerChannel)sRLoader.loadObject();
        }
    }

    @Override
    public int[] ioPortsRequested() {
        return new int[]{this.ioPortBase, this.ioPortBase + 1, this.ioPortBase + 2, this.ioPortBase + 3};
    }

    @Override
    public int ioPortReadLong(int n) {
        return this.ioPortReadWord(n) & 0xFFFF | this.ioPortReadWord(n + 2) << 16 & 0xFFFF0000;
    }

    @Override
    public int ioPortReadWord(int n) {
        return this.ioPortReadByte(n) & 0xFF | this.ioPortReadByte(n + 1) << 8 & 0xFF00;
    }

    @Override
    public int ioPortReadByte(int n) {
        return this.channels[n & 3].read();
    }

    @Override
    public void ioPortWriteLong(int n, int n2) {
        this.ioPortWriteWord(n, 0xFFFF & n2);
        this.ioPortWriteWord(n + 2, 0xFFFF & n2 >>> 16);
    }

    @Override
    public void ioPortWriteWord(int n, int n2) {
        this.ioPortWriteByte(n, 0xFF & n2);
        this.ioPortWriteByte(n + 1, 0xFF & n2 >>> 8);
    }

    @Override
    public void ioPortWriteByte(int n, int n2) {
        n2 &= 0xFF;
        if ((n &= 3) == 3) {
            int n3 = n2 >>> 6;
            if (n3 == 3) {
                for (n3 = 0; n3 < 3; ++n3) {
                    if (0 == (n2 & 2 << n3)) continue;
                    this.channels[n3].readBack(n2);
                }
            } else {
                this.channels[n3].writeControlWord(n2);
            }
        } else {
            this.channels[n].write(n2);
        }
    }

    @Override
    public void reset() {
        this.irqDevice = null;
        this.timingSource = null;
        this.ioportRegistered = false;
    }

    public int getOut(int n) {
        return this.channels[n].getOut(this.timingSource.getTime());
    }

    public int getMode(int n) {
        return this.channels[n].getMode();
    }

    public int getInitialCount(int n) {
        return this.channels[n].getInitialCount();
    }

    public boolean getGate(int n) {
        return this.channels[n].gate;
    }

    public void setGate(int n, boolean bl) {
        this.channels[n].setGate(bl);
    }

    @Override
    public boolean initialised() {
        return this.irqDevice != null && this.timingSource != null && this.ioportRegistered;
    }

    @Override
    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof InterruptController && hardwareComponent.initialised()) {
            this.irqDevice = (InterruptController)hardwareComponent;
        }
        if (hardwareComponent instanceof Clock && hardwareComponent.initialised()) {
            this.timingSource = (Clock)hardwareComponent;
        }
        if (hardwareComponent instanceof IOPortHandler && hardwareComponent.initialised()) {
            ((IOPortHandler)hardwareComponent).registerIOPortCapable(this);
            this.ioportRegistered = true;
        }
        if (hardwareComponent instanceof PCSpeaker) {
            this.speaker = (PCSpeaker)hardwareComponent;
        }
        if (this.initialised() && this.channels == null) {
            this.channels = new TimerChannel[3];
            for (int i = 0; i < this.channels.length; ++i) {
                this.channels[i] = new TimerChannel(this, i);
            }
            this.channels[0].setIRQTimer(this.timingSource.newTimer(this.channels[0]));
            this.channels[0].setIRQ(this.irq);
            this.channels[2].setIRQTimer(this.timingSource.newTimer(this.channels[2]));
            this.channels[2].setIRQ(-1);
        }
    }

    public String toString() {
        return "Intel i8254 Interval Timer";
    }

    public static class TimerChannel
    extends AbstractHardwareComponent
    implements TimerResponsive {
        private int countValue;
        private int outputLatch;
        private int inputLatch;
        private int countLatched;
        private boolean statusLatched;
        private boolean nullCount;
        private boolean gate;
        private int status;
        private int readState;
        private int writeState;
        private int rwMode;
        private int mode;
        private int bcd;
        private long countStartTime;
        private long nextTransitionTimeValue;
        private Timer irqTimer;
        private int irq;
        private IntervalTimer upperBackref;

        public TimerChannel(IntervalTimer intervalTimer, int n) {
            this.upperBackref = intervalTimer;
            this.mode = 3;
            this.gate = n != 2;
            this.loadCount(0);
            this.nullCount = true;
        }

        @Override
        public void dumpStatusPartial(StatusDumper statusDumper) {
            super.dumpStatusPartial(statusDumper);
            statusDumper.println("\tupperBackref <object #" + statusDumper.objectNumber(this.upperBackref) + ">");
            if (this.upperBackref != null) {
                this.upperBackref.dumpStatus(statusDumper);
            }
            statusDumper.println("\tcountValue " + this.countValue + " outputLatch " + this.outputLatch);
            statusDumper.println("\tinputLatch " + this.inputLatch + " countLatched " + this.countLatched);
            statusDumper.println("\tstatusLatched " + this.statusLatched + " nullCount " + this.nullCount);
            statusDumper.println("\tgate " + this.gate + " status " + this.status + " readState " + this.readState);
            statusDumper.println("\twriteState " + this.writeState + " rwMode " + this.rwMode + " mode " + this.mode);
            statusDumper.println("\tbcd " + this.bcd + " countStartTime " + this.countStartTime);
            statusDumper.println("\tnextTransitionTimeValue " + this.nextTransitionTimeValue + " irq " + this.irq);
            statusDumper.println("\tirqTimer <object #" + statusDumper.objectNumber(this.irqTimer) + ">");
            if (this.irqTimer != null) {
                this.irqTimer.dumpStatus(statusDumper);
            }
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": TimerChannel:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            super.dumpSRPartial(sRDumper);
            sRDumper.dumpInt(this.countValue);
            sRDumper.dumpInt(this.outputLatch);
            sRDumper.dumpInt(this.inputLatch);
            sRDumper.dumpInt(this.countLatched);
            sRDumper.dumpBoolean(this.statusLatched);
            sRDumper.dumpBoolean(this.nullCount);
            sRDumper.dumpBoolean(this.gate);
            sRDumper.dumpInt(this.status);
            sRDumper.dumpInt(this.readState);
            sRDumper.dumpInt(this.writeState);
            sRDumper.dumpInt(this.rwMode);
            sRDumper.dumpInt(this.mode);
            sRDumper.dumpInt(this.bcd);
            sRDumper.dumpLong(this.countStartTime);
            sRDumper.dumpLong(this.nextTransitionTimeValue);
            sRDumper.dumpInt(this.irq);
            sRDumper.dumpObject(this.irqTimer);
            sRDumper.dumpObject(this.upperBackref);
        }

        public TimerChannel(SRLoader sRLoader) throws IOException {
            super(sRLoader);
            this.countValue = sRLoader.loadInt();
            this.outputLatch = sRLoader.loadInt();
            this.inputLatch = sRLoader.loadInt();
            this.countLatched = sRLoader.loadInt();
            this.statusLatched = sRLoader.loadBoolean();
            this.nullCount = sRLoader.loadBoolean();
            this.gate = sRLoader.loadBoolean();
            this.status = sRLoader.loadInt();
            this.readState = sRLoader.loadInt();
            this.writeState = sRLoader.loadInt();
            this.rwMode = sRLoader.loadInt();
            this.mode = sRLoader.loadInt();
            this.bcd = sRLoader.loadInt();
            this.countStartTime = sRLoader.loadLong();
            this.nextTransitionTimeValue = sRLoader.loadLong();
            this.irq = sRLoader.loadInt();
            this.irqTimer = (Timer)sRLoader.loadObject();
            this.upperBackref = (IntervalTimer)sRLoader.loadObject();
        }

        public int read() {
            if (this.statusLatched) {
                this.statusLatched = false;
                return this.status;
            }
            switch (this.countLatched) {
                case 1: {
                    this.countLatched = 0;
                    return this.outputLatch & 0xFF;
                }
                case 2: {
                    this.countLatched = 0;
                    return this.outputLatch >>> 8 & 0xFF;
                }
                case 3: {
                    this.countLatched = 4;
                    return this.outputLatch & 0xFF;
                }
                case 4: {
                    this.countLatched = 0;
                    return this.outputLatch >>> 8 & 0xFF;
                }
            }
            switch (this.readState) {
                default: {
                    return this.getCount() & 0xFF;
                }
                case 2: {
                    return this.getCount() >>> 8 & 0xFF;
                }
                case 3: {
                    this.readState = 4;
                    return this.getCount() & 0xFF;
                }
                case 4: 
            }
            this.readState = 3;
            return this.getCount() >>> 8 & 0xFF;
        }

        public void readBack(int n) {
            if (0 == (n & 0x20)) {
                this.latchCount();
            }
            if (0 == (n & 0x10)) {
                this.latchStatus();
            }
        }

        private void latchCount() {
            if (0 != this.countLatched) {
                this.outputLatch = this.getCount();
                this.countLatched = this.rwMode;
            }
        }

        private void latchStatus() {
            if (!this.statusLatched) {
                this.status = this.getOut(this.upperBackref.timingSource.getTime()) << 7 | (this.nullCount ? 64 : 0) | this.rwMode << 4 | this.mode << 1 | this.bcd;
                this.statusLatched = true;
            }
        }

        public void write(int n) {
            switch (this.writeState) {
                default: {
                    this.nullCount = true;
                    this.loadCount(0xFF & n);
                    break;
                }
                case 2: {
                    this.nullCount = true;
                    this.loadCount((0xFF & n) << 8);
                    break;
                }
                case 3: {
                    this.inputLatch = n;
                    this.writeState = 4;
                    break;
                }
                case 4: {
                    this.nullCount = true;
                    this.loadCount(0xFF & this.inputLatch | (0xFF & n) << 8);
                    this.writeState = 3;
                }
            }
        }

        public void writeControlWord(int n) {
            int n2 = n >>> 4 & 3;
            if (n2 == 0) {
                this.latchCount();
            } else {
                this.nullCount = true;
                this.rwMode = n2;
                this.readState = n2;
                this.writeState = n2;
                this.mode = n >>> 1 & 7;
                this.bcd = n & 1;
            }
        }

        public void setGate(boolean bl) {
            switch (this.mode) {
                default: {
                    break;
                }
                case 1: 
                case 5: {
                    if (this.gate || !bl) break;
                    this.countStartTime = this.upperBackref.timingSource.getTime();
                    this.irqTimerUpdate(this.countStartTime);
                    break;
                }
                case 2: 
                case 3: {
                    if (this.gate || !bl) break;
                    this.countStartTime = this.upperBackref.timingSource.getTime();
                    this.irqTimerUpdate(this.countStartTime);
                }
            }
            this.gate = bl;
        }

        private int getCount() {
            long l = IntervalTimer.scale64(this.upperBackref.timingSource.getTime() - this.countStartTime, 1193182, (int)this.upperBackref.timingSource.getTickRate());
            switch (this.mode) {
                case 0: 
                case 1: 
                case 4: 
                case 5: {
                    return (int)((long)this.countValue - l & 0xFFFFL);
                }
                case 3: {
                    return (int)((long)this.countValue - 2L * l % (long)this.countValue);
                }
            }
            return (int)((long)this.countValue - l % (long)this.countValue);
        }

        private int getOut(long l) {
            long l2 = IntervalTimer.scale64(l - this.countStartTime, 1193182, (int)this.upperBackref.timingSource.getTickRate());
            switch (this.mode) {
                default: {
                    if (l2 >= (long)this.countValue) {
                        return 1;
                    }
                    return 0;
                }
                case 1: {
                    if (l2 < (long)this.countValue) {
                        return 1;
                    }
                    return 0;
                }
                case 2: {
                    if (l2 % (long)this.countValue == 0L && l2 != 0L) {
                        return 1;
                    }
                    return 0;
                }
                case 3: {
                    if (l2 % (long)this.countValue < (long)(this.countValue + 1 >>> 1)) {
                        return 1;
                    }
                    return 0;
                }
                case 4: 
                case 5: 
            }
            if (l2 == (long)this.countValue) {
                return 1;
            }
            return 0;
        }

        private long getNextTransitionTime(long l) {
            long l2;
            long l3 = IntervalTimer.scale64(l - this.countStartTime, 1193182, (int)this.upperBackref.timingSource.getTickRate());
            switch (this.mode) {
                default: {
                    if (l3 < (long)this.countValue) {
                        l2 = this.countValue;
                        break;
                    }
                    return -1L;
                }
                case 2: {
                    long l4 = l3 / (long)this.countValue * (long)this.countValue;
                    if (l3 - l4 == 0L && l3 != 0L) {
                        l2 = l4 + (long)this.countValue;
                        break;
                    }
                    l2 = l4 + (long)this.countValue + 1L;
                    break;
                }
                case 3: {
                    long l5 = l3 / (long)this.countValue * (long)this.countValue;
                    long l6 = this.countValue + 1 >>> 1;
                    if (l3 - l5 < l6) {
                        l2 = l5 + l6;
                        break;
                    }
                    l2 = l5 + (long)this.countValue;
                    break;
                }
                case 4: 
                case 5: {
                    if (l3 < (long)this.countValue) {
                        l2 = this.countValue;
                        break;
                    }
                    if (l3 == (long)this.countValue) {
                        l2 = this.countValue + 1;
                        break;
                    }
                    return -1L;
                }
            }
            l2 = this.countStartTime + IntervalTimer.scale64(l2, (int)this.upperBackref.timingSource.getTickRate(), 1193182);
            if (l2 <= l) {
                l2 = l + 1L;
            }
            return l2;
        }

        private void loadCount(int n) {
            this.nullCount = false;
            if (n == 0) {
                n = 65536;
            }
            this.countStartTime = this.upperBackref.timingSource.getTime();
            this.countValue = n;
            this.irqTimerUpdate(this.countStartTime);
        }

        private void irqTimerUpdate(long l) {
            if (this.irqTimer == null) {
                return;
            }
            long l2 = this.getNextTransitionTime(l);
            int n = this.getOut(l);
            if (this.irq >= 0) {
                this.upperBackref.irqDevice.setIRQ(this.irq, n);
            } else if (this.irq == -1) {
                this.upperBackref.speaker.setPITInput(n != 0);
            }
            this.nextTransitionTimeValue = l2;
            if (l2 != -1L) {
                this.irqTimer.setExpiry(l2);
            } else {
                this.irqTimer.disable();
            }
        }

        public int getMode() {
            return this.mode;
        }

        public int getInitialCount() {
            return this.countValue;
        }

        @Override
        public void callback() {
            this.irqTimerUpdate(this.nextTransitionTimeValue);
        }

        public void setIRQTimer(Timer timer) {
            this.irqTimer = timer;
        }

        public void setIRQ(int n) {
            this.irq = n;
        }

        @Override
        public int getTimerType() {
            return 2;
        }
    }
}

