/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.pci;

import java.io.IOException;
import org.jpc.emulator.AbstractHardwareComponent;
import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.memory.PhysicalAddressSpace;
import org.jpc.emulator.motherboard.IOPortHandler;
import org.jpc.emulator.pci.IOPortIORegion;
import org.jpc.emulator.pci.IORegion;
import org.jpc.emulator.pci.IRQBouncer;
import org.jpc.emulator.pci.MemoryMappedIORegion;
import org.jpc.emulator.pci.PCIDevice;
import org.jpc.emulator.pci.PCIISABridge;

public class PCIBus
extends AbstractHardwareComponent {
    static final int PCI_DEVICES_MAX = 64;
    static final int PCI_IRQ_WORDS = 2;
    private static final byte[] PCI_IRQS = new byte[]{11, 9, 11, 9};
    private int busNumber;
    private int devFNMinimum;
    private int biosIOAddress;
    private int biosMemoryAddress;
    private PCIDevice[] devices;
    private PCIISABridge isaBridge;
    private IOPortHandler ioports;
    private PhysicalAddressSpace memory;
    private int pciIRQIndex;
    private int[][] pciIRQLevels;

    public PCIBus() {
        this.busNumber = 0;
        this.pciIRQIndex = 0;
        this.devices = new PCIDevice[256];
        this.pciIRQLevels = new int[4][2];
        this.devFNMinimum = 8;
    }

    @Override
    public void dumpStatusPartial(StatusDumper statusDumper) {
        int n;
        super.dumpStatusPartial(statusDumper);
        statusDumper.println("\tbusNumber " + this.busNumber + " devFNMinimum " + this.devFNMinimum);
        statusDumper.println("\tpciIRQIndex " + this.pciIRQIndex + " biosIOAddress " + this.biosIOAddress);
        statusDumper.println("\tbiosMemoryAddress " + this.biosMemoryAddress);
        statusDumper.println("\tisaBridge <object #" + statusDumper.objectNumber(this.isaBridge) + ">");
        if (this.isaBridge != null) {
            this.isaBridge.dumpStatus(statusDumper);
        }
        statusDumper.println("\tioports <object #" + statusDumper.objectNumber(this.ioports) + ">");
        if (this.ioports != null) {
            this.ioports.dumpStatus(statusDumper);
        }
        statusDumper.println("\tmemory <object #" + statusDumper.objectNumber(this.memory) + ">");
        if (this.memory != null) {
            this.memory.dumpStatus(statusDumper);
        }
        for (n = 0; n < this.devices.length; ++n) {
            statusDumper.println("\tdevices[" + n + "] <object #" + statusDumper.objectNumber(this.devices[n]) + ">");
            if (this.devices[n] == null) continue;
            this.devices[n].dumpStatus(statusDumper);
        }
        for (n = 0; n < this.pciIRQLevels.length; ++n) {
            if (this.pciIRQLevels[n] != null) {
                for (int i = 0; i < this.pciIRQLevels[n].length; ++i) {
                    statusDumper.println("\tpciIRQLevels[" + n + "][" + i + "] " + this.pciIRQLevels[n][i]);
                }
                continue;
            }
            statusDumper.println("\tpciIRQLevels[" + n + "] null");
        }
    }

    @Override
    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": PCIBus:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        int n;
        super.dumpSRPartial(sRDumper);
        sRDumper.dumpInt(this.busNumber);
        sRDumper.dumpInt(this.devFNMinimum);
        sRDumper.dumpInt(this.pciIRQIndex);
        sRDumper.dumpInt(this.biosIOAddress);
        sRDumper.dumpInt(this.biosMemoryAddress);
        sRDumper.dumpObject(this.isaBridge);
        sRDumper.dumpObject(this.ioports);
        sRDumper.dumpObject(this.memory);
        sRDumper.dumpInt(this.devices.length);
        for (n = 0; n < this.devices.length; ++n) {
            sRDumper.dumpObject(this.devices[n]);
        }
        sRDumper.dumpInt(this.pciIRQLevels.length);
        for (n = 0; n < this.pciIRQLevels.length; ++n) {
            sRDumper.dumpArray(this.pciIRQLevels[n]);
        }
    }

    public PCIBus(SRLoader sRLoader) throws IOException {
        super(sRLoader);
        int n;
        this.busNumber = sRLoader.loadInt();
        this.devFNMinimum = sRLoader.loadInt();
        this.pciIRQIndex = sRLoader.loadInt();
        this.biosIOAddress = sRLoader.loadInt();
        this.biosMemoryAddress = sRLoader.loadInt();
        this.isaBridge = (PCIISABridge)sRLoader.loadObject();
        this.ioports = (IOPortHandler)sRLoader.loadObject();
        this.memory = (PhysicalAddressSpace)sRLoader.loadObject();
        this.devices = new PCIDevice[sRLoader.loadInt()];
        for (n = 0; n < this.devices.length; ++n) {
            this.devices[n] = (PCIDevice)sRLoader.loadObject();
        }
        this.pciIRQLevels = new int[sRLoader.loadInt()][];
        for (n = 0; n < this.pciIRQLevels.length; ++n) {
            this.pciIRQLevels[n] = sRLoader.loadArrayInt();
        }
    }

    public boolean registerDevice(PCIDevice pCIDevice) {
        if (this.pciIRQIndex >= 64) {
            return false;
        }
        if (pCIDevice.autoAssignDeviceFunctionNumber()) {
            int n = this.findFreeDevFN();
            if (0 <= n) {
                pCIDevice.assignDeviceFunctionNumber(n);
            }
        } else {
            PCIDevice pCIDevice2 = this.devices[pCIDevice.getDeviceFunctionNumber()];
            if (pCIDevice2 != null) {
                System.err.println("Informational: unregistering pci device " + pCIDevice2 + ".");
                pCIDevice2.deassignDeviceFunctionNumber();
            }
        }
        if (pCIDevice.getIRQIndex() == -1) {
            pCIDevice.setIRQIndex(this.pciIRQIndex++);
        }
        this.addDevice(pCIDevice);
        IRQBouncer iRQBouncer = this.isaBridge.makeBouncer(pCIDevice);
        pCIDevice.addIRQBouncer(iRQBouncer);
        return this.registerPCIIORegions(pCIDevice);
    }

    private int findFreeDevFN() {
        for (int i = this.devFNMinimum; i < 256; i += 8) {
            if (null != this.devices[i]) continue;
            return i;
        }
        return -1;
    }

    private boolean registerPCIIORegions(PCIDevice pCIDevice) {
        IORegion[] iORegionArray = pCIDevice.getIORegions();
        if (iORegionArray == null) {
            return true;
        }
        boolean bl = true;
        for (IORegion iORegion : iORegionArray) {
            if (7 <= iORegion.getRegionNumber()) {
                bl = false;
                continue;
            }
            if (iORegion.getRegionNumber() == 6) {
                pCIDevice.putConfigLong(48, iORegion.getType());
                continue;
            }
            pCIDevice.putConfigLong(16 + iORegion.getRegionNumber() * 4, iORegion.getType());
        }
        return bl;
    }

    private void updateMappings(PCIDevice pCIDevice) {
        IORegion[] iORegionArray = pCIDevice.getIORegions();
        if (iORegionArray == null) {
            return;
        }
        short s = pCIDevice.configReadWord(4);
        for (IORegion iORegion : iORegionArray) {
            int n;
            if (null == iORegion || 7 <= iORegion.getRegionNumber()) continue;
            int n2 = 6 == iORegion.getRegionNumber() ? 48 : 16 + iORegion.getRegionNumber() * 4;
            int n3 = -1;
            if (iORegion instanceof IOPortIORegion) {
                if (0 != (s & 1)) {
                    n3 = pCIDevice.configReadLong(n2);
                    n = (n3 = (int)((long)n3 & (iORegion.getSize() - 1L ^ 0xFFFFFFFFFFFFFFFFL))) + (int)iORegion.getSize() - 1;
                    if ((long)n <= (0xFFFFFFFFL & (long)n3) || 0 == n3 || 65536L <= (0xFFFFFFFFL & (long)n)) {
                        n3 = -1;
                    }
                }
            } else if (iORegion instanceof MemoryMappedIORegion) {
                if (0 != (s & 2)) {
                    n3 = pCIDevice.configReadLong(n2);
                    if (6 == iORegion.getRegionNumber() && 0 == (n3 & 1)) {
                        n3 = -1;
                    } else {
                        n = (n3 = (int)((long)n3 & (iORegion.getSize() - 1L ^ 0xFFFFFFFFFFFFFFFFL))) + (int)iORegion.getSize() - 1;
                        if (n <= n3 || 0 == n3 || -1 == n) {
                            n3 = -1;
                        }
                    }
                }
            } else {
                System.err.println("Critical error: Unknown IORegion type.");
                throw new IllegalStateException("Unknown PCI IORegion Type");
            }
            if (iORegion.getAddress() == n3) continue;
            if (iORegion.getAddress() != -1) {
                if (iORegion instanceof IOPortIORegion) {
                    n = pCIDevice.configReadWord(10);
                    if (257 == n && 4L == iORegion.getSize()) {
                        System.err.println("Warning: supposed to partially unmap");
                        this.ioports.deregisterIOPortCapable((IOPortIORegion)iORegion);
                    } else {
                        this.ioports.deregisterIOPortCapable((IOPortIORegion)iORegion);
                    }
                } else if (iORegion instanceof MemoryMappedIORegion) {
                    this.memory.unmap(iORegion.getAddress(), (int)iORegion.getSize());
                }
            }
            iORegion.setAddress(n3);
            if (iORegion.getAddress() == -1) continue;
            if (iORegion instanceof IOPortIORegion) {
                this.ioports.registerIOPortCapable((IOPortIORegion)iORegion);
                continue;
            }
            if (!(iORegion instanceof MemoryMappedIORegion)) continue;
            this.memory.mapMemoryRegion((MemoryMappedIORegion)iORegion, iORegion.getAddress(), (int)iORegion.getSize());
        }
    }

    private void addDevice(PCIDevice pCIDevice) {
        this.devices[pCIDevice.getDeviceFunctionNumber()] = pCIDevice;
    }

    private PCIDevice validPCIDataAccess(int n) {
        int n2 = n >>> 16 & 0xFF;
        if (0 != n2) {
            return null;
        }
        return this.devices[n >>> 8 & 0xFF];
    }

    void writePCIDataByte(int n, byte by) {
        PCIDevice pCIDevice = this.validPCIDataAccess(n);
        if (null == pCIDevice) {
            return;
        }
        if (pCIDevice.configWriteByte(n & 0xFF, by)) {
            this.updateMappings(pCIDevice);
        }
    }

    void writePCIDataWord(int n, short s) {
        PCIDevice pCIDevice = this.validPCIDataAccess(n);
        if (null == pCIDevice) {
            return;
        }
        if (pCIDevice.configWriteWord(n & 0xFF, s)) {
            this.updateMappings(pCIDevice);
        }
    }

    void writePCIDataLong(int n, int n2) {
        PCIDevice pCIDevice = this.validPCIDataAccess(n);
        if (null == pCIDevice) {
            return;
        }
        if (pCIDevice.configWriteLong(n & 0xFF, n2)) {
            this.updateMappings(pCIDevice);
        }
    }

    byte readPCIDataByte(int n) {
        PCIDevice pCIDevice = this.validPCIDataAccess(n);
        if (null == pCIDevice) {
            return -1;
        }
        return pCIDevice.configReadByte(n & 0xFF);
    }

    short readPCIDataWord(int n) {
        PCIDevice pCIDevice = this.validPCIDataAccess(n);
        if (null == pCIDevice) {
            return -1;
        }
        return pCIDevice.configReadWord(n & 0xFF);
    }

    int readPCIDataLong(int n) {
        PCIDevice pCIDevice = this.validPCIDataAccess(n);
        if (null == pCIDevice) {
            return -1;
        }
        return pCIDevice.configReadLong(n & 0xFF);
    }

    public void biosInit() {
        int n;
        this.biosIOAddress = 49152;
        this.biosMemoryAddress = -268435456;
        byte[] byArray = new byte[]{0, 0};
        for (n = 0; n < 4; ++n) {
            byte by = PCI_IRQS[n];
            int n2 = by >> 3;
            byArray[n2] = (byte)(byArray[n2] | 1 << (by & 7));
            this.isaBridge.configWriteByte(96 + n, by);
        }
        this.ioports.ioPortWriteByte(1232, byArray[0]);
        this.ioports.ioPortWriteByte(1233, byArray[1]);
        for (n = 0; n < 256; ++n) {
            PCIDevice pCIDevice = this.devices[n];
            if (pCIDevice == null) continue;
            this.biosInitDevice(pCIDevice);
        }
    }

    private final void biosInitDevice(PCIDevice pCIDevice) {
        int n = 0xFFFF & pCIDevice.configReadWord(10);
        int n2 = 0xFFFF & pCIDevice.configReadWord(0);
        int n3 = 0xFFFF & pCIDevice.configReadWord(2);
        switch (n) {
            case 257: {
                if ((0xFFFF & n2) == 32902 && (0xFFFF & n3) == 28688) {
                    pCIDevice.configWriteWord(64, (short)Short.MIN_VALUE);
                    pCIDevice.configWriteWord(66, (short)Short.MIN_VALUE);
                    this.defaultIOMap(pCIDevice);
                    break;
                }
                this.setIORegionAddress(pCIDevice, 0, 496);
                this.setIORegionAddress(pCIDevice, 1, 1012);
                this.setIORegionAddress(pCIDevice, 2, 368);
                this.setIORegionAddress(pCIDevice, 3, 884);
                break;
            }
            case 768: {
                if (n2 == 4660) {
                    this.setIORegionAddress(pCIDevice, 0, -536870912);
                    break;
                }
                this.defaultIOMap(pCIDevice);
                break;
            }
            case 2048: {
                if (n2 != 4116 || n3 != 70 && n3 != 65535) break;
                this.setIORegionAddress(pCIDevice, 0, -2138832896);
                break;
            }
            case 65280: {
                if (n2 != 4203 || n3 != 23 && n3 != 34) break;
                this.setIORegionAddress(pCIDevice, 0, -2139095040);
                break;
            }
            case 512: {
                this.setIORegionAddress(pCIDevice, 0, pCIDevice.configReadLong(16));
                break;
            }
            default: {
                this.defaultIOMap(pCIDevice);
            }
        }
        int n4 = pCIDevice.configReadByte(61);
        if (n4 != 0) {
            n4 = this.isaBridge.slotGetPIRQ(pCIDevice, n4 - 1);
            pCIDevice.configWriteByte(60, PCI_IRQS[n4]);
        }
    }

    private void defaultIOMap(PCIDevice pCIDevice) {
        IORegion[] iORegionArray = pCIDevice.getIORegions();
        if (iORegionArray == null) {
            return;
        }
        for (IORegion iORegion : iORegionArray) {
            int n;
            if (iORegion == null) continue;
            if (iORegion instanceof IOPortIORegion) {
                n = this.biosIOAddress;
                n = (int)((long)n + iORegion.getSize() - 1L & (iORegion.getSize() - 1L ^ 0xFFFFFFFFFFFFFFFFL));
                this.setIORegionAddress(pCIDevice, iORegion.getRegionNumber(), n);
                this.biosIOAddress = (int)((long)this.biosIOAddress + iORegion.getSize());
                continue;
            }
            if (!(iORegion instanceof MemoryMappedIORegion)) continue;
            n = this.biosMemoryAddress;
            n = (int)((long)n + iORegion.getSize() - 1L & (iORegion.getSize() - 1L ^ 0xFFFFFFFFFFFFFFFFL));
            this.setIORegionAddress(pCIDevice, iORegion.getRegionNumber(), n);
            this.biosMemoryAddress = (int)((long)this.biosMemoryAddress + iORegion.getSize());
        }
    }

    private void setIORegionAddress(PCIDevice pCIDevice, int n, int n2) {
        IORegion iORegion;
        int n3 = n == 6 ? 48 : 16 + n * 4;
        if (pCIDevice.configWriteLong(n3, n2)) {
            this.updateMappings(pCIDevice);
        }
        if ((iORegion = pCIDevice.getIORegion(n)) == null) {
            return;
        }
        short s = pCIDevice.configReadWord(4);
        s = iORegion.getRegionNumber() == 6 ? (short)(s | 2) : (iORegion instanceof IOPortIORegion ? (short)(s | 1) : (short)(s | 2));
        if (pCIDevice.configWriteWord(4, s)) {
            this.updateMappings(pCIDevice);
        }
    }

    @Override
    public void reset() {
        this.isaBridge = null;
        this.ioports = null;
        this.memory = null;
        this.pciIRQIndex = 0;
        this.devices = new PCIDevice[256];
        this.pciIRQLevels = new int[4][2];
    }

    @Override
    public boolean initialised() {
        return this.isaBridge != null && this.ioports != null && this.memory != null;
    }

    @Override
    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof PCIISABridge) {
            this.isaBridge = (PCIISABridge)hardwareComponent;
        }
        if (hardwareComponent instanceof IOPortHandler && hardwareComponent.initialised()) {
            this.ioports = (IOPortHandler)hardwareComponent;
        }
        if (hardwareComponent instanceof PhysicalAddressSpace && hardwareComponent.initialised()) {
            this.memory = (PhysicalAddressSpace)hardwareComponent;
        }
        if (this.memory != null && hardwareComponent instanceof PCIDevice && ((PCIDevice)((Object)hardwareComponent)).wantsMappingUpdate()) {
            this.updateMappings((PCIDevice)((Object)hardwareComponent));
        }
    }
}

