/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.pci.peripheral;

import java.io.IOException;
import org.jpc.diskimages.BlockDevice;
import org.jpc.emulator.AbstractHardwareComponent;
import org.jpc.emulator.SRDumpable;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.motherboard.IOPortCapable;
import org.jpc.emulator.motherboard.InterruptController;
import org.jpc.emulator.pci.peripheral.BMDMAIORegion;

public class IDEChannel
extends AbstractHardwareComponent
implements IOPortCapable {
    private IDEState[] devices;
    private IDEState currentDevice;
    private int ioBase;
    private int ioBaseTwo;
    private int irq;
    private InterruptController irqDevice;
    private int nextDriveSerial;

    @Override
    public void dumpStatusPartial(StatusDumper statusDumper) {
        super.dumpStatusPartial(statusDumper);
        statusDumper.println("\tioBase " + this.ioBase + " ioBaseTwo " + this.ioBaseTwo + " irq " + this.irq);
        statusDumper.println("\tnextDriveSerial " + this.nextDriveSerial);
        statusDumper.println("\tirqDevice <object #" + statusDumper.objectNumber(this.irqDevice) + ">");
        if (this.irqDevice != null) {
            this.irqDevice.dumpStatus(statusDumper);
        }
        statusDumper.println("\tcurrentDevice <object #" + statusDumper.objectNumber(this.currentDevice) + ">");
        if (this.currentDevice != null) {
            this.currentDevice.dumpStatus(statusDumper);
        }
        if (this.devices != null) {
            for (int i = 0; i < this.devices.length; ++i) {
                statusDumper.println("\tdevices[" + i + "] <object #" + statusDumper.objectNumber(this.devices[i]) + ">");
                if (this.devices[i] == null) continue;
                this.devices[i].dumpStatus(statusDumper);
            }
        } else {
            statusDumper.println("\tdevices null");
        }
    }

    @Override
    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": IDEChannel:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        sRDumper.dumpInt(this.devices.length);
        for (int i = 0; i < this.devices.length; ++i) {
            sRDumper.dumpObject(this.devices[i]);
        }
        sRDumper.dumpObject(this.currentDevice);
        sRDumper.dumpInt(this.ioBase);
        sRDumper.dumpInt(this.ioBaseTwo);
        sRDumper.dumpInt(this.irq);
        sRDumper.dumpObject(this.irqDevice);
        sRDumper.dumpInt(this.nextDriveSerial);
    }

    public IDEChannel(SRLoader sRLoader) throws IOException {
        sRLoader.objectCreated(this);
        this.devices = new IDEState[sRLoader.loadInt()];
        for (int i = 0; i < this.devices.length; ++i) {
            this.devices[i] = (IDEState)sRLoader.loadObject();
        }
        this.currentDevice = (IDEState)sRLoader.loadObject();
        this.ioBase = sRLoader.loadInt();
        this.ioBaseTwo = sRLoader.loadInt();
        this.irq = sRLoader.loadInt();
        this.irqDevice = (InterruptController)sRLoader.loadObject();
        this.nextDriveSerial = sRLoader.loadInt();
    }

    private static void shortToBigEndianBytes(byte[] byArray, int n, short s) {
        byArray[n + 0] = (byte)(s >> 8);
        byArray[n + 1] = (byte)s;
    }

    private static void intToBigEndianBytes(byte[] byArray, int n, int n2) {
        byArray[n + 0] = (byte)(n2 >> 24);
        byArray[n + 1] = (byte)(n2 >> 16);
        byArray[n + 2] = (byte)(n2 >> 8);
        byArray[n + 3] = (byte)n2;
    }

    private static int bigEndianBytesToInt(byte[] byArray, int n) {
        int n2 = 0;
        n2 |= byArray[n + 0] << 24 & 0xFF000000;
        n2 |= byArray[n + 1] << 16 & 0xFF0000;
        n2 |= byArray[n + 2] << 8 & 0xFF00;
        return n2 |= byArray[n + 3] << 0 & 0xFF;
    }

    private static short bigEndianBytesToShort(byte[] byArray, int n) {
        short s = 0;
        s = (short)(s | byArray[n + 0] << 8 & 0xFF00);
        s = (short)(s | byArray[n + 1] << 0 & 0xFF);
        return s;
    }

    private static void lbaToMSF(byte[] byArray, int n, int n2) {
        byArray[n + 0] = (byte)((n2 += 150) / 75 / 60);
        byArray[n + 1] = (byte)(n2 / 75 % 60);
        byArray[n + 2] = (byte)(n2 % 75);
    }

    private static void putLE16InByte(byte[] byArray, int n, int n2) {
        byArray[n + 0] = (byte)n2;
        byArray[n + 1] = (byte)(n2 >>> 8);
    }

    private static void stringToBytes(String string, byte[] byArray, int n, int n2) {
        int n3;
        byte[] byArray2 = string.getBytes();
        for (n3 = 0; n3 < Math.min(byArray2.length, n2); ++n3) {
            byArray[n + n3 ^ 1] = byArray2[n3];
        }
        while (n3 < n2) {
            byArray[n + n3 ^ 1] = 32;
            ++n3;
        }
    }

    public IDEChannel(int n, InterruptController interruptController, int n2, int n3, BlockDevice[] blockDeviceArray, BMDMAIORegion bMDMAIORegion) {
        this.irq = n;
        this.irqDevice = interruptController;
        this.ioBase = n2;
        this.ioBaseTwo = n3;
        this.nextDriveSerial = 1;
        this.devices = new IDEState[2];
        this.devices[0] = new IDEState(this, blockDeviceArray[0]);
        this.devices[1] = new IDEState(this, blockDeviceArray[1]);
        this.devices[0].bmdma = bMDMAIORegion;
        this.devices[1].bmdma = bMDMAIORegion;
        this.currentDevice = this.devices[0];
    }

    public void setDrives(BlockDevice[] blockDeviceArray) {
        this.devices[0].setDrive(blockDeviceArray[0]);
        this.devices[1].setDrive(blockDeviceArray[1]);
    }

    @Override
    public void ioPortWriteByte(int n, int n2) {
        if (n == this.ioBaseTwo) {
            this.writeCommand(n2);
            return;
        }
        this.writeIDE(n, n2);
    }

    @Override
    public void ioPortWriteWord(int n, int n2) {
        switch (n - this.ioBase) {
            case 0: 
            case 1: {
                this.writeDataWord(n2);
                break;
            }
            default: {
                this.ioPortWriteByte(n, n2);
                this.ioPortWriteByte(n + 1, n2 >>> 8);
            }
        }
    }

    @Override
    public void ioPortWriteLong(int n, int n2) {
        switch (n - this.ioBase) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.writeDataLong(n2);
                break;
            }
            default: {
                this.ioPortWriteWord(n, n2);
                this.ioPortWriteWord(n + 2, n2 >>> 16);
            }
        }
    }

    @Override
    public int ioPortReadByte(int n) {
        if (n == this.ioBaseTwo) {
            return this.readStatus();
        }
        return this.readIDE(n);
    }

    @Override
    public int ioPortReadWord(int n) {
        switch (n - this.ioBase) {
            case 0: 
            case 1: {
                return this.readDataWord();
            }
        }
        return 0xFF & this.ioPortReadByte(n) | 0xFF00 & this.ioPortReadByte(n + 1) << 8;
    }

    @Override
    public int ioPortReadLong(int n) {
        switch (n - this.ioBase) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return this.readDataLong();
            }
        }
        return 0xFFFF & this.ioPortReadWord(n) | 0xFFFF0000 & this.ioPortReadWord(n + 2) << 16;
    }

    @Override
    public int[] ioPortsRequested() {
        if (this.ioBaseTwo == 0) {
            return new int[]{this.ioBase, this.ioBase + 1, this.ioBase + 2, this.ioBase + 3, this.ioBase + 4, this.ioBase + 5, this.ioBase + 6, this.ioBase + 7};
        }
        return new int[]{this.ioBase, this.ioBase + 1, this.ioBase + 2, this.ioBase + 3, this.ioBase + 4, this.ioBase + 5, this.ioBase + 6, this.ioBase + 7, this.ioBaseTwo};
    }

    private void writeCommand(int n) {
        if ((this.devices[0].command & 4) == 0 && (n & 4) != 0) {
            this.devices[0].status = (byte)-112;
            this.devices[0].error = 1;
            this.devices[1].status = (byte)-112;
            this.devices[1].error = 1;
        } else if ((this.devices[0].command & 4) != 0 && (n & 4) == 0) {
            for (int i = 0; i < 2; ++i) {
                this.devices[i].status = this.devices[i].isCDROM ? (byte)0 : (byte)80;
                this.devices[i].setSignature();
            }
        }
        this.devices[0].command = (byte)n;
        this.devices[1].command = (byte)n;
    }

    private int readStatus() {
        if (this.devices[0].drive == null && this.devices[1].drive == null || this.currentDevice != this.devices[0] && this.currentDevice.drive == null) {
            return 0;
        }
        return this.currentDevice.status;
    }

    private void writeIDE(int n, int n2) {
        boolean bl = false;
        block0 : switch (n &= 7) {
            case 0: {
                break;
            }
            case 1: {
                this.clearHob();
                this.devices[0].hobFeature = this.devices[0].feature;
                this.devices[1].hobFeature = this.devices[1].feature;
                this.devices[0].feature = (byte)n2;
                this.devices[1].feature = (byte)n2;
                break;
            }
            case 2: {
                this.clearHob();
                this.devices[0].hobNSector = (byte)this.devices[0].nSector;
                this.devices[1].hobNSector = (byte)this.devices[1].nSector;
                this.devices[0].nSector = 0xFF & n2;
                this.devices[1].nSector = 0xFF & n2;
                break;
            }
            case 3: {
                this.clearHob();
                this.devices[0].hobSector = this.devices[0].sector;
                this.devices[1].hobSector = this.devices[1].sector;
                this.devices[0].sector = (byte)n2;
                this.devices[1].sector = (byte)n2;
                break;
            }
            case 4: {
                this.clearHob();
                this.devices[0].hobLCyl = this.devices[0].lcyl;
                this.devices[1].hobLCyl = this.devices[1].lcyl;
                this.devices[0].lcyl = (byte)n2;
                this.devices[1].lcyl = (byte)n2;
                break;
            }
            case 5: {
                this.clearHob();
                this.devices[0].hobHCyl = this.devices[0].hcyl;
                this.devices[1].hobHCyl = this.devices[1].hcyl;
                this.devices[0].hcyl = (byte)n2;
                this.devices[1].hcyl = (byte)n2;
                break;
            }
            case 6: {
                this.devices[0].select = (byte)(n2 & 0xFFFFFFEF | 0xA0);
                this.devices[1].select = (byte)(n2 | 0x10 | 0xA0);
                this.currentDevice = this.devices[n2 >> 4 & 1];
                break;
            }
            default: {
                if (this.currentDevice != this.devices[0] && this.currentDevice.drive == null) break;
                switch (n2) {
                    case 236: {
                        if (this.currentDevice.drive != null && !this.currentDevice.isCDROM) {
                            this.currentDevice.identify();
                            this.currentDevice.status = (byte)80;
                            this.currentDevice.transferStart(this.currentDevice.ioBuffer, 0, 512, 1);
                        } else {
                            if (this.currentDevice.isCDROM) {
                                this.currentDevice.setSignature();
                            }
                            this.currentDevice.abortCommand();
                        }
                        this.currentDevice.setIRQ();
                        break block0;
                    }
                    case 16: 
                    case 145: {
                        this.currentDevice.error = 0;
                        this.currentDevice.status = (byte)80;
                        this.currentDevice.setIRQ();
                        break block0;
                    }
                    case 198: {
                        if (this.currentDevice.nSector > 16 || this.currentDevice.nSector == 0 || (this.currentDevice.nSector & this.currentDevice.nSector - 1) != 0) {
                            this.currentDevice.abortCommand();
                        } else {
                            this.currentDevice.multSectors = this.currentDevice.nSector;
                            this.currentDevice.status = (byte)64;
                        }
                        this.currentDevice.setIRQ();
                        break block0;
                    }
                    case 66: {
                        bl = true;
                    }
                    case 64: 
                    case 65: {
                        this.currentDevice.commandLBA48Transform(bl);
                        this.currentDevice.status = (byte)64;
                        this.currentDevice.setIRQ();
                        break block0;
                    }
                    case 36: {
                        bl = true;
                    }
                    case 32: 
                    case 33: {
                        if (this.currentDevice.drive == null) {
                            this.currentDevice.abortCommand();
                            this.currentDevice.setIRQ();
                            return;
                        }
                        this.currentDevice.commandLBA48Transform(bl);
                        this.currentDevice.requiredNumberOfSectors = 1;
                        this.currentDevice.sectorRead();
                        break block0;
                    }
                    case 52: {
                        bl = true;
                    }
                    case 48: 
                    case 49: {
                        this.currentDevice.commandLBA48Transform(bl);
                        this.currentDevice.error = 0;
                        this.currentDevice.status = (byte)80;
                        this.currentDevice.requiredNumberOfSectors = 1;
                        this.currentDevice.transferStart(this.currentDevice.ioBuffer, 0, 512, 2);
                        break block0;
                    }
                    case 41: {
                        bl = true;
                    }
                    case 196: {
                        if (this.currentDevice.multSectors == 0) {
                            this.currentDevice.abortCommand();
                            this.currentDevice.setIRQ();
                            return;
                        }
                        this.currentDevice.commandLBA48Transform(bl);
                        this.currentDevice.requiredNumberOfSectors = this.currentDevice.multSectors;
                        this.currentDevice.sectorRead();
                        break block0;
                    }
                    case 57: {
                        bl = true;
                    }
                    case 197: {
                        if (this.currentDevice.multSectors == 0) {
                            this.currentDevice.abortCommand();
                            this.currentDevice.setIRQ();
                            return;
                        }
                        this.currentDevice.commandLBA48Transform(bl);
                        this.currentDevice.error = 0;
                        this.currentDevice.status = (byte)80;
                        this.currentDevice.requiredNumberOfSectors = this.currentDevice.multSectors;
                        int n3 = this.currentDevice.nSector;
                        if (n3 > this.currentDevice.requiredNumberOfSectors) {
                            n3 = this.currentDevice.requiredNumberOfSectors;
                        }
                        this.currentDevice.transferStart(this.currentDevice.ioBuffer, 0, 512 * n3, 2);
                        break block0;
                    }
                    case 37: {
                        bl = true;
                    }
                    case 200: 
                    case 201: {
                        if (this.currentDevice.drive == null) {
                            this.currentDevice.abortCommand();
                            this.currentDevice.setIRQ();
                            return;
                        }
                        this.currentDevice.commandLBA48Transform(bl);
                        this.currentDevice.sectorReadDMA();
                        break block0;
                    }
                    case 53: {
                        bl = true;
                    }
                    case 202: 
                    case 203: {
                        if (this.currentDevice.drive == null) {
                            this.currentDevice.abortCommand();
                            this.currentDevice.setIRQ();
                            return;
                        }
                        this.currentDevice.commandLBA48Transform(bl);
                        this.currentDevice.sectorWriteDMA();
                        break block0;
                    }
                    case 39: {
                        bl = true;
                    }
                    case 248: {
                        this.currentDevice.commandLBA48Transform(bl);
                        this.currentDevice.setSector(this.currentDevice.drive.getTotalSectors() - 1L);
                        this.currentDevice.status = (byte)64;
                        this.currentDevice.setIRQ();
                        break block0;
                    }
                    case 229: {
                        this.currentDevice.nSector = 255;
                        this.currentDevice.status = (byte)64;
                        this.currentDevice.setIRQ();
                        break block0;
                    }
                    case 239: {
                        if (this.currentDevice.drive == null) {
                            this.currentDevice.abortCommand();
                            this.currentDevice.setIRQ();
                            return;
                        }
                        switch (this.currentDevice.feature) {
                            case -126: 
                            case -86: 
                            case 2: 
                            case 85: {
                                this.currentDevice.status = (byte)80;
                                this.currentDevice.setIRQ();
                                break block0;
                            }
                            case 3: {
                                int n4 = this.currentDevice.nSector & 7;
                                switch (this.currentDevice.nSector >>> 3) {
                                    case 0: 
                                    case 1: {
                                        IDEChannel.putLE16InByte(this.currentDevice.identifyData, 126, 7);
                                        IDEChannel.putLE16InByte(this.currentDevice.identifyData, 176, 63);
                                        break;
                                    }
                                    case 4: {
                                        IDEChannel.putLE16InByte(this.currentDevice.identifyData, 126, 7 | 1 << n4 + 8);
                                        IDEChannel.putLE16InByte(this.currentDevice.identifyData, 176, 63);
                                        break;
                                    }
                                    case 8: {
                                        IDEChannel.putLE16InByte(this.currentDevice.identifyData, 126, 7);
                                        IDEChannel.putLE16InByte(this.currentDevice.identifyData, 176, 0x3F | 1 << n4 + 8);
                                        break;
                                    }
                                    default: {
                                        this.currentDevice.abortCommand();
                                        this.currentDevice.setIRQ();
                                        return;
                                    }
                                }
                                this.currentDevice.status = (byte)80;
                                this.currentDevice.setIRQ();
                                break block0;
                            }
                        }
                        this.currentDevice.abortCommand();
                        this.currentDevice.setIRQ();
                        return;
                    }
                    case 231: 
                    case 234: {
                        if (this.currentDevice.drive != null) {
                            System.err.println("Notice: IDEChannel Should flush " + this.currentDevice.drive + ".");
                        }
                        this.currentDevice.status = (byte)64;
                        this.currentDevice.setIRQ();
                        break block0;
                    }
                    case 224: 
                    case 225: {
                        this.currentDevice.status = (byte)64;
                        this.currentDevice.setIRQ();
                        break block0;
                    }
                    case 161: {
                        if (this.currentDevice.isCDROM) {
                            this.currentDevice.atapiIdentify();
                            this.currentDevice.status = (byte)80;
                            this.currentDevice.transferStart(this.currentDevice.ioBuffer, 0, 512, 1);
                        } else {
                            this.currentDevice.abortCommand();
                        }
                        this.currentDevice.setIRQ();
                        break block0;
                    }
                    case 144: {
                        this.currentDevice.setSignature();
                        this.currentDevice.status = 0;
                        this.currentDevice.error = 1;
                        break block0;
                    }
                    case 8: {
                        if (!this.currentDevice.isCDROM) {
                            this.currentDevice.abortCommand();
                            this.currentDevice.setIRQ();
                            return;
                        }
                        this.currentDevice.setSignature();
                        this.currentDevice.status = 0;
                        this.currentDevice.error = 1;
                        break block0;
                    }
                    case 160: {
                        if (!this.currentDevice.isCDROM) {
                            this.currentDevice.abortCommand();
                            this.currentDevice.setIRQ();
                            return;
                        }
                        if ((this.currentDevice.feature & 2) != 0) {
                            this.currentDevice.abortCommand();
                            this.currentDevice.setIRQ();
                            return;
                        }
                        this.currentDevice.atapiDMA = (this.currentDevice.feature & 1) == 1;
                        this.currentDevice.nSector = 1;
                        this.currentDevice.transferStart(this.currentDevice.ioBuffer, 0, 12, 4);
                        break block0;
                    }
                }
                this.currentDevice.abortCommand();
                this.currentDevice.setIRQ();
                return;
            }
        }
    }

    private int readIDE(int n) {
        boolean bl = false;
        switch (n &= 7) {
            case 0: {
                return 255;
            }
            case 1: {
                if (this.devices[0].drive == null && this.devices[1].drive == null) {
                    return 0;
                }
                if (!bl) {
                    return this.currentDevice.error;
                }
                return this.currentDevice.hobFeature;
            }
            case 2: {
                if (this.devices[0].drive == null && this.devices[1].drive == null) {
                    return 0;
                }
                if (!bl) {
                    return this.currentDevice.nSector & 0xFF;
                }
                return this.currentDevice.hobNSector;
            }
            case 3: {
                if (this.devices[0].drive == null && this.devices[1].drive == null) {
                    return 0;
                }
                if (!bl) {
                    return this.currentDevice.sector;
                }
                return this.currentDevice.hobSector;
            }
            case 4: {
                if (this.devices[0].drive == null && this.devices[1].drive == null) {
                    return 0;
                }
                if (!bl) {
                    return this.currentDevice.lcyl;
                }
                return this.currentDevice.hobLCyl;
            }
            case 5: {
                if (this.devices[0].drive == null && this.devices[1].drive == null) {
                    return 0;
                }
                if (!bl) {
                    return this.currentDevice.hcyl;
                }
                return this.currentDevice.hobHCyl;
            }
            case 6: {
                if (this.devices[0].drive == null && this.devices[1].drive == null) {
                    return 0;
                }
                return this.currentDevice.select;
            }
        }
        if (this.devices[0].drive == null && this.devices[1].drive == null || this.currentDevice != this.devices[0] && this.currentDevice.drive == null) {
            this.irqDevice.setIRQ(this.irq, 0);
            return 0;
        }
        this.irqDevice.setIRQ(this.irq, 0);
        return this.currentDevice.status;
    }

    private int readDataWord() {
        int n = 0;
        n |= 0xFF & this.currentDevice.dataBuffer[this.currentDevice.dataBufferOffset++];
        n |= 0xFF00 & this.currentDevice.dataBuffer[this.currentDevice.dataBufferOffset++] << 8;
        if (this.currentDevice.dataBufferOffset >= this.currentDevice.dataBufferEnd) {
            this.currentDevice.endTransfer(this.currentDevice.endTransferFunction);
        }
        return n;
    }

    private int readDataLong() {
        int n = 0;
        n |= 0xFF & this.currentDevice.dataBuffer[this.currentDevice.dataBufferOffset++];
        n |= 0xFF00 & this.currentDevice.dataBuffer[this.currentDevice.dataBufferOffset++] << 8;
        n |= 0xFF0000 & this.currentDevice.dataBuffer[this.currentDevice.dataBufferOffset++] << 16;
        n |= 0xFF000000 & this.currentDevice.dataBuffer[this.currentDevice.dataBufferOffset++] << 24;
        if (this.currentDevice.dataBufferOffset >= this.currentDevice.dataBufferEnd) {
            this.currentDevice.endTransfer(this.currentDevice.endTransferFunction);
        }
        return n;
    }

    private void writeDataWord(int n) {
        this.currentDevice.dataBuffer[this.currentDevice.dataBufferOffset++] = (byte)n;
        this.currentDevice.dataBuffer[this.currentDevice.dataBufferOffset++] = (byte)(n >> 8);
        if (this.currentDevice.dataBufferOffset >= this.currentDevice.dataBufferEnd) {
            this.currentDevice.endTransfer(this.currentDevice.endTransferFunction);
        }
    }

    private void writeDataLong(int n) {
        this.currentDevice.dataBuffer[this.currentDevice.dataBufferOffset++] = (byte)n;
        this.currentDevice.dataBuffer[this.currentDevice.dataBufferOffset++] = (byte)(n >> 8);
        this.currentDevice.dataBuffer[this.currentDevice.dataBufferOffset++] = (byte)(n >> 16);
        this.currentDevice.dataBuffer[this.currentDevice.dataBufferOffset++] = (byte)(n >> 24);
        if (this.currentDevice.dataBufferOffset >= this.currentDevice.dataBufferEnd) {
            this.currentDevice.endTransfer(this.currentDevice.endTransferFunction);
        }
    }

    private void clearHob() {
        this.devices[0].select = (byte)(this.devices[0].select & 0xFFFFFF7F);
        this.devices[1].select = (byte)(this.devices[1].select & 0xFFFFFF7F);
    }

    public String toString() {
        if (this.ioBaseTwo == 0) {
            return "IDE Channel @ 0x" + Integer.toHexString(this.ioBase) + "-0x" + Integer.toHexString(this.ioBase + 7) + " on irq " + this.irq;
        }
        return "IDE Channel @ 0x" + Integer.toHexString(this.ioBase) + "-0x" + Integer.toHexString(this.ioBase + 7) + ", 0x" + Integer.toHexString(this.ioBaseTwo) + " on irq " + this.irq;
    }

    public static class IDEState
    implements SRDumpable {
        public static final int ERR_STAT = 1;
        public static final int INDEX_STAT = 2;
        public static final int ECC_STAT = 4;
        public static final int DRQ_STAT = 8;
        public static final int SEEK_STAT = 16;
        public static final int SRV_STAT = 16;
        public static final int WRERR_STAT = 32;
        public static final int READY_STAT = 64;
        public static final int BUSY_STAT = 128;
        private static final int ABRT_ERR = 4;
        public static final int IDE_CMD_RESET = 4;
        public static final int IDE_CMD_DISABLE_IRQ = 2;
        public static final int WIN_NOP = 0;
        public static final int CFA_REQ_EXT_ERROR_CODE = 3;
        public static final int WIN_SRST = 8;
        public static final int WIN_DEVICE_RESET = 8;
        public static final int WIN_RECAL = 16;
        public static final int WIN_RESTORE = 16;
        public static final int WIN_READ = 32;
        public static final int WIN_READ_ONCE = 33;
        public static final int WIN_READ_LONG = 34;
        public static final int WIN_READ_LONG_ONCE = 35;
        public static final int WIN_READ_EXT = 36;
        public static final int WIN_READDMA_EXT = 37;
        public static final int WIN_READDMA_QUEUED_EXT = 38;
        public static final int WIN_READ_NATIVE_MAX_EXT = 39;
        public static final int WIN_MULTREAD_EXT = 41;
        public static final int WIN_WRITE = 48;
        public static final int WIN_WRITE_ONCE = 49;
        public static final int WIN_WRITE_LONG = 50;
        public static final int WIN_WRITE_LONG_ONCE = 51;
        public static final int WIN_WRITE_EXT = 52;
        public static final int WIN_WRITEDMA_EXT = 53;
        public static final int WIN_WRITEDMA_QUEUED_EXT = 54;
        public static final int WIN_SET_MAX_EXT = 55;
        public static final int CFA_WRITE_SECT_WO_ERASE = 56;
        public static final int WIN_MULTWRITE_EXT = 57;
        public static final int WIN_WRITE_VERIFY = 60;
        public static final int WIN_VERIFY = 64;
        public static final int WIN_VERIFY_ONCE = 65;
        public static final int WIN_VERIFY_EXT = 66;
        public static final int WIN_FORMAT = 80;
        public static final int WIN_INIT = 96;
        public static final int WIN_SEEK = 112;
        public static final int CFA_TRANSLATE_SECTOR = 135;
        public static final int WIN_DIAGNOSE = 144;
        public static final int WIN_SPECIFY = 145;
        public static final int WIN_DOWNLOAD_MICROCODE = 146;
        public static final int WIN_STANDBYNOW2 = 148;
        public static final int WIN_STANDBY2 = 150;
        public static final int WIN_SETIDLE2 = 151;
        public static final int WIN_CHECKPOWERMODE2 = 152;
        public static final int WIN_SLEEPNOW2 = 153;
        public static final int WIN_PACKETCMD = 160;
        public static final int WIN_PIDENTIFY = 161;
        public static final int WIN_QUEUED_SERVICE = 162;
        public static final int WIN_SMART = 176;
        public static final int CFA_ERASE_SECTORS = 192;
        public static final int WIN_MULTREAD = 196;
        public static final int WIN_MULTWRITE = 197;
        public static final int WIN_SETMULT = 198;
        public static final int WIN_READDMA_QUEUED = 199;
        public static final int WIN_READDMA = 200;
        public static final int WIN_READDMA_ONCE = 201;
        public static final int WIN_WRITEDMA = 202;
        public static final int WIN_WRITEDMA_ONCE = 203;
        public static final int WIN_WRITEDMA_QUEUED = 204;
        public static final int CFA_WRITE_MULTI_WO_ERASE = 205;
        public static final int WIN_GETMEDIASTATUS = 218;
        public static final int WIN_ACKMEDIACHANGE = 219;
        public static final int WIN_POSTBOOT = 220;
        public static final int WIN_PREBOOT = 221;
        public static final int WIN_DOORLOCK = 222;
        public static final int WIN_DOORUNLOCK = 223;
        public static final int WIN_STANDBYNOW1 = 224;
        public static final int WIN_IDLEIMMEDIATE = 225;
        public static final int WIN_STANDBY = 226;
        public static final int WIN_SETIDLE1 = 227;
        public static final int WIN_READ_BUFFER = 228;
        public static final int WIN_CHECKPOWERMODE1 = 229;
        public static final int WIN_SLEEPNOW1 = 230;
        public static final int WIN_FLUSH_CACHE = 231;
        public static final int WIN_WRITE_BUFFER = 232;
        public static final int WIN_WRITE_SAME = 233;
        public static final int WIN_FLUSH_CACHE_EXT = 234;
        public static final int WIN_IDENTIFY = 236;
        public static final int WIN_MEDIAEJECT = 237;
        public static final int WIN_IDENTIFY_DMA = 238;
        public static final int WIN_SETFEATURES = 239;
        public static final int EXABYTE_ENABLE_NEST = 240;
        public static final int WIN_SECURITY_SET_PASS = 241;
        public static final int WIN_SECURITY_UNLOCK = 242;
        public static final int WIN_SECURITY_ERASE_PREPARE = 243;
        public static final int WIN_SECURITY_ERASE_UNIT = 244;
        public static final int WIN_SECURITY_FREEZE_LOCK = 245;
        public static final int WIN_SECURITY_DISABLE = 246;
        public static final int WIN_READ_NATIVE_MAX = 248;
        public static final int WIN_SET_MAX = 249;
        public static final int DISABLE_SEAGATE = 251;
        public static final int MAX_MULT_SECTORS = 16;
        public static final int ATAPI_PACKET_SIZE = 12;
        public static final int GPCMD_BLANK = 161;
        public static final int GPCMD_CLOSE_TRACK = 91;
        public static final int GPCMD_FLUSH_CACHE = 53;
        public static final int GPCMD_FORMAT_UNIT = 4;
        public static final int GPCMD_GET_CONFIGURATION = 70;
        public static final int GPCMD_GET_EVENT_STATUS_NOTIFICATION = 74;
        public static final int GPCMD_GET_PERFORMANCE = 172;
        public static final int GPCMD_INQUIRY = 18;
        public static final int GPCMD_LOAD_UNLOAD = 166;
        public static final int GPCMD_MECHANISM_STATUS = 189;
        public static final int GPCMD_MODE_SELECT_10 = 85;
        public static final int GPCMD_MODE_SENSE_10 = 90;
        public static final int GPCMD_PAUSE_RESUME = 75;
        public static final int GPCMD_PLAY_AUDIO_10 = 69;
        public static final int GPCMD_PLAY_AUDIO_MSF = 71;
        public static final int GPCMD_PLAY_AUDIO_TI = 72;
        public static final int GPCMD_PLAY_CD = 188;
        public static final int GPCMD_PREVENT_ALLOW_MEDIUM_REMOVAL = 30;
        public static final int GPCMD_READ_10 = 40;
        public static final int GPCMD_READ_12 = 168;
        public static final int GPCMD_READ_CDVD_CAPACITY = 37;
        public static final int GPCMD_READ_CD = 190;
        public static final int GPCMD_READ_CD_MSF = 185;
        public static final int GPCMD_READ_DISC_INFO = 81;
        public static final int GPCMD_READ_DVD_STRUCTURE = 173;
        public static final int GPCMD_READ_FORMAT_CAPACITIES = 35;
        public static final int GPCMD_READ_HEADER = 68;
        public static final int GPCMD_READ_TRACK_RZONE_INFO = 82;
        public static final int GPCMD_READ_SUBCHANNEL = 66;
        public static final int GPCMD_READ_TOC_PMA_ATIP = 67;
        public static final int GPCMD_REPAIR_RZONE_TRACK = 88;
        public static final int GPCMD_REPORT_KEY = 164;
        public static final int GPCMD_REQUEST_SENSE = 3;
        public static final int GPCMD_RESERVE_RZONE_TRACK = 83;
        public static final int GPCMD_SCAN = 186;
        public static final int GPCMD_SEEK = 43;
        public static final int GPCMD_SEND_DVD_STRUCTURE = 173;
        public static final int GPCMD_SEND_EVENT = 162;
        public static final int GPCMD_SEND_KEY = 163;
        public static final int GPCMD_SEND_OPC = 84;
        public static final int GPCMD_SET_READ_AHEAD = 167;
        public static final int GPCMD_SET_STREAMING = 182;
        public static final int GPCMD_START_STOP_UNIT = 27;
        public static final int GPCMD_STOP_PLAY_SCAN = 78;
        public static final int GPCMD_TEST_UNIT_READY = 0;
        public static final int GPCMD_VERIFY_10 = 47;
        public static final int GPCMD_WRITE_10 = 42;
        public static final int GPCMD_WRITE_AND_VERIFY_10 = 46;
        public static final int GPCMD_SET_SPEED = 187;
        public static final int GPCMD_PLAYAUDIO_TI = 72;
        public static final int GPCMD_GET_MEDIA_STATUS = 218;
        public static final int GPMODE_R_W_ERROR_PAGE = 1;
        public static final int GPMODE_WRITE_PARMS_PAGE = 5;
        public static final int GPMODE_AUDIO_CTL_PAGE = 14;
        public static final int GPMODE_POWER_PAGE = 26;
        public static final int GPMODE_FAULT_FAIL_PAGE = 28;
        public static final int GPMODE_TO_PROTECT_PAGE = 29;
        public static final int GPMODE_CAPABILITIES_PAGE = 42;
        public static final int GPMODE_ALL_PAGES = 63;
        public static final int GPMODE_CDROM_PAGE = 13;
        public static final int ATAPI_INT_REASON_CD = 1;
        public static final int ATAPI_INT_REASON_IO = 2;
        public static final int ATAPI_INT_REASON_REL = 4;
        public static final int ATAPI_INT_REASON_TAG = 248;
        public static final int ASC_ILLEGAL_OPCODE = 32;
        public static final int ASC_LOGICAL_BLOCK_OOR = 33;
        public static final int ASC_INV_FIELD_IN_CMD_PACKET = 36;
        public static final int ASC_MEDIUM_NOT_PRESENT = 58;
        public static final int ASC_SAVING_PARAMETERS_NOT_SUPPORTED = 57;
        public static final int SENSE_NONE = 0;
        public static final int SENSE_NOT_READY = 2;
        public static final int SENSE_ILLEGAL_REQUEST = 5;
        public static final int SENSE_UNIT_ATTENTION = 6;
        public static final int ETF_TRANSFER_STOP = 1;
        public static final int ETF_SECTOR_WRITE = 2;
        public static final int ETF_SECTOR_READ = 3;
        public static final int ETF_ATAPI_COMMAND = 4;
        public static final int ETF_ATAPI_COMMAND_REPLY_END = 5;
        public static final int ETF_DUMMY_TRANSFER_STOP = 6;
        public static final int IDF_NONE = 0;
        public static final int IDF_WRITE_DMA_CB = 1;
        public static final int IDF_READ_DMA_CB = 2;
        public static final int IDF_ATAPI_READ_DMA_CB = 3;
        public static final String HD_VERSION = "0.01";
        private int cylinders;
        private int heads;
        private int sectors;
        public byte status;
        public byte command;
        public byte error;
        public byte feature;
        public byte select;
        public byte hcyl;
        public byte lcyl;
        public byte sector;
        public int nSector;
        public int endTransferFunction;
        public boolean isCDROM;
        public boolean atapiDMA;
        public int requiredNumberOfSectors;
        public int multSectors;
        public int driveSerial;
        public byte hobFeature;
        public byte hobNSector;
        public byte hobSector;
        public byte hobLCyl;
        public byte hobHCyl;
        public boolean lba48;
        public byte[] ioBuffer;
        private int ioBufferSize;
        private int ioBufferIndex;
        public byte[] dataBuffer;
        public int dataBufferOffset;
        public int dataBufferEnd;
        public boolean identifySet;
        public byte[] identifyData;
        public byte senseKey;
        public byte asc;
        public int elementaryTransferSize;
        public int packetTransferSize;
        public int lba;
        public int cdSectorSize;
        public BlockDevice drive;
        public BMDMAIORegion bmdma;
        private IDEChannel upperBackref;

        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            sRDumper.dumpInt(this.cylinders);
            sRDumper.dumpInt(this.heads);
            sRDumper.dumpInt(this.sectors);
            sRDumper.dumpByte(this.status);
            sRDumper.dumpByte(this.command);
            sRDumper.dumpByte(this.error);
            sRDumper.dumpByte(this.feature);
            sRDumper.dumpByte(this.select);
            sRDumper.dumpByte(this.hcyl);
            sRDumper.dumpByte(this.lcyl);
            sRDumper.dumpByte(this.sector);
            sRDumper.dumpInt(this.nSector);
            sRDumper.dumpInt(this.endTransferFunction);
            sRDumper.dumpBoolean(this.isCDROM);
            sRDumper.dumpBoolean(this.atapiDMA);
            sRDumper.dumpInt(this.requiredNumberOfSectors);
            sRDumper.dumpInt(this.multSectors);
            sRDumper.dumpInt(this.driveSerial);
            sRDumper.dumpByte(this.hobFeature);
            sRDumper.dumpByte(this.hobNSector);
            sRDumper.dumpByte(this.hobSector);
            sRDumper.dumpByte(this.hobLCyl);
            sRDumper.dumpByte(this.hobHCyl);
            sRDumper.dumpBoolean(this.lba48);
            sRDumper.dumpArray(this.ioBuffer);
            sRDumper.dumpInt(this.ioBufferSize);
            sRDumper.dumpInt(this.ioBufferIndex);
            sRDumper.dumpArray(this.dataBuffer);
            sRDumper.dumpInt(this.dataBufferOffset);
            sRDumper.dumpInt(this.dataBufferEnd);
            sRDumper.dumpBoolean(this.identifySet);
            sRDumper.dumpArray(this.identifyData);
            sRDumper.dumpByte(this.senseKey);
            sRDumper.dumpByte(this.asc);
            sRDumper.dumpInt(this.elementaryTransferSize);
            sRDumper.dumpInt(this.packetTransferSize);
            sRDumper.dumpInt(this.lba);
            sRDumper.dumpInt(this.cdSectorSize);
            sRDumper.dumpObject(this.drive);
            sRDumper.dumpObject(this.bmdma);
            sRDumper.dumpObject(this.upperBackref);
        }

        public IDEState(SRLoader sRLoader) throws IOException {
            sRLoader.objectCreated(this);
            this.cylinders = sRLoader.loadInt();
            this.heads = sRLoader.loadInt();
            this.sectors = sRLoader.loadInt();
            this.status = sRLoader.loadByte();
            this.command = sRLoader.loadByte();
            this.error = sRLoader.loadByte();
            this.feature = sRLoader.loadByte();
            this.select = sRLoader.loadByte();
            this.hcyl = sRLoader.loadByte();
            this.lcyl = sRLoader.loadByte();
            this.sector = sRLoader.loadByte();
            this.nSector = sRLoader.loadInt();
            this.endTransferFunction = sRLoader.loadInt();
            this.isCDROM = sRLoader.loadBoolean();
            this.atapiDMA = sRLoader.loadBoolean();
            this.requiredNumberOfSectors = sRLoader.loadInt();
            this.multSectors = sRLoader.loadInt();
            this.driveSerial = sRLoader.loadInt();
            this.hobFeature = sRLoader.loadByte();
            this.hobNSector = sRLoader.loadByte();
            this.hobSector = sRLoader.loadByte();
            this.hobLCyl = sRLoader.loadByte();
            this.hobHCyl = sRLoader.loadByte();
            this.lba48 = sRLoader.loadBoolean();
            this.ioBuffer = sRLoader.loadArrayByte();
            this.ioBufferSize = sRLoader.loadInt();
            this.ioBufferIndex = sRLoader.loadInt();
            this.dataBuffer = sRLoader.loadArrayByte();
            this.dataBufferOffset = sRLoader.loadInt();
            this.dataBufferEnd = sRLoader.loadInt();
            this.identifySet = sRLoader.loadBoolean();
            this.identifyData = sRLoader.loadArrayByte();
            this.senseKey = sRLoader.loadByte();
            this.asc = sRLoader.loadByte();
            this.elementaryTransferSize = sRLoader.loadInt();
            this.packetTransferSize = sRLoader.loadInt();
            this.lba = sRLoader.loadInt();
            this.cdSectorSize = sRLoader.loadInt();
            this.drive = (BlockDevice)sRLoader.loadObject();
            this.bmdma = (BMDMAIORegion)sRLoader.loadObject();
            this.upperBackref = (IDEChannel)sRLoader.loadObject();
        }

        public void dumpStatusPartial(StatusDumper statusDumper) {
            statusDumper.println("\tupperBackref <object #" + statusDumper.objectNumber(this.upperBackref) + ">");
            if (this.upperBackref != null) {
                this.upperBackref.dumpStatus(statusDumper);
            }
            statusDumper.println("\tcylinders " + this.cylinders + " heads " + this.heads + " sectors " + this.sectors);
            statusDumper.println("\tstatus " + this.status + " command " + this.command + " error " + this.error + " select " + this.select);
            statusDumper.println("\thcyl " + this.hcyl + " lcyl " + this.lcyl + " sector " + this.sector + " nSector " + this.nSector);
            statusDumper.println("\tendTransferFunction " + this.endTransferFunction + " isCDROM " + this.isCDROM);
            statusDumper.println("\tatapiDMA " + this.atapiDMA + " requiredNumberOfSectors " + this.requiredNumberOfSectors);
            statusDumper.println("\tmultSectors " + this.multSectors + " driveSerial " + this.driveSerial);
            statusDumper.println("\thobFeature " + this.hobFeature + " hobSector " + this.hobSector + " feature " + this.feature);
            statusDumper.println("\thobLCyl " + this.hobLCyl + " hobHCyl " + this.hobHCyl + " hobNSector " + this.hobNSector);
            statusDumper.println("\tlba48 " + this.lba48 + " ioBufferSize " + this.ioBufferSize + " ioBufferIndex " + this.ioBufferIndex);
            statusDumper.println("\tdataBufferOffset " + this.dataBufferOffset + " dataBufferEnd " + this.dataBufferEnd);
            statusDumper.println("\tidentifySet " + this.identifySet + " senseKey " + this.senseKey);
            statusDumper.println("\tasc " + this.asc + " elementaryTransferSize " + this.elementaryTransferSize);
            statusDumper.println("\tpacketTransferSize " + this.packetTransferSize + " lba " + this.lba);
            statusDumper.println("\tcdSectorSize " + this.cdSectorSize);
            statusDumper.println("\tdrive <object #" + statusDumper.objectNumber(this.drive) + ">");
            if (this.drive != null) {
                this.drive.dumpStatus(statusDumper);
            }
            statusDumper.println("\tbmdma <object #" + statusDumper.objectNumber(this.bmdma) + ">");
            if (this.bmdma != null) {
                this.bmdma.dumpStatus(statusDumper);
            }
            statusDumper.printArray(this.ioBuffer, "ioBuffer");
            statusDumper.printArray(this.dataBuffer, "dataBuffer");
            statusDumper.printArray(this.identifyData, "identifyData");
        }

        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": IDEState:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        public IDEState(IDEChannel iDEChannel, BlockDevice blockDevice) {
            this.upperBackref = iDEChannel;
            this.drive = blockDevice;
            if (blockDevice != null) {
                this.cylinders = blockDevice.getCylinders();
                this.heads = blockDevice.getHeads();
                this.sectors = blockDevice.getSectors();
                if (blockDevice.getType() == BlockDevice.Type.CDROM) {
                    this.isCDROM = true;
                }
            }
            this.ioBuffer = new byte[8196];
            this.identifyData = new byte[512];
            this.identifySet = false;
            this.lba48 = false;
            this.driveSerial = this.upperBackref.nextDriveSerial++;
            this.reset();
        }

        public void setDrive(BlockDevice blockDevice) {
            this.drive = blockDevice;
        }

        public int dmaCallback(int n, int n2, int n3) {
            switch (n) {
                case 3: {
                    return this.atapiCommandReadDMACallback(n2, n3);
                }
            }
            System.err.println("Warning: Need DMA callback function " + n + ".");
            return 0;
        }

        public void setSignature() {
            this.select = (byte)(this.select & 0xF0);
            this.nSector = 1;
            this.sector = 1;
            if (this.isCDROM) {
                this.lcyl = (byte)20;
                this.hcyl = (byte)-21;
            } else if (this.drive != null) {
                this.lcyl = 0;
                this.hcyl = 0;
            } else {
                this.lcyl = (byte)-1;
                this.hcyl = (byte)-1;
            }
        }

        public void setIRQ() {
            if ((this.command & 2) == 0) {
                if (this.bmdma != null) {
                    this.bmdma.setIRQ();
                }
                this.upperBackref.irqDevice.setIRQ(this.upperBackref.irq, 1);
            }
        }

        public void abortCommand() {
            this.status = (byte)65;
            this.error = (byte)4;
        }

        public void atapiIdentify() {
            if (this.identifySet) {
                System.arraycopy(this.identifyData, 0, this.ioBuffer, 0, this.identifyData.length);
                return;
            }
            for (int i = 0; i < 512; ++i) {
                this.ioBuffer[i] = 0;
            }
            IDEChannel.putLE16InByte(this.ioBuffer, 0, 34240);
            IDEChannel.stringToBytes("JPC" + this.driveSerial, this.ioBuffer, 20, 20);
            IDEChannel.putLE16InByte(this.ioBuffer, 40, 3);
            IDEChannel.putLE16InByte(this.ioBuffer, 42, 512);
            IDEChannel.putLE16InByte(this.ioBuffer, 44, 4);
            IDEChannel.stringToBytes(HD_VERSION, this.ioBuffer, 46, 8);
            IDEChannel.stringToBytes("JPC CD-ROM", this.ioBuffer, 54, 40);
            IDEChannel.putLE16InByte(this.ioBuffer, 96, 1);
            IDEChannel.putLE16InByte(this.ioBuffer, 98, 512);
            IDEChannel.putLE16InByte(this.ioBuffer, 106, 3);
            IDEChannel.putLE16InByte(this.ioBuffer, 126, 259);
            IDEChannel.putLE16InByte(this.ioBuffer, 128, 1);
            IDEChannel.putLE16InByte(this.ioBuffer, 130, 180);
            IDEChannel.putLE16InByte(this.ioBuffer, 132, 180);
            IDEChannel.putLE16InByte(this.ioBuffer, 134, 300);
            IDEChannel.putLE16InByte(this.ioBuffer, 136, 180);
            IDEChannel.putLE16InByte(this.ioBuffer, 142, 30);
            IDEChannel.putLE16InByte(this.ioBuffer, 144, 30);
            IDEChannel.putLE16InByte(this.ioBuffer, 160, 30);
            System.arraycopy(this.ioBuffer, 0, this.identifyData, 0, this.identifyData.length);
            this.identifySet = true;
        }

        public void setSector(long l) {
            if ((this.select & 0x40) != 0) {
                if (!this.lba48) {
                    this.select = (byte)((long)(this.select & 0xF0) | l >>> 24);
                    this.hcyl = (byte)(l >>> 16);
                    this.lcyl = (byte)(l >>> 8);
                    this.sector = (byte)l;
                } else {
                    this.sector = (byte)l;
                    this.lcyl = (byte)(l >>> 8);
                    this.hcyl = (byte)(l >>> 16);
                    this.hobSector = (byte)(l >>> 24);
                    this.hobLCyl = (byte)(l >>> 32);
                    this.hobHCyl = (byte)(l >>> 40);
                }
            } else {
                int n = (int)(l / (long)(this.heads * this.sectors));
                int n2 = (int)(l % (long)(this.heads * this.sectors));
                this.hcyl = (byte)(n >>> 8);
                this.lcyl = (byte)n;
                this.select = (byte)(this.select & 0xF0 | n2 / this.sectors & 0xF);
                this.sector = (byte)(n2 % this.sectors + 1);
            }
        }

        public void sectorWriteDMA() {
            this.status = (byte)88;
            int n = this.nSector;
            if (n > 16) {
                n = 16;
            }
            this.ioBufferIndex = 0;
            this.ioBufferSize = n * 512;
            this.dmaStart(1);
        }

        public void sectorReadDMA() {
            this.status = (byte)88;
            this.ioBufferIndex = 0;
            this.ioBufferSize = 0;
            this.dmaStart(2);
        }

        public void sectorWrite() {
            this.status = (byte)80;
            long l = this.getSector();
            int n = this.nSector;
            if (n > this.requiredNumberOfSectors) {
                n = this.requiredNumberOfSectors;
            }
            this.drive.write(l, this.ioBuffer, n);
            this.nSector -= n;
            if (this.nSector == 0) {
                this.transferStop();
            } else {
                int n2 = this.nSector;
                if (n2 > this.requiredNumberOfSectors) {
                    n2 = this.requiredNumberOfSectors;
                }
                this.transferStart(this.ioBuffer, 0, 512 * n2, 2);
            }
            this.setSector(l + (long)n);
            this.setIRQ();
        }

        public void sectorRead() {
            this.status = (byte)80;
            this.error = 0;
            long l = this.getSector();
            int n = this.nSector;
            if (n == 0) {
                this.transferStop();
            } else {
                n = Math.min(n, this.requiredNumberOfSectors);
                this.drive.read(l, this.ioBuffer, n);
                this.transferStart(this.ioBuffer, 0, 512 * n, 3);
                this.setIRQ();
                this.setSector(l + (long)n);
                this.nSector -= n;
            }
        }

        public void identify() {
            int n;
            if (this.identifySet) {
                System.arraycopy(this.identifyData, 0, this.ioBuffer, 0, this.identifyData.length);
                return;
            }
            for (n = 0; n < 512; ++n) {
                this.ioBuffer[n] = 0;
            }
            IDEChannel.putLE16InByte(this.ioBuffer, 0, 64);
            IDEChannel.putLE16InByte(this.ioBuffer, 2, this.cylinders);
            IDEChannel.putLE16InByte(this.ioBuffer, 6, this.heads);
            IDEChannel.putLE16InByte(this.ioBuffer, 8, 512 * this.sectors);
            IDEChannel.putLE16InByte(this.ioBuffer, 10, 512);
            IDEChannel.putLE16InByte(this.ioBuffer, 12, this.sectors);
            IDEChannel.stringToBytes("JPC" + this.driveSerial, this.ioBuffer, 20, 20);
            IDEChannel.putLE16InByte(this.ioBuffer, 40, 3);
            IDEChannel.putLE16InByte(this.ioBuffer, 42, 512);
            IDEChannel.putLE16InByte(this.ioBuffer, 44, 4);
            IDEChannel.stringToBytes(HD_VERSION, this.ioBuffer, 46, 8);
            IDEChannel.stringToBytes("JPC HARDDISK", this.ioBuffer, 54, 40);
            IDEChannel.putLE16InByte(this.ioBuffer, 94, 32784);
            IDEChannel.putLE16InByte(this.ioBuffer, 96, 1);
            IDEChannel.putLE16InByte(this.ioBuffer, 98, 2816);
            IDEChannel.putLE16InByte(this.ioBuffer, 102, 512);
            IDEChannel.putLE16InByte(this.ioBuffer, 104, 512);
            IDEChannel.putLE16InByte(this.ioBuffer, 106, 7);
            IDEChannel.putLE16InByte(this.ioBuffer, 108, this.cylinders);
            IDEChannel.putLE16InByte(this.ioBuffer, 110, this.heads);
            IDEChannel.putLE16InByte(this.ioBuffer, 112, this.sectors);
            n = this.cylinders * this.heads * this.sectors;
            IDEChannel.putLE16InByte(this.ioBuffer, 114, n);
            IDEChannel.putLE16InByte(this.ioBuffer, 116, n >>> 16);
            if (this.multSectors != 0) {
                IDEChannel.putLE16InByte(this.ioBuffer, 118, 0x100 | this.multSectors);
            }
            IDEChannel.putLE16InByte(this.ioBuffer, 120, (short)this.drive.getTotalSectors());
            IDEChannel.putLE16InByte(this.ioBuffer, 122, (short)(this.drive.getTotalSectors() >>> 16));
            IDEChannel.putLE16InByte(this.ioBuffer, 126, 7);
            IDEChannel.putLE16InByte(this.ioBuffer, 130, 120);
            IDEChannel.putLE16InByte(this.ioBuffer, 132, 120);
            IDEChannel.putLE16InByte(this.ioBuffer, 134, 120);
            IDEChannel.putLE16InByte(this.ioBuffer, 136, 120);
            IDEChannel.putLE16InByte(this.ioBuffer, 160, 240);
            IDEChannel.putLE16InByte(this.ioBuffer, 162, 22);
            IDEChannel.putLE16InByte(this.ioBuffer, 164, 16384);
            IDEChannel.putLE16InByte(this.ioBuffer, 166, 28672);
            IDEChannel.putLE16InByte(this.ioBuffer, 168, 16384);
            IDEChannel.putLE16InByte(this.ioBuffer, 170, 16384);
            IDEChannel.putLE16InByte(this.ioBuffer, 172, 28672);
            IDEChannel.putLE16InByte(this.ioBuffer, 174, 16384);
            IDEChannel.putLE16InByte(this.ioBuffer, 176, 8255);
            IDEChannel.putLE16InByte(this.ioBuffer, 186, 24577);
            IDEChannel.putLE16InByte(this.ioBuffer, 200, this.nSector);
            IDEChannel.putLE16InByte(this.ioBuffer, 202, this.nSector >>> 16);
            IDEChannel.putLE16InByte(this.ioBuffer, 204, 0);
            IDEChannel.putLE16InByte(this.ioBuffer, 206, 0);
            System.arraycopy(this.ioBuffer, 0, this.identifyData, 0, this.identifyData.length);
            this.identifySet = true;
        }

        public void transferStart(byte[] byArray, int n, int n2, int n3) {
            this.endTransferFunction = n3;
            this.dataBuffer = byArray;
            this.dataBufferOffset = n;
            this.dataBufferEnd = n2 + n;
            this.status = (byte)(this.status | 8);
        }

        private void transferStop() {
            this.endTransferFunction = 1;
            this.dataBuffer = this.ioBuffer;
            this.dataBufferEnd = 0;
            this.dataBufferOffset = 0;
            this.status = (byte)(this.status & 0xFFFFFFF7);
        }

        private void commandLBA48Transform(boolean bl) {
            this.lba48 = bl;
            if (!this.lba48) {
                if (this.nSector == 0) {
                    this.nSector = 256;
                }
            } else if (this.nSector == 0 && this.hobNSector == 0) {
                this.nSector = 65536;
            } else {
                int n = 0xFF & this.nSector;
                int n2 = 0xFF & this.hobNSector;
                this.nSector = n2 << 8 | n;
            }
        }

        private long getSector() {
            if ((this.select & 0x40) != 0) {
                if (!this.lba48) {
                    return ((long)this.select & 0xFL) << 24 | (0xFFL & (long)this.hcyl) << 16 | (0xFFL & (long)this.lcyl) << 8 | 0xFFL & (long)this.sector;
                }
                return (0xFFL & (long)this.hobHCyl) << 40 | (0xFFL & (long)this.hobLCyl) << 32 | (0xFFL & (long)this.hobSector) << 24 | (0xFFL & (long)this.hcyl) << 16 | (0xFFL & (long)this.lcyl) << 16 | 0xFFL & (long)this.sector;
            }
            return ((0xFFL & (long)this.hcyl) << 8 | 0xFFL & (long)this.lcyl) * (long)this.heads * (long)this.sectors + ((long)this.select & 0xFL) * (long)this.sectors + ((0xFFL & (long)this.sector) - 1L);
        }

        private void dmaStart(int n) {
            if (this.bmdma == null) {
                return;
            }
            this.bmdma.setIDEDevice(this);
            this.bmdma.setDMAFunction(n);
            if ((this.bmdma.getStatus() & 1) != 0) {
                this.bmdma.ideDMALoop();
            }
        }

        public void endTransfer(int n) {
            switch (n) {
                case 1: {
                    this.transferStop();
                    break;
                }
                case 2: {
                    this.sectorWrite();
                    break;
                }
                case 3: {
                    this.sectorRead();
                    break;
                }
                case 4: {
                    this.atapiCommand();
                    break;
                }
                case 5: {
                    this.atapiCommandReplyEnd();
                    break;
                }
                case 6: {
                    this.dummyTransferStop();
                }
            }
        }

        public void reset() {
            this.multSectors = 16;
            this.select = (byte)-96;
            this.status = (byte)64;
            this.setSignature();
            this.endTransferFunction = 6;
            this.endTransfer(6);
        }

        private void atapiCommand() {
            block0 : switch (0xFF & this.ioBuffer[0]) {
                case 0: {
                    if (this.drive.isInserted()) {
                        this.atapiCommandOk();
                        break;
                    }
                    this.atapiCommandError(2, 58);
                    break;
                }
                case 90: {
                    short s = IDEChannel.bigEndianBytesToShort(this.ioBuffer, 7);
                    int n = (0xFF & this.ioBuffer[2]) >>> 6;
                    int n2 = this.ioBuffer[2] & 0x3F;
                    switch (n) {
                        case 0: {
                            switch (n2) {
                                case 1: {
                                    IDEChannel.shortToBigEndianBytes(this.ioBuffer, 0, (short)22);
                                    this.ioBuffer[2] = 112;
                                    this.ioBuffer[3] = 0;
                                    this.ioBuffer[4] = 0;
                                    this.ioBuffer[5] = 0;
                                    this.ioBuffer[6] = 0;
                                    this.ioBuffer[7] = 0;
                                    this.ioBuffer[8] = 1;
                                    this.ioBuffer[9] = 6;
                                    this.ioBuffer[10] = 0;
                                    this.ioBuffer[11] = 5;
                                    this.ioBuffer[12] = 0;
                                    this.ioBuffer[13] = 0;
                                    this.ioBuffer[14] = 0;
                                    this.ioBuffer[15] = 0;
                                    this.atapiCommandReply(16, s);
                                    break block0;
                                }
                                case 42: {
                                    IDEChannel.shortToBigEndianBytes(this.ioBuffer, 0, (short)34);
                                    this.ioBuffer[2] = 112;
                                    this.ioBuffer[3] = 0;
                                    this.ioBuffer[4] = 0;
                                    this.ioBuffer[5] = 0;
                                    this.ioBuffer[6] = 0;
                                    this.ioBuffer[7] = 0;
                                    this.ioBuffer[8] = 42;
                                    this.ioBuffer[9] = 18;
                                    this.ioBuffer[10] = 0;
                                    this.ioBuffer[11] = 0;
                                    this.ioBuffer[12] = 112;
                                    this.ioBuffer[13] = 96;
                                    this.ioBuffer[14] = 41;
                                    if (this.drive.isLocked()) {
                                        this.ioBuffer[6] = (byte)(this.ioBuffer[6] | 2);
                                    }
                                    this.ioBuffer[15] = 0;
                                    IDEChannel.shortToBigEndianBytes(this.ioBuffer, 16, (short)706);
                                    this.ioBuffer[18] = 0;
                                    this.ioBuffer[19] = 2;
                                    IDEChannel.shortToBigEndianBytes(this.ioBuffer, 20, (short)512);
                                    IDEChannel.shortToBigEndianBytes(this.ioBuffer, 22, (short)706);
                                    this.ioBuffer[24] = 0;
                                    this.ioBuffer[25] = 0;
                                    this.ioBuffer[26] = 0;
                                    this.ioBuffer[27] = 0;
                                    this.atapiCommandReply(28, s);
                                    break block0;
                                }
                            }
                            this.atapiCommandError(5, 36);
                            break block0;
                        }
                        case 1: {
                            this.atapiCommandError(5, 36);
                            break block0;
                        }
                        case 2: {
                            this.atapiCommandError(5, 36);
                            break block0;
                        }
                    }
                    this.atapiCommandError(5, 57);
                    break;
                }
                case 3: {
                    int n = 0xFF & this.ioBuffer[4];
                    for (int i = 0; i < 18; ++i) {
                        this.ioBuffer[i] = 0;
                    }
                    this.ioBuffer[0] = -16;
                    this.ioBuffer[2] = this.senseKey;
                    this.ioBuffer[7] = 10;
                    this.ioBuffer[12] = this.asc;
                    this.atapiCommandReply(18, n);
                    break;
                }
                case 30: {
                    if (this.drive.isInserted()) {
                        this.drive.setLock((this.ioBuffer[4] & 1) != 0);
                        this.atapiCommandOk();
                        break;
                    }
                    this.atapiCommandError(2, 58);
                    break;
                }
                case 40: 
                case 168: {
                    if (!this.drive.isInserted()) {
                        this.atapiCommandError(2, 58);
                        break;
                    }
                    int n = this.ioBuffer[0] == 40 ? IDEChannel.bigEndianBytesToShort(this.ioBuffer, 7) : IDEChannel.bigEndianBytesToInt(this.ioBuffer, 6);
                    int n3 = IDEChannel.bigEndianBytesToInt(this.ioBuffer, 2);
                    if (n == 0) {
                        this.atapiCommandOk();
                        break;
                    }
                    if ((0xFFFFFFFFL & (long)n3) + (0xFFFFFFFFL & (long)n) << 2 > this.drive.getTotalSectors()) {
                        this.atapiCommandError(5, 33);
                        break;
                    }
                    this.atapiCommandRead(n3, n, 2048);
                    break;
                }
                case 190: {
                    if (!this.drive.isInserted()) {
                        this.atapiCommandError(2, 58);
                        break;
                    }
                    int n = (0xFF & this.ioBuffer[6]) << 16 | (0xFF & this.ioBuffer[7]) << 8 | 0xFF & this.ioBuffer[8];
                    int n4 = IDEChannel.bigEndianBytesToInt(this.ioBuffer, 2);
                    if (n == 0) {
                        this.atapiCommandOk();
                        break;
                    }
                    if ((0xFFFFFFFFL & (long)n4) + (0xFFFFFFFFL & (long)n) << 2 > this.drive.getTotalSectors()) {
                        this.atapiCommandError(5, 33);
                        break;
                    }
                    int n5 = 0xFF & this.ioBuffer[9];
                    switch (n5 & 0xF8) {
                        case 0: {
                            this.atapiCommandOk();
                            break block0;
                        }
                        case 16: {
                            this.atapiCommandRead(n4, n, 2048);
                            break block0;
                        }
                        case 248: {
                            this.atapiCommandRead(n4, n, 2352);
                            break block0;
                        }
                    }
                    this.atapiCommandError(5, 36);
                    break;
                }
                case 43: {
                    if (!this.drive.isInserted()) {
                        this.atapiCommandError(2, 58);
                        break;
                    }
                    int n = IDEChannel.bigEndianBytesToInt(this.ioBuffer, 2);
                    if ((0xFFFFFFFFL & (long)n) << 2 > this.drive.getTotalSectors()) {
                        this.atapiCommandError(5, 33);
                        break;
                    }
                    this.atapiCommandOk();
                    break;
                }
                case 27: {
                    boolean bl;
                    boolean bl2 = (this.ioBuffer[4] & 1) != 0;
                    boolean bl3 = bl = (this.ioBuffer[4] & 2) != 0;
                    if (bl && !bl2) {
                        this.drive.close();
                    }
                    this.atapiCommandOk();
                    break;
                }
                case 189: {
                    short s = IDEChannel.bigEndianBytesToShort(this.ioBuffer, 8);
                    IDEChannel.shortToBigEndianBytes(this.ioBuffer, 0, (short)0);
                    this.ioBuffer[2] = 0;
                    this.ioBuffer[3] = 0;
                    this.ioBuffer[4] = 0;
                    this.ioBuffer[5] = 1;
                    IDEChannel.shortToBigEndianBytes(this.ioBuffer, 6, (short)0);
                    this.atapiCommandReply(8, s);
                    break;
                }
                case 67: {
                    if (!this.drive.isInserted()) {
                        this.atapiCommandError(2, 58);
                        break;
                    }
                    short s = IDEChannel.bigEndianBytesToShort(this.ioBuffer, 7);
                    int n = (0xFF & this.ioBuffer[9]) >>> 6;
                    int n6 = this.ioBuffer[1] >>> 1 & 1;
                    int n7 = 0xFF & this.ioBuffer[6];
                    switch (n) {
                        case 0: {
                            int n8 = this.cdromReadTOC((int)(this.drive.getTotalSectors() >>> 2), this.ioBuffer, n6, n7);
                            if (n8 < 0) {
                                this.atapiCommandError(5, 36);
                                break block0;
                            }
                            this.atapiCommandReply(n8, s);
                            break block0;
                        }
                        case 1: {
                            for (int i = 0; i < 12; ++i) {
                                this.ioBuffer[i] = 0;
                            }
                            this.ioBuffer[1] = 10;
                            this.ioBuffer[2] = 1;
                            this.ioBuffer[3] = 1;
                            this.atapiCommandReply(12, s);
                            break block0;
                        }
                        case 2: {
                            int n9 = this.cdromReadTOCRaw((int)(this.drive.getTotalSectors() >>> 2), this.ioBuffer, n6, n7);
                            if (n9 < 0) {
                                this.atapiCommandError(5, 36);
                                break block0;
                            }
                            this.atapiCommandReply(n9, s);
                            break block0;
                        }
                    }
                    this.atapiCommandError(5, 36);
                    break;
                }
                case 37: {
                    if (!this.drive.isInserted()) {
                        this.atapiCommandError(2, 58);
                        break;
                    }
                    IDEChannel.intToBigEndianBytes(this.ioBuffer, 0, (int)((this.drive.getTotalSectors() >>> 2) - 1L));
                    IDEChannel.intToBigEndianBytes(this.ioBuffer, 4, 2048);
                    this.atapiCommandReply(8, 8);
                    break;
                }
                case 18: {
                    int n;
                    int n10 = 0xFF & this.ioBuffer[4];
                    this.ioBuffer[0] = 5;
                    this.ioBuffer[1] = -128;
                    this.ioBuffer[2] = 0;
                    this.ioBuffer[3] = 33;
                    this.ioBuffer[4] = 31;
                    this.ioBuffer[5] = 0;
                    this.ioBuffer[6] = 0;
                    this.ioBuffer[7] = 0;
                    byte[] byArray = "JPC".getBytes();
                    int n11 = 8;
                    for (n = 0; n < byArray.length; ++n) {
                        this.ioBuffer[n11] = byArray[n];
                        ++n11;
                    }
                    while (n11 < 16) {
                        this.ioBuffer[n11] = 0;
                        ++n11;
                    }
                    byArray = "JPC CD-ROM".getBytes();
                    n11 = 16;
                    for (n = 0; n < byArray.length; ++n) {
                        this.ioBuffer[n11] = byArray[n];
                        ++n11;
                    }
                    while (n11 < 32) {
                        this.ioBuffer[n11] = 0;
                        ++n11;
                    }
                    byArray = "1.0".getBytes();
                    n11 = 32;
                    for (n = 0; n < byArray.length; ++n) {
                        this.ioBuffer[n11] = byArray[n];
                        ++n11;
                    }
                    while (n11 < 36) {
                        this.ioBuffer[n11] = 0;
                        ++n11;
                    }
                    this.atapiCommandReply(36, n10);
                    break;
                }
                default: {
                    this.atapiCommandError(5, 32);
                }
            }
        }

        private void dummyTransferStop() {
            this.dataBuffer = this.ioBuffer;
            this.dataBufferEnd = 0;
            this.ioBuffer[0] = -1;
            this.ioBuffer[1] = -1;
            this.ioBuffer[2] = -1;
            this.ioBuffer[3] = -1;
        }

        private void atapiCommandOk() {
            this.error = 0;
            this.status = (byte)64;
            this.nSector = this.nSector & 0xFFFFFFF8 | 2 | 1;
            this.setIRQ();
        }

        private void atapiCommandError(int n, int n2) {
            this.error = (byte)(this.senseKey << 4);
            this.status = (byte)65;
            this.nSector = this.nSector & 0xFFFFFFF8 | 2 | 1;
            this.senseKey = (byte)n;
            this.asc = (byte)n2;
            this.setIRQ();
        }

        private void atapiCommandReply(int n, int n2) {
            n = Math.min(n, n2);
            this.lba = -1;
            this.packetTransferSize = n;
            this.elementaryTransferSize = 0;
            this.ioBufferIndex = 0;
            this.status = (byte)64;
            this.atapiCommandReplyEnd();
        }

        private void atapiCommandRead(int n, int n2, int n3) {
            if (this.atapiDMA) {
                this.atapiCommandReadDMA(n, n2, n3);
            } else {
                this.atapiCommandReadPIO(n, n2, n3);
            }
        }

        private void atapiCommandReadDMA(int n, int n2, int n3) {
            this.lba = n;
            this.packetTransferSize = n2 * n3;
            this.ioBufferIndex = n3;
            this.cdSectorSize = n3;
            this.status = (byte)72;
            this.dmaStart(3);
        }

        private void atapiCommandReadPIO(int n, int n2, int n3) {
            this.lba = n;
            this.packetTransferSize = n2 * n3;
            this.elementaryTransferSize = 0;
            this.ioBufferIndex = n3;
            this.cdSectorSize = n3;
            this.status = (byte)64;
            this.atapiCommandReplyEnd();
        }

        private void atapiCommandReplyEnd() {
            if (this.packetTransferSize <= 0) {
                this.transferStop();
                this.status = (byte)64;
                this.nSector = this.nSector & 0xFFFFFFF8 | 2 | 1;
                this.setIRQ();
            } else {
                if (this.lba != -1 && this.ioBufferIndex >= this.cdSectorSize) {
                    this.cdReadSector(this.lba, this.ioBuffer, this.cdSectorSize);
                    ++this.lba;
                    this.ioBufferIndex = 0;
                }
                if (this.elementaryTransferSize > 0) {
                    int n = Math.min(this.cdSectorSize - this.ioBufferIndex, this.elementaryTransferSize);
                    this.transferStart(this.ioBuffer, this.ioBufferIndex, n, 5);
                    this.packetTransferSize -= n;
                    this.elementaryTransferSize -= n;
                    this.ioBufferIndex += n;
                } else {
                    int n;
                    this.nSector = this.nSector & 0xFFFFFFF8 | 2;
                    int n2 = 0xFF & this.lcyl | 0xFF00 & this.hcyl << 8;
                    if (n2 == 65535) {
                        --n2;
                    }
                    if ((n = this.packetTransferSize) > n2) {
                        if ((n2 & 1) != 0) {
                            --n2;
                        }
                        n = n2;
                    }
                    this.lcyl = (byte)n;
                    this.hcyl = (byte)(n >>> 8);
                    this.elementaryTransferSize = n;
                    if (this.lba != -1) {
                        n = Math.min(this.cdSectorSize - this.ioBufferIndex, n);
                    }
                    this.transferStart(this.ioBuffer, this.ioBufferIndex, n, 5);
                    this.packetTransferSize -= n;
                    this.elementaryTransferSize -= n;
                    this.ioBufferIndex += n;
                    this.setIRQ();
                }
            }
        }

        private int atapiCommandReadDMACallback(int n, int n2) {
            System.err.println("Informational: CD DMA callback read");
            int n3 = n2;
            while (n2 > 0 && this.packetTransferSize > 0) {
                int n4 = this.cdSectorSize - this.ioBufferIndex;
                if (n4 <= 0) {
                    ++this.lba;
                    this.ioBufferIndex = 0;
                    n4 = this.cdSectorSize;
                }
                if (n4 > n2) {
                    n4 = n2;
                }
                this.cdReadSector(this.lba, this.ioBuffer, n4);
                this.bmdma.writeMemory(n, this.ioBuffer, this.ioBufferIndex, n4);
                this.packetTransferSize -= n4;
                this.ioBufferIndex += n4;
                n2 -= n4;
                n += n4;
            }
            if (this.packetTransferSize <= 0) {
                this.status = (byte)64;
                this.nSector = this.nSector & 0xFFFFFFF8 | 2 | 1;
                this.setIRQ();
                return 0;
            }
            return n3 - n2;
        }

        private int cdromReadTOC(int n, byte[] byArray, int n2, int n3) {
            if (n3 > 1 && n3 != 170) {
                return -1;
            }
            int n4 = 2;
            byArray[n4++] = 1;
            byArray[n4++] = 1;
            if (n3 <= 1) {
                byArray[n4++] = 0;
                byArray[n4++] = 20;
                byArray[n4++] = 1;
                byArray[n4++] = 0;
                if (n2 != 0) {
                    byArray[n4++] = 0;
                    IDEChannel.lbaToMSF(byArray, n4, 0);
                    n4 += 3;
                } else {
                    IDEChannel.intToBigEndianBytes(byArray, n4, 0);
                    n4 += 4;
                }
            }
            byArray[n4++] = 0;
            byArray[n4++] = 22;
            byArray[n4++] = -86;
            byArray[n4++] = 0;
            if (n2 != 0) {
                byArray[n4++] = 0;
                IDEChannel.lbaToMSF(byArray, n4, n);
                n4 += 3;
            } else {
                IDEChannel.intToBigEndianBytes(byArray, n4, n);
                n4 += 4;
            }
            IDEChannel.shortToBigEndianBytes(byArray, n4, (short)(n4 - 2));
            return n4;
        }

        private int cdromReadTOCRaw(int n, byte[] byArray, int n2, int n3) {
            int n4 = 2;
            byArray[n4++] = 1;
            byArray[n4++] = 1;
            byArray[n4++] = 1;
            byArray[n4++] = 20;
            byArray[n4++] = 0;
            byArray[n4++] = -96;
            byArray[n4++] = 0;
            byArray[n4++] = 0;
            byArray[n4++] = 0;
            byArray[n4++] = 0;
            byArray[n4++] = 1;
            byArray[n4++] = 0;
            byArray[n4++] = 0;
            byArray[n4++] = 1;
            byArray[n4++] = 20;
            byArray[n4++] = 0;
            byArray[n4++] = -95;
            byArray[n4++] = 0;
            byArray[n4++] = 0;
            byArray[n4++] = 0;
            byArray[n4++] = 0;
            byArray[n4++] = 1;
            byArray[n4++] = 0;
            byArray[n4++] = 0;
            byArray[n4++] = 1;
            byArray[n4++] = 20;
            byArray[n4++] = 0;
            byArray[n4++] = -94;
            byArray[n4++] = 0;
            byArray[n4++] = 0;
            byArray[n4++] = 0;
            if (n2 != 0) {
                byArray[n4++] = 0;
                IDEChannel.lbaToMSF(byArray, n4, n);
                n4 += 3;
            } else {
                IDEChannel.intToBigEndianBytes(byArray, n4, n);
                n4 += 4;
            }
            byArray[n4++] = 1;
            byArray[n4++] = 20;
            byArray[n4++] = 0;
            byArray[n4++] = 1;
            byArray[n4++] = 0;
            byArray[n4++] = 0;
            byArray[n4++] = 0;
            if (n2 != 0) {
                byArray[n4++] = 0;
                IDEChannel.lbaToMSF(byArray, n4, 0);
                n4 += 3;
            } else {
                byArray[n4++] = 0;
                byArray[n4++] = 0;
                byArray[n4++] = 0;
                byArray[n4++] = 0;
            }
            IDEChannel.shortToBigEndianBytes(byArray, n4, (short)(n4 - 2));
            return n4;
        }

        private void cdReadSector(int n, byte[] byArray, int n2) {
            switch (n2) {
                case 2048: {
                    this.drive.read((0xFFFFFFFFL & (long)n) << 2, byArray, 4);
                    break;
                }
                case 2352: {
                    int n3;
                    this.drive.read((0xFFFFFFFFL & (long)n) << 2, byArray, 4);
                    System.arraycopy(byArray, 0, byArray, 16, 2048);
                    byArray[0] = 0;
                    for (n3 = 1; n3 < 11; ++n3) {
                        byArray[n3] = -1;
                    }
                    byArray[11] = 0;
                    IDEChannel.lbaToMSF(byArray, 12, n);
                    byArray[15] = 1;
                    for (n3 = 2064; n3 < 2352; ++n3) {
                        byArray[n3] = 0;
                    }
                    break;
                }
            }
        }
    }
}

