/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.pci.peripheral;

import java.io.IOException;
import org.jpc.diskimages.BlockDevice;
import org.jpc.emulator.DriveSet;
import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.memory.PhysicalAddressSpace;
import org.jpc.emulator.motherboard.IOPortHandler;
import org.jpc.emulator.motherboard.InterruptController;
import org.jpc.emulator.pci.AbstractPCIDevice;
import org.jpc.emulator.pci.IORegion;
import org.jpc.emulator.pci.PCIBus;
import org.jpc.emulator.pci.PCIDevice;
import org.jpc.emulator.pci.PCIISABridge;
import org.jpc.emulator.pci.peripheral.BMDMAIORegion;
import org.jpc.emulator.pci.peripheral.IDEChannel;

public class PIIX3IDEInterface
extends AbstractPCIDevice {
    private InterruptController irqDevice;
    private IDEChannel[] channels;
    private boolean drivesUpdated;
    private BMDMAIORegion[] bmdmaRegions;
    private BlockDevice[] drives;
    private boolean ioportRegistered;
    private boolean pciRegistered;
    private boolean dmaRegistered;
    private boolean devfnSet;

    @Override
    public void dumpStatusPartial(StatusDumper statusDumper) {
        int n;
        super.dumpStatusPartial(statusDumper);
        statusDumper.println("\tdrivesUpdated " + this.drivesUpdated);
        statusDumper.println("\tirqDevice <object #" + statusDumper.objectNumber(this.irqDevice) + ">");
        if (this.irqDevice != null) {
            this.irqDevice.dumpStatus(statusDumper);
        }
        for (n = 0; n < this.channels.length; ++n) {
            statusDumper.println("\tchannels[" + n + "] <object #" + statusDumper.objectNumber(this.channels[n]) + ">");
            if (this.channels[n] == null) continue;
            this.channels[n].dumpStatus(statusDumper);
        }
        for (n = 0; n < this.bmdmaRegions.length; ++n) {
            statusDumper.println("\tbmdmaRegions[" + n + "] <object #" + statusDumper.objectNumber(this.bmdmaRegions[n]) + ">");
            if (this.bmdmaRegions[n] == null) continue;
            this.bmdmaRegions[n].dumpStatus(statusDumper);
        }
        if (this.drives != null) {
            for (n = 0; n < this.drives.length; ++n) {
                statusDumper.println("\tdrives[" + n + "] <object #" + statusDumper.objectNumber(this.drives[n]) + ">");
                if (this.drives[n] == null) continue;
                this.drives[n].dumpStatus(statusDumper);
            }
        } else {
            statusDumper.println("\tdrives null");
        }
    }

    @Override
    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": PIIX3IDEInterface:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        int n;
        super.dumpSRPartial(sRDumper);
        sRDumper.dumpBoolean(this.drivesUpdated);
        sRDumper.dumpObject(this.irqDevice);
        sRDumper.dumpInt(this.channels.length);
        for (n = 0; n < this.channels.length; ++n) {
            sRDumper.dumpObject(this.channels[n]);
        }
        sRDumper.dumpInt(this.bmdmaRegions.length);
        for (n = 0; n < this.bmdmaRegions.length; ++n) {
            sRDumper.dumpObject(this.bmdmaRegions[n]);
        }
        if (this.drives != null) {
            sRDumper.dumpBoolean(true);
            sRDumper.dumpInt(this.drives.length);
            for (n = 0; n < this.drives.length; ++n) {
                sRDumper.dumpObject(this.drives[n]);
            }
        } else {
            sRDumper.dumpBoolean(false);
        }
    }

    public PIIX3IDEInterface(SRLoader sRLoader) throws IOException {
        super(sRLoader);
        int n;
        this.drivesUpdated = sRLoader.loadBoolean();
        this.irqDevice = (InterruptController)sRLoader.loadObject();
        this.channels = new IDEChannel[sRLoader.loadInt()];
        for (n = 0; n < this.channels.length; ++n) {
            this.channels[n] = (IDEChannel)sRLoader.loadObject();
        }
        this.bmdmaRegions = new BMDMAIORegion[sRLoader.loadInt()];
        for (n = 0; n < this.bmdmaRegions.length; ++n) {
            this.bmdmaRegions[n] = (BMDMAIORegion)sRLoader.loadObject();
        }
        n = sRLoader.loadBoolean() ? 1 : 0;
        if (n != 0) {
            this.drives = new BlockDevice[sRLoader.loadInt()];
            for (int i = 0; i < this.drives.length; ++i) {
                this.drives[i] = (BlockDevice)sRLoader.loadObject();
            }
        } else {
            this.drives = null;
        }
    }

    public PIIX3IDEInterface() {
        this.devfnSet = false;
        this.ioportRegistered = false;
        this.pciRegistered = false;
        this.dmaRegistered = false;
        this.assignDeviceFunctionNumber(-1);
        this.putConfigWord(0, (short)-32634);
        this.putConfigWord(2, (short)28688);
        this.putConfigByte(9, (byte)-128);
        this.putConfigWord(10, (short)257);
        this.putConfigByte(14, (byte)0);
        this.channels = new IDEChannel[2];
        this.bmdmaRegions = new BMDMAIORegion[2];
        this.bmdmaRegions[1] = new BMDMAIORegion(null, true);
        this.bmdmaRegions[0] = new BMDMAIORegion(this.bmdmaRegions[1], true);
    }

    @Override
    public boolean autoAssignDeviceFunctionNumber() {
        return false;
    }

    @Override
    public void deassignDeviceFunctionNumber() {
        System.err.println("Warning: PCI device/function number conflict.");
    }

    @Override
    public IORegion[] getIORegions() {
        return new IORegion[]{this.bmdmaRegions[0]};
    }

    @Override
    public IORegion getIORegion(int n) {
        if (n == 4) {
            return this.bmdmaRegions[0];
        }
        return null;
    }

    @Override
    public boolean initialised() {
        return this.ioportRegistered && this.pciRegistered && this.dmaRegistered && this.irqDevice != null && this.drives != null;
    }

    @Override
    public void reset() {
        this.devfnSet = false;
        this.ioportRegistered = false;
        this.pciRegistered = false;
        this.assignDeviceFunctionNumber(-1);
        this.putConfigWord(0, (short)-32634);
        this.putConfigWord(2, (short)28688);
        this.putConfigByte(9, (byte)-128);
        this.putConfigWord(10, (short)257);
        this.putConfigByte(14, (byte)0);
        this.channels = new IDEChannel[2];
        this.dmaRegistered = false;
        this.bmdmaRegions = new BMDMAIORegion[2];
        this.bmdmaRegions[1] = new BMDMAIORegion(null, true);
        this.bmdmaRegions[0] = new BMDMAIORegion(this.bmdmaRegions[1], true);
        this.irqDevice = null;
        this.drives = null;
        super.reset();
    }

    @Override
    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof InterruptController && hardwareComponent.initialised()) {
            this.irqDevice = (InterruptController)hardwareComponent;
        }
        if (hardwareComponent instanceof IOPortHandler && hardwareComponent.initialised() && this.irqDevice != null && this.drives != null) {
            this.channels[0] = new IDEChannel(14, this.irqDevice, 496, 1014, new BlockDevice[]{this.drives[0], this.drives[1]}, this.bmdmaRegions[0]);
            this.channels[1] = new IDEChannel(15, this.irqDevice, 368, 886, new BlockDevice[]{this.drives[2], this.drives[3]}, this.bmdmaRegions[1]);
            ((IOPortHandler)hardwareComponent).registerIOPortCapable(this.channels[0]);
            ((IOPortHandler)hardwareComponent).registerIOPortCapable(this.channels[1]);
            this.ioportRegistered = true;
        }
        if (hardwareComponent instanceof PCIBus && hardwareComponent.initialised() && !this.pciRegistered && this.devfnSet) {
            this.pciRegistered = ((PCIBus)hardwareComponent).registerDevice(this);
        }
        if (hardwareComponent instanceof PCIISABridge && hardwareComponent.initialised()) {
            this.assignDeviceFunctionNumber(((PCIDevice)((Object)hardwareComponent)).getDeviceFunctionNumber() + 1);
            this.devfnSet = true;
        }
        if (hardwareComponent instanceof DriveSet && hardwareComponent.initialised()) {
            this.drives = new BlockDevice[4];
            this.drives[0] = ((DriveSet)hardwareComponent).getHardDrive(0);
            this.drives[1] = ((DriveSet)hardwareComponent).getHardDrive(1);
            this.drives[2] = ((DriveSet)hardwareComponent).getHardDrive(2);
            this.drives[3] = ((DriveSet)hardwareComponent).getHardDrive(3);
        }
        if (hardwareComponent instanceof PhysicalAddressSpace) {
            this.dmaRegistered = true;
            this.bmdmaRegions[0].setAddressSpace((PhysicalAddressSpace)hardwareComponent);
            this.bmdmaRegions[1].setAddressSpace((PhysicalAddressSpace)hardwareComponent);
        }
    }

    public String toString() {
        return "Intel PIIX3 IDE Interface";
    }
}

