/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.processor;

import java.io.IOException;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.memory.AddressSpace;
import org.jpc.emulator.processor.ProcessorException;
import org.jpc.emulator.processor.Segment;

public class DescriptorTableSegment
extends Segment {
    private final int base;
    private final long limit;

    @Override
    public void dumpStatusPartial(StatusDumper statusDumper) {
        super.dumpStatusPartial(statusDumper);
        statusDumper.println("\tbase " + this.base + " limit " + this.limit);
    }

    @Override
    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": DescriptorTableSegment:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        super.dumpSRPartial(sRDumper);
        sRDumper.dumpInt(this.base);
        sRDumper.dumpLong(this.limit);
    }

    public DescriptorTableSegment(SRLoader sRLoader) throws IOException {
        super(sRLoader);
        this.base = sRLoader.loadInt();
        this.limit = sRLoader.loadLong();
    }

    public DescriptorTableSegment(AddressSpace addressSpace, int n, int n2) {
        super(addressSpace, true);
        this.base = n;
        this.limit = 0xFFFFFFFFL & (long)n2;
    }

    @Override
    public int getLimit() {
        return (int)this.limit;
    }

    @Override
    public int getBase() {
        return this.base;
    }

    @Override
    public int getSelector() {
        System.err.println("Critical error: No selector for a descriptor table segment.");
        throw new IllegalStateException("No selector for a descriptor table segment");
    }

    @Override
    public boolean setSelector(int n) {
        System.err.println("Critical error: Can not set selector for a descriptor table segment.");
        throw new IllegalStateException("Cannot set a selector for a descriptor table segment");
    }

    @Override
    public void checkAddress(int n) {
        if ((0xFFFFFFFFL & (long)n) > this.limit) {
            System.err.println("Emulated: Offset beyond end of Descriptor Table Segment: Offset=" + Integer.toHexString(n) + ", limit=" + Long.toHexString(this.limit));
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n, true);
        }
    }

    @Override
    public int translateAddressRead(int n) {
        this.checkAddress(n);
        return this.base + n;
    }

    @Override
    public int translateAddressWrite(int n) {
        this.checkAddress(n);
        return this.base + n;
    }

    @Override
    public int getDPL() {
        System.err.println("Critical error: Descriptor Table Segment getDPL().");
        throw new IllegalStateException("[LG]DTR getDPL(): " + this.getClass().toString());
    }

    @Override
    public int getRPL() {
        System.err.println("Critical error: Descriptor Table Segment getRPL().");
        throw new IllegalStateException("[LG]DTR getRPL(): " + this.getClass().toString());
    }

    @Override
    public void setRPL(int n) {
        System.err.println("Critical error: Descriptor Table Segment setRPL().");
        throw new IllegalStateException("[LG]DTR setDPL(): " + this.getClass().toString());
    }

    @Override
    public boolean getDefaultSizeFlag() {
        System.err.println("Critical error: Descriptor Table Segment getDefaultSizeFlag().");
        throw new IllegalStateException("[LG]DTR getDefaultSizeFlag(): " + this.getClass().toString());
    }

    @Override
    public int getType() {
        System.err.println("Critical error: Descriptor Table Segment getType().");
        throw new IllegalStateException("[LG]DTR getType(): " + this.getClass().toString());
    }

    @Override
    public boolean isPresent() {
        return true;
    }

    @Override
    public boolean isSystem() {
        return true;
    }

    @Override
    public void printState() {
        System.out.println("Descriptor Table Segment");
        System.out.print("base: " + Integer.toHexString(this.base));
        System.out.println("limit: " + Long.toHexString(this.limit));
    }
}

