/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.processor;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jpc.emulator.Clock;
import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.memory.AddressSpace;
import org.jpc.emulator.memory.AlignmentCheckedAddressSpace;
import org.jpc.emulator.memory.LinearAddressSpace;
import org.jpc.emulator.memory.PhysicalAddressSpace;
import org.jpc.emulator.motherboard.IOPortHandler;
import org.jpc.emulator.motherboard.InterruptController;
import org.jpc.emulator.processor.ModeSwitchException;
import org.jpc.emulator.processor.ProcessorException;
import org.jpc.emulator.processor.ProtectedModeSegment;
import org.jpc.emulator.processor.Segment;
import org.jpc.emulator.processor.SegmentFactory;
import org.jpc.emulator.processor.fpu64.FpuState;

public class Processor
implements HardwareComponent {
    public static final int STATE_VERSION = 1;
    public static final int STATE_MINOR_VERSION = 0;
    public int clockDivider;
    public static final int IFLAGS_HARDWARE_INTERRUPT = 1;
    public static final int IFLAGS_PROCESSOR_EXCEPTION = 2;
    public static final int IFLAGS_RESET_REQUEST = 4;
    public static final int IFLAGS_IOPL_MASK = 12288;
    public static final int CR0_PROTECTION_ENABLE = 1;
    public static final int CR0_MONITOR_COPROCESSOR = 2;
    public static final int CR0_FPU_EMULATION = 4;
    public static final int CR0_TASK_SWITCHED = 8;
    public static final int CR0_EXTENSION_TYPE = 16;
    public static final int CR0_NUMERIC_ERROR = 32;
    public static final int CR0_WRITE_PROTECT = 65536;
    public static final int CR0_ALIGNMENT_MASK = 262144;
    public static final int CR0_NOT_WRITETHROUGH = 0x20000000;
    public static final int CR0_CACHE_DISABLE = 0x40000000;
    public static final int CR0_PAGING = Integer.MIN_VALUE;
    public static final int CR3_PAGE_CACHE_DISABLE = 16;
    public static final int CR3_PAGE_WRITES_TRANSPARENT = 8;
    public static final int CR4_VIRTUAL8086_MODE_EXTENSIONS = 1;
    public static final int CR4_PROTECTED_MODE_VIRTUAL_INTERRUPTS = 2;
    public static final int CR4_TIME_STAMP_DISABLE = 4;
    public static final int CR4_DEBUGGING_EXTENSIONS = 8;
    public static final int CR4_PAGE_SIZE_EXTENSIONS = 16;
    public static final int CR4_PHYSICAL_ADDRESS_EXTENSION = 32;
    public static final int CR4_MACHINE_CHECK_ENABLE = 64;
    public static final int CR4_PAGE_GLOBAL_ENABLE = 128;
    public static final int CR4_PERFORMANCE_MONITORING_COUNTER_ENABLE = 256;
    public static final int CR4_OS_SUPPORT_FXSAVE_FXSTORE = 512;
    public static final int CR4_OS_SUPPORT_UNMASKED_SIMD_EXCEPTIONS = 1024;
    public static final int SYSENTER_CS_MSR = 372;
    public static final int SYSENTER_ESP_MSR = 373;
    public static final int SYSENTER_EIP_MSR = 374;
    public long instructionsExecuted;
    public int eax;
    public int ebx;
    public int edx;
    public int ecx;
    public int esi;
    public int edi;
    public int esp;
    public int ebp;
    public int eip;
    private int cr0;
    private int cr1;
    private int cr2;
    private int cr3;
    private int cr4;
    public int dr0;
    public int dr1;
    public int dr2;
    public int dr3;
    public int dr4;
    public int dr5;
    public int dr6;
    public int dr7;
    public Segment cs;
    public Segment ds;
    public Segment ss;
    public Segment es;
    public Segment fs;
    public Segment gs;
    public Segment idtr;
    public Segment gdtr;
    public Segment ldtr;
    public Segment tss;
    public boolean eflagsCarry;
    public boolean eflagsParity;
    public boolean eflagsAuxiliaryCarry;
    public boolean eflagsZero;
    public boolean eflagsSign;
    public boolean eflagsTrap;
    public boolean eflagsInterruptEnable;
    public boolean eflagsDirection;
    public boolean eflagsOverflow;
    public int eflagsIOPrivilegeLevel;
    public boolean eflagsNestedTask;
    public boolean eflagsResume;
    public boolean eflagsVirtual8086Mode;
    public boolean eflagsAlignmentCheck;
    public boolean eflagsVirtualInterrupt;
    public boolean eflagsVirtualInterruptPending;
    public boolean eflagsID;
    public boolean eflagsInterruptEnableSoon;
    public boolean eflagsMachineHalt;
    public boolean eflagsLastAborted;
    public boolean eflagsWaiting;
    public LinearAddressSpace linearMemory;
    public PhysicalAddressSpace physicalMemory;
    public AlignmentCheckedAddressSpace alignmentCheckedMemory;
    public IOPortHandler ioports;
    private volatile int interruptFlags;
    private InterruptController interruptController;
    private boolean alignmentChecking;
    private Map<Integer, Long> modelSpecificRegisters;
    private long resetTime;
    private int currentPrivilegeLevel;
    private boolean started = false;
    private Clock vmClock;
    public boolean SYSFLAG_FLUSHONMODIFY = false;
    public FpuState fpu;
    private long fpuUsedNotPresent;
    private long fpuUsedNotPresentCount;
    private static final long FPU_USED_SILENCE_TIME = 50000L;
    private int auxiliaryCarryOne;
    private int auxiliaryCarryTwo;
    private int auxiliaryCarryThree;
    private boolean auxiliaryCarryCalculated;
    private int auxiliaryCarryMethod;
    public static final int AC_XOR = 1;
    public static final int AC_BIT4_NEQ = 2;
    public static final int AC_LNIBBLE_MAX = 3;
    public static final int AC_LNIBBLE_ZERO = 4;
    public static final int AC_LNIBBLE_NZERO = 5;
    private static final boolean[] parityMap = new boolean[256];
    private int parityOne;
    private boolean parityCalculated;
    private int overflowOne;
    private int overflowTwo;
    private int overflowThree;
    private long overflowLong;
    private boolean overflowCalculated;
    private int overflowMethod;
    public static final int OF_NZ = 1;
    public static final int OF_NOT_BYTE = 2;
    public static final int OF_NOT_SHORT = 3;
    public static final int OF_NOT_INT = 4;
    public static final int OF_LOW_WORD_NZ = 5;
    public static final int OF_HIGH_BYTE_NZ = 6;
    public static final int OF_BIT6_XOR_CARRY = 7;
    public static final int OF_BIT7_XOR_CARRY = 8;
    public static final int OF_BIT14_XOR_CARRY = 9;
    public static final int OF_BIT15_XOR_CARRY = 10;
    public static final int OF_BIT30_XOR_CARRY = 11;
    public static final int OF_BIT31_XOR_CARRY = 12;
    public static final int OF_BIT7_DIFFERENT = 13;
    public static final int OF_BIT15_DIFFERENT = 14;
    public static final int OF_BIT31_DIFFERENT = 15;
    public static final int OF_MAX_BYTE = 16;
    public static final int OF_MAX_SHORT = 17;
    public static final int OF_MAX_INT = 18;
    public static final int OF_MIN_BYTE = 19;
    public static final int OF_MIN_SHORT = 20;
    public static final int OF_MIN_INT = 21;
    public static final int OF_ADD_BYTE = 22;
    public static final int OF_ADD_SHORT = 23;
    public static final int OF_ADD_INT = 24;
    public static final int OF_SUB_BYTE = 25;
    public static final int OF_SUB_SHORT = 26;
    public static final int OF_SUB_INT = 27;
    private int carryOne;
    private int carryTwo;
    private long carryLong;
    private boolean carryCalculated;
    private int carryMethod;
    public static final int CY_NZ = 1;
    public static final int CY_NOT_BYTE = 2;
    public static final int CY_NOT_SHORT = 3;
    public static final int CY_NOT_INT = 4;
    public static final int CY_LOW_WORD_NZ = 5;
    public static final int CY_HIGH_BYTE_NZ = 6;
    public static final int CY_NTH_BIT_SET = 7;
    public static final int CY_GREATER_FF = 8;
    public static final int CY_TWIDDLE_FF = 9;
    public static final int CY_TWIDDLE_FFFF = 10;
    public static final int CY_TWIDDLE_FFFFFFFF = 11;
    public static final int CY_SHL_OUTBIT_BYTE = 12;
    public static final int CY_SHL_OUTBIT_SHORT = 13;
    public static final int CY_SHL_OUTBIT_INT = 14;
    public static final int CY_SHR_OUTBIT = 15;
    public static final int CY_LOWBIT = 16;
    public static final int CY_HIGHBIT_BYTE = 17;
    public static final int CY_HIGHBIT_SHORT = 18;
    public static final int CY_HIGHBIT_INT = 19;
    public static final int CY_OFFENDBIT_BYTE = 20;
    public static final int CY_OFFENDBIT_SHORT = 21;
    public static final int CY_OFFENDBIT_INT = 22;
    private int zeroOne;
    private boolean zeroCalculated;
    private int signOne;
    private boolean signCalculated;

    public Processor(Clock clock, int n) {
        this.vmClock = clock;
        this.clockDivider = n;
        this.fpu = null;
        this.linearMemory = null;
        this.physicalMemory = null;
        this.alignmentCheckedMemory = null;
        this.ioports = null;
        this.alignmentChecking = false;
        this.modelSpecificRegisters = new HashMap<Integer, Long>();
        if (this.fpu != null) {
            this.fpu.init();
            this.cr0 |= 0x10;
        } else {
            this.cr0 |= 4;
        }
    }

    public void setFPU(FpuState fpuState) {
        this.fpu = fpuState;
        if (this.fpu != null) {
            this.fpu.init();
            this.cr0 |= 0x10;
            this.cr0 &= 0xFFFFFFFB;
        } else {
            this.cr0 |= 4;
            this.cr0 &= 0xFFFFFFEF;
        }
    }

    public void printState() {
        System.out.println("********************************");
        System.out.println("CPU State:");
        if (this.isProtectedMode()) {
            if (this.isVirtual8086Mode()) {
                System.out.println("Virtual8086 Mode");
            } else {
                System.out.println("Protected Mode");
            }
        } else {
            System.out.println("Real Mode");
        }
        System.out.println("EAX: " + Integer.toHexString(this.eax));
        System.out.println("EBX: " + Integer.toHexString(this.ebx));
        System.out.println("EDX: " + Integer.toHexString(this.edx));
        System.out.println("ECX: " + Integer.toHexString(this.ecx));
        System.out.println("ESI: " + Integer.toHexString(this.esi));
        System.out.println("EDI: " + Integer.toHexString(this.edi));
        System.out.println("ESP: " + Integer.toHexString(this.esp));
        System.out.println("EBP: " + Integer.toHexString(this.ebp));
        System.out.println("EIP: " + Integer.toHexString(this.eip));
        System.out.println("EFLAGS: " + Integer.toHexString(this.getEFlags()));
        System.out.println("CS selector-base: " + Integer.toHexString(this.cs.getSelector()) + "-" + Integer.toHexString(this.cs.getBase()) + " (" + this.cs.getClass().toString() + ")");
        System.out.println("DS selector-base: " + Integer.toHexString(this.ds.getSelector()) + "-" + Integer.toHexString(this.ds.getBase()) + " (" + this.cs.getClass().toString() + ")");
        System.out.println("ES selector-base: " + Integer.toHexString(this.es.getSelector()) + "-" + Integer.toHexString(this.es.getBase()) + " (" + this.cs.getClass().toString() + ")");
        System.out.println("FS selector-base: " + Integer.toHexString(this.fs.getSelector()) + "-" + Integer.toHexString(this.fs.getBase()) + " (" + this.cs.getClass().toString() + ")");
        System.out.println("GS selector-base: " + Integer.toHexString(this.gs.getSelector()) + "-" + Integer.toHexString(this.gs.getBase()) + " (" + this.cs.getClass().toString() + ")");
        System.out.println("SS selector-base: " + Integer.toHexString(this.ss.getSelector()) + "-" + Integer.toHexString(this.ss.getBase()) + " (" + this.cs.getClass().toString() + ")");
        System.out.println("GDTR base-limit: " + Integer.toHexString(this.gdtr.getBase()) + "-" + Integer.toHexString(this.gdtr.getLimit()) + " (" + this.cs.getClass().toString() + ")");
        System.out.println("IDTR base-limit: " + Integer.toHexString(this.idtr.getBase()) + "-" + Integer.toHexString(this.idtr.getLimit()) + " (" + this.cs.getClass().toString() + ")");
        if (this.ldtr == SegmentFactory.NULL_SEGMENT) {
            System.out.println("Null LDTR");
        } else {
            System.out.println("LDTR base-limit: " + Integer.toHexString(this.ldtr.getBase()) + "-" + Integer.toHexString(this.ldtr.getLimit()) + " (" + this.cs.getClass().toString() + ")");
        }
        if (this.tss == SegmentFactory.NULL_SEGMENT) {
            System.out.println("Null TSS");
        } else {
            System.out.println("TSS selector-base: " + Integer.toHexString(this.tss.getSelector()) + "-" + Integer.toHexString(this.tss.getBase()) + " (" + this.cs.getClass().toString() + ")");
        }
        System.out.println("CR0: " + Integer.toHexString(this.cr0));
        System.out.println("CR1: " + Integer.toHexString(this.cr1));
        System.out.println("CR2: " + Integer.toHexString(this.cr2));
        System.out.println("CR3: " + Integer.toHexString(this.cr3));
        System.out.println("CR4: " + Integer.toHexString(this.cr4));
        System.out.println("Executed: " + this.instructionsExecuted);
        System.out.println("********************************");
    }

    public void dumpStatusPartial(StatusDumper statusDumper) {
        statusDumper.println("\tinstructionsExecuted " + this.instructionsExecuted);
        statusDumper.println("\teax " + this.eax + " ebx " + this.ebx + " ecx " + this.ecx + " edx " + this.edx + " esi " + this.esi + " edi " + this.edi);
        statusDumper.println("\tesp " + this.esp + " ebp " + this.ebp + " eip " + this.eip + " cr0 " + this.cr0 + " cr1 " + this.cr1 + " cr2 " + this.cr2);
        statusDumper.println("\tcr3 " + this.cr3 + " cr4 " + this.cr4 + " dr0 " + this.dr0 + " dr1 " + this.dr1 + " dr2 " + this.dr2 + " dr3 " + this.dr3);
        statusDumper.println("\tdr4 " + this.dr4 + " dr5 " + this.dr5 + " dr6 " + this.dr6 + " dr7 " + this.dr7);
        statusDumper.println("\teflags:" + (this.eflagsCarry ? " CARRY" : "") + (this.eflagsParity ? " PARITY" : "") + (this.eflagsAuxiliaryCarry ? " AUXCARRY" : "") + (this.eflagsZero ? " ZERO" : "") + (this.eflagsSign ? " SIGN" : "") + (this.eflagsTrap ? " TRAP" : "") + (this.eflagsInterruptEnable ? " INTENABLE" : "") + (this.eflagsDirection ? " DIRECTION" : "") + (this.eflagsOverflow ? " OVERFLOW" : "") + " IOPL" + this.eflagsIOPrivilegeLevel + (this.eflagsNestedTask ? " NESTED" : "") + (this.eflagsResume ? " RESUME" : "") + (this.eflagsVirtual8086Mode ? " VM86" : "") + (this.eflagsAlignmentCheck ? " ALIGN" : "") + (this.eflagsVirtualInterrupt ? " VINTENABLE" : "") + (this.eflagsVirtualInterruptPending ? " VINTPENDING" : "") + (this.eflagsID ? " IDFLAG" : "") + (this.eflagsInterruptEnableSoon ? " INTENABLESOON" : ""));
        statusDumper.println("\tinterruptFlags " + this.interruptFlags + " alignmentChecking " + this.alignmentChecking);
        statusDumper.println("\tresetTime" + this.resetTime + " currentPrivilegeLevel " + this.currentPrivilegeLevel);
        statusDumper.println("\tstarted " + this.started + " clockDivider " + this.clockDivider);
        statusDumper.println("\toverflowOne " + this.overflowOne + " overflowTwo " + this.overflowTwo);
        statusDumper.println("\toverflowThree " + this.overflowThree + " overflowLong " + this.overflowLong);
        statusDumper.println("\toverflowCalculated " + this.overflowCalculated + " overflowMethod " + this.overflowMethod);
        statusDumper.println("\tauxiliaryCarryOne " + this.auxiliaryCarryOne + " auxiliaryCarryTwo " + this.auxiliaryCarryTwo);
        statusDumper.println("\tauxiliaryCarryThree " + this.overflowThree + " auxiliaryCarryMethod " + this.auxiliaryCarryMethod);
        statusDumper.println("\tauxiliaryCarryCalculated " + this.auxiliaryCarryCalculated + " zeroOne " + this.zeroOne);
        statusDumper.println("\tzeroCalculated " + this.zeroCalculated + " carryMethod " + this.carryMethod);
        statusDumper.println("\tcarryCalculated " + this.carryCalculated + " carryLong " + this.carryLong);
        statusDumper.println("\tcarryOne " + this.carryOne + " carryTwo " + this.carryTwo);
        statusDumper.println("\tSYSFLAG_FLUSHONMODIFY " + this.SYSFLAG_FLUSHONMODIFY);
        statusDumper.println("\tcs <object #" + statusDumper.objectNumber(this.cs) + ">");
        if (this.cs != null) {
            this.cs.dumpStatus(statusDumper);
        }
        statusDumper.println("\tds <object #" + statusDumper.objectNumber(this.ds) + ">");
        if (this.ds != null) {
            this.ds.dumpStatus(statusDumper);
        }
        statusDumper.println("\tes <object #" + statusDumper.objectNumber(this.es) + ">");
        if (this.es != null) {
            this.es.dumpStatus(statusDumper);
        }
        statusDumper.println("\tfs <object #" + statusDumper.objectNumber(this.fs) + ">");
        if (this.fs != null) {
            this.fs.dumpStatus(statusDumper);
        }
        statusDumper.println("\tgs <object #" + statusDumper.objectNumber(this.gs) + ">");
        if (this.gs != null) {
            this.gs.dumpStatus(statusDumper);
        }
        statusDumper.println("\tss <object #" + statusDumper.objectNumber(this.ss) + ">");
        if (this.ss != null) {
            this.ss.dumpStatus(statusDumper);
        }
        statusDumper.println("\tidtr <object #" + statusDumper.objectNumber(this.idtr) + ">");
        if (this.idtr != null) {
            this.idtr.dumpStatus(statusDumper);
        }
        statusDumper.println("\tgdtr <object #" + statusDumper.objectNumber(this.gdtr) + ">");
        if (this.gdtr != null) {
            this.gdtr.dumpStatus(statusDumper);
        }
        statusDumper.println("\tldtr <object #" + statusDumper.objectNumber(this.ldtr) + ">");
        if (this.ldtr != null) {
            this.ldtr.dumpStatus(statusDumper);
        }
        statusDumper.println("\ttss <object #" + statusDumper.objectNumber(this.tss) + ">");
        if (this.tss != null) {
            this.tss.dumpStatus(statusDumper);
        }
        statusDumper.println("\tlinearMemory <object #" + statusDumper.objectNumber(this.linearMemory) + ">");
        if (this.linearMemory != null) {
            this.linearMemory.dumpStatus(statusDumper);
        }
        statusDumper.println("\tphysicalMemory <object #" + statusDumper.objectNumber(this.physicalMemory) + ">");
        if (this.physicalMemory != null) {
            this.physicalMemory.dumpStatus(statusDumper);
        }
        statusDumper.println("\talignmentCheckedMemory <object #" + statusDumper.objectNumber(this.alignmentCheckedMemory) + ">");
        if (this.alignmentCheckedMemory != null) {
            this.alignmentCheckedMemory.dumpStatus(statusDumper);
        }
        statusDumper.println("\tioports <object #" + statusDumper.objectNumber(this.ioports) + ">");
        if (this.ioports != null) {
            this.ioports.dumpStatus(statusDumper);
        }
        statusDumper.println("\tinterruptController <object #" + statusDumper.objectNumber(this.interruptController) + ">");
        if (this.interruptController != null) {
            this.interruptController.dumpStatus(statusDumper);
        }
        statusDumper.println("\tvmClock <object #" + statusDumper.objectNumber(this.vmClock) + ">");
        if (this.vmClock != null) {
            this.vmClock.dumpStatus(statusDumper);
        }
        statusDumper.println("\tfpu <object #" + statusDumper.objectNumber(this.fpu) + ">");
        if (this.fpu != null) {
            this.fpu.dumpStatus(statusDumper);
        }
        statusDumper.println("\tmodelSpecificRegisters:");
        Set<Map.Entry<Integer, Long>> set = this.modelSpecificRegisters.entrySet();
        for (Map.Entry<Integer, Long> entry : set) {
            statusDumper.println("\t\t" + entry.getKey() + " -> " + entry.getValue());
        }
        statusDumper.println("\teflagsMachineHalt " + this.eflagsMachineHalt);
        statusDumper.println("\teflagsLastAborted " + this.eflagsLastAborted + " eflagsWaiting " + this.eflagsWaiting);
    }

    @Override
    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": Processor:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        sRDumper.dumpLong(this.instructionsExecuted);
        sRDumper.dumpInt(this.eax);
        sRDumper.dumpInt(this.ebx);
        sRDumper.dumpInt(this.edx);
        sRDumper.dumpInt(this.ecx);
        sRDumper.dumpInt(this.esi);
        sRDumper.dumpInt(this.edi);
        sRDumper.dumpInt(this.esp);
        sRDumper.dumpInt(this.ebp);
        sRDumper.dumpInt(this.eip);
        sRDumper.dumpInt(this.cr0);
        sRDumper.dumpInt(this.cr1);
        sRDumper.dumpInt(this.cr2);
        sRDumper.dumpInt(this.cr3);
        sRDumper.dumpInt(this.cr4);
        sRDumper.dumpInt(this.dr0);
        sRDumper.dumpInt(this.dr1);
        sRDumper.dumpInt(this.dr2);
        sRDumper.dumpInt(this.dr3);
        sRDumper.dumpInt(this.dr4);
        sRDumper.dumpInt(this.dr5);
        sRDumper.dumpInt(this.dr6);
        sRDumper.dumpInt(this.dr7);
        sRDumper.dumpObject(this.cs);
        sRDumper.dumpObject(this.ds);
        sRDumper.dumpObject(this.ss);
        sRDumper.dumpObject(this.es);
        sRDumper.dumpObject(this.fs);
        sRDumper.dumpObject(this.gs);
        sRDumper.dumpObject(this.idtr);
        sRDumper.dumpObject(this.gdtr);
        sRDumper.dumpObject(this.ldtr);
        sRDumper.dumpObject(this.tss);
        sRDumper.dumpInt(this.clockDivider);
        sRDumper.dumpBoolean(this.eflagsCarry);
        sRDumper.dumpBoolean(this.eflagsParity);
        sRDumper.dumpBoolean(this.eflagsAuxiliaryCarry);
        sRDumper.dumpBoolean(this.eflagsZero);
        sRDumper.dumpBoolean(this.eflagsSign);
        sRDumper.dumpBoolean(this.eflagsTrap);
        sRDumper.dumpBoolean(this.eflagsInterruptEnable);
        sRDumper.dumpBoolean(this.eflagsDirection);
        sRDumper.dumpBoolean(this.eflagsOverflow);
        sRDumper.dumpInt(this.eflagsIOPrivilegeLevel);
        sRDumper.dumpBoolean(this.eflagsNestedTask);
        sRDumper.dumpBoolean(this.eflagsResume);
        sRDumper.dumpBoolean(this.eflagsVirtual8086Mode);
        sRDumper.dumpBoolean(this.eflagsAlignmentCheck);
        sRDumper.dumpBoolean(this.eflagsVirtualInterrupt);
        sRDumper.dumpBoolean(this.eflagsVirtualInterruptPending);
        sRDumper.dumpBoolean(this.eflagsID);
        sRDumper.dumpBoolean(this.eflagsInterruptEnableSoon);
        sRDumper.dumpObject(this.linearMemory);
        sRDumper.dumpObject(this.physicalMemory);
        sRDumper.dumpObject(this.alignmentCheckedMemory);
        sRDumper.dumpObject(this.ioports);
        sRDumper.dumpInt(this.interruptFlags);
        sRDumper.dumpObject(this.interruptController);
        sRDumper.dumpObject(this.vmClock);
        sRDumper.dumpBoolean(this.alignmentChecking);
        sRDumper.dumpLong(this.resetTime);
        sRDumper.dumpInt(this.currentPrivilegeLevel);
        sRDumper.dumpBoolean(this.started);
        sRDumper.dumpObject(this.fpu);
        sRDumper.dumpInt(this.parityOne);
        sRDumper.dumpBoolean(this.parityCalculated);
        sRDumper.dumpInt(this.auxiliaryCarryOne);
        sRDumper.dumpInt(this.auxiliaryCarryTwo);
        sRDumper.dumpInt(this.auxiliaryCarryThree);
        sRDumper.dumpBoolean(this.auxiliaryCarryCalculated);
        sRDumper.dumpInt(this.auxiliaryCarryMethod);
        sRDumper.dumpInt(this.overflowOne);
        sRDumper.dumpInt(this.overflowTwo);
        sRDumper.dumpInt(this.overflowThree);
        sRDumper.dumpLong(this.overflowLong);
        sRDumper.dumpBoolean(this.overflowCalculated);
        sRDumper.dumpInt(this.overflowMethod);
        sRDumper.dumpInt(this.carryOne);
        sRDumper.dumpInt(this.carryTwo);
        sRDumper.dumpLong(this.carryLong);
        sRDumper.dumpBoolean(this.carryCalculated);
        sRDumper.dumpInt(this.carryMethod);
        sRDumper.dumpInt(this.zeroOne);
        sRDumper.dumpBoolean(this.zeroCalculated);
        sRDumper.dumpInt(this.signOne);
        sRDumper.dumpBoolean(this.signCalculated);
        Set<Map.Entry<Integer, Long>> set = this.modelSpecificRegisters.entrySet();
        for (Map.Entry<Integer, Long> entry : set) {
            sRDumper.dumpBoolean(true);
            sRDumper.dumpInt(entry.getKey());
            sRDumper.dumpLong(entry.getValue());
        }
        sRDumper.dumpBoolean(false);
        sRDumper.dumpBoolean(this.eflagsWaiting);
        sRDumper.dumpBoolean(this.SYSFLAG_FLUSHONMODIFY);
    }

    public Processor(SRLoader sRLoader) throws IOException {
        sRLoader.objectCreated(this);
        this.instructionsExecuted = sRLoader.loadLong();
        this.eax = sRLoader.loadInt();
        this.ebx = sRLoader.loadInt();
        this.edx = sRLoader.loadInt();
        this.ecx = sRLoader.loadInt();
        this.esi = sRLoader.loadInt();
        this.edi = sRLoader.loadInt();
        this.esp = sRLoader.loadInt();
        this.ebp = sRLoader.loadInt();
        this.eip = sRLoader.loadInt();
        this.cr0 = sRLoader.loadInt();
        this.cr1 = sRLoader.loadInt();
        this.cr2 = sRLoader.loadInt();
        this.cr3 = sRLoader.loadInt();
        this.cr4 = sRLoader.loadInt();
        this.dr0 = sRLoader.loadInt();
        this.dr1 = sRLoader.loadInt();
        this.dr2 = sRLoader.loadInt();
        this.dr3 = sRLoader.loadInt();
        this.dr4 = sRLoader.loadInt();
        this.dr5 = sRLoader.loadInt();
        this.dr6 = sRLoader.loadInt();
        this.dr7 = sRLoader.loadInt();
        this.cs = (Segment)sRLoader.loadObject();
        this.ds = (Segment)sRLoader.loadObject();
        this.ss = (Segment)sRLoader.loadObject();
        this.es = (Segment)sRLoader.loadObject();
        this.fs = (Segment)sRLoader.loadObject();
        this.gs = (Segment)sRLoader.loadObject();
        this.idtr = (Segment)sRLoader.loadObject();
        this.gdtr = (Segment)sRLoader.loadObject();
        this.ldtr = (Segment)sRLoader.loadObject();
        this.tss = (Segment)sRLoader.loadObject();
        this.clockDivider = sRLoader.loadInt();
        this.eflagsCarry = sRLoader.loadBoolean();
        this.eflagsParity = sRLoader.loadBoolean();
        this.eflagsAuxiliaryCarry = sRLoader.loadBoolean();
        this.eflagsZero = sRLoader.loadBoolean();
        this.eflagsSign = sRLoader.loadBoolean();
        this.eflagsTrap = sRLoader.loadBoolean();
        this.eflagsInterruptEnable = sRLoader.loadBoolean();
        this.eflagsDirection = sRLoader.loadBoolean();
        this.eflagsOverflow = sRLoader.loadBoolean();
        this.eflagsIOPrivilegeLevel = sRLoader.loadInt();
        this.eflagsNestedTask = sRLoader.loadBoolean();
        this.eflagsResume = sRLoader.loadBoolean();
        this.eflagsVirtual8086Mode = sRLoader.loadBoolean();
        this.eflagsAlignmentCheck = sRLoader.loadBoolean();
        this.eflagsVirtualInterrupt = sRLoader.loadBoolean();
        this.eflagsVirtualInterruptPending = sRLoader.loadBoolean();
        this.eflagsID = sRLoader.loadBoolean();
        this.eflagsInterruptEnableSoon = sRLoader.loadBoolean();
        this.linearMemory = (LinearAddressSpace)sRLoader.loadObject();
        this.physicalMemory = (PhysicalAddressSpace)sRLoader.loadObject();
        this.alignmentCheckedMemory = (AlignmentCheckedAddressSpace)sRLoader.loadObject();
        this.ioports = (IOPortHandler)sRLoader.loadObject();
        this.interruptFlags = sRLoader.loadInt();
        this.interruptController = (InterruptController)sRLoader.loadObject();
        this.vmClock = (Clock)sRLoader.loadObject();
        this.alignmentChecking = sRLoader.loadBoolean();
        this.resetTime = sRLoader.loadLong();
        this.currentPrivilegeLevel = sRLoader.loadInt();
        this.started = sRLoader.loadBoolean();
        this.fpu = (FpuState)sRLoader.loadObject();
        this.parityOne = sRLoader.loadInt();
        this.parityCalculated = sRLoader.loadBoolean();
        this.auxiliaryCarryOne = sRLoader.loadInt();
        this.auxiliaryCarryTwo = sRLoader.loadInt();
        this.auxiliaryCarryThree = sRLoader.loadInt();
        this.auxiliaryCarryCalculated = sRLoader.loadBoolean();
        this.auxiliaryCarryMethod = sRLoader.loadInt();
        this.overflowOne = sRLoader.loadInt();
        this.overflowTwo = sRLoader.loadInt();
        this.overflowThree = sRLoader.loadInt();
        this.overflowLong = sRLoader.loadLong();
        this.overflowCalculated = sRLoader.loadBoolean();
        this.overflowMethod = sRLoader.loadInt();
        this.carryOne = sRLoader.loadInt();
        this.carryTwo = sRLoader.loadInt();
        this.carryLong = sRLoader.loadLong();
        this.carryCalculated = sRLoader.loadBoolean();
        this.carryMethod = sRLoader.loadInt();
        this.zeroOne = sRLoader.loadInt();
        this.zeroCalculated = sRLoader.loadBoolean();
        this.signOne = sRLoader.loadInt();
        this.signCalculated = sRLoader.loadBoolean();
        this.modelSpecificRegisters = new HashMap<Integer, Long>();
        boolean bl = sRLoader.loadBoolean();
        while (bl) {
            int n = sRLoader.loadInt();
            long l = sRLoader.loadLong();
            this.modelSpecificRegisters.put(n, l);
        }
        this.eflagsWaiting = sRLoader.loadBoolean();
        this.SYSFLAG_FLUSHONMODIFY = false;
        if (sRLoader.objectEndsHere()) {
            return;
        }
        this.SYSFLAG_FLUSHONMODIFY = sRLoader.loadBoolean();
    }

    public int getIOPrivilegeLevel() {
        return this.eflagsIOPrivilegeLevel;
    }

    public int getEFlags() {
        int n = 2;
        if (this.getCarryFlag()) {
            n |= 1;
        }
        if (this.getParityFlag()) {
            n |= 4;
        }
        if (this.getAuxiliaryCarryFlag()) {
            n |= 0x10;
        }
        if (this.getZeroFlag()) {
            n |= 0x40;
        }
        if (this.getSignFlag()) {
            n |= 0x80;
        }
        if (this.eflagsTrap) {
            n |= 0x100;
        }
        if (this.eflagsInterruptEnable) {
            n |= 0x200;
        }
        if (this.eflagsDirection) {
            n |= 0x400;
        }
        if (this.getOverflowFlag()) {
            n |= 0x800;
        }
        n |= this.eflagsIOPrivilegeLevel << 12;
        if (this.eflagsNestedTask) {
            n |= 0x4000;
        }
        if (this.eflagsResume) {
            n |= 0x10000;
        }
        if (this.eflagsVirtual8086Mode) {
            n |= 0x20000;
        }
        if (this.eflagsAlignmentCheck) {
            n |= 0x40000;
        }
        if (this.eflagsVirtualInterrupt) {
            n |= 0x80000;
        }
        if (this.eflagsVirtualInterruptPending) {
            n |= 0x100000;
        }
        if (this.eflagsID) {
            n |= 0x200000;
        }
        return n;
    }

    public void setEFlags(int n) {
        this.setCarryFlag((n & 1) != 0);
        this.setParityFlag((n & 4) != 0);
        this.setAuxiliaryCarryFlag((n & 0x10) != 0);
        this.setZeroFlag((n & 0x40) != 0);
        this.setSignFlag((n & 0x80) != 0);
        this.eflagsTrap = (n & 0x100) != 0;
        this.eflagsInterruptEnable = (n & 0x200) != 0;
        this.eflagsInterruptEnableSoon = this.eflagsInterruptEnable;
        this.eflagsDirection = (n & 0x400) != 0;
        this.setOverflowFlag((n & 0x800) != 0);
        this.eflagsIOPrivilegeLevel = n >> 12 & 3;
        this.eflagsNestedTask = (n & 0x4000) != 0;
        this.eflagsResume = (n & 0x10000) != 0;
        this.eflagsVirtualInterrupt = (n & 0x80000) != 0;
        this.eflagsVirtualInterruptPending = (n & 0x100000) != 0;
        this.eflagsID = (n & 0x200000) != 0;
        if (this.eflagsAlignmentCheck != ((n & 0x40000) != 0)) {
            this.eflagsAlignmentCheck = (n & 0x40000) != 0;
            this.checkAlignmentChecking();
        }
        if (this.eflagsVirtual8086Mode != ((n & 0x20000) != 0)) {
            boolean bl = this.eflagsVirtual8086Mode = (n & 0x20000) != 0;
            if (this.eflagsVirtual8086Mode) {
                throw ModeSwitchException.VIRTUAL8086_MODE_EXCEPTION;
            }
            throw ModeSwitchException.PROTECTED_MODE_EXCEPTION;
        }
    }

    public void setCPL(int n) {
        this.currentPrivilegeLevel = n;
        this.linearMemory.setSupervisor(this.currentPrivilegeLevel == 0);
        this.checkAlignmentChecking();
    }

    public int getCPL() {
        return this.currentPrivilegeLevel;
    }

    public void reportFPUException() {
        if ((this.cr0 & 0x20) != 0) {
            System.err.println("Emulated: Reporting FPU error via exception 0x10");
            throw ProcessorException.FLOATING_POINT;
        }
        System.err.println("Emulated: Reporting FPU error via IRQ #13");
        this.interruptController.setIRQ(13, 1);
    }

    public void raiseInterrupt() {
        this.interruptFlags |= 1;
    }

    public void clearInterrupt() {
        this.interruptFlags &= 0xFFFFFFFE;
    }

    public void waitForInterrupt() {
        this.eflagsWaiting = true;
        if (this.eflagsInterruptEnableSoon) {
            this.eflagsInterruptEnable = true;
        }
        while ((this.interruptFlags & 1) == 0) {
            Clock.timePasses(this.vmClock, this.clockDivider);
            if (!this.eflagsMachineHalt) continue;
            System.err.println("Informational: HALT aborted.");
            throw ProcessorException.TRACESTOP;
        }
        this.eflagsWaiting = false;
        if (this.isProtectedMode()) {
            if (this.isVirtual8086Mode()) {
                this.processProtectedModeInterrupts(0);
            } else {
                this.processProtectedModeInterrupts(0);
            }
        } else {
            this.processRealModeInterrupts(0);
        }
    }

    public void instructionExecuted() {
        Clock.timePasses(this.vmClock, this.clockDivider);
    }

    public void useFPU(boolean bl) {
        if (this.fpu == null || (this.cr0 & 4) != 0) {
            if (this.fpu == null) {
                ++this.fpuUsedNotPresentCount;
                if (this.fpuUsedNotPresent == 0L || this.vmClock.getTime() > this.fpuUsedNotPresent + 50000L) {
                    this.fpuUsedNotPresent = this.vmClock.getTime();
                    System.err.println("Warning: FPU used but not present (" + this.fpuUsedNotPresentCount + "times already).");
                }
            }
            throw ProcessorException.FPU_NA_0;
        }
        if (bl && (this.cr0 & 2) == 0) {
            return;
        }
        if ((this.cr0 & 8) != 0) {
            throw ProcessorException.FPU_NA_0;
        }
    }

    public void requestReset() {
        this.interruptFlags |= 4;
    }

    public boolean isProtectedMode() {
        return (this.cr0 & 1) == 1;
    }

    public boolean isVirtual8086Mode() {
        return this.eflagsVirtual8086Mode;
    }

    public void setCR0(int n) {
        boolean bl;
        int n2 = (n |= 0x10) ^ this.cr0;
        if (n2 == 0) {
            return;
        }
        this.cr0 = n;
        boolean bl2 = (n2 & Integer.MIN_VALUE) != 0;
        boolean bl3 = (n2 & 0x40000000) != 0;
        boolean bl4 = (n2 & 1) != 0;
        boolean bl5 = (n2 & 0x10000) != 0;
        boolean bl6 = bl = (n2 & 0x40000) != 0;
        if ((n2 & 0x20000000) != 0) {
            System.err.println("Warning: Unimplemented CR0 flags change " + Integer.toHexString(n2) + ". " + "Value now is " + Integer.toHexString(n) + ".");
        }
        if (bl2 && (n & 1) == 0 && (n & Integer.MIN_VALUE) != 0) {
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, 0, true);
        }
        if (bl) {
            this.checkAlignmentChecking();
        }
        if (bl2 || bl3) {
            this.linearMemory.setPagingEnabled((n & Integer.MIN_VALUE) != 0);
            this.linearMemory.setPageCacheEnabled((n & 0x40000000) == 0);
        }
        if (bl5) {
            this.linearMemory.setWriteProtectUserPages((n & 0x10000) != 0);
        }
        if (bl4) {
            if ((n & 1) != 0) {
                this.convertSegmentsToProtectedMode();
                throw ModeSwitchException.PROTECTED_MODE_EXCEPTION;
            }
            this.setCPL(0);
            this.convertSegmentsToRealMode();
            throw ModeSwitchException.REAL_MODE_EXCEPTION;
        }
    }

    public int getCR0() {
        return this.cr0;
    }

    public void setCR3(int n) {
        this.cr3 = n;
        this.linearMemory.setPageWriteThroughEnabled((n & 8) != 0);
        this.linearMemory.setPageCacheEnabled((n & 0x10) == 0);
        this.linearMemory.setPageDirectoryBaseAddress(n);
    }

    public int getCR3() {
        return this.cr3;
    }

    public int getCR2() {
        return this.cr2;
    }

    public void setCR2(int n) {
        this.cr2 = n;
    }

    public void setCR4(int n) {
        if (this.cr4 == n) {
            return;
        }
        this.cr4 = this.cr4 & 0xFFFFFFA0 | n & 0x5F;
        if ((this.cr4 & 1) != 0) {
            System.err.println("Warning: Virtual-8086 mode extensions enabled in the processor");
        }
        if ((this.cr4 & 2) != 0) {
            System.err.println("Warning: Protected mode virtual interrupts enabled in the processor");
        }
        if ((this.cr4 & 0x400) != 0) {
            System.err.println("Warning: SIMD instruction support modified in the processor");
        }
        if ((this.cr4 & 0x200) != 0) {
            System.err.println("Warning: FXSave and FXRStore enabled in the processor");
        }
        if ((this.cr4 & 8) != 0) {
            System.err.println("Warning: Debugging extensions enabled");
        }
        if ((this.cr4 & 4) != 0) {
            System.err.println("Warning: Timestamp restricted to CPL0");
        }
        if ((this.cr4 & 0x20) != 0) {
            System.err.println("Critical error: 36-bit addressing enabled.");
            throw new IllegalStateException("36-bit addressing not supported");
        }
        this.linearMemory.setGlobalPagesEnabled((n & 0x80) != 0);
        this.linearMemory.setPageSizeExtensionsEnabled((this.cr4 & 0x10) != 0);
    }

    public int getCR4() {
        return this.cr4;
    }

    public void setDR0(int n) {
        this.dr0 = n;
    }

    public void setDR1(int n) {
        this.dr1 = n;
    }

    public void setDR2(int n) {
        this.dr2 = n;
    }

    public void setDR3(int n) {
        this.dr3 = n;
    }

    public void setDR6(int n) {
        this.dr6 = n;
    }

    public void setDR7(int n) {
        this.dr7 = n;
    }

    public int getDR0() {
        return this.dr0;
    }

    public int getDR1() {
        return this.dr1;
    }

    public int getDR2() {
        return this.dr2;
    }

    public int getDR3() {
        return this.dr3;
    }

    public int getDR6() {
        return this.dr6;
    }

    public int getDR7() {
        return this.dr7;
    }

    public long getMSR(int n) {
        try {
            return this.modelSpecificRegisters.get(n);
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("Emulated: Reading unset MSR " + n + ", giving 0.");
            return 0L;
        }
    }

    public void setMSR(int n, long l) {
        this.modelSpecificRegisters.put(n, l);
    }

    private void convertSegmentsToRealMode() {
        try {
            this.cs = SegmentFactory.createRealModeSegment((AddressSpace)this.physicalMemory, this.cs);
        }
        catch (ProcessorException processorException) {
            this.cs = SegmentFactory.createRealModeSegment((AddressSpace)this.physicalMemory, 0);
        }
        try {
            this.ds = SegmentFactory.createRealModeSegment((AddressSpace)this.physicalMemory, this.ds);
        }
        catch (ProcessorException processorException) {
            this.ds = SegmentFactory.createRealModeSegment((AddressSpace)this.physicalMemory, 0);
        }
        try {
            this.ss = SegmentFactory.createRealModeSegment((AddressSpace)this.physicalMemory, this.ss);
        }
        catch (ProcessorException processorException) {
            this.ss = SegmentFactory.createRealModeSegment((AddressSpace)this.physicalMemory, 0);
        }
        try {
            this.es = SegmentFactory.createRealModeSegment((AddressSpace)this.physicalMemory, this.es);
        }
        catch (ProcessorException processorException) {
            this.es = SegmentFactory.createRealModeSegment((AddressSpace)this.physicalMemory, 0);
        }
        try {
            this.fs = SegmentFactory.createRealModeSegment((AddressSpace)this.physicalMemory, this.fs);
        }
        catch (ProcessorException processorException) {
            this.fs = SegmentFactory.createRealModeSegment((AddressSpace)this.physicalMemory, 0);
        }
        try {
            this.gs = SegmentFactory.createRealModeSegment((AddressSpace)this.physicalMemory, this.gs);
        }
        catch (ProcessorException processorException) {
            this.gs = SegmentFactory.createRealModeSegment((AddressSpace)this.physicalMemory, 0);
        }
    }

    private void convertSegmentsToProtectedMode() {
        this.cs.setAddressSpace(this.linearMemory);
        this.ds.setAddressSpace(this.linearMemory);
        this.ss.setAddressSpace(this.linearMemory);
        this.es.setAddressSpace(this.linearMemory);
        this.fs.setAddressSpace(this.linearMemory);
        this.gs.setAddressSpace(this.linearMemory);
    }

    private void updateAlignmentCheckingInDataSegments() {
        if (this.alignmentChecking) {
            this.ds.setAddressSpace(this.alignmentCheckedMemory);
            this.ss.setAddressSpace(this.alignmentCheckedMemory);
            this.es.setAddressSpace(this.alignmentCheckedMemory);
            this.fs.setAddressSpace(this.alignmentCheckedMemory);
            this.gs.setAddressSpace(this.alignmentCheckedMemory);
        } else {
            this.ds.setAddressSpace(this.linearMemory);
            this.ss.setAddressSpace(this.linearMemory);
            this.es.setAddressSpace(this.linearMemory);
            this.fs.setAddressSpace(this.linearMemory);
            this.gs.setAddressSpace(this.linearMemory);
        }
    }

    public Segment createDescriptorTableSegment(int n, int n2) {
        return SegmentFactory.createDescriptorTableSegment(this.linearMemory, n, n2);
    }

    public void correctAlignmentChecking(Segment segment) {
        if (this.alignmentChecking && (segment.getType() & 0x18) == 16) {
            segment.setAddressSpace(this.alignmentCheckedMemory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Segment getSegment(int n) {
        boolean bl = this.linearMemory.isSupervisor();
        try {
            long l = 0L;
            this.linearMemory.setSupervisor(true);
            if ((n & 4) != 0) {
                l = this.ldtr.getQuadWord(n & 0xFFF8);
            } else {
                if (n < 4) {
                    Segment segment = SegmentFactory.NULL_SEGMENT;
                    return segment;
                }
                l = this.gdtr.getQuadWord(n & 0xFFF8);
            }
            Segment segment = SegmentFactory.createProtectedModeSegment(this.linearMemory, n, l);
            if (this.alignmentChecking && (segment.getType() & 0x18) == 16) {
                segment.setAddressSpace(this.alignmentCheckedMemory);
            }
            Segment segment2 = segment;
            return segment2;
        }
        finally {
            this.linearMemory.setSupervisor(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Segment getSegment(int n, Segment segment, Segment segment2) {
        boolean bl = this.linearMemory.isSupervisor();
        try {
            long l = 0L;
            this.linearMemory.setSupervisor(true);
            if ((n & 4) != 0) {
                l = segment.getQuadWord(n & 0xFFF8);
            } else {
                if (n < 4) {
                    Segment segment3 = SegmentFactory.NULL_SEGMENT;
                    return segment3;
                }
                l = segment2.getQuadWord(n & 0xFFF8);
            }
            Segment segment4 = SegmentFactory.createProtectedModeSegment(this.linearMemory, n, l);
            if (this.alignmentChecking && (segment4.getType() & 0x18) == 16) {
                segment4.setAddressSpace(this.alignmentCheckedMemory);
            }
            Segment segment5 = segment4;
            return segment5;
        }
        finally {
            this.linearMemory.setSupervisor(bl);
        }
    }

    @Override
    public void reset() {
        this.resetTime = this.instructionsExecuted;
        this.edx = 0;
        this.ecx = 0;
        this.ebx = 0;
        this.eax = 0;
        this.esp = 0;
        this.ebp = 0;
        this.esi = 0;
        this.edi = 0;
        this.edx = 1587;
        this.interruptFlags = 0;
        this.currentPrivilegeLevel = 0;
        this.linearMemory.reset();
        this.alignmentChecking = false;
        this.eip = 65520;
        this.cr0 = 0x60000010;
        this.cr4 = 0;
        this.cr3 = 0;
        this.cr2 = 0;
        this.dr3 = 0;
        this.dr2 = 0;
        this.dr1 = 0;
        this.dr0 = 0;
        this.dr6 = -61456;
        this.dr7 = 1792;
        this.eflagsInterruptEnable = false;
        this.eflagsTrap = false;
        this.eflagsSign = false;
        this.eflagsZero = false;
        this.eflagsAuxiliaryCarry = false;
        this.eflagsParity = false;
        this.eflagsCarry = false;
        this.signCalculated = true;
        this.zeroCalculated = true;
        this.auxiliaryCarryCalculated = true;
        this.parityCalculated = true;
        this.carryCalculated = true;
        this.eflagsVirtual8086Mode = false;
        this.eflagsResume = false;
        this.eflagsNestedTask = false;
        this.eflagsOverflow = false;
        this.eflagsDirection = false;
        this.overflowCalculated = true;
        this.eflagsID = false;
        this.eflagsVirtualInterruptPending = false;
        this.eflagsVirtualInterrupt = false;
        this.eflagsAlignmentCheck = false;
        this.eflagsIOPrivilegeLevel = 0;
        this.eflagsInterruptEnableSoon = false;
        this.cs = SegmentFactory.createRealModeSegment((AddressSpace)this.physicalMemory, 61440);
        this.ds = SegmentFactory.createRealModeSegment((AddressSpace)this.physicalMemory, 0);
        this.ss = SegmentFactory.createRealModeSegment((AddressSpace)this.physicalMemory, 0);
        this.es = SegmentFactory.createRealModeSegment((AddressSpace)this.physicalMemory, 0);
        this.fs = SegmentFactory.createRealModeSegment((AddressSpace)this.physicalMemory, 0);
        this.gs = SegmentFactory.createRealModeSegment((AddressSpace)this.physicalMemory, 0);
        this.idtr = SegmentFactory.createDescriptorTableSegment(this.physicalMemory, 0, 65535);
        this.ldtr = SegmentFactory.NULL_SEGMENT;
        this.gdtr = SegmentFactory.createDescriptorTableSegment(this.physicalMemory, 0, 65535);
        this.tss = SegmentFactory.NULL_SEGMENT;
        this.modelSpecificRegisters.clear();
        if (this.fpu != null) {
            this.fpu.init();
            this.cr0 |= 0x10;
        } else {
            this.cr0 |= 4;
        }
    }

    public long getClockCount() {
        return this.instructionsExecuted - this.resetTime;
    }

    public final int getInstructionPointer() {
        return this.cs.translateAddressRead(this.eip);
    }

    public final void processRealModeInterrupts(int n) {
        if (this.eflagsInterruptEnable) {
            if ((this.interruptFlags & 4) != 0) {
                this.reset();
                return;
            }
            if ((this.interruptFlags & 1) != 0) {
                this.interruptFlags &= 0xFFFFFFFE;
                int n2 = this.interruptController.cpuGetInterrupt();
                this.handleRealModeInterrupt(n2);
            }
        }
        this.eflagsInterruptEnable = this.eflagsInterruptEnableSoon;
    }

    public final void processProtectedModeInterrupts(int n) {
        if (this.eflagsInterruptEnable) {
            if ((this.interruptFlags & 4) != 0) {
                this.reset();
                return;
            }
            if ((this.interruptFlags & 1) != 0) {
                this.interruptFlags &= 0xFFFFFFFE;
                this.handleHardProtectedModeInterrupt(this.interruptController.cpuGetInterrupt());
            }
        }
        this.eflagsInterruptEnable = this.eflagsInterruptEnableSoon;
    }

    public final void processVirtual8086ModeInterrupts(int n) {
        if (this.eflagsInterruptEnable) {
            if ((this.interruptFlags & 4) != 0) {
                this.reset();
                return;
            }
            if ((this.interruptFlags & 1) != 0) {
                this.interruptFlags &= 0xFFFFFFFE;
                if ((this.getCR4() & 1) != 0) {
                    System.err.println("Critical error: VM8086 extensions not supported.");
                    throw new IllegalStateException("VM8086 extensions not supported");
                }
                this.handleHardVirtual8086ModeInterrupt(this.interruptController.cpuGetInterrupt());
            }
        }
        this.eflagsInterruptEnable = this.eflagsInterruptEnableSoon;
    }

    public final void handleRealModeException(ProcessorException processorException) {
        this.handleRealModeInterrupt(processorException.getType().vector());
    }

    private final void handleRealModeInterrupt(int n) {
        if (n * 4 + 3 > this.idtr.getLimit()) {
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, 0, true);
        }
        int n2 = 0xFFFF & this.idtr.getWord(n *= 4);
        int n3 = 0xFFFF & this.idtr.getWord(n + 2);
        short s = (short)this.esp;
        s = (short)(s - 2);
        int n4 = this.getEFlags() & 0xFFFF;
        this.ss.setWord(s & 0xFFFF, (short)n4);
        this.eflagsInterruptEnable = false;
        this.eflagsInterruptEnableSoon = false;
        this.eflagsTrap = false;
        this.eflagsAlignmentCheck = false;
        this.eflagsResume = false;
        s = (short)(s - 2);
        this.ss.setWord(s & 0xFFFF, (short)this.cs.getSelector());
        s = (short)(s - 2);
        this.ss.setWord(s & 0xFFFF, (short)this.eip);
        this.esp = 0xFFFF0000 & this.esp | s & 0xFFFF;
        this.eip = n2;
        if (!this.cs.setSelector(n3)) {
            System.err.println("Emulated: Setting CS to RM in RM interrupt");
            this.cs = SegmentFactory.createRealModeSegment((AddressSpace)this.physicalMemory, n3);
            this.setCPL(0);
        }
    }

    public final void handleProtectedModeException(ProcessorException processorException) {
        int n = this.esp;
        int n2 = this.eip;
        Segment segment = this.cs;
        Segment segment2 = this.ss;
        try {
            this.followProtectedModeException(processorException.getType().vector(), processorException.hasErrorCode(), processorException.getErrorCode(), false, false);
        }
        catch (ProcessorException processorException2) {
            System.err.println("Emulated: Double Fault: " + processorException2);
            this.esp = n;
            this.eip = n2;
            this.cs = segment;
            this.ss = segment2;
            if (processorException.getType() == ProcessorException.Type.DOUBLE_FAULT) {
                System.err.println("Emulated: Triple fault. Unhandleable, CPU shutting down: " + processorException2);
                throw new TripleFault("Triple Fault, CPU shutting down.");
            }
            if (processorException2.combinesToDoubleFault(processorException)) {
                this.handleProtectedModeException(ProcessorException.DOUBLE_FAULT_0);
            }
            this.handleProtectedModeException(processorException2);
        }
    }

    public final void handleSoftProtectedModeInterrupt(int n, int n2) {
        int n3 = this.esp;
        int n4 = this.eip;
        Segment segment = this.cs;
        Segment segment2 = this.ss;
        try {
            this.followProtectedModeException(n, false, 0, false, true);
        }
        catch (ProcessorException processorException) {
            this.esp = n3;
            this.eip = n4;
            this.cs = segment;
            this.ss = segment2;
            if (processorException.pointsToSelf()) {
                this.eip -= n2;
            }
            this.handleProtectedModeException(processorException);
        }
    }

    public final void handleHardProtectedModeInterrupt(int n) {
        int n2 = this.esp;
        int n3 = this.eip;
        Segment segment = this.cs;
        Segment segment2 = this.ss;
        try {
            this.followProtectedModeException(n, false, 0, true, false);
        }
        catch (ProcessorException processorException) {
            this.esp = n2;
            this.eip = n3;
            this.cs = segment;
            this.ss = segment2;
            this.handleProtectedModeException(processorException);
        }
    }

    private final void checkGate(Segment segment, int n, boolean bl) {
        if (bl && segment.getDPL() < this.currentPrivilegeLevel) {
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n + 2, true);
        }
        if (!segment.isPresent()) {
            throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, n + 2, true);
        }
    }

    public final void setSupervisorQuadWord(Segment segment, int n, long l) {
        boolean bl = this.linearMemory.isSupervisor();
        this.linearMemory.setSupervisor(true);
        segment.setQuadWord(n, l);
        this.linearMemory.setSupervisor(bl);
    }

    public final void setSupervisorDoubleWord(Segment segment, int n, int n2) {
        boolean bl = this.linearMemory.isSupervisor();
        this.linearMemory.setSupervisor(true);
        segment.setDoubleWord(n, n2);
        this.linearMemory.setSupervisor(bl);
    }

    public final long readSupervisorQuadWord(Segment segment, int n) {
        boolean bl = this.linearMemory.isSupervisor();
        this.linearMemory.setSupervisor(true);
        long l = segment.getQuadWord(n);
        this.linearMemory.setSupervisor(bl);
        return l;
    }

    public final int readSupervisorDoubleWord(Segment segment, int n) {
        boolean bl = this.linearMemory.isSupervisor();
        this.linearMemory.setSupervisor(true);
        int n2 = segment.getDoubleWord(n);
        this.linearMemory.setSupervisor(bl);
        return n2;
    }

    public final int readSupervisorWord(Segment segment, int n) {
        boolean bl = this.linearMemory.isSupervisor();
        this.linearMemory.setSupervisor(true);
        short s = segment.getWord(n);
        this.linearMemory.setSupervisor(bl);
        return s;
    }

    public final int readSupervisorByte(Segment segment, int n) {
        boolean bl = this.linearMemory.isSupervisor();
        this.linearMemory.setSupervisor(true);
        byte by = segment.getByte(n);
        this.linearMemory.setSupervisor(bl);
        return by;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void followProtectedModeException(int n, boolean bl, int n2, boolean bl2, boolean bl3) {
        Segment segment;
        if (n == ProcessorException.Type.PAGE_FAULT.vector()) {
            this.setCR2(this.linearMemory.getLastWalkedAddress());
            if (this.linearMemory.getLastWalkedAddress() == -1074158656) {
                System.err.println("Emulated: Found it ********* @ " + Integer.toHexString(this.getInstructionPointer()));
                System.exit(0);
            }
        }
        int n3 = n << 3;
        int n4 = bl2 ? 1 : 0;
        boolean bl4 = this.linearMemory.isSupervisor();
        try {
            this.linearMemory.setSupervisor(true);
            long l = this.idtr.getQuadWord(n3);
            segment = SegmentFactory.createProtectedModeSegment(this.linearMemory, n3, l);
        }
        catch (ProcessorException processorException) {
            System.err.println("Emulated: Failed to create gate in PM excp: selector=" + Integer.toHexString(n3));
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n3 + 2 + n4, true);
        }
        finally {
            this.linearMemory.setSupervisor(bl4);
        }
        block14 : switch (segment.getType()) {
            default: {
                System.err.println("Emulated: Invalid gate type for throwing interrupt: " + Integer.toHexString(segment.getType()) + ".");
                throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n3 + 2 + n4, true);
            }
            case 5: {
                System.err.println("Critical error: Task gates as interrupt handlers not implemented.");
                throw new IllegalStateException("Unimplemented Interrupt Handler: Task Gate");
            }
            case 6: {
                Segment segment2;
                ProtectedModeSegment.InterruptGate16Bit interruptGate16Bit = (ProtectedModeSegment.InterruptGate16Bit)segment;
                this.checkGate(interruptGate16Bit, n3, bl3);
                int n5 = interruptGate16Bit.getTargetSegment();
                try {
                    segment2 = this.getSegment(n5);
                }
                catch (ProcessorException processorException) {
                    throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n5 + n4, true);
                }
                if (segment2.getDPL() > this.currentPrivilegeLevel) {
                    throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n5 + n4, true);
                }
                switch (segment2.getType()) {
                    default: {
                        throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n5 + n4, true);
                    }
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: {
                        if (!segment2.isPresent()) {
                            throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, n5 + n4, true);
                        }
                        if (segment2.getDPL() < this.currentPrivilegeLevel) {
                            Segment segment3;
                            int n6;
                            int n7 = 0;
                            int n8 = 0;
                            if ((this.tss.getType() & 8) != 0) {
                                n6 = segment2.getDPL() * 8 + 4;
                                if (n6 + 7 > this.tss.getLimit()) {
                                    throw new ProcessorException(ProcessorException.Type.TASK_SWITCH, this.tss.getSelector(), true);
                                }
                                bl4 = this.linearMemory.isSupervisor();
                                try {
                                    this.linearMemory.setSupervisor(true);
                                    n7 = 0xFFFF & this.tss.getWord(n6 + 4);
                                    n8 = this.tss.getDoubleWord(n6);
                                }
                                finally {
                                    this.linearMemory.setSupervisor(bl4);
                                }
                            } else {
                                n6 = segment2.getDPL() * 4 + 2;
                                if (n6 + 4 > this.tss.getLimit()) {
                                    throw new ProcessorException(ProcessorException.Type.TASK_SWITCH, this.tss.getSelector(), true);
                                }
                                n7 = 0xFFFF & this.tss.getWord(n6 + 2);
                                n8 = 0xFFFF & this.tss.getWord(n6);
                            }
                            try {
                                segment3 = this.getSegment(n7);
                            }
                            catch (ProcessorException processorException) {
                                throw new ProcessorException(ProcessorException.Type.TASK_SWITCH, n7, true);
                            }
                            if (segment3.getRPL() != segment2.getDPL()) {
                                throw new ProcessorException(ProcessorException.Type.TASK_SWITCH, n7, true);
                            }
                            if (segment3.getDPL() != segment2.getDPL() || (segment3.getType() & 0x1A) != 18) {
                                throw new ProcessorException(ProcessorException.Type.TASK_SWITCH, n7, true);
                            }
                            if (!segment3.isPresent()) {
                                throw new ProcessorException(ProcessorException.Type.STACK_SEGMENT, n7, true);
                            }
                            if (bl ? segment3.getDefaultSizeFlag() && this.esp < 12 && this.esp > 0 || !segment3.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 12 : segment3.getDefaultSizeFlag() && this.esp < 10 && this.esp > 0 || !segment3.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 10) {
                                throw ProcessorException.STACK_SEGMENT_0;
                            }
                            int n9 = interruptGate16Bit.getTargetOffset();
                            segment2.checkAddress(n9);
                            int n10 = this.ss.getSelector();
                            int n11 = this.esp;
                            int n12 = this.cs.getSelector();
                            int n13 = this.eip;
                            this.ss = segment3;
                            this.esp = n8;
                            this.ss.setRPL(segment2.getDPL());
                            this.cs = segment2;
                            this.eip = n9;
                            this.setCPL(this.cs.getDPL());
                            if (this.ss.getDefaultSizeFlag()) {
                                this.esp -= 2;
                                this.ss.setWord(this.esp, (short)n10);
                                this.esp -= 2;
                                this.ss.setWord(this.esp, (short)n11);
                                this.esp -= 2;
                                this.ss.setWord(this.esp, (short)this.getEFlags());
                                this.esp -= 2;
                                this.ss.setWord(this.esp, (short)n12);
                                this.esp -= 2;
                                this.ss.setWord(this.esp, (short)n13);
                                if (bl) {
                                    this.esp -= 2;
                                    this.ss.setWord(this.esp, (short)n2);
                                }
                            } else {
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 2 & 0xFFFF;
                                this.ss.setWord(this.esp & 0xFFFF, (short)n10);
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 2 & 0xFFFF;
                                this.ss.setWord(this.esp & 0xFFFF, (short)n11);
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 2 & 0xFFFF;
                                this.ss.setWord(this.esp & 0xFFFF, (short)this.getEFlags());
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 2 & 0xFFFF;
                                this.ss.setWord(this.esp & 0xFFFF, (short)n12);
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 2 & 0xFFFF;
                                this.ss.setWord(this.esp & 0xFFFF, (short)n13);
                                if (bl) {
                                    this.esp = this.esp & 0xFFFF0000 | this.esp - 2 & 0xFFFF;
                                    this.ss.setWord(this.esp & 0xFFFF, (short)n2);
                                }
                            }
                            this.eflagsInterruptEnableSoon = false;
                            this.eflagsInterruptEnable = false;
                            this.eflagsTrap = false;
                            this.eflagsNestedTask = false;
                            this.eflagsVirtual8086Mode = false;
                            this.eflagsResume = false;
                            break block14;
                        }
                        if (segment2.getDPL() == this.currentPrivilegeLevel) {
                            if (bl ? this.ss.getDefaultSizeFlag() && this.esp < 8 && this.esp > 0 || !this.ss.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 8 : this.ss.getDefaultSizeFlag() && this.esp < 6 && this.esp > 0 || !this.ss.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 6) {
                                throw ProcessorException.STACK_SEGMENT_0;
                            }
                            int n14 = interruptGate16Bit.getTargetOffset();
                            segment2.checkAddress(n14);
                            if (this.ss.getDefaultSizeFlag()) {
                                this.esp -= 2;
                                this.ss.setWord(this.esp, (short)this.getEFlags());
                                this.esp -= 2;
                                this.ss.setWord(this.esp, (short)this.cs.getSelector());
                                this.esp -= 2;
                                this.ss.setWord(this.esp, (short)this.eip);
                                if (bl) {
                                    this.esp -= 2;
                                    this.ss.setWord(this.esp, (short)n2);
                                }
                            } else {
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 2 & 0xFFFF;
                                this.ss.setWord(this.esp & 0xFFFF, (short)this.getEFlags());
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 2 & 0xFFFF;
                                this.ss.setWord(this.esp & 0xFFFF, (short)this.cs.getSelector());
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 2 & 0xFFFF;
                                this.ss.setWord(this.esp & 0xFFFF, (short)this.eip);
                                if (bl) {
                                    this.esp = this.esp & 0xFFFF0000 | this.esp - 2 & 0xFFFF;
                                    this.ss.setWord(this.esp & 0xFFFF, (short)n2);
                                }
                            }
                            this.cs = segment2;
                            this.eip = n14;
                            this.cs.setRPL(this.currentPrivilegeLevel);
                            this.eflagsInterruptEnableSoon = false;
                            this.eflagsInterruptEnable = false;
                            this.eflagsTrap = false;
                            this.eflagsNestedTask = false;
                            this.eflagsVirtual8086Mode = false;
                            this.eflagsResume = false;
                            break block14;
                        }
                        throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n5 + n4, true);
                    }
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                }
                if (!segment2.isPresent()) {
                    throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, n3, true);
                }
                if (bl ? this.ss.getDefaultSizeFlag() && this.esp < 8 && this.esp > 0 || !this.ss.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 8 : this.ss.getDefaultSizeFlag() && this.esp < 6 && this.esp > 0 || !this.ss.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 6) {
                    throw ProcessorException.STACK_SEGMENT_0;
                }
                int n15 = interruptGate16Bit.getTargetOffset();
                segment2.checkAddress(n15);
                if (this.ss.getDefaultSizeFlag()) {
                    this.esp -= 2;
                    this.ss.setWord(this.esp, (short)this.getEFlags());
                    this.esp -= 2;
                    this.ss.setWord(this.esp, (short)this.cs.getSelector());
                    this.esp -= 2;
                    this.ss.setWord(this.esp, (short)this.eip);
                    if (bl) {
                        this.esp -= 2;
                        this.ss.setWord(this.esp, (short)n2);
                    }
                } else {
                    this.esp = this.esp & 0xFFFF0000 | this.esp - 2 & 0xFFFF;
                    this.ss.setWord(this.esp & 0xFFFF, (short)this.getEFlags());
                    this.esp = this.esp & 0xFFFF0000 | this.esp - 2 & 0xFFFF;
                    this.ss.setWord(this.esp & 0xFFFF, (short)this.cs.getSelector());
                    this.esp = this.esp & 0xFFFF0000 | this.esp - 2 & 0xFFFF;
                    this.ss.setWord(this.esp & 0xFFFF, (short)this.eip);
                    if (bl) {
                        this.esp = this.esp & 0xFFFF0000 | this.esp - 2 & 0xFFFF;
                        this.ss.setWord(this.esp & 0xFFFF, (short)n2);
                    }
                }
                this.cs = segment2;
                this.eip = n15;
                this.cs.setRPL(this.currentPrivilegeLevel);
                this.eflagsInterruptEnableSoon = false;
                this.eflagsInterruptEnable = false;
                this.eflagsTrap = false;
                this.eflagsNestedTask = false;
                this.eflagsVirtual8086Mode = false;
                this.eflagsResume = false;
                break;
            }
            case 7: {
                Segment segment4;
                ProtectedModeSegment.TrapGate16Bit trapGate16Bit = (ProtectedModeSegment.TrapGate16Bit)segment;
                this.checkGate(trapGate16Bit, n3, bl3);
                int n16 = trapGate16Bit.getTargetSegment();
                try {
                    segment4 = this.getSegment(n16);
                }
                catch (ProcessorException processorException) {
                    throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n16 + n4, true);
                }
                if (segment4.getDPL() > this.currentPrivilegeLevel) {
                    throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n16 + n4, true);
                }
                switch (segment4.getType()) {
                    default: {
                        throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n16 + n4, true);
                    }
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: {
                        if (!segment4.isPresent()) {
                            throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, n16 + n4, true);
                        }
                        if (segment4.getDPL() < this.currentPrivilegeLevel) {
                            Segment segment5;
                            int n17;
                            int n18 = 0;
                            int n19 = 0;
                            if ((this.tss.getType() & 8) != 0) {
                                n17 = segment4.getDPL() * 8 + 4;
                                if (n17 + 7 > this.tss.getLimit()) {
                                    throw new ProcessorException(ProcessorException.Type.TASK_SWITCH, this.tss.getSelector(), true);
                                }
                                bl4 = this.linearMemory.isSupervisor();
                                try {
                                    this.linearMemory.setSupervisor(true);
                                    n18 = 0xFFFF & this.tss.getWord(n17 + 4);
                                    n19 = this.tss.getDoubleWord(n17);
                                }
                                finally {
                                    this.linearMemory.setSupervisor(bl4);
                                }
                            } else {
                                n17 = segment4.getDPL() * 4 + 2;
                                if (n17 + 4 > this.tss.getLimit()) {
                                    throw new ProcessorException(ProcessorException.Type.TASK_SWITCH, this.tss.getSelector(), true);
                                }
                                n18 = 0xFFFF & this.tss.getWord(n17 + 2);
                                n19 = 0xFFFF & this.tss.getWord(n17);
                            }
                            try {
                                segment5 = this.getSegment(n18);
                            }
                            catch (ProcessorException processorException) {
                                throw new ProcessorException(ProcessorException.Type.TASK_SWITCH, n18, true);
                            }
                            if (segment5.getRPL() != segment4.getDPL()) {
                                throw new ProcessorException(ProcessorException.Type.TASK_SWITCH, n18, true);
                            }
                            if (segment5.getDPL() != segment4.getDPL() || (segment5.getType() & 0x1A) != 18) {
                                throw new ProcessorException(ProcessorException.Type.TASK_SWITCH, n18, true);
                            }
                            if (!segment5.isPresent()) {
                                throw new ProcessorException(ProcessorException.Type.STACK_SEGMENT, n18, true);
                            }
                            if (bl ? segment5.getDefaultSizeFlag() && this.esp < 12 && this.esp > 0 || !segment5.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 12 : segment5.getDefaultSizeFlag() && this.esp < 10 && this.esp > 0 || !segment5.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 10) {
                                throw ProcessorException.STACK_SEGMENT_0;
                            }
                            int n20 = trapGate16Bit.getTargetOffset();
                            segment4.checkAddress(n20);
                            int n21 = this.ss.getSelector();
                            int n22 = this.esp;
                            int n23 = this.cs.getSelector();
                            int n24 = this.eip;
                            this.ss = segment5;
                            this.esp = n19;
                            this.ss.setRPL(segment4.getDPL());
                            this.cs = segment4;
                            this.eip = n20;
                            this.setCPL(this.cs.getDPL());
                            if (this.ss.getDefaultSizeFlag()) {
                                this.esp -= 2;
                                this.ss.setWord(this.esp, (short)n21);
                                this.esp -= 2;
                                this.ss.setWord(this.esp, (short)n22);
                                this.esp -= 2;
                                this.ss.setWord(this.esp, (short)this.getEFlags());
                                this.esp -= 2;
                                this.ss.setWord(this.esp, (short)n23);
                                this.esp -= 2;
                                this.ss.setWord(this.esp, (short)n24);
                                if (bl) {
                                    this.esp -= 2;
                                    this.ss.setWord(this.esp, (short)n2);
                                }
                            } else {
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 2 & 0xFFFF;
                                this.ss.setWord(this.esp & 0xFFFF, (short)n21);
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 2 & 0xFFFF;
                                this.ss.setWord(this.esp & 0xFFFF, (short)n22);
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 2 & 0xFFFF;
                                this.ss.setWord(this.esp & 0xFFFF, (short)this.getEFlags());
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 2 & 0xFFFF;
                                this.ss.setWord(this.esp & 0xFFFF, (short)n23);
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 2 & 0xFFFF;
                                this.ss.setWord(this.esp & 0xFFFF, (short)n24);
                                if (bl) {
                                    this.esp = this.esp & 0xFFFF0000 | this.esp - 2 & 0xFFFF;
                                    this.ss.setWord(this.esp & 0xFFFF, (short)n2);
                                }
                            }
                            this.eflagsTrap = false;
                            this.eflagsNestedTask = false;
                            this.eflagsVirtual8086Mode = false;
                            this.eflagsResume = false;
                            break block14;
                        }
                        if (segment4.getDPL() == this.currentPrivilegeLevel) {
                            if (bl ? this.ss.getDefaultSizeFlag() && this.esp < 8 && this.esp > 0 || !this.ss.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 8 : this.ss.getDefaultSizeFlag() && this.esp < 6 && this.esp > 0 || !this.ss.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 6) {
                                throw ProcessorException.STACK_SEGMENT_0;
                            }
                            int n25 = trapGate16Bit.getTargetOffset();
                            segment4.checkAddress(n25);
                            if (this.ss.getDefaultSizeFlag()) {
                                this.esp -= 2;
                                this.ss.setWord(this.esp, (short)this.getEFlags());
                                this.esp -= 2;
                                this.ss.setWord(this.esp, (short)this.cs.getSelector());
                                this.esp -= 2;
                                this.ss.setWord(this.esp, (short)this.eip);
                                if (bl) {
                                    this.esp -= 2;
                                    this.ss.setWord(this.esp, (short)n2);
                                }
                            } else {
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 2 & 0xFFFF;
                                this.ss.setWord(this.esp & 0xFFFF, (short)this.getEFlags());
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 2 & 0xFFFF;
                                this.ss.setWord(this.esp & 0xFFFF, (short)this.cs.getSelector());
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 2 & 0xFFFF;
                                this.ss.setWord(this.esp & 0xFFFF, (short)this.eip);
                                if (bl) {
                                    this.esp = this.esp & 0xFFFF0000 | this.esp - 2 & 0xFFFF;
                                    this.ss.setWord(this.esp & 0xFFFF, (short)n2);
                                }
                            }
                            this.cs = segment4;
                            this.eip = n25;
                            this.cs.setRPL(this.currentPrivilegeLevel);
                            this.eflagsTrap = false;
                            this.eflagsNestedTask = false;
                            this.eflagsVirtual8086Mode = false;
                            this.eflagsResume = false;
                            break block14;
                        }
                        throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n16 + n4, true);
                    }
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                }
                if (!segment4.isPresent()) {
                    throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, n3, true);
                }
                if (bl ? this.ss.getDefaultSizeFlag() && this.esp < 8 && this.esp > 0 || !this.ss.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 8 : this.ss.getDefaultSizeFlag() && this.esp < 6 && this.esp > 0 || !this.ss.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 6) {
                    throw ProcessorException.STACK_SEGMENT_0;
                }
                int n26 = trapGate16Bit.getTargetOffset();
                segment4.checkAddress(n26);
                if (this.ss.getDefaultSizeFlag()) {
                    this.esp -= 2;
                    this.ss.setWord(this.esp, (short)this.getEFlags());
                    this.esp -= 2;
                    this.ss.setWord(this.esp, (short)this.cs.getSelector());
                    this.esp -= 2;
                    this.ss.setWord(this.esp, (short)this.eip);
                    if (bl) {
                        this.esp -= 2;
                        this.ss.setWord(this.esp, (short)n2);
                    }
                } else {
                    this.esp = this.esp & 0xFFFF0000 | this.esp - 2 & 0xFFFF;
                    this.ss.setWord(this.esp & 0xFFFF, (short)this.getEFlags());
                    this.esp = this.esp & 0xFFFF0000 | this.esp - 2 & 0xFFFF;
                    this.ss.setWord(this.esp & 0xFFFF, (short)this.cs.getSelector());
                    this.esp = this.esp & 0xFFFF0000 | this.esp - 2 & 0xFFFF;
                    this.ss.setWord(this.esp & 0xFFFF, (short)this.eip);
                    if (bl) {
                        this.esp = this.esp & 0xFFFF0000 | this.esp - 2 & 0xFFFF;
                        this.ss.setWord(this.esp & 0xFFFF, (short)n2);
                    }
                }
                this.cs = segment4;
                this.eip = n26;
                this.cs.setRPL(this.currentPrivilegeLevel);
                this.eflagsTrap = false;
                this.eflagsNestedTask = false;
                this.eflagsVirtual8086Mode = false;
                this.eflagsResume = false;
                break;
            }
            case 14: {
                Segment segment6;
                ProtectedModeSegment.InterruptGate32Bit interruptGate32Bit = (ProtectedModeSegment.InterruptGate32Bit)segment;
                this.checkGate(segment, n3, bl3);
                int n27 = interruptGate32Bit.getTargetSegment();
                try {
                    segment6 = this.getSegment(n27);
                }
                catch (ProcessorException processorException) {
                    throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n27 + n4, true);
                }
                if (segment6.getDPL() > this.currentPrivilegeLevel) {
                    throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n27 + n4, true);
                }
                switch (segment6.getType()) {
                    default: {
                        throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n27 + n4, true);
                    }
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: {
                        if (!segment6.isPresent()) {
                            throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, n27 + n4, true);
                        }
                        if (segment6.getDPL() < this.currentPrivilegeLevel) {
                            Segment segment7;
                            int n28;
                            int n29 = 0;
                            int n30 = 0;
                            if ((this.tss.getType() & 8) != 0) {
                                n28 = segment6.getDPL() * 8 + 4;
                                if (n28 + 7 > this.tss.getLimit()) {
                                    throw new ProcessorException(ProcessorException.Type.TASK_SWITCH, this.tss.getSelector(), true);
                                }
                                bl4 = this.linearMemory.isSupervisor();
                                try {
                                    this.linearMemory.setSupervisor(true);
                                    n29 = 0xFFFF & this.tss.getWord(n28 + 4);
                                    n30 = this.tss.getDoubleWord(n28);
                                }
                                finally {
                                    this.linearMemory.setSupervisor(bl4);
                                }
                            } else {
                                n28 = segment6.getDPL() * 4 + 2;
                                if (n28 + 4 > this.tss.getLimit()) {
                                    throw new ProcessorException(ProcessorException.Type.TASK_SWITCH, this.tss.getSelector(), true);
                                }
                                n29 = 0xFFFF & this.tss.getWord(n28 + 2);
                                n30 = 0xFFFF & this.tss.getWord(n28);
                            }
                            try {
                                segment7 = this.getSegment(n29);
                            }
                            catch (ProcessorException processorException) {
                                throw new ProcessorException(ProcessorException.Type.TASK_SWITCH, n29, true);
                            }
                            if (segment7.getRPL() != segment6.getDPL()) {
                                throw new ProcessorException(ProcessorException.Type.TASK_SWITCH, n29, true);
                            }
                            if (segment7.getDPL() != segment6.getDPL() || (segment7.getType() & 0x1A) != 18) {
                                throw new ProcessorException(ProcessorException.Type.TASK_SWITCH, n29, true);
                            }
                            if (!segment7.isPresent()) {
                                throw new ProcessorException(ProcessorException.Type.STACK_SEGMENT, n29, true);
                            }
                            if (bl ? segment7.getDefaultSizeFlag() && this.esp < 24 && this.esp > 0 || !segment7.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 24 : segment7.getDefaultSizeFlag() && this.esp < 20 && this.esp > 0 || !segment7.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 20) {
                                throw ProcessorException.STACK_SEGMENT_0;
                            }
                            int n31 = interruptGate32Bit.getTargetOffset();
                            segment6.checkAddress(n31);
                            int n32 = this.ss.getSelector();
                            int n33 = this.esp;
                            int n34 = this.cs.getSelector();
                            int n35 = this.eip;
                            this.ss = segment7;
                            this.esp = n30;
                            this.ss.setRPL(segment6.getDPL());
                            this.cs = segment6;
                            this.eip = n31;
                            this.setCPL(this.cs.getDPL());
                            if (this.ss.getDefaultSizeFlag()) {
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, n32);
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, n33);
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, this.getEFlags());
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, n34);
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, n35);
                                if (bl) {
                                    this.esp -= 4;
                                    this.ss.setDoubleWord(this.esp, n2);
                                }
                            } else {
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, n32);
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, n33);
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, this.getEFlags());
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, n34);
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, n35);
                                if (bl) {
                                    this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                    this.ss.setDoubleWord(this.esp & 0xFFFF, n2);
                                }
                            }
                            this.eflagsInterruptEnableSoon = false;
                            this.eflagsInterruptEnable = false;
                            this.eflagsTrap = false;
                            this.eflagsNestedTask = false;
                            this.eflagsVirtual8086Mode = false;
                            this.eflagsResume = false;
                            break block14;
                        }
                        if (segment6.getDPL() == this.currentPrivilegeLevel) {
                            if (bl ? this.ss.getDefaultSizeFlag() && this.esp < 16 && this.esp > 0 || !this.ss.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 16 : this.ss.getDefaultSizeFlag() && this.esp < 12 && this.esp > 0 || !this.ss.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 12) {
                                throw ProcessorException.STACK_SEGMENT_0;
                            }
                            int n36 = interruptGate32Bit.getTargetOffset();
                            segment6.checkAddress(n36);
                            if (this.ss.getDefaultSizeFlag()) {
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, this.getEFlags());
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, this.cs.getSelector());
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, this.eip);
                                if (bl) {
                                    this.esp -= 4;
                                    this.ss.setDoubleWord(this.esp, n2);
                                }
                            } else {
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, this.getEFlags());
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, this.cs.getSelector());
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, this.eip);
                                if (bl) {
                                    this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                    this.ss.setDoubleWord(this.esp & 0xFFFF, n2);
                                }
                            }
                            this.cs = segment6;
                            this.eip = n36;
                            this.cs.setRPL(this.currentPrivilegeLevel);
                            this.eflagsInterruptEnableSoon = false;
                            this.eflagsInterruptEnable = false;
                            this.eflagsTrap = false;
                            this.eflagsNestedTask = false;
                            this.eflagsVirtual8086Mode = false;
                            this.eflagsResume = false;
                            break block14;
                        }
                        throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n27 + n4, true);
                    }
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                }
                if (!segment6.isPresent()) {
                    throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, n3, true);
                }
                if (bl) {
                    if (this.ss.getDefaultSizeFlag() && this.esp < 16 && this.esp > 0 || !this.ss.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 16) {
                        System.err.println("Emulated: Insufficient stack space for interrupt (case #1).");
                        throw ProcessorException.STACK_SEGMENT_0;
                    }
                } else if (this.ss.getDefaultSizeFlag() && this.esp < 12 && this.esp > 0 || !this.ss.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 12) {
                    System.err.println("Emulated: Insufficient stack space for interrupt (case #2).");
                    throw ProcessorException.STACK_SEGMENT_0;
                }
                int n37 = interruptGate32Bit.getTargetOffset();
                segment6.checkAddress(n37);
                if (this.ss.getDefaultSizeFlag()) {
                    this.esp -= 4;
                    this.ss.setDoubleWord(this.esp, this.getEFlags());
                    this.esp -= 4;
                    this.ss.setDoubleWord(this.esp, this.cs.getSelector());
                    this.esp -= 4;
                    this.ss.setDoubleWord(this.esp, this.eip);
                    if (bl) {
                        this.esp -= 4;
                        this.ss.setDoubleWord(this.esp, n2);
                    }
                } else {
                    this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                    this.ss.setDoubleWord(this.esp & 0xFFFF, this.getEFlags());
                    this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                    this.ss.setDoubleWord(this.esp & 0xFFFF, this.cs.getSelector());
                    this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                    this.ss.setDoubleWord(this.esp & 0xFFFF, this.eip);
                    if (bl) {
                        this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                        this.ss.setDoubleWord(this.esp & 0xFFFF, n2);
                    }
                }
                this.cs = segment6;
                this.eip = n37;
                this.cs.setRPL(this.currentPrivilegeLevel);
                this.eflagsInterruptEnableSoon = false;
                this.eflagsInterruptEnable = false;
                this.eflagsTrap = false;
                this.eflagsNestedTask = false;
                this.eflagsVirtual8086Mode = false;
                this.eflagsResume = false;
                break;
            }
            case 15: {
                Segment segment8;
                ProtectedModeSegment.TrapGate32Bit trapGate32Bit = (ProtectedModeSegment.TrapGate32Bit)segment;
                this.checkGate(segment, n3, bl3);
                int n38 = trapGate32Bit.getTargetSegment();
                try {
                    segment8 = this.getSegment(n38);
                }
                catch (ProcessorException processorException) {
                    throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n38 + n4, true);
                }
                if (segment8.getDPL() > this.currentPrivilegeLevel) {
                    throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n38 + n4, true);
                }
                switch (segment8.getType()) {
                    default: {
                        throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n38 + n4, true);
                    }
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: {
                        if (!segment8.isPresent()) {
                            throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, n38 + n4, true);
                        }
                        if (segment8.getDPL() < this.currentPrivilegeLevel) {
                            Segment segment9;
                            int n39;
                            int n40 = 0;
                            int n41 = 0;
                            if ((this.tss.getType() & 8) != 0) {
                                n39 = segment8.getDPL() * 8 + 4;
                                if (n39 + 7 > this.tss.getLimit()) {
                                    throw new ProcessorException(ProcessorException.Type.TASK_SWITCH, this.tss.getSelector(), true);
                                }
                                bl4 = this.linearMemory.isSupervisor();
                                try {
                                    this.linearMemory.setSupervisor(true);
                                    n40 = 0xFFFF & this.tss.getWord(n39 + 4);
                                    n41 = this.tss.getDoubleWord(n39);
                                }
                                finally {
                                    this.linearMemory.setSupervisor(bl4);
                                }
                            } else {
                                n39 = segment8.getDPL() * 4 + 2;
                                if (n39 + 4 > this.tss.getLimit()) {
                                    throw new ProcessorException(ProcessorException.Type.TASK_SWITCH, this.tss.getSelector(), true);
                                }
                                n40 = 0xFFFF & this.tss.getWord(n39 + 2);
                                n41 = 0xFFFF & this.tss.getWord(n39);
                            }
                            try {
                                segment9 = this.getSegment(n40);
                            }
                            catch (ProcessorException processorException) {
                                throw new ProcessorException(ProcessorException.Type.TASK_SWITCH, n40, true);
                            }
                            if (segment9.getRPL() != segment8.getDPL()) {
                                throw new ProcessorException(ProcessorException.Type.TASK_SWITCH, n40, true);
                            }
                            if (segment9.getDPL() != segment8.getDPL() || (segment9.getType() & 0x1A) != 18) {
                                throw new ProcessorException(ProcessorException.Type.TASK_SWITCH, n40, true);
                            }
                            if (!segment9.isPresent()) {
                                throw new ProcessorException(ProcessorException.Type.STACK_SEGMENT, n40, true);
                            }
                            if (bl) {
                                if (segment9.getDefaultSizeFlag() && this.esp < 24 && this.esp > 0 || !segment9.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 24) {
                                    System.err.println("Emulated: Insufficient stack space for interrupt (case #3).");
                                    throw ProcessorException.STACK_SEGMENT_0;
                                }
                            } else if (segment9.getDefaultSizeFlag() && this.esp < 20 && this.esp > 0 || !segment9.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 20) {
                                System.err.println("Emulated: Insufficient stack space for interrupt (case #4).");
                                throw ProcessorException.STACK_SEGMENT_0;
                            }
                            int n42 = trapGate32Bit.getTargetOffset();
                            segment8.checkAddress(n42);
                            int n43 = this.ss.getSelector();
                            int n44 = this.esp;
                            int n45 = this.cs.getSelector();
                            int n46 = this.eip;
                            this.ss = segment9;
                            this.esp = n41;
                            this.ss.setRPL(segment8.getDPL());
                            this.cs = segment8;
                            this.eip = n42;
                            this.setCPL(this.cs.getDPL());
                            if (this.ss.getDefaultSizeFlag()) {
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, n43);
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, n44);
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, this.getEFlags());
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, n45);
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, n46);
                                if (bl) {
                                    this.esp -= 4;
                                    this.ss.setDoubleWord(this.esp, n2);
                                }
                            } else {
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, n43);
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, n44);
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, this.getEFlags());
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, n45);
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, n46);
                                if (bl) {
                                    this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                    this.ss.setDoubleWord(this.esp & 0xFFFF, n2);
                                }
                            }
                            this.eflagsTrap = false;
                            this.eflagsNestedTask = false;
                            this.eflagsVirtual8086Mode = false;
                            this.eflagsResume = false;
                            break block14;
                        }
                        if (segment8.getDPL() == this.currentPrivilegeLevel) {
                            if (bl) {
                                if (this.ss.getDefaultSizeFlag() && this.esp < 16 && this.esp > 0 || !this.ss.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 16) {
                                    System.err.println("Emulated: Insufficient stack space for interrupt (case #5).");
                                    throw ProcessorException.STACK_SEGMENT_0;
                                }
                            } else if (this.ss.getDefaultSizeFlag() && this.esp < 12 && this.esp > 0 || !this.ss.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 12) {
                                System.err.println("Emulated: Insufficient stack space for interrupt (case #6).");
                                throw ProcessorException.STACK_SEGMENT_0;
                            }
                            int n47 = trapGate32Bit.getTargetOffset();
                            segment8.checkAddress(n47);
                            if (this.ss.getDefaultSizeFlag()) {
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, this.getEFlags());
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, this.cs.getSelector());
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, this.eip);
                                if (bl) {
                                    this.esp -= 4;
                                    this.ss.setDoubleWord(this.esp, n2);
                                }
                            } else {
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, this.getEFlags());
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, this.cs.getSelector());
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, this.eip);
                                if (bl) {
                                    this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                    this.ss.setDoubleWord(this.esp & 0xFFFF, n2);
                                }
                            }
                            this.cs = segment8;
                            this.eip = n47;
                            this.cs.setRPL(this.currentPrivilegeLevel);
                            this.eflagsTrap = false;
                            this.eflagsNestedTask = false;
                            this.eflagsVirtual8086Mode = false;
                            this.eflagsResume = false;
                            break block14;
                        }
                        throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n38 + n4, true);
                    }
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                }
                if (!segment8.isPresent()) {
                    throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, n3, true);
                }
                if (bl) {
                    if (this.ss.getDefaultSizeFlag() && this.esp < 16 && this.esp > 0 || !this.ss.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 16) {
                        System.err.println("Emulated: Insufficient stack space for interrupt (case #7).");
                        throw ProcessorException.STACK_SEGMENT_0;
                    }
                } else if (this.ss.getDefaultSizeFlag() && this.esp < 12 && this.esp > 0 || !this.ss.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 12) {
                    System.err.println("Emulated: Insufficient stack space for interrupt (case #8).");
                    throw ProcessorException.STACK_SEGMENT_0;
                }
                int n48 = trapGate32Bit.getTargetOffset();
                segment8.checkAddress(n48);
                if (this.ss.getDefaultSizeFlag()) {
                    this.esp -= 4;
                    this.ss.setDoubleWord(this.esp, this.getEFlags());
                    this.esp -= 4;
                    this.ss.setDoubleWord(this.esp, this.cs.getSelector());
                    this.esp -= 4;
                    this.ss.setDoubleWord(this.esp, this.eip);
                    if (bl) {
                        this.esp -= 4;
                        this.ss.setDoubleWord(this.esp, n2);
                    }
                } else {
                    this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                    this.ss.setDoubleWord(this.esp & 0xFFFF, this.getEFlags());
                    this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                    this.ss.setDoubleWord(this.esp & 0xFFFF, this.cs.getSelector());
                    this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                    this.ss.setDoubleWord(this.esp & 0xFFFF, this.eip);
                    if (bl) {
                        this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                        this.ss.setDoubleWord(this.esp & 0xFFFF, n2);
                    }
                }
                this.cs = segment8;
                this.eip = n48;
                this.cs.setRPL(this.currentPrivilegeLevel);
                this.eflagsTrap = false;
                this.eflagsNestedTask = false;
                this.eflagsVirtual8086Mode = false;
                this.eflagsResume = false;
            }
        }
    }

    public final void handleVirtual8086ModeException(ProcessorException processorException) {
        int n = this.esp;
        int n2 = this.eip;
        Segment segment = this.cs;
        Segment segment2 = this.ss;
        try {
            this.followVirtual8086ModeException(processorException.getType().vector(), processorException.hasErrorCode(), processorException.getErrorCode(), false, false);
        }
        catch (ProcessorException processorException2) {
            System.err.println("Emulated: Double Fault: " + processorException2);
            this.esp = n;
            this.eip = n2;
            this.cs = segment;
            this.ss = segment2;
            if (processorException.getType() == ProcessorException.Type.DOUBLE_FAULT) {
                System.err.println("Emulated: Triple fault. Unhandleable, CPU shutting down: " + processorException2);
                throw new TripleFault("Triple Fault, CPU shutting down.");
            }
            if (processorException2.combinesToDoubleFault(processorException)) {
                this.handleVirtual8086ModeException(ProcessorException.DOUBLE_FAULT_0);
            }
            this.handleVirtual8086ModeException(processorException2);
        }
    }

    public final void handleSoftVirtual8086ModeInterrupt(int n, int n2) {
        int n3 = this.esp;
        int n4 = this.eip;
        Segment segment = this.cs;
        Segment segment2 = this.ss;
        if ((this.getCR4() & 1) != 0) {
            System.err.println("Critical error: VME not supported.");
            throw new IllegalStateException("VME not supported");
        }
        if (this.eflagsIOPrivilegeLevel < 3) {
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, 0, true);
        }
        try {
            this.followVirtual8086ModeException(n, false, 0, false, true);
        }
        catch (ProcessorException processorException) {
            this.esp = n3;
            this.eip = n4;
            this.cs = segment;
            this.ss = segment2;
            if (processorException.pointsToSelf()) {
                this.eip -= n2;
            }
            if (processorException.getType() == ProcessorException.Type.DOUBLE_FAULT) {
                System.err.println("Emulated: Triple fault. Unhandleable, CPU shutting down: " + processorException);
                throw new TripleFault("Triple Fault, CPU shutting down.");
            }
            this.handleVirtual8086ModeException(processorException);
        }
    }

    public final void handleHardVirtual8086ModeInterrupt(int n) {
        int n2 = this.esp;
        int n3 = this.eip;
        Segment segment = this.cs;
        Segment segment2 = this.ss;
        try {
            this.followVirtual8086ModeException(n, false, 0, true, false);
        }
        catch (ProcessorException processorException) {
            this.esp = n2;
            this.eip = n3;
            this.cs = segment;
            this.ss = segment2;
            this.handleVirtual8086ModeException(processorException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void followVirtual8086ModeException(int n, boolean bl, int n2, boolean bl2, boolean bl3) {
        Segment segment;
        Segment segment2;
        int n3;
        if (n == ProcessorException.Type.PAGE_FAULT.vector()) {
            this.setCR2(this.linearMemory.getLastWalkedAddress());
        }
        int n4 = n << 3;
        int n5 = n3 = bl2 ? 1 : 0;
        if (n4 + 7 > this.idtr.getLimit()) {
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n4 + 2 + n3, true);
        }
        boolean bl4 = this.linearMemory.isSupervisor();
        try {
            this.linearMemory.setSupervisor(true);
            long l = this.idtr.getQuadWord(n4);
            segment2 = SegmentFactory.createProtectedModeSegment(this.linearMemory, n4, l);
        }
        catch (ProcessorException processorException) {
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n4 + 2 + n3, true);
        }
        finally {
            this.linearMemory.setSupervisor(bl4);
        }
        if (!segment2.isSystem()) {
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n4 + 2, true);
        }
        switch (segment2.getType()) {
            default: {
                System.err.println("Emulated: Invalid Gate Type For Throwing Interrupt: 0x" + Integer.toHexString(segment2.getType()));
                throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n4 + 2 + n3, true);
            }
            case 5: {
                System.err.println("Critical error: Unimplemented Interrupt Handler: Task Gate");
                throw new IllegalStateException("Unimplemented Interrupt Handler: Task Gate");
            }
            case 6: {
                System.err.println("Critical error: Unimplemented Interrupt Handler: 16-bit Interrupt Gate");
                throw new IllegalStateException("Unimplemented Interrupt Handler: 16-bit Interrupt Gate");
            }
            case 7: {
                System.err.println("Critical error: Unimplemented Interrupt Handler: 16-bit Trap Gate");
                throw new IllegalStateException("Unimplemented Interrupt Handler: 16-bit Trap Gate");
            }
            case 14: {
                Segment segment3;
                ProtectedModeSegment.InterruptGate32Bit interruptGate32Bit = (ProtectedModeSegment.InterruptGate32Bit)segment2;
                this.checkGate(segment2, n4, bl3);
                int n6 = interruptGate32Bit.getTargetSegment();
                if ((n6 & 0xFFFC) == 0) {
                    throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, 0, true);
                }
                try {
                    segment3 = this.getSegment(n6);
                }
                catch (ProcessorException processorException) {
                    throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n6, true);
                }
                if (segment3.getDPL() > this.currentPrivilegeLevel | segment3.isSystem()) {
                    throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n6 & 0xFFFC, true);
                }
                if (!segment3.isPresent()) {
                    throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, n6 & 0xFFFC, true);
                }
                switch (segment3.getType()) {
                    default: {
                        System.err.println("Emulated: " + segment3);
                        throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n6 & 0xFFFC, true);
                    }
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: {
                        if (segment3.getDPL() < this.currentPrivilegeLevel) {
                            int n7;
                            if (segment3.getDPL() != 0) {
                                throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n6 & 0xFFFC, true);
                            }
                            int n8 = 0;
                            int n9 = 0;
                            if ((this.tss.getType() & 8) != 0) {
                                n7 = segment3.getDPL() * 8 + 4;
                                if (n7 + 7 > this.tss.getLimit()) {
                                    throw new ProcessorException(ProcessorException.Type.TASK_SWITCH, this.tss.getSelector(), true);
                                }
                                bl4 = this.linearMemory.isSupervisor();
                                try {
                                    this.linearMemory.setSupervisor(true);
                                    n8 = 0xFFFF & this.tss.getWord(n7 + 4);
                                    n9 = this.tss.getDoubleWord(n7);
                                }
                                finally {
                                    this.linearMemory.setSupervisor(bl4);
                                }
                            } else {
                                n7 = segment3.getDPL() * 4 + 2;
                                if (n7 + 4 > this.tss.getLimit()) {
                                    throw new ProcessorException(ProcessorException.Type.TASK_SWITCH, this.tss.getSelector(), true);
                                }
                                n8 = 0xFFFF & this.tss.getWord(n7 + 2);
                                n9 = 0xFFFF & this.tss.getWord(n7);
                            }
                            if ((n8 & 0xFFFC) == 0) {
                                throw new ProcessorException(ProcessorException.Type.TASK_SWITCH, 0, true);
                            }
                            Segment segment4 = null;
                            try {
                                segment4 = this.getSegment(n8);
                            }
                            catch (ProcessorException processorException) {
                                throw new ProcessorException(ProcessorException.Type.TASK_SWITCH, n8, true);
                            }
                            if (segment4.getRPL() != segment3.getDPL()) {
                                throw new ProcessorException(ProcessorException.Type.TASK_SWITCH, n8 & 0xFFFC, true);
                            }
                            if (segment4.getDPL() != segment3.getDPL() || (segment4.getType() & 0x1A) != 18) {
                                throw new ProcessorException(ProcessorException.Type.TASK_SWITCH, n8 & 0xFFFC, true);
                            }
                            if (segment4.isSystem()) {
                                throw new ProcessorException(ProcessorException.Type.TASK_SWITCH, n8 & 0xFFFC, true);
                            }
                            if (!segment4.isPresent()) {
                                throw new ProcessorException(ProcessorException.Type.STACK_SEGMENT, n8, true);
                            }
                            if (bl ? segment4.getDefaultSizeFlag() && this.esp < 40 && this.esp > 0 || !segment4.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 40 && this.esp > 0 : segment4.getDefaultSizeFlag() && this.esp < 36 && this.esp > 0 || !segment4.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 36 && this.esp > 0) {
                                throw new ProcessorException(ProcessorException.Type.STACK_SEGMENT, 0, true);
                            }
                            int n10 = interruptGate32Bit.getTargetOffset();
                            segment3.checkAddress(n10);
                            int n11 = this.ss.getSelector() & 0xFFFF;
                            int n12 = this.esp;
                            int n13 = this.cs.getSelector() & 0xFFFF;
                            int n14 = this.eip & 0xFFFF;
                            this.ss = segment4;
                            this.esp = n9;
                            this.ss.setRPL(segment3.getDPL());
                            this.cs = segment3;
                            this.eip = n10;
                            this.setCPL(this.cs.getDPL());
                            this.cs.setRPL(this.cs.getDPL());
                            if (this.ss.getDefaultSizeFlag()) {
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, this.gs.getSelector() & 0xFFFF);
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, this.fs.getSelector() & 0xFFFF);
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, this.ds.getSelector() & 0xFFFF);
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, this.es.getSelector() & 0xFFFF);
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, n11);
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, n12);
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, this.getEFlags());
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, n13);
                                this.esp -= 4;
                                this.ss.setDoubleWord(this.esp, n14);
                                if (bl) {
                                    this.esp -= 4;
                                    this.ss.setDoubleWord(this.esp, n2);
                                }
                            } else {
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, this.gs.getSelector() & 0xFFFF);
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, this.fs.getSelector() & 0xFFFF);
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, this.ds.getSelector() & 0xFFFF);
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, this.es.getSelector() & 0xFFFF);
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, n11);
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, n12);
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, this.getEFlags());
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, n13);
                                this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                this.ss.setDoubleWord(this.esp & 0xFFFF, n14);
                                if (bl) {
                                    this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                                    this.ss.setDoubleWord(this.esp & 0xFFFF, n2);
                                }
                            }
                            this.gs = SegmentFactory.NULL_SEGMENT;
                            this.fs = SegmentFactory.NULL_SEGMENT;
                            this.ds = SegmentFactory.NULL_SEGMENT;
                            this.es = SegmentFactory.NULL_SEGMENT;
                            this.eflagsInterruptEnableSoon = false;
                            this.eflagsInterruptEnable = false;
                            this.eflagsTrap = false;
                            this.eflagsNestedTask = false;
                            this.eflagsVirtual8086Mode = false;
                            this.eflagsResume = false;
                            throw ModeSwitchException.PROTECTED_MODE_EXCEPTION;
                        }
                        System.err.println("Critical error: Unimplemented same level exception in VM86 32 bit INT gate (non conforming code segment)...");
                        throw new IllegalStateException("Unimplemented same level exception in VM86 32 bit INT gate (non conforming code segment)...");
                    }
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                }
                throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n6, true);
            }
            case 15: 
        }
        ProtectedModeSegment.TrapGate32Bit trapGate32Bit = (ProtectedModeSegment.TrapGate32Bit)segment2;
        this.checkGate(segment2, n4, bl3);
        int n15 = trapGate32Bit.getTargetSegment();
        if ((n15 & 0xFFFC) == 0) {
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, 0, true);
        }
        try {
            segment = this.getSegment(n15);
        }
        catch (ProcessorException processorException) {
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, (n15 & 0xFFFC) + n3, true);
        }
        if (segment.getDPL() > this.currentPrivilegeLevel) {
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, (n15 & 0xFFFC) + n3, true);
        }
        if (segment.isSystem()) {
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, (n15 & 0xFFFC) + n3, true);
        }
        switch (segment.getType()) {
            default: {
                throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n15 + n3, true);
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                if (!segment.isPresent()) {
                    throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, n15 + n3, true);
                }
                if (segment.getDPL() < this.currentPrivilegeLevel) {
                    int n16;
                    if (segment.getDPL() != 0) {
                        throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n15 & 0xFFFC, true);
                    }
                    int n17 = 0;
                    int n18 = 0;
                    if ((this.tss.getType() & 8) != 0) {
                        n16 = segment.getDPL() * 8 + 4;
                        if (n16 + 7 > this.tss.getLimit()) {
                            throw new ProcessorException(ProcessorException.Type.TASK_SWITCH, this.tss.getSelector(), true);
                        }
                        bl4 = this.linearMemory.isSupervisor();
                        try {
                            this.linearMemory.setSupervisor(true);
                            n17 = 0xFFFF & this.tss.getWord(n16 + 4);
                            n18 = this.tss.getDoubleWord(n16);
                        }
                        finally {
                            this.linearMemory.setSupervisor(bl4);
                        }
                    } else {
                        n16 = segment.getDPL() * 4 + 2;
                        if (n16 + 4 > this.tss.getLimit()) {
                            throw new ProcessorException(ProcessorException.Type.TASK_SWITCH, this.tss.getSelector(), true);
                        }
                        n17 = 0xFFFF & this.tss.getWord(n16 + 2);
                        n18 = 0xFFFF & this.tss.getWord(n16);
                    }
                    if ((n17 & 0xFFFC) == 0) {
                        throw new ProcessorException(ProcessorException.Type.TASK_SWITCH, 0, true);
                    }
                    Segment segment5 = null;
                    try {
                        segment5 = this.getSegment(n17);
                    }
                    catch (ProcessorException processorException) {
                        throw new ProcessorException(ProcessorException.Type.TASK_SWITCH, n17 + n3, true);
                    }
                    if (segment5.getRPL() != segment.getDPL()) {
                        throw new ProcessorException(ProcessorException.Type.TASK_SWITCH, n17 & 0xFFFC, true);
                    }
                    if (segment5.getDPL() != segment.getDPL() || (segment5.getType() & 0x1A) != 18) {
                        throw new ProcessorException(ProcessorException.Type.TASK_SWITCH, n17 & 0xFFFC, true);
                    }
                    if (segment5.isSystem()) {
                        throw new ProcessorException(ProcessorException.Type.TASK_SWITCH, n17 & 0xFFFC, true);
                    }
                    if (!segment5.isPresent()) {
                        throw new ProcessorException(ProcessorException.Type.STACK_SEGMENT, n17 & 0xFFFC, true);
                    }
                    if (bl ? segment5.getDefaultSizeFlag() && this.esp < 40 && this.esp > 0 || !segment5.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 40 && this.esp > 0 : segment5.getDefaultSizeFlag() && this.esp < 36 && this.esp > 0 || !segment5.getDefaultSizeFlag() && (this.esp & 0xFFFF) < 36 && this.esp > 0) {
                        throw new ProcessorException(ProcessorException.Type.STACK_SEGMENT, 0, true);
                    }
                    int n19 = trapGate32Bit.getTargetOffset();
                    segment.checkAddress(n19);
                    int n20 = this.ss.getSelector() & 0xFFFF;
                    int n21 = this.esp;
                    int n22 = this.cs.getSelector() & 0xFFFF;
                    int n23 = this.eip & 0xFFFF;
                    this.ss = segment5;
                    this.esp = n18;
                    this.ss.setRPL(segment.getDPL());
                    this.cs = segment;
                    this.eip = n19;
                    this.setCPL(this.cs.getDPL());
                    if (this.ss.getDefaultSizeFlag()) {
                        this.esp -= 4;
                        this.ss.setDoubleWord(this.esp, this.gs.getSelector() & 0xFFFF);
                        this.esp -= 4;
                        this.ss.setDoubleWord(this.esp, this.fs.getSelector() & 0xFFFF);
                        this.esp -= 4;
                        this.ss.setDoubleWord(this.esp, this.ds.getSelector() & 0xFFFF);
                        this.esp -= 4;
                        this.ss.setDoubleWord(this.esp, this.es.getSelector() & 0xFFFF);
                        this.esp -= 4;
                        this.ss.setDoubleWord(this.esp, n20);
                        this.esp -= 4;
                        this.ss.setDoubleWord(this.esp, n21);
                        this.esp -= 4;
                        this.ss.setDoubleWord(this.esp, this.getEFlags());
                        this.esp -= 4;
                        this.ss.setDoubleWord(this.esp, n22);
                        this.esp -= 4;
                        this.ss.setDoubleWord(this.esp, n23);
                        if (bl) {
                            this.esp -= 4;
                            this.ss.setDoubleWord(this.esp, n2);
                        }
                    } else {
                        this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                        this.ss.setDoubleWord(this.esp & 0xFFFF, this.gs.getSelector() & 0xFFFF);
                        this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                        this.ss.setDoubleWord(this.esp & 0xFFFF, this.fs.getSelector() & 0xFFFF);
                        this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                        this.ss.setDoubleWord(this.esp & 0xFFFF, this.ds.getSelector() & 0xFFFF);
                        this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                        this.ss.setDoubleWord(this.esp & 0xFFFF, this.es.getSelector() & 0xFFFF);
                        this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                        this.ss.setDoubleWord(this.esp & 0xFFFF, n20);
                        this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                        this.ss.setDoubleWord(this.esp & 0xFFFF, n21);
                        this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                        this.ss.setDoubleWord(this.esp & 0xFFFF, this.getEFlags());
                        this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                        this.ss.setDoubleWord(this.esp & 0xFFFF, n22);
                        this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                        this.ss.setDoubleWord(this.esp & 0xFFFF, n23);
                        if (bl) {
                            this.esp = this.esp & 0xFFFF0000 | this.esp - 4 & 0xFFFF;
                            this.ss.setDoubleWord(this.esp & 0xFFFF, n2);
                        }
                    }
                    this.gs = SegmentFactory.NULL_SEGMENT;
                    this.fs = SegmentFactory.NULL_SEGMENT;
                    this.ds = SegmentFactory.NULL_SEGMENT;
                    this.es = SegmentFactory.NULL_SEGMENT;
                    this.eflagsTrap = false;
                    this.eflagsNestedTask = false;
                    this.eflagsVirtual8086Mode = false;
                    this.eflagsResume = false;
                    throw ModeSwitchException.PROTECTED_MODE_EXCEPTION;
                }
                System.err.println("Critical error: Unimplemented same level exception in VM86 32 bit TRAP gate (non conforming code segment)...");
                throw new IllegalStateException("Unimplemented same level exception in VM86 32 bit TRAP gate (non conforming code segment)...");
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
        }
        if (!segment.isPresent()) {
            throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, n4, true);
        }
        throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n15, true);
    }

    private void checkAlignmentChecking() {
        if (this.getCPL() == 3 && this.eflagsAlignmentCheck && (this.cr0 & 0x40000) != 0) {
            if (!this.alignmentChecking) {
                System.err.println("Emulated: Alignment checking enabled");
                this.alignmentChecking = true;
                this.updateAlignmentCheckingInDataSegments();
            }
        } else if (this.alignmentChecking) {
            System.err.println("Emulated: Alignment checking disabled");
            this.alignmentChecking = false;
            this.updateAlignmentCheckingInDataSegments();
        }
    }

    @Override
    public boolean initialised() {
        boolean bl;
        boolean bl2 = bl = this.physicalMemory != null && this.linearMemory != null && this.ioports != null && this.interruptController != null;
        if (bl && !this.started) {
            this.reset();
            this.started = true;
        }
        return bl;
    }

    @Override
    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof LinearAddressSpace) {
            this.linearMemory = (LinearAddressSpace)hardwareComponent;
            this.alignmentCheckedMemory = new AlignmentCheckedAddressSpace(this.linearMemory);
        }
        if (hardwareComponent instanceof PhysicalAddressSpace) {
            this.physicalMemory = (PhysicalAddressSpace)hardwareComponent;
        }
        if (hardwareComponent instanceof IOPortHandler) {
            this.ioports = (IOPortHandler)hardwareComponent;
        }
        if (hardwareComponent instanceof InterruptController && hardwareComponent.initialised()) {
            this.interruptController = (InterruptController)hardwareComponent;
        }
    }

    public boolean getAuxiliaryCarryFlag() {
        if (this.auxiliaryCarryCalculated) {
            return this.eflagsAuxiliaryCarry;
        }
        this.auxiliaryCarryCalculated = true;
        if (this.auxiliaryCarryMethod == 1) {
            this.eflagsAuxiliaryCarry = ((this.auxiliaryCarryOne ^ this.auxiliaryCarryTwo ^ this.auxiliaryCarryThree) & 0x10) != 0;
            return this.eflagsAuxiliaryCarry;
        }
        if (this.auxiliaryCarryMethod == 3) {
            this.eflagsAuxiliaryCarry = (this.auxiliaryCarryOne & 0xF) == 15;
            return this.eflagsAuxiliaryCarry;
        }
        if (this.auxiliaryCarryMethod == 4) {
            this.eflagsAuxiliaryCarry = (this.auxiliaryCarryOne & 0xF) == 0;
            return this.eflagsAuxiliaryCarry;
        }
        switch (this.auxiliaryCarryMethod) {
            case 2: {
                this.eflagsAuxiliaryCarry = (this.auxiliaryCarryOne & 8) != (this.auxiliaryCarryTwo & 8);
                return this.eflagsAuxiliaryCarry;
            }
            case 5: {
                this.eflagsAuxiliaryCarry = (this.auxiliaryCarryOne & 0xF) != 0;
                return this.eflagsAuxiliaryCarry;
            }
        }
        System.err.println("Warning: Missing auxiliary-carry flag calculation method");
        return this.eflagsAuxiliaryCarry;
    }

    public void setAuxiliaryCarryFlag(int n, int n2, int n3, int n4) {
        this.auxiliaryCarryCalculated = false;
        this.auxiliaryCarryOne = n;
        this.auxiliaryCarryTwo = n2;
        this.auxiliaryCarryThree = n3;
        this.auxiliaryCarryMethod = n4;
    }

    public void setAuxiliaryCarryFlag(int n, int n2, int n3) {
        this.auxiliaryCarryCalculated = false;
        this.auxiliaryCarryOne = n;
        this.auxiliaryCarryTwo = n2;
        this.auxiliaryCarryMethod = n3;
    }

    public void setAuxiliaryCarryFlag(int n, int n2) {
        this.auxiliaryCarryCalculated = false;
        this.auxiliaryCarryOne = n;
        this.auxiliaryCarryMethod = n2;
    }

    public void setAuxiliaryCarryFlag(boolean bl) {
        this.auxiliaryCarryCalculated = true;
        this.eflagsAuxiliaryCarry = bl;
    }

    public boolean getParityFlag() {
        if (this.parityCalculated) {
            return this.eflagsParity;
        }
        this.parityCalculated = true;
        this.eflagsParity = parityMap[this.parityOne & 0xFF];
        return this.eflagsParity;
    }

    public void setParityFlag(boolean bl) {
        this.parityCalculated = true;
        this.eflagsParity = bl;
    }

    public void setParityFlag(int n) {
        this.parityCalculated = false;
        this.parityOne = n;
    }

    public boolean getOverflowFlag() {
        if (this.overflowCalculated) {
            return this.eflagsOverflow;
        }
        this.overflowCalculated = true;
        if (this.overflowMethod == 22) {
            return (this.overflowTwo & 0x80) == (this.overflowThree & 0x80) && (this.overflowTwo & 0x80) != (this.overflowOne & 0x80);
        }
        if (this.overflowMethod == 23) {
            return (this.overflowTwo & 0x8000) == (this.overflowThree & 0x8000) && (this.overflowTwo & 0x8000) != (this.overflowOne & 0x8000);
        }
        if (this.overflowMethod == 24) {
            return (this.overflowTwo & Integer.MIN_VALUE) == (this.overflowThree & Integer.MIN_VALUE) && (this.overflowTwo & Integer.MIN_VALUE) != (this.overflowOne & Integer.MIN_VALUE);
        }
        if (this.overflowMethod == 25) {
            return (this.overflowTwo & 0x80) != (this.overflowThree & 0x80) && (this.overflowTwo & 0x80) != (this.overflowOne & 0x80);
        }
        if (this.overflowMethod == 26) {
            return (this.overflowTwo & 0x8000) != (this.overflowThree & 0x8000) && (this.overflowTwo & 0x8000) != (this.overflowOne & 0x8000);
        }
        if (this.overflowMethod == 27) {
            return (this.overflowTwo & Integer.MIN_VALUE) != (this.overflowThree & Integer.MIN_VALUE) && (this.overflowTwo & Integer.MIN_VALUE) != (this.overflowOne & Integer.MIN_VALUE);
        }
        if (this.overflowMethod == 16) {
            this.eflagsOverflow = this.overflowOne == 127;
            return this.eflagsOverflow;
        }
        if (this.overflowMethod == 17) {
            this.eflagsOverflow = this.overflowOne == Short.MAX_VALUE;
            return this.eflagsOverflow;
        }
        if (this.overflowMethod == 20) {
            this.eflagsOverflow = this.overflowOne == Short.MIN_VALUE;
            return this.eflagsOverflow;
        }
        if (this.overflowMethod == 10) {
            this.eflagsOverflow = (this.overflowOne & 0x8000) != 0 ^ this.getCarryFlag();
            return this.eflagsOverflow;
        }
        switch (this.overflowMethod) {
            case 1: {
                this.eflagsOverflow = this.overflowOne != 0;
                return this.eflagsOverflow;
            }
            case 2: {
                this.eflagsOverflow = this.overflowOne != (byte)this.overflowOne;
                return this.eflagsOverflow;
            }
            case 3: {
                this.eflagsOverflow = this.overflowOne != (short)this.overflowOne;
                return this.eflagsOverflow;
            }
            case 4: {
                this.eflagsOverflow = this.overflowLong != (long)((int)this.overflowLong);
                return this.eflagsOverflow;
            }
            case 5: {
                this.eflagsOverflow = (this.overflowOne & 0xFFFF) != 0;
                return this.eflagsOverflow;
            }
            case 6: {
                this.eflagsOverflow = (this.overflowOne & 0xFF00) != 0;
                return this.eflagsOverflow;
            }
            case 7: {
                this.eflagsOverflow = (this.overflowOne & 0x40) != 0 ^ this.getCarryFlag();
                return this.eflagsOverflow;
            }
            case 8: {
                this.eflagsOverflow = (this.overflowOne & 0x80) != 0 ^ this.getCarryFlag();
                return this.eflagsOverflow;
            }
            case 9: {
                this.eflagsOverflow = (this.overflowOne & 0x4000) != 0 ^ this.getCarryFlag();
                return this.eflagsOverflow;
            }
            case 11: {
                this.eflagsOverflow = (this.overflowOne & 0x40000000) != 0 ^ this.getCarryFlag();
                return this.eflagsOverflow;
            }
            case 12: {
                this.eflagsOverflow = (this.overflowOne & Integer.MIN_VALUE) != 0 ^ this.getCarryFlag();
                return this.eflagsOverflow;
            }
            case 13: {
                this.eflagsOverflow = (this.overflowOne & 0x80) != (this.overflowTwo & 0x80);
                return this.eflagsOverflow;
            }
            case 14: {
                this.eflagsOverflow = (this.overflowOne & 0x8000) != (this.overflowTwo & 0x8000);
                return this.eflagsOverflow;
            }
            case 15: {
                this.eflagsOverflow = (this.overflowOne & Integer.MIN_VALUE) != (this.overflowTwo & Integer.MIN_VALUE);
                return this.eflagsOverflow;
            }
            case 18: {
                this.eflagsOverflow = this.overflowOne == Integer.MAX_VALUE;
                return this.eflagsOverflow;
            }
            case 19: {
                this.eflagsOverflow = this.overflowOne == -128;
                return this.eflagsOverflow;
            }
            case 21: {
                this.eflagsOverflow = this.overflowOne == Integer.MIN_VALUE;
                return this.eflagsOverflow;
            }
        }
        System.err.println("Warning: Missing overflow flag calculation method");
        return this.eflagsOverflow;
    }

    public void setOverflowFlag(boolean bl) {
        this.overflowCalculated = true;
        this.eflagsOverflow = bl;
    }

    public void setOverflowFlag(long l, int n) {
        this.overflowCalculated = false;
        this.overflowLong = l;
        this.overflowMethod = n;
    }

    public void setOverflowFlag(int n, int n2) {
        this.overflowCalculated = false;
        this.overflowOne = n;
        this.overflowMethod = n2;
    }

    public void setOverflowFlag(int n, int n2, int n3) {
        this.overflowCalculated = false;
        this.overflowOne = n;
        this.overflowTwo = n2;
        this.overflowMethod = n3;
    }

    public void setOverflowFlag(int n, int n2, int n3, int n4) {
        this.overflowCalculated = false;
        this.overflowOne = n;
        this.overflowTwo = n2;
        this.overflowThree = n3;
        this.overflowMethod = n4;
    }

    public boolean getCarryFlag() {
        if (this.carryCalculated) {
            return this.eflagsCarry;
        }
        this.carryCalculated = true;
        if (this.carryMethod == 10) {
            this.eflagsCarry = (this.carryOne & 0xFFFF0000) != 0;
            return this.eflagsCarry;
        }
        if (this.carryMethod == 9) {
            this.eflagsCarry = (this.carryOne & 0xFFFFFF00) != 0;
            return this.eflagsCarry;
        }
        if (this.carryMethod == 15) {
            this.eflagsCarry = (this.carryOne >>> this.carryTwo - 1 & 1) != 0;
            return this.eflagsCarry;
        }
        if (this.carryMethod == 11) {
            this.eflagsCarry = (this.carryLong & 0xFFFFFFFF00000000L) != 0L;
            return this.eflagsCarry;
        }
        if (this.carryMethod == 13) {
            this.eflagsCarry = (this.carryOne << this.carryTwo - 1 & 0x8000) != 0;
            return this.eflagsCarry;
        }
        switch (this.carryMethod) {
            case 1: {
                this.eflagsCarry = this.carryOne != 0;
                return this.eflagsCarry;
            }
            case 2: {
                this.eflagsCarry = this.carryOne != (byte)this.carryOne;
                return this.eflagsCarry;
            }
            case 3: {
                this.eflagsCarry = this.carryOne != (short)this.carryOne;
                return this.eflagsCarry;
            }
            case 4: {
                this.eflagsCarry = this.carryLong != (long)((int)this.carryLong);
                return this.eflagsCarry;
            }
            case 5: {
                this.eflagsCarry = (this.carryOne & 0xFFFF) != 0;
                return this.eflagsCarry;
            }
            case 6: {
                this.eflagsCarry = (this.carryOne & 0xFF00) != 0;
                return this.eflagsCarry;
            }
            case 7: {
                this.eflagsCarry = (this.carryOne & 1 << this.carryTwo) != 0;
                return this.eflagsCarry;
            }
            case 8: {
                this.eflagsCarry = this.carryOne > 255;
                return this.eflagsCarry;
            }
            case 12: {
                this.eflagsCarry = (this.carryOne << this.carryTwo - 1 & 0x80) != 0;
                return this.eflagsCarry;
            }
            case 14: {
                this.eflagsCarry = (this.carryOne << this.carryTwo - 1 & Integer.MIN_VALUE) != 0;
                return this.eflagsCarry;
            }
            case 16: {
                this.eflagsCarry = (this.carryOne & 1) != 0;
                return this.eflagsCarry;
            }
            case 17: {
                this.eflagsCarry = (this.carryOne & 0x80) != 0;
                return this.eflagsCarry;
            }
            case 18: {
                this.eflagsCarry = (this.carryOne & 0x8000) != 0;
                return this.eflagsCarry;
            }
            case 19: {
                this.eflagsCarry = (this.carryOne & Integer.MIN_VALUE) != 0;
                return this.eflagsCarry;
            }
            case 20: {
                this.eflagsCarry = (this.carryOne & 0x100) != 0;
                return this.eflagsCarry;
            }
            case 21: {
                this.eflagsCarry = (this.carryOne & 0x10000) != 0;
                return this.eflagsCarry;
            }
            case 22: {
                this.eflagsCarry = (this.carryLong & 0x100000000L) != 0L;
                return this.eflagsCarry;
            }
        }
        System.err.println("Warning: Missing carry flag calculation method");
        return this.eflagsCarry;
    }

    public void setCarryFlag(boolean bl) {
        this.carryCalculated = true;
        this.eflagsCarry = bl;
    }

    public void setCarryFlag(long l, int n) {
        this.carryCalculated = false;
        this.carryLong = l;
        this.carryMethod = n;
    }

    public void setCarryFlag(int n, int n2) {
        this.carryCalculated = false;
        this.carryOne = n;
        this.carryMethod = n2;
    }

    public void setCarryFlag(int n, int n2, int n3) {
        this.carryCalculated = false;
        this.carryOne = n;
        this.carryTwo = n2;
        this.carryMethod = n3;
    }

    public boolean getZeroFlag() {
        if (this.zeroCalculated) {
            return this.eflagsZero;
        }
        this.zeroCalculated = true;
        this.eflagsZero = this.zeroOne == 0;
        return this.eflagsZero;
    }

    public void setZeroFlag(boolean bl) {
        this.zeroCalculated = true;
        this.eflagsZero = bl;
    }

    public void setZeroFlag(int n) {
        this.zeroCalculated = false;
        this.zeroOne = n;
    }

    public boolean getSignFlag() {
        if (this.signCalculated) {
            return this.eflagsSign;
        }
        this.signCalculated = true;
        this.eflagsSign = this.signOne < 0;
        return this.eflagsSign;
    }

    public void setSignFlag(boolean bl) {
        this.signCalculated = true;
        this.eflagsSign = bl;
    }

    public void setSignFlag(int n) {
        this.signCalculated = false;
        this.signOne = n;
    }

    static {
        for (int i = 0; i < parityMap.length; ++i) {
            Processor.parityMap[i] = (Integer.bitCount(i) & 1) == 0;
        }
    }

    public static class TripleFault
    extends IllegalStateException {
        private static final long serialVersionUID = 7L;

        public TripleFault(String string) {
            super(string);
        }
    }
}

