/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.processor;

import java.io.IOException;
import org.jpc.emulator.SRDumpable;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;

public final class ProcessorException
extends RuntimeException
implements SRDumpable {
    private static final long serialVersionUID = 4L;
    public static final ProcessorException DIVIDE_ERROR = new ProcessorException(Type.DIVIDE_ERROR, true);
    public static final ProcessorException BOUND_RANGE = new ProcessorException(Type.BOUND_RANGE, true);
    public static final ProcessorException UNDEFINED = new ProcessorException(Type.UNDEFINED, true);
    public static final ProcessorException DOUBLE_FAULT_0 = new ProcessorException(Type.DOUBLE_FAULT, 0, true);
    public static final ProcessorException STACK_SEGMENT_0 = new ProcessorException(Type.STACK_SEGMENT, 0, true);
    public static final ProcessorException GENERAL_PROTECTION_0 = new ProcessorException(Type.GENERAL_PROTECTION, 0, true);
    public static final ProcessorException FLOATING_POINT = new ProcessorException(Type.FLOATING_POINT, true);
    public static final ProcessorException ALIGNMENT_CHECK_0 = new ProcessorException(Type.ALIGNMENT_CHECK, 0, true);
    public static final ProcessorException FPU_NA_0 = new ProcessorException(Type.NO_FPU, true);
    public static final ProcessorException TRACESTOP = new ProcessorException(Type.TRACESTOP, true);
    public static final ProcessorException SELFMODIFIED = new ProcessorException(Type.SELFMODIFIED, true);
    private final Type type;
    private final int errorCode;
    private final boolean pointsToSelf;
    private final boolean hasErrorCode;

    public void dumpStatusPartial(StatusDumper statusDumper) {
        statusDumper.println("\ttype " + (Object)((Object)this.type) + " errorCode " + this.errorCode + " pointsToSelf" + this.pointsToSelf);
        statusDumper.println("\thasErrorCode" + this.hasErrorCode);
    }

    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": ProcessorException:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        sRDumper.dumpByte(Type.toNumeric(this.type));
        sRDumper.dumpInt(this.errorCode);
        sRDumper.dumpBoolean(this.pointsToSelf);
        sRDumper.dumpBoolean(this.hasErrorCode);
    }

    public ProcessorException(SRLoader sRLoader) throws IOException {
        sRLoader.objectCreated(this);
        this.type = Type.fromNumeric(sRLoader.loadByte());
        this.errorCode = sRLoader.loadInt();
        this.pointsToSelf = sRLoader.loadBoolean();
        this.hasErrorCode = sRLoader.loadBoolean();
    }

    public ProcessorException(Type type, int n, boolean bl) {
        this.type = type;
        this.hasErrorCode = true;
        this.errorCode = n;
        this.pointsToSelf = bl;
    }

    private ProcessorException(Type type, boolean bl) {
        this.type = type;
        this.hasErrorCode = false;
        this.errorCode = 0;
        this.pointsToSelf = bl;
    }

    public Type getType() {
        return this.type;
    }

    public boolean hasErrorCode() {
        return this.hasErrorCode;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public boolean pointsToSelf() {
        return this.pointsToSelf;
    }

    public boolean combinesToDoubleFault(ProcessorException processorException) {
        switch (this.getType()) {
            case DIVIDE_ERROR: 
            case TASK_SWITCH: 
            case NOT_PRESENT: 
            case STACK_SEGMENT: 
            case GENERAL_PROTECTION: {
                switch (processorException.getType()) {
                    case DIVIDE_ERROR: 
                    case TASK_SWITCH: 
                    case NOT_PRESENT: 
                    case STACK_SEGMENT: 
                    case GENERAL_PROTECTION: 
                    case PAGE_FAULT: {
                        return true;
                    }
                }
                return false;
            }
            case PAGE_FAULT: {
                return processorException.getType() == Type.PAGE_FAULT;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        if (this.hasErrorCode()) {
            return "Processor Exception: " + (Object)((Object)this.type) + " [errorcode:0x" + Integer.toHexString(this.getErrorCode()) + "]";
        }
        return "Processor Exception: " + (Object)((Object)this.type);
    }

    public static enum Type {
        DIVIDE_ERROR(0),
        DEBUG(1),
        BREAKPOINT(3),
        OVERFLOW(4),
        BOUND_RANGE(5),
        UNDEFINED(6),
        NO_FPU(7),
        DOUBLE_FAULT(8),
        FPU_SEGMENT_OVERRUN(9),
        TASK_SWITCH(10),
        NOT_PRESENT(11),
        STACK_SEGMENT(12),
        GENERAL_PROTECTION(13),
        PAGE_FAULT(14),
        FLOATING_POINT(16),
        ALIGNMENT_CHECK(17),
        MACHINE_CHECK(18),
        SIMD_FLOATING_POINT(19),
        TRACESTOP(20),
        SELFMODIFIED(21);

        private final int vector;

        private Type(int n2) {
            this.vector = n2;
        }

        public int vector() {
            return this.vector;
        }

        static Type fromNumeric(byte by) {
            for (Type type : Type.values()) {
                if (by != type.vector + 1) continue;
                return type;
            }
            return null;
        }

        static byte toNumeric(Type type) {
            for (Type type2 : Type.values()) {
                if (type != type2) continue;
                return (byte)(type2.vector + 1);
            }
            return 0;
        }
    }
}

