/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.processor.fpu64;

import java.io.IOException;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.processor.Processor;
import org.jpc.emulator.processor.ProcessorException;
import org.jpc.emulator.processor.Segment;
import org.jpc.emulator.processor.fpu64.FpuState;

public class FpuState64
extends FpuState {
    public static final int FPU_SPECIAL_TAG_NONE = 0;
    public static final int FPU_SPECIAL_TAG_NAN = 1;
    public static final int FPU_SPECIAL_TAG_UNSUPPORTED = 2;
    public static final int FPU_SPECIAL_TAG_INFINITY = 3;
    public static final int FPU_SPECIAL_TAG_DENORMAL = 4;
    public static final int FPU_SPECIAL_TAG_SNAN = 5;
    public static final double UNDERFLOW_THRESHOLD = Math.pow(2.0, -1022.0);
    private final Processor cpu;
    double[] data;
    int[] tag;
    int[] specialTag;
    public long lastIP;
    public long lastData;
    public int lastOpcode;
    public boolean infinityControl;
    public int conditionCode;
    public int top;
    private int statusWord;
    private boolean invalidOperation;
    private boolean denormalizedOperand;
    private boolean zeroDivide;
    private boolean overflow;
    private boolean underflow;
    private boolean precision;
    private boolean stackFault;
    private int maskWord;
    private int precisionControl;
    private int roundingControl;
    int reg0;
    int reg1;
    int reg2;
    long reg0l;
    boolean protmode;
    double freg0;
    double freg1;
    private static final double L2TEN = Math.log(10.0) / Math.log(2.0);
    private static final double L2E = 1.0 / Math.log(2.0);
    private static final double LOG2 = Math.log(2.0) / Math.log(10.0);
    private static final double LN2 = Math.log(2.0);
    private static final double POS0 = Double.longBitsToDouble(0L);

    @Override
    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": FpuState64:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    @Override
    public void dumpStatusPartial(StatusDumper statusDumper) {
        int n;
        super.dumpStatusPartial(statusDumper);
        statusDumper.println("\tlastIP " + this.lastIP + " lastData " + this.lastData + " lastOpcode " + this.lastOpcode);
        statusDumper.println("\tinfinityControl " + this.infinityControl + " conditionCode " + this.conditionCode + " top " + this.top);
        statusDumper.println("\tstatusWord:" + this.statusWord + (this.invalidOperation ? " INVOP" : "") + (this.denormalizedOperand ? " DENORM" : "") + (this.zeroDivide ? " DIV0" : "") + (this.underflow ? " UNDERFLOW" : "") + (this.overflow ? " OVERFLOW" : "") + (this.precision ? " INEXACT" : "") + (this.stackFault ? " STACKFAULT" : ""));
        for (n = 0; n < this.data.length; ++n) {
            statusDumper.println("\tData#" + n + " " + this.data[n]);
        }
        for (n = 0; n < this.tag.length; ++n) {
            statusDumper.println("\ttag#" + n + " " + this.tag[n]);
        }
        for (n = 0; n < this.specialTag.length; ++n) {
            statusDumper.println("\tspecialTag#" + n + " " + this.specialTag[n]);
        }
        statusDumper.println("\tcpu <object #" + statusDumper.objectNumber(this.cpu) + ">");
        if (this.cpu != null) {
            this.cpu.dumpStatus(statusDumper);
        }
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        super.dumpSRPartial(sRDumper);
        sRDumper.dumpLong(this.lastIP);
        sRDumper.dumpLong(this.lastData);
        sRDumper.dumpInt(this.lastOpcode);
        sRDumper.dumpBoolean(this.infinityControl);
        sRDumper.dumpInt(this.conditionCode);
        sRDumper.dumpInt(this.top);
        sRDumper.dumpObject(this.cpu);
        sRDumper.dumpArray(this.data);
        sRDumper.dumpArray(this.tag);
        sRDumper.dumpArray(this.specialTag);
        sRDumper.dumpInt(this.statusWord);
        sRDumper.dumpBoolean(this.invalidOperation);
        sRDumper.dumpBoolean(this.denormalizedOperand);
        sRDumper.dumpBoolean(this.zeroDivide);
        sRDumper.dumpBoolean(this.overflow);
        sRDumper.dumpBoolean(this.underflow);
        sRDumper.dumpBoolean(this.precision);
        sRDumper.dumpBoolean(this.stackFault);
    }

    public FpuState64(SRLoader sRLoader) throws IOException {
        super(sRLoader);
        this.lastIP = sRLoader.loadLong();
        this.lastData = sRLoader.loadLong();
        this.lastOpcode = sRLoader.loadInt();
        this.infinityControl = sRLoader.loadBoolean();
        this.conditionCode = sRLoader.loadInt();
        this.top = sRLoader.loadInt();
        this.cpu = (Processor)sRLoader.loadObject();
        this.data = sRLoader.loadArrayDouble();
        this.tag = sRLoader.loadArrayInt();
        this.specialTag = sRLoader.loadArrayInt();
        this.statusWord = sRLoader.loadInt();
        this.invalidOperation = sRLoader.loadBoolean();
        this.denormalizedOperand = sRLoader.loadBoolean();
        this.zeroDivide = sRLoader.loadBoolean();
        this.overflow = sRLoader.loadBoolean();
        this.underflow = sRLoader.loadBoolean();
        this.precision = sRLoader.loadBoolean();
        this.stackFault = sRLoader.loadBoolean();
    }

    public boolean getInvalidOperation() {
        return (this.statusWord & 1) != 0;
    }

    public boolean getDenormalizedOperand() {
        return (this.statusWord & 2) != 0;
    }

    public boolean getZeroDivide() {
        return (this.statusWord & 4) != 0;
    }

    public boolean getOverflow() {
        return (this.statusWord & 8) != 0;
    }

    public boolean getUnderflow() {
        return (this.statusWord & 0x10) != 0;
    }

    public boolean getPrecision() {
        return (this.statusWord & 0x20) != 0;
    }

    public boolean getStackFault() {
        return (this.statusWord & 0x40) != 0;
    }

    public void setInvalidOperation() {
        this.statusWord |= 1;
    }

    public void setDenormalizedOperand() {
        this.statusWord |= 2;
    }

    public void setZeroDivide() {
        this.statusWord |= 4;
    }

    public void setOverflow() {
        this.statusWord |= 8;
    }

    public void setUnderflow() {
        this.statusWord |= 0x10;
    }

    public void setPrecision() {
        this.statusWord |= 0x20;
    }

    public void setStackFault() {
        this.statusWord |= 0x40;
    }

    public boolean getBusy() {
        return this.getErrorSummaryStatus();
    }

    public boolean getErrorSummaryStatus() {
        return (this.statusWord & 0x3F & ~this.maskWord) != 0;
    }

    public void checkExceptions() throws ProcessorException {
        if (this.getErrorSummaryStatus()) {
            this.cpu.reportFPUException();
        }
    }

    public void clearExceptions() {
        this.statusWord = 0;
    }

    public boolean getInvalidOperationMask() {
        return (this.maskWord & 1) != 0;
    }

    public boolean getDenormalizedOperandMask() {
        return (this.maskWord & 2) != 0;
    }

    public boolean getZeroDivideMask() {
        return (this.maskWord & 4) != 0;
    }

    public boolean getOverflowMask() {
        return (this.maskWord & 8) != 0;
    }

    public boolean getUnderflowMask() {
        return (this.maskWord & 0x10) != 0;
    }

    public boolean getPrecisionMask() {
        return (this.maskWord & 0x20) != 0;
    }

    public int getPrecisionControl() {
        return this.precisionControl;
    }

    public int getRoundingControl() {
        return this.roundingControl;
    }

    public void setInvalidOperationMask(boolean bl) {
        this.maskWord = bl ? (this.maskWord |= 1) : (this.maskWord &= 0xFFFFFFFE);
    }

    public void setDenormalizedOperandMask(boolean bl) {
        this.maskWord = bl ? (this.maskWord |= 2) : (this.maskWord &= 0xFFFFFFFD);
    }

    public void setZeroDivideMask(boolean bl) {
        this.maskWord = bl ? (this.maskWord |= 4) : (this.maskWord &= 0xFFFFFFFB);
    }

    public void setOverflowMask(boolean bl) {
        this.maskWord = bl ? (this.maskWord |= 8) : (this.maskWord &= 0xFFFFFFF7);
    }

    public void setUnderflowMask(boolean bl) {
        this.maskWord = bl ? (this.maskWord |= 0x10) : (this.maskWord &= 0xFFFFFFEF);
    }

    public void setPrecisionMask(boolean bl) {
        this.maskWord = bl ? (this.maskWord |= 0x20) : (this.maskWord &= 0xFFFFFFDF);
    }

    public void setAllMasks(boolean bl) {
        this.maskWord = bl ? (this.maskWord |= 0x3F) : 0;
    }

    public void setPrecisionControl(int n) {
        if (n != 2) {
            System.err.println("Warning: Only double-precision math is supported by FPU64 X87 emulator.");
        }
        this.precisionControl = 2;
    }

    public void setRoundingControl(int n) {
        if (n != 0) {
            System.err.println("Warning: Only nearest rounding is supported by FPU64 X87 emulator.");
        }
        this.roundingControl = 0;
    }

    public FpuState64(Processor processor) {
        this.cpu = processor;
        this.data = new double[8];
        this.tag = new int[8];
        this.specialTag = new int[8];
        this.init();
    }

    @Override
    public void init() {
        int n;
        for (n = 0; n < this.tag.length; ++n) {
            this.tag[n] = 3;
        }
        for (n = 0; n < this.specialTag.length; ++n) {
            this.specialTag[n] = 0;
        }
        this.clearExceptions();
        this.conditionCode = 0;
        this.top = 0;
        this.setAllMasks(true);
        this.infinityControl = false;
        this.setPrecisionControl(2);
        this.setRoundingControl(0);
        this.lastOpcode = 0;
        this.lastIP = this.lastData = (long)0;
    }

    public int tagCode(double d) {
        if (d == 0.0) {
            return 1;
        }
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return 2;
        }
        return 0;
    }

    public static boolean isDenormal(double d) {
        long l = Double.doubleToRawLongBits(d);
        int n = (int)(l >> 52 & 0x7FFL);
        if (n != 0) {
            return false;
        }
        long l2 = l & 0xFFFFFFFFFFFFFL;
        return l2 != 0L;
    }

    public static boolean isSNaN(long l) {
        int n = (int)(l >> 52 & 0x7FFL);
        if (n != 2047) {
            return false;
        }
        long l2 = l & 0xFFFFFFFFFFFFFL;
        if ((l2 & 0x8000000000000L) != 0L) {
            return false;
        }
        return l2 != 0L;
    }

    public static int specialTagCode(double d) {
        if (Double.isNaN(d)) {
            return 1;
        }
        if (Double.isInfinite(d)) {
            return 3;
        }
        if (FpuState64.isDenormal(d)) {
            return 4;
        }
        return 0;
    }

    public void push(double d) throws ProcessorException {
        if (--this.top < 0) {
            this.top = 7;
        }
        if (this.tag[this.top] != 3) {
            this.setInvalidOperation();
            this.setStackFault();
            this.conditionCode |= 2;
            this.checkExceptions();
        }
        this.data[this.top] = d;
        this.tag[this.top] = this.tagCode(d);
        this.specialTag[this.top] = FpuState64.specialTagCode(d);
    }

    public double pop() throws ProcessorException {
        if (this.tag[this.top] == 3) {
            this.setInvalidOperation();
            this.setStackFault();
            this.conditionCode &= 0xFFFFFFFD;
            this.checkExceptions();
        } else if (this.specialTag[this.top] == 5) {
            this.setInvalidOperation();
            this.checkExceptions();
            return Double.NaN;
        }
        double d = this.data[this.top];
        this.tag[this.top] = 3;
        if (++this.top >= 8) {
            this.top = 0;
        }
        return d;
    }

    public double ST(int n) throws ProcessorException {
        int n2 = this.top + n & 7;
        if (this.tag[n2] == 3) {
            this.setInvalidOperation();
            this.setStackFault();
            this.conditionCode &= 0xFFFFFFFD;
            this.checkExceptions();
        } else if (this.specialTag[n2] == 5) {
            this.setInvalidOperation();
            this.checkExceptions();
            return Double.NaN;
        }
        return this.data[n2];
    }

    public int getTag(int n) {
        int n2 = this.top + n & 7;
        return this.tag[n2];
    }

    public int getSpecialTag(int n) {
        int n2 = this.top + n & 7;
        return this.specialTag[n2];
    }

    public void setTagEmpty(int n) {
        int n2 = this.top + n & 7;
        this.tag[n2] = 3;
    }

    public void setST(int n, double d) {
        int n2 = this.top + n & 7;
        this.data[n2] = d;
        this.tag[n2] = this.tagCode(d);
        this.specialTag[n2] = FpuState64.specialTagCode(d);
    }

    public int getStatus() {
        int n = this.statusWord;
        if (this.getErrorSummaryStatus()) {
            n |= 0x80;
        }
        if (this.getBusy()) {
            n |= 0x8000;
        }
        n |= this.top << 11;
        n |= (this.conditionCode & 7) << 8;
        return n |= (this.conditionCode & 8) << 11;
    }

    public void setStatus(int n) {
        this.statusWord &= 0xFFFFFF80;
        this.statusWord |= n & 0x7F;
        this.top = n >> 11 & 7;
        this.conditionCode = n >> 8 & 7;
        this.conditionCode |= n >>> 14 & 1;
    }

    public int getControl() {
        int n = this.maskWord;
        n |= (this.precisionControl & 3) << 8;
        n |= (this.roundingControl & 3) << 10;
        if (this.infinityControl) {
            n |= 0x1000;
        }
        return n;
    }

    public void setControl(int n) {
        this.maskWord &= 0xFFFFFFC0;
        this.maskWord |= n & 0x3F;
        this.infinityControl = (n & 0x1000) != 0;
        this.setPrecisionControl(n >> 8 & 3);
        this.setRoundingControl(n >> 10 & 3);
    }

    public int getTagWord() {
        int n = 0;
        for (int i = 7; i >= 0; --i) {
            n = n << 2 | this.tag[i] & 3;
        }
        return n;
    }

    public void setTagWord(int n) {
        for (int i = 0; i < this.tag.length; ++i) {
            int n2 = n & 3;
            if (n2 == 3) {
                this.tag[i] = 3;
            } else {
                this.tag[i] = this.tagCode(this.data[i]);
                if (this.specialTag[i] != 5) {
                    this.specialTag[i] = FpuState64.specialTagCode(this.data[i]);
                }
            }
            n >>= 2;
        }
    }

    public static byte[] doubleToExtended(double d, boolean bl) {
        byte[] byArray = new byte[10];
        long l = 0L;
        int n = 0;
        if (bl) {
            l = -4611686018427387904L;
        } else {
            long l2 = Double.doubleToRawLongBits(d);
            l = l2 & 0xFFFFFL;
            n = (int)(l2 >> 52) & 0x7FF;
            boolean bl2 = (l2 & Integer.MIN_VALUE) != 0L;
            l |= 0x100000L;
            l <<= 11;
            n += 15360;
            if (bl2) {
                n |= 0x8000;
            }
        }
        for (int i = 0; i < 8; ++i) {
            byArray[i] = (byte)l;
            l >>>= 8;
        }
        byArray[8] = (byte)n;
        byArray[9] = (byte)(n >>> 8);
        return byArray;
    }

    public static int specialTagCode(byte[] byArray) {
        boolean bl;
        int n;
        long l = 0L;
        for (n = 7; n >= 0; --n) {
            long l2 = (long)byArray[n] & 0xFFL;
            l |= l2;
            l <<= 8;
        }
        n = byArray[8] & 0xFF | (byArray[9] & 0x7F) << 8;
        boolean bl2 = bl = (byArray[7] & 0x80) != 0;
        if (n == 0) {
            if (bl) {
                return 4;
            }
            return 4;
        }
        if (n == Short.MAX_VALUE) {
            if (l == 0L) {
                return 2;
            }
            if (bl) {
                if (l << 1 == 0L) {
                    return 3;
                }
                if (l >>> 62 == 0L) {
                    return 5;
                }
                return 1;
            }
            return 2;
        }
        if (bl) {
            return 0;
        }
        return 2;
    }

    public static double extendedToDouble(byte[] byArray) {
        boolean bl;
        int n;
        long l = 0L;
        for (n = 7; n >= 0; --n) {
            long l2 = (long)byArray[n] & 0xFFL;
            l |= l2;
            l <<= 8;
        }
        n = byArray[8] & 0xFF | (byArray[9] & 0x7F) << 8;
        boolean bl2 = (byArray[9] & 0x80) != 0;
        boolean bl3 = bl = (byArray[7] & 0x80) != 0;
        if (n == 0) {
            if (bl) {
                n = 1;
            }
            return 0.0;
        }
        if (n == Short.MAX_VALUE) {
            if (l == 0L) {
                return Double.NaN;
            }
            if (bl) {
                if (l << 1 == 0L) {
                    return bl2 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                }
                return Double.NaN;
            }
            return Double.NaN;
        }
        if (bl) {
            l >>>= 11;
            if ((n -= 15360) > 2047) {
                return bl2 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            if (n < 0) {
                l >>>= -n;
                n = 0;
            }
            l &= 0xFFFFFFFFFFFFFL;
            l |= ((long)n & 0x7FFL) << 52;
            if (bl2) {
                l |= Integer.MIN_VALUE;
            }
            return Double.longBitsToDouble(l);
        }
        return Double.NaN;
    }

    @Override
    public int doFPUOp(int n, int n2, Segment segment, int n3, int n4, int n5, int n6, long l) {
        this.reg0 = n4;
        this.reg1 = n5;
        this.reg2 = n6;
        this.reg0l = l;
        switch (n) {
            case 506: {
                this.checkExceptions();
                return 0;
            }
            case 662: {
                this.freg0 = this.ST(0);
                this.validateOperand(this.freg0);
                return 0;
            }
            case 663: {
                this.freg0 = this.ST(n2);
                this.validateOperand(this.freg0);
                return 16;
            }
            case 664: {
                int n7 = segment.getDoubleWord(n3);
                this.freg0 = Float.intBitsToFloat(n7);
                if (Double.isNaN(this.freg0) && (n7 & 0x400000) == 0) {
                    this.setInvalidOperation();
                }
                this.validateOperand(this.freg0);
                return 0;
            }
            case 665: {
                long l2 = segment.getQuadWord(n3);
                this.freg0 = Double.longBitsToDouble(l2);
                if (Double.isNaN(this.freg0) && (l2 & 0x8000000000000L) == 0L) {
                    this.setInvalidOperation();
                }
                this.validateOperand(this.freg0);
                return 0;
            }
            case 666: {
                byte[] byArray = new byte[10];
                for (int i = 0; i < 10; ++i) {
                    byArray[i] = segment.getByte(n3 + i);
                }
                this.freg0 = FpuState64.extendedToDouble(byArray);
                if (Double.isNaN(this.freg0) && (Double.doubleToLongBits(this.freg0) & 0x8000000000000L) == 0L) {
                    this.setInvalidOperation();
                }
                this.validateOperand(this.freg0);
                return 0;
            }
            case 667: {
                this.freg0 = this.reg0;
                this.validateOperand(this.freg0);
                return 0;
            }
            case 668: {
                this.freg0 = this.reg0l;
                this.validateOperand(this.freg0);
                return 0;
            }
            case 669: {
                this.freg0 = 1.0;
                return 0;
            }
            case 670: {
                this.freg0 = L2TEN;
                return 0;
            }
            case 671: {
                this.freg0 = L2E;
                return 0;
            }
            case 672: {
                this.freg0 = Math.PI;
                return 0;
            }
            case 673: {
                this.freg0 = LOG2;
                return 0;
            }
            case 674: {
                this.freg0 = LN2;
                return 0;
            }
            case 675: {
                this.freg0 = POS0;
                return 0;
            }
            case 683: {
                this.freg1 = POS0;
                return 0;
            }
            case 749: {
                this.checkExceptions();
                this.clearExceptions();
                return 0;
            }
            case 676: {
                this.freg1 = this.ST(0);
                this.validateOperand(this.freg1);
                return 0;
            }
            case 677: {
                this.freg1 = this.ST(n2);
                this.validateOperand(this.freg1);
                return 16;
            }
            case 678: {
                int n8 = segment.getDoubleWord(n3);
                this.freg1 = Float.intBitsToFloat(n8);
                if (Double.isNaN(this.freg1) && (n8 & 0x400000) == 0) {
                    this.setInvalidOperation();
                }
                this.validateOperand(this.freg1);
                return 0;
            }
            case 679: {
                long l3 = segment.getQuadWord(n3);
                this.freg1 = Double.longBitsToDouble(l3);
                if (Double.isNaN(this.freg1) && (l3 & 0x8000000000000L) == 0L) {
                    this.setInvalidOperation();
                }
                this.validateOperand(this.freg1);
                return 0;
            }
            case 681: {
                this.freg1 = this.reg0;
                this.validateOperand(this.freg1);
                return 0;
            }
            case 682: {
                this.freg1 = this.reg0l;
                this.validateOperand(this.freg1);
                return 0;
            }
            case 684: {
                this.setST(0, this.freg0);
                return 0;
            }
            case 685: {
                this.setST(n2, this.freg0);
                return 16;
            }
            case 686: {
                int n9 = Float.floatToRawIntBits((float)this.freg0);
                segment.setDoubleWord(n3, n9);
                return 0;
            }
            case 687: {
                long l4 = Double.doubleToRawLongBits(this.freg0);
                segment.setQuadWord(n3, l4);
                return 0;
            }
            case 689: {
                this.reg0 = (int)this.freg0;
                return 1;
            }
            case 688: {
                byte[] byArray = FpuState64.doubleToExtended(this.freg0, false);
                for (int i = 0; i < 10; ++i) {
                    segment.setByte(n3 + i, byArray[i]);
                }
                return 0;
            }
            case 690: {
                this.setST(0, this.freg1);
                return 0;
            }
            case 691: {
                this.setST(n2, this.freg1);
                return 16;
            }
            case 692: {
                int n10 = Float.floatToRawIntBits((float)this.freg1);
                segment.setDoubleWord(n3, n10);
                return 0;
            }
            case 693: {
                long l5 = Double.doubleToRawLongBits(this.freg1);
                segment.setQuadWord(n3, l5);
                return 0;
            }
            case 695: {
                this.reg0 = (int)this.freg1;
                return 1;
            }
            case 697: {
                this.setControl(this.reg0);
                return 0;
            }
            case 696: {
                this.reg0 = this.getControl();
                return 1;
            }
            case 699: {
                this.setStatus(this.reg0);
                return 0;
            }
            case 698: {
                this.reg0 = this.getStatus();
                return 1;
            }
            case 704: {
                int n11 = 13;
                if (Double.isNaN(this.freg0) || Double.isNaN(this.freg1)) {
                    this.setInvalidOperation();
                } else {
                    n11 = this.freg0 > this.freg1 ? 0 : (this.freg0 < this.freg1 ? 1 : 8);
                }
                this.conditionCode &= 2;
                this.conditionCode |= n11;
                return 0;
            }
            case 706: {
                int n12 = 13;
                if (Double.isNaN(this.freg0) || Double.isNaN(this.freg1)) {
                    this.setInvalidOperation();
                } else {
                    n12 = this.freg0 > this.freg1 ? 0 : (this.freg0 < this.freg1 ? 1 : 8);
                }
                this.conditionCode &= 2;
                this.conditionCode |= n12;
                return 0;
            }
            case 705: {
                int n13 = 13;
                if (!Double.isNaN(this.freg0) && !Double.isNaN(this.freg1)) {
                    n13 = this.freg0 > this.freg1 ? 0 : (this.freg0 < this.freg1 ? 1 : 8);
                }
                this.conditionCode &= 2;
                this.conditionCode |= n13;
                return 0;
            }
            case 707: {
                int n14 = 13;
                if (!Double.isNaN(this.freg0) && !Double.isNaN(this.freg1)) {
                    n14 = this.freg0 > this.freg1 ? 0 : (this.freg0 < this.freg1 ? 1 : 8);
                }
                this.conditionCode &= 2;
                this.conditionCode |= n14;
                return 0;
            }
            case 700: {
                this.pop();
                return 0;
            }
            case 701: {
                this.push(this.freg0);
                return 0;
            }
            case 710: {
                this.freg0 = -this.freg0;
                return 0;
            }
            case 711: {
                this.freg0 = Math.abs(this.freg0);
                return 0;
            }
            case 712: {
                int n15;
                this.conditionCode = n15 = FpuState64.specialTagCode(this.ST(0));
                return 0;
            }
            case 713: {
                this.setST(0, Math.pow(2.0, this.ST(0)) - 1.0);
                return 0;
            }
            case 702: {
                if (this.freg0 == Double.NEGATIVE_INFINITY && this.freg1 == Double.POSITIVE_INFINITY || this.freg0 == Double.POSITIVE_INFINITY && this.freg1 == Double.NEGATIVE_INFINITY) {
                    this.setInvalidOperation();
                }
                this.freg0 += this.freg1;
                return 0;
            }
            case 703: {
                if (Double.isInfinite(this.freg0) && this.freg1 == 0.0 || Double.isInfinite(this.freg1) && this.freg0 == 0.0) {
                    this.setInvalidOperation();
                }
                this.freg0 *= this.freg1;
                return 0;
            }
            case 708: {
                if (this.freg0 == Double.NEGATIVE_INFINITY && this.freg1 == Double.NEGATIVE_INFINITY || this.freg0 == Double.POSITIVE_INFINITY && this.freg1 == Double.POSITIVE_INFINITY) {
                    this.setInvalidOperation();
                }
                this.freg0 -= this.freg1;
                return 0;
            }
            case 709: {
                if (this.freg0 == 0.0 && this.freg1 == 0.0 || Double.isInfinite(this.freg0) && Double.isInfinite(this.freg1)) {
                    this.setInvalidOperation();
                }
                if (this.freg1 == 0.0 && !Double.isNaN(this.freg0) && !Double.isInfinite(this.freg0)) {
                    this.setZeroDivide();
                }
                this.freg0 /= this.freg1;
                return 0;
            }
            case 723: {
                if (this.freg0 < 0.0) {
                    this.setInvalidOperation();
                }
                this.freg0 = Math.sqrt(this.freg0);
                return 0;
            }
            case 727: {
                if (Double.isInfinite(this.freg0)) {
                    this.setInvalidOperation();
                }
                if (this.freg0 > 9.223372036854776E18 || this.freg0 < -9.223372036854776E18) {
                    this.conditionCode |= 4;
                } else {
                    this.freg0 = Math.sin(this.freg0);
                }
                return 0;
            }
            case 728: {
                if (Double.isInfinite(this.freg0)) {
                    this.setInvalidOperation();
                }
                if (this.freg0 > 9.223372036854776E18 || this.freg0 < -9.223372036854776E18) {
                    this.conditionCode |= 4;
                } else {
                    this.freg0 = Math.cos(this.freg0);
                }
                return 0;
            }
            case 733: {
                this.setTagEmpty(this.reg0);
                return 0;
            }
            case 734: {
                int n16;
                long l6 = 0L;
                long l7 = 1L;
                for (n16 = 0; n16 < 9; ++n16) {
                    byte by = segment.getByte(n3 + n16);
                    l6 += (long)(by & 0xF) * l7;
                    l6 += (long)(by >> 4 & 0xF) * (l7 *= 10L);
                    l7 *= 10L;
                }
                n16 = segment.getByte(n3 + 9);
                double d = l6;
                if (n16 < 0) {
                    d *= -1.0;
                }
                this.freg0 = d;
                return 0;
            }
            case 735: {
                long l8 = (long)Math.abs(this.freg0);
                long l9 = 1L;
                for (int i = 0; i < 9; ++i) {
                    int n17 = (int)(l8 % (l9 * 10L) / l9);
                    byte by = (byte)n17;
                    n17 = (int)(l8 % ((l9 *= 10L) * 10L) / l9);
                    by = (byte)(by | n17 << 4);
                    segment.setByte(n3 + i, by);
                }
                segment.setByte(n3 + 9, this.freg0 < 0.0 ? (byte)-128 : 0);
                return 0;
            }
            case 738: {
                System.err.println("Warning: Using incomplete microcode: FSTENV_14");
                segment.setWord(n3, (short)this.getControl());
                segment.setWord(n3 + 2, (short)this.getStatus());
                segment.setWord(n3 + 4, (short)this.getTagWord());
                segment.setWord(n3 + 6, (short)0);
                segment.setWord(n3 + 8, (short)0);
                segment.setWord(n3 + 10, (short)0);
                segment.setWord(n3 + 12, (short)0);
                return 0;
            }
            case 736: {
                System.err.println("Warning: Using incomplete microcode: FLDENV_14");
                this.setControl(segment.getWord(n3));
                this.setStatus(segment.getWord(n3 + 2));
                this.setTagWord(segment.getWord(n3 + 4));
                return 0;
            }
            case 739: {
                System.err.println("Warning: Using incomplete microcode: FSTENV_28");
                if (segment == null) {
                    System.err.println("Error: FSTENV_28 to NULL segment. Aieee...");
                }
                segment.setDoubleWord(n3, this.getControl() & 0xFFFF);
                segment.setDoubleWord(n3 + 4, this.getStatus() & 0xFFFF);
                segment.setDoubleWord(n3 + 8, this.getTagWord() & 0xFFFF);
                segment.setDoubleWord(n3 + 12, 0);
                segment.setDoubleWord(n3 + 16, 0);
                segment.setDoubleWord(n3 + 20, 0);
                segment.setDoubleWord(n3 + 24, 0);
                return 0;
            }
            case 737: {
                System.err.println("Warning: Using incomplete microcode: FLDENV_28");
                this.setControl(segment.getDoubleWord(n3));
                this.setStatus(segment.getDoubleWord(n3 + 4));
                this.setTagWord(segment.getDoubleWord(n3 + 8));
                return 0;
            }
            case 716: {
                this.freg0 = Math.atan2(this.freg1, this.freg0);
                return 0;
            }
            case 721: {
                int n18 = Math.getExponent(this.freg0) - Math.getExponent(this.freg1);
                if (n18 < 64) {
                    this.conditionCode &= 0xFFFFFFFB;
                    this.freg0 %= this.freg1;
                    long l10 = (long)Math.rint(this.freg0 / this.freg1);
                    this.conditionCode &= 4;
                    if ((l10 & 1L) != 0L) {
                        this.conditionCode |= 2;
                    }
                    if ((l10 & 2L) != 0L) {
                        this.conditionCode |= 8;
                    }
                    if ((l10 & 4L) != 0L) {
                        this.conditionCode |= 1;
                    }
                } else {
                    this.conditionCode |= 4;
                    int n19 = 63;
                    double d = Math.pow(2.0, n18 - n19);
                    double d2 = this.freg0 / this.freg1 / d;
                    double d3 = d2 < 0.0 ? Math.ceil(d2) : Math.floor(d2);
                    this.freg0 -= this.freg1 * d3 * d;
                }
                return 0;
            }
            case 718: {
                int n20 = Math.getExponent(this.freg0) - Math.getExponent(this.freg1);
                if (n20 < 64) {
                    this.conditionCode &= 0xFFFFFFFB;
                    double d = Math.IEEEremainder(this.freg0, this.freg1);
                    long l11 = (long)Math.rint(this.freg0 / this.freg1);
                    this.conditionCode &= 4;
                    if ((l11 & 1L) != 0L) {
                        this.conditionCode |= 2;
                    }
                    if ((l11 & 2L) != 0L) {
                        this.conditionCode |= 8;
                    }
                    if ((l11 & 4L) != 0L) {
                        this.conditionCode |= 1;
                    }
                    this.setST(0, d);
                } else {
                    this.conditionCode |= 4;
                    int n21 = 63;
                    double d = Math.pow(2.0, n20 - n21);
                    double d4 = this.freg0 / this.freg1 / d;
                    double d5 = d4 < 0.0 ? Math.ceil(d4) : Math.floor(d4);
                    this.freg0 -= this.freg1 * d5 * d;
                }
                return 0;
            }
            case 715: {
                if (this.freg0 > Math.pow(2.0, 63.0) || this.freg0 < -1.0 * Math.pow(2.0, 63.0)) {
                    if (Double.isInfinite(this.freg0)) {
                        this.setInvalidOperation();
                    }
                    this.conditionCode |= 4;
                } else {
                    this.conditionCode &= 0xFFFFFFFB;
                    this.freg0 = Math.tan(this.freg0);
                }
                return 0;
            }
            case 726: {
                this.freg0 = Math.scalb(this.freg0, (int)this.freg1);
                return 0;
            }
            case 724: {
                this.freg1 = Math.sin(this.freg0);
                this.freg0 = Math.cos(this.freg0);
                return 0;
            }
            case 717: {
                int n22 = Math.getExponent(this.freg0);
                this.freg1 = n22;
                this.freg0 = Math.scalb(this.freg0, -n22);
                return 0;
            }
            case 714: {
                if (this.freg0 < 0.0) {
                    this.setInvalidOperation();
                } else if (Double.isInfinite(this.freg0)) {
                    if (this.freg1 == 0.0) {
                        this.setInvalidOperation();
                    } else {
                        this.freg1 = this.freg1 > 0.0 ? this.freg0 : -this.freg0;
                    }
                } else if (this.freg0 == 1.0 && Double.isInfinite(this.freg1)) {
                    this.setInvalidOperation();
                } else if (this.freg0 == 0.0) {
                    if (this.freg1 == 0.0) {
                        this.setInvalidOperation();
                    } else if (!Double.isInfinite(this.freg1)) {
                        this.setZeroDivide();
                    } else {
                        this.freg1 = -this.freg1;
                    }
                } else if (Double.isInfinite(this.freg1)) {
                    if (this.freg0 < 1.0) {
                        this.freg1 = -this.freg1;
                    }
                } else {
                    this.freg1 = this.freg1 * Math.log(this.freg0) / LN2;
                }
                this.freg0 = this.freg1;
                return 0;
            }
            case 722: {
                if (this.freg0 == 0.0) {
                    if (Double.isInfinite(this.freg1)) {
                        this.setInvalidOperation();
                    } else {
                        this.freg1 = 0.0;
                    }
                } else if (Double.isInfinite(this.freg1)) {
                    if (this.freg0 < 0.0) {
                        this.freg1 = -this.freg1;
                    }
                } else {
                    this.freg1 = this.freg1 * Math.log(this.freg0 + 1.0) / LN2;
                }
                this.freg0 = this.freg1;
                return 0;
            }
            case 725: {
                if (Double.isInfinite(this.freg0)) {
                    return 0;
                }
                switch (this.getRoundingControl()) {
                    case 0: {
                        this.freg0 = Math.rint(this.freg0);
                        break;
                    }
                    case 1: {
                        this.freg0 = Math.floor(this.freg0);
                        break;
                    }
                    case 2: {
                        this.freg0 = Math.ceil(this.freg0);
                        break;
                    }
                    case 3: {
                        this.freg0 = Math.signum(this.freg0) * Math.floor(Math.abs(this.freg0));
                        break;
                    }
                    default: {
                        System.err.println("Critical error: Invalid rounding control type.");
                        throw new IllegalStateException("Invalid rounding control value");
                    }
                }
                this.reg0 = (int)this.freg0;
                this.reg0l = (long)this.freg0;
                return 9;
            }
            case 751: {
                this.checkResult(this.freg0);
                return 0;
            }
            case 752: {
                this.checkResult(this.freg1);
                return 0;
            }
            case 750: {
                this.init();
                return 0;
            }
            case 731: {
                System.err.println("Warning: Using incomplete microcode: FSAVE_94");
                segment.setWord(n3, (short)this.getControl());
                segment.setWord(n3 + 2, (short)this.getStatus());
                segment.setWord(n3 + 4, (short)this.getTagWord());
                segment.setWord(n3 + 6, (short)0);
                segment.setWord(n3 + 8, (short)0);
                segment.setWord(n3 + 10, (short)0);
                segment.setWord(n3 + 12, (short)0);
                for (int i = 0; i < 8; ++i) {
                    byte[] byArray = FpuState64.doubleToExtended(this.ST(i), false);
                    for (int j = 0; j < 10; ++j) {
                        segment.setByte(n3 + 14 + j + 10 * i, byArray[j]);
                    }
                }
                this.init();
                return 0;
            }
            case 729: {
                System.err.println("Warning: Using incomplete microcode: FRSTOR_94");
                this.setControl(segment.getWord(n3));
                this.setStatus(segment.getWord(n3 + 2));
                this.setTagWord(segment.getWord(n3 + 4));
                return 0;
            }
            case 732: {
                System.err.println("Warning: Using incomplete microcode: FSAVE_108");
                segment.setDoubleWord(n3, this.getControl() & 0xFFFF);
                segment.setDoubleWord(n3 + 4, this.getStatus() & 0xFFFF);
                segment.setDoubleWord(n3 + 8, this.getTagWord() & 0xFFFF);
                segment.setDoubleWord(n3 + 12, 0);
                segment.setDoubleWord(n3 + 16, 0);
                segment.setDoubleWord(n3 + 20, 0);
                segment.setDoubleWord(n3 + 24, 0);
                for (int i = 0; i < 8; ++i) {
                    byte[] byArray = FpuState64.doubleToExtended(this.ST(i), false);
                    for (int j = 0; j < 10; ++j) {
                        segment.setByte(n3 + 28 + j + 10 * i, byArray[j]);
                    }
                }
                this.init();
                return 0;
            }
            case 730: {
                System.err.println("Warning: Using incomplete microcode: FRSTOR_108");
                this.setControl(segment.getDoubleWord(n3));
                this.setStatus(segment.getDoubleWord(n3 + 4));
                this.setTagWord(segment.getDoubleWord(n3 + 8));
                return 0;
            }
        }
        return -1;
    }

    @Override
    public void setProtectedMode(boolean bl) {
        this.protmode = bl;
    }

    @Override
    public int getReg0() {
        return this.reg0;
    }

    @Override
    public int getReg1() {
        return this.reg1;
    }

    @Override
    public int getReg2() {
        return this.reg2;
    }

    @Override
    public long getReg0l() {
        return this.reg0l;
    }

    private void checkResult(double d) throws ProcessorException {
        if (Double.isInfinite(d)) {
            this.setOverflow();
            if (!this.protmode) {
                this.checkExceptions();
            }
        }
    }

    private void validateOperand(double d) throws ProcessorException {
        long l = Double.doubleToRawLongBits(d);
        if ((l >> 52 & 0x7FFL) == 0L && (l & 0xFFFFFFFFFFFFFL) != 0L) {
            this.setDenormalizedOperand();
            if (!this.protmode) {
                this.checkExceptions();
            }
        }
    }
}

