/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.jrsr;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jpc.Misc;

public class JRSRArchiveReader
implements Closeable {
    private RandomAccessFile underlying;
    private Map<String, Long> memberStart;
    private Map<String, Long> memberEnd;
    private String currentMember;
    private boolean closed;
    private byte[] buffer;
    private int bufferFill;
    private int bufferStart;
    private long bufferBase;
    private boolean eofFlag;
    private int parseState;
    private boolean dreq;
    private static final int STATE_IN_LINE = 0;
    private static final int STATE_LAST_194 = 1;
    private static final int STATE_LAST_226 = 2;
    private static final int STATE_LAST_226_128 = 3;
    private static final int STATE_LINE_START = 4;
    private static final int STATE_MAJOR_MASK = 4;
    private static final int STATE_MINOR_MASK = 3;

    private void startMember(String string, long l, long l2) throws IOException {
        if (this.currentMember != null) {
            this.memberEnd.put(this.currentMember, new Long(l));
        }
        if (this.memberStart.get(string) != null) {
            throw new IOException("Invalid JRSR archive: Member \"" + string + "\" present multiple times");
        }
        this.memberStart.put(string, new Long(l2));
        this.currentMember = string;
    }

    private void endMember(long l) {
        Long l2 = new Long(l);
        if (this.currentMember != null) {
            this.memberEnd.put(this.currentMember, l2);
        }
        this.currentMember = null;
    }

    private final void initBuffers(long l) {
        this.buffer = new byte[2048];
        this.bufferFill = 0;
        this.bufferStart = 0;
        this.bufferBase = l;
        this.dreq = true;
        this.parseState = 4;
    }

    private final void fillBuffers() throws IOException {
        if (this.bufferStart > 0 && this.bufferFill > 0) {
            System.arraycopy(this.buffer, this.bufferStart, this.buffer, 0, this.bufferFill);
        }
        this.bufferStart = 0;
        int n = 0;
        if (this.dreq || this.bufferFill == 0) {
            if (!this.eofFlag && this.bufferFill < this.buffer.length) {
                n = this.underlying.read(this.buffer, this.bufferFill, this.buffer.length - this.bufferFill);
            }
            if (n < 0) {
                this.eofFlag = true;
            } else {
                this.bufferFill += n;
            }
            this.dreq = false;
        }
    }

    private final void skipRestOfLine() throws IOException {
        while (true) {
            int n = -1;
            this.fillBuffers();
            if (this.bufferFill <= 0) {
                if (!this.eofFlag) {
                    continue;
                }
            } else {
                n = this.buffer[this.bufferStart] & 0xFF;
            }
            if (n == -1) {
                throw new IOException("Unexpected end of JRSR archive while skipping rest of line.");
            }
            ++this.bufferStart;
            ++this.bufferBase;
            --this.bufferFill;
            this.parseState = this.parseState & 3 | 0;
            block0 : switch (this.parseState) {
                case 0: {
                    switch (n) {
                        case 10: 
                        case 13: 
                        case 28: 
                        case 29: 
                        case 30: {
                            this.parseState = 4;
                            return;
                        }
                        case 194: {
                            this.parseState = 1;
                            break block0;
                        }
                        case 226: {
                            this.parseState = 2;
                        }
                    }
                    break;
                }
                case 1: {
                    if (n != 133) break;
                    this.parseState = 4;
                    return;
                }
                case 2: {
                    if (n != 128) break;
                    this.parseState = 3;
                    break;
                }
                case 3: {
                    if (n != 169) break;
                    this.parseState = 4;
                    return;
                }
            }
        }
    }

    private final String utf8ToString(byte[] byArray, int n, int n2) throws IOException {
        return Charset.forName("UTF-8").newDecoder().decode(ByteBuffer.wrap(byArray, n, n2)).toString();
    }

    private final boolean processCommand(boolean bl) throws IOException {
        long l = this.bufferBase;
        int n = 0;
        long l2 = this.bufferBase;
        int n2 = 0;
        int n3 = 1;
        while (true) {
            this.dreq = true;
            this.fillBuffers();
            if (n2 == this.bufferFill) {
                if (this.bufferFill == this.buffer.length) {
                    throw new IOException("JRSR command directive too long");
                }
                if (!this.eofFlag) continue;
                throw new IOException("Unexpected end of file while parsin JRSR command directive");
            }
            int n4 = -1;
            int n5 = -1;
            int n6 = -1;
            if (n2 < this.bufferFill) {
                n4 = this.buffer[this.bufferStart + n2] & 0xFF;
            }
            if (n2 < this.bufferFill - 1) {
                n5 = this.buffer[this.bufferStart + n2 + 1] & 0xFF;
            }
            if (n2 < this.bufferFill - 2) {
                n6 = this.buffer[this.bufferStart + n2 + 2] & 0xFF;
            }
            if (n4 == 10 || n4 == 13 || n4 == 28 || n4 == 29 || n4 == 30) break;
            if (n4 == 194 && n5 == 133) {
                n3 = 2;
                break;
            }
            if (n4 == 226 && n5 == 128 && n6 == 169) {
                n3 = 3;
                break;
            }
            ++n2;
        }
        n = n2;
        l2 = l + (long)n2 + (long)n3;
        String string = this.utf8ToString(this.buffer, this.bufferStart, n);
        this.bufferStart = this.bufferStart + n2 + n3;
        this.bufferFill = this.bufferFill - n2 - n3;
        this.bufferBase = l2;
        return this.processCommand(string, bl, l, l2);
    }

    private final boolean processCommand(String string, boolean bl, long l, long l2) throws IOException {
        boolean bl2 = false;
        if ("!END".equals(string)) {
            if (!bl) {
                throw new IOException("JRSR !END not allowed outside member.");
            }
            this.endMember(l);
            bl2 = false;
        } else if (string.startsWith("!BEGIN") && Misc.isspace(string.charAt(6))) {
            int n;
            for (n = 6; n < string.length() && Misc.isspace(string.charAt(n)); ++n) {
            }
            if (n == string.length()) {
                throw new IOException("JRSR !BEGIN requires member name.");
            }
            this.startMember(string.substring(n), l, l2);
            bl2 = true;
        } else {
            throw new IOException("JRSR Unknown command line: '" + string + "'.");
        }
        return bl2;
    }

    private boolean eatLinefeeds() throws IOException {
        boolean bl = false;
        if (this.parseState != 4) {
            throw new IllegalStateException("Unexpected state (not STATE_LINE_START) in eatLineFeeds.");
        }
        while (true) {
            int n = -1;
            int n2 = 0;
            switch (this.parseState & 3) {
                case 0: {
                    n2 = 0;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 1;
                    break;
                }
                case 3: {
                    n2 = 2;
                }
            }
            if (this.bufferFill <= n2) {
                this.dreq = true;
                this.fillBuffers();
            }
            if (this.bufferFill <= n2) {
                if (!this.eofFlag) {
                    continue;
                }
            } else {
                n = this.buffer[this.bufferStart + n2] & 0xFF;
            }
            block5 : switch (this.parseState & 3) {
                case 0: {
                    switch (n) {
                        case 10: 
                        case 13: 
                        case 28: 
                        case 29: 
                        case 30: {
                            ++this.bufferStart;
                            --this.bufferFill;
                            ++this.bufferBase;
                            bl = true;
                            this.parseState = 4;
                            break block5;
                        }
                        case 194: {
                            this.parseState = this.parseState & 4 | 1;
                            break block5;
                        }
                        case 226: {
                            this.parseState = this.parseState & 4 | 2;
                            break block5;
                        }
                    }
                    return bl;
                }
                case 1: {
                    switch (n) {
                        case 133: {
                            this.bufferStart += 2;
                            this.bufferFill -= 2;
                            this.bufferBase += 2L;
                            bl = true;
                            this.parseState = 4;
                            break block5;
                        }
                    }
                    this.parseState = this.parseState & 4 | 0;
                    return bl;
                }
                case 2: {
                    switch (n) {
                        case 128: {
                            this.parseState = this.parseState & 4 | 3;
                            break block5;
                        }
                    }
                    this.parseState = this.parseState & 4 | 0;
                    return bl;
                }
                case 3: {
                    switch (n) {
                        case 169: {
                            this.bufferStart += 3;
                            this.bufferFill -= 3;
                            this.bufferBase += 3L;
                            bl = true;
                            this.parseState = 4;
                            break block5;
                        }
                    }
                    this.parseState = this.parseState & 4 | 0;
                    return bl;
                }
            }
        }
    }

    private void parseMembers(long l) throws IOException {
        boolean bl = false;
        this.initBuffers(l);
        while (!this.eofFlag || this.bufferFill > 0) {
            this.fillBuffers();
            if (this.eofFlag && this.bufferFill == 0 || this.eatLinefeeds()) continue;
            if (bl) {
                if (this.buffer[this.bufferStart] == 43) {
                    this.skipRestOfLine();
                    continue;
                }
                if (this.buffer[this.bufferStart] == 33) {
                    bl = this.processCommand(true);
                    continue;
                }
                throw new IOException("Unexpected character while expecting + or ! at start of line");
            }
            if (this.buffer[this.bufferStart] != 33) {
                throw new IOException("Unexpected character while expecting ! at start of line");
            }
            bl = this.processCommand(false);
        }
        if (bl) {
            throw new IOException("Unexpected end of JRSR archive (still inside member)");
        }
    }

    public JRSRArchiveReader(String string) throws IOException {
        long l = 5L;
        this.memberStart = new HashMap<String, Long>();
        this.memberEnd = new HashMap<String, Long>();
        try {
            this.underlying = new RandomAccessFile(string, "r");
        }
        catch (IOException iOException) {
            throw new IOException("Can not open JRSR archive \"" + string + "\"");
        }
        this.currentMember = null;
        byte[] byArray = new byte[5];
        try {
            this.underlying.readFully(byArray);
            if (byArray[0] != 74 || byArray[1] != 82 || byArray[2] != 83 || byArray[3] != 82) {
                throw new IOException("Bad magic");
            }
            switch (byArray[4] & 0xFF) {
                case 10: 
                case 13: 
                case 28: 
                case 29: 
                case 30: {
                    break;
                }
                case 194: {
                    int n = -1;
                    try {
                        n = this.underlying.readUnsignedByte();
                    }
                    catch (EOFException eOFException) {
                        throw new IOException("Bad magic");
                    }
                    if (n == 133) {
                        ++l;
                        break;
                    }
                    throw new IOException("Bad magic");
                }
                case 226: {
                    int n = -1;
                    int n2 = -1;
                    try {
                        n = this.underlying.readUnsignedByte();
                        n2 = this.underlying.readUnsignedByte();
                    }
                    catch (EOFException eOFException) {
                        throw new IOException("Bad magic");
                    }
                    if (n == 128 && n2 == 169) {
                        l += 2L;
                        break;
                    }
                    throw new IOException("Bad magic");
                }
            }
        }
        catch (IOException iOException) {
            throw new IOException("Bad JRSR archive magic in \"" + string + "\"");
        }
        this.parseMembers(l);
    }

    @Override
    public void close() throws IOException {
        this.memberStart = null;
        this.memberEnd = null;
        this.underlying.close();
        this.closed = true;
    }

    public JRSRArchiveInputStream readMember(String string) throws IOException {
        if (this.closed) {
            throw new IOException("Trying to operate on closed stream");
        }
        Long l = this.memberStart.get(string);
        Long l2 = this.memberEnd.get(string);
        if (l == null || l2 == null) {
            throw new IOException("No such member \"" + string + "\" in JRSR archive.");
        }
        return new JRSRArchiveInputStream(l, l2);
    }

    public Set<String> getMembers() throws IOException {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.closed) {
            throw new IOException("Trying to operate on closed stream");
        }
        for (Map.Entry<String, Long> entry : this.memberStart.entrySet()) {
            hashSet.add(entry.getKey());
        }
        return hashSet;
    }

    public class JRSRArchiveInputStream
    extends InputStream {
        private int parseState2;
        private long seekingPoint;
        private long endMarker;
        private byte[] buffer;
        private int bufferStart;
        private int bufferFill;
        private boolean closed2;

        JRSRArchiveInputStream(long l, long l2) {
            this.seekingPoint = l;
            this.endMarker = l2;
            this.buffer = new byte[2048];
            this.bufferStart = 0;
            this.bufferFill = 0;
            this.parseState2 = 4;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fillBuffer() throws IOException {
            JRSRArchiveReader jRSRArchiveReader = JRSRArchiveReader.this;
            synchronized (jRSRArchiveReader) {
                if (this.bufferFill > 0 && this.bufferStart > 0) {
                    System.arraycopy(this.buffer, this.bufferStart, this.buffer, 0, this.bufferFill);
                }
                this.bufferStart = 0;
                if (this.endMarker == this.seekingPoint || this.bufferFill == this.buffer.length) {
                    return;
                }
                JRSRArchiveReader.this.underlying.seek(this.seekingPoint);
                if (this.endMarker - this.seekingPoint < (long)(this.buffer.length - this.bufferFill)) {
                    JRSRArchiveReader.this.underlying.readFully(this.buffer, this.bufferFill, (int)(this.endMarker - this.seekingPoint));
                    this.bufferStart = 0;
                    this.bufferFill += (int)(this.endMarker - this.seekingPoint);
                    this.seekingPoint = this.endMarker;
                } else {
                    JRSRArchiveReader.this.underlying.readFully(this.buffer, this.bufferFill, this.buffer.length - this.bufferFill);
                    this.bufferStart = 0;
                    this.seekingPoint += (long)(this.buffer.length - this.bufferFill);
                    this.bufferFill = this.buffer.length;
                }
            }
        }

        private boolean eatLinefeeds() throws IOException {
            boolean bl = false;
            if (this.parseState2 != 4) {
                throw new IllegalStateException("Unexpected state (not STATE_LINE_START) in eatLineFeeds.");
            }
            while (true) {
                int n = -1;
                int n2 = 0;
                switch (this.parseState2 & 3) {
                    case 0: {
                        n2 = 0;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 1;
                        break;
                    }
                    case 3: {
                        n2 = 2;
                    }
                }
                if (this.bufferFill <= n2) {
                    this.fillBuffer();
                }
                if (this.bufferFill <= n2) {
                    if (this.seekingPoint < this.endMarker) {
                        continue;
                    }
                } else {
                    n = this.buffer[this.bufferStart + n2] & 0xFF;
                }
                block5 : switch (this.parseState2 & 3) {
                    case 0: {
                        switch (n) {
                            case 10: 
                            case 13: 
                            case 28: 
                            case 29: 
                            case 30: {
                                ++this.bufferStart;
                                --this.bufferFill;
                                bl = true;
                                this.parseState2 = 4;
                                break block5;
                            }
                            case 194: {
                                this.parseState2 = this.parseState2 & 4 | 1;
                                break block5;
                            }
                            case 226: {
                                this.parseState2 = this.parseState2 & 4 | 2;
                                break block5;
                            }
                        }
                        return bl;
                    }
                    case 1: {
                        switch (n) {
                            case 133: {
                                this.bufferStart += 2;
                                this.bufferFill -= 2;
                                bl = true;
                                this.parseState2 = 4;
                                break block5;
                            }
                        }
                        this.parseState2 = this.parseState2 & 4 | 0;
                        return bl;
                    }
                    case 2: {
                        switch (n) {
                            case 128: {
                                this.parseState2 = this.parseState2 & 4 | 3;
                                break block5;
                            }
                        }
                        this.parseState2 = this.parseState2 & 4 | 0;
                        return bl;
                    }
                    case 3: {
                        switch (n) {
                            case 169: {
                                this.bufferStart += 3;
                                this.bufferFill -= 3;
                                bl = true;
                                this.parseState2 = 4;
                                break block5;
                            }
                        }
                        this.parseState2 = this.parseState2 & 4 | 0;
                        return bl;
                    }
                }
            }
        }

        private final long copyLine(byte[] byArray, int n, long l) throws IOException {
            long l2 = 0L;
            while (l2 < l) {
                int n2 = -1;
                if (this.bufferFill <= 0) {
                    this.fillBuffer();
                }
                if (this.bufferFill <= 0) {
                    if (this.seekingPoint < this.endMarker) {
                        continue;
                    }
                } else {
                    n2 = this.buffer[this.bufferStart] & 0xFF;
                }
                if (n2 == -1) {
                    return l2;
                }
                if (this.parseState2 == 4) {
                    if (this.eatLinefeeds()) continue;
                    if (n2 != 43) {
                        throw new IOException("Parsing JRSR member, expected <43>, got byte <" + n2 + ">.");
                    }
                    this.parseState2 = 0;
                    ++this.bufferStart;
                    --this.bufferFill;
                    continue;
                }
                if ((this.parseState2 & 4) == 4) {
                    throw new IllegalStateException("Unexpected state STATE_LINE_START_LAST_x in copyLine.");
                }
                if (byArray != null) {
                    byArray[n] = (byte)n2;
                }
                ++n;
                ++l2;
                ++this.bufferStart;
                --this.bufferFill;
                block0 : switch (this.parseState2) {
                    case 0: {
                        switch (n2) {
                            case 10: 
                            case 13: 
                            case 28: 
                            case 29: 
                            case 30: {
                                this.parseState2 = 4;
                                break block0;
                            }
                            case 194: {
                                this.parseState2 = 1;
                                break block0;
                            }
                            case 226: {
                                this.parseState2 = 2;
                            }
                        }
                        break;
                    }
                    case 1: {
                        this.parseState2 = n2 == 133 ? 4 : 0;
                        break;
                    }
                    case 2: {
                        this.parseState2 = n2 == 128 ? 3 : 0;
                        break;
                    }
                    case 3: {
                        this.parseState2 = n2 == 169 ? 4 : 0;
                    }
                }
            }
            return l2;
        }

        @Override
        public long skip(long l) throws IOException {
            if (JRSRArchiveReader.this.closed || this.closed2) {
                throw new IOException("Trying to operate on closed stream");
            }
            long l2 = 0L;
            while (l > 0L) {
                long l3 = this.copyLine(null, 0, l);
                l2 += l3;
                l -= l3;
                if (l3 != 0L || this.seekingPoint != this.endMarker) continue;
                return l2;
            }
            return l2;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (JRSRArchiveReader.this.closed || this.closed2) {
                throw new IOException("Trying to operate on closed stream");
            }
            long l = 0L;
            while (n2 > 0) {
                long l2 = this.copyLine(byArray, n, n2);
                l += l2;
                n2 -= (int)l2;
                n += (int)l2;
                if (l2 != 0L || this.seekingPoint != this.endMarker) continue;
                return l > 0L ? (int)l : -1;
            }
            return (int)l;
        }

        @Override
        public int available() {
            return 1000;
        }

        @Override
        public void close() {
            this.closed2 = true;
        }

        @Override
        public int read() throws IOException {
            if (JRSRArchiveReader.this.closed || this.closed2) {
                throw new IOException("Trying to operate on closed stream");
            }
            byte[] byArray = new byte[1];
            int n = this.read(byArray, 0, 1);
            if (n < 0) {
                return -1;
            }
            return byArray[0];
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        @Override
        public void mark(int n) {
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public void reset() throws IOException {
            throw new IOException("JRSRArchiveInputStream does not support mark()");
        }
    }
}

