/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.luaextensions;

import java.io.IOException;
import java.util.Set;
import mnj.lua.Lua;
import mnj.lua.LuaTable;
import org.jpc.jrsr.JRSRArchiveReader;
import org.jpc.luaextensions.BinaryInFile;
import org.jpc.plugins.LuaPlugin;

public class ArchiveIn
extends LuaPlugin.LuaResource {
    JRSRArchiveReader object;

    ArchiveIn(LuaPlugin luaPlugin, String string) throws IOException {
        super(luaPlugin);
        this.object = new JRSRArchiveReader(string);
    }

    @Override
    public void destroy() throws IOException {
        this.object.close();
        this.object = null;
    }

    public int luaCB_member_list(Lua lua, LuaPlugin luaPlugin) {
        try {
            int n = 1;
            LuaTable luaTable = lua.newTable();
            Set<String> set = this.object.getMembers();
            for (String string : set) {
                lua.setTable(luaTable, new Double(n++), string);
            }
            lua.push(luaTable);
        }
        catch (IOException iOException) {
            lua.pushNil();
            lua.pushString("IOException: " + iOException.getMessage());
            return 2;
        }
        return 1;
    }

    public int luaCB_member(Lua lua, LuaPlugin luaPlugin) {
        lua.pushNil();
        String string = lua.checkString(2);
        try {
            JRSRArchiveReader.JRSRArchiveInputStream jRSRArchiveInputStream = this.object.readMember(string);
            luaPlugin.generateLuaClass(lua, new BinaryInFile(luaPlugin, jRSRArchiveInputStream));
        }
        catch (IOException iOException) {
            lua.pushNil();
            lua.pushString("IOException: " + iOException.getMessage());
            return 2;
        }
        return 1;
    }

    public int luaCB_close(Lua lua, LuaPlugin luaPlugin) {
        try {
            luaPlugin.destroyLuaObject(lua);
            lua.pushBoolean(true);
        }
        catch (IOException iOException) {
            lua.pushBoolean(false);
            lua.pushString("IOException: " + iOException.getMessage());
            return 2;
        }
        return 1;
    }

    public static int luaCB_open(Lua lua, LuaPlugin luaPlugin) {
        lua.pushNil();
        String string = lua.checkString(1);
        try {
            luaPlugin.generateLuaClass(lua, new ArchiveIn(luaPlugin, string));
        }
        catch (IOException iOException) {
            lua.pushNil();
            lua.pushString("IOException: " + iOException.getMessage());
            return 2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            lua.pushNil();
            lua.pushString("Illegal argument: " + illegalArgumentException.getMessage());
            return 2;
        }
        return 1;
    }
}

