/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.luaextensions;

import java.io.IOException;
import java.io.InputStream;
import mnj.lua.Lua;
import mnj.lua.LuaTable;
import org.jpc.Misc;
import org.jpc.jrsr.UTFInputLineStream;
import org.jpc.plugins.LuaPlugin;

public class TextInFile
extends LuaPlugin.LuaResource {
    UTFInputLineStream object;

    public TextInFile(LuaPlugin luaPlugin, InputStream inputStream) throws IOException {
        super(luaPlugin);
        this.object = new UTFInputLineStream(inputStream);
    }

    @Override
    public void destroy() throws IOException {
        this.object.close();
        this.object = null;
    }

    public int luaCB_read(Lua lua, LuaPlugin luaPlugin) {
        try {
            String string = this.object.readLine();
            if (string == null) {
                lua.pushNil();
                lua.pushNil();
                return 2;
            }
            lua.push(string);
        }
        catch (IOException iOException) {
            lua.pushNil();
            lua.pushString("IOException: " + iOException.getMessage());
            return 2;
        }
        return 1;
    }

    public int luaCB_read_component(Lua lua, LuaPlugin luaPlugin) {
        try {
            LuaTable luaTable;
            String[] stringArray = Misc.nextParseLine(this.object);
            if (stringArray != null) {
                luaTable = lua.newTable();
                for (int i = 0; i < stringArray.length; ++i) {
                    lua.setTable(luaTable, new Double(i + 1), stringArray[i]);
                }
            } else {
                lua.pushNil();
                lua.pushNil();
                return 2;
            }
            lua.push(luaTable);
        }
        catch (IOException iOException) {
            lua.pushNil();
            lua.pushString("IOException: " + iOException.getMessage());
            return 2;
        }
        return 1;
    }

    public int luaCB_close(Lua lua, LuaPlugin luaPlugin) {
        try {
            luaPlugin.destroyLuaObject(lua);
            lua.pushBoolean(true);
        }
        catch (IOException iOException) {
            lua.pushBoolean(false);
            lua.pushString("IOException: " + iOException.getMessage());
            return 2;
        }
        return 1;
    }
}

