/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.modules;

import java.io.IOException;
import org.jpc.emulator.AbstractHardwareComponent;
import org.jpc.emulator.Clock;
import org.jpc.emulator.EventDispatchTarget;
import org.jpc.emulator.EventRecorder;
import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.motherboard.IOPortCapable;
import org.jpc.emulator.motherboard.IOPortHandler;

public class Joystick
extends AbstractHardwareComponent
implements IOPortCapable,
EventDispatchTarget {
    private boolean ioportRegistered;
    private Clock clock;
    private long[] axisExpiry;
    private long[] axisHold;
    private boolean[] button;
    private long[] axisHoldV;
    private boolean[] buttonV;
    private EventRecorder rec;
    private static final String[] CHAN_IDS = new String[4];
    private static final int INITIAL_POS = 10000;

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        super.dumpSRPartial(sRDumper);
        sRDumper.dumpBoolean(this.ioportRegistered);
        sRDumper.dumpObject(this.clock);
        sRDumper.dumpArray(this.axisExpiry);
    }

    private void createArrays() {
        this.axisExpiry = new long[4];
        this.axisHold = new long[4];
        this.axisHoldV = new long[4];
        this.button = new boolean[4];
        this.buttonV = new boolean[4];
        for (int i = 0; i < 4; ++i) {
            this.axisHoldV[i] = 10000L;
            this.axisHold[i] = 10000L;
        }
    }

    public Joystick(SRLoader sRLoader) throws IOException {
        super(sRLoader);
        this.ioportRegistered = sRLoader.loadBoolean();
        this.clock = (Clock)sRLoader.loadObject();
        this.axisExpiry = sRLoader.loadArrayLong();
        this.createArrays();
    }

    public Joystick() throws IOException {
        this.createArrays();
    }

    @Override
    public void dumpStatusPartial(StatusDumper statusDumper) {
        super.dumpStatusPartial(statusDumper);
        statusDumper.println("\tioportRegistered " + this.ioportRegistered);
        statusDumper.println("\tclock <object #" + statusDumper.objectNumber(this.clock) + ">");
        if (this.clock != null) {
            this.clock.dumpStatus(statusDumper);
        }
        statusDumper.printArray(this.axisExpiry, "\taxisExpiry");
    }

    @Override
    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": Joystick:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    @Override
    public boolean initialised() {
        return this.clock != null && this.ioportRegistered;
    }

    @Override
    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof Clock && hardwareComponent.initialised()) {
            this.clock = (Clock)hardwareComponent;
        }
        if (hardwareComponent instanceof IOPortHandler && hardwareComponent.initialised()) {
            ((IOPortHandler)hardwareComponent).registerIOPortCapable(this);
            this.ioportRegistered = true;
        }
    }

    @Override
    public int[] ioPortsRequested() {
        int[] nArray = new int[]{513};
        return nArray;
    }

    @Override
    public void ioPortWriteWord(int n, int n2) {
        this.ioPortWriteByte(n, n2 & 0xFF);
        this.ioPortWriteByte(n + 1, n2 >>> 8 & 0xFF);
    }

    @Override
    public void ioPortWriteLong(int n, int n2) {
        this.ioPortWriteByte(n, n2 & 0xFF);
        this.ioPortWriteByte(n + 1, n2 >>> 8 & 0xFF);
        this.ioPortWriteByte(n + 2, n2 >>> 16 & 0xFF);
        this.ioPortWriteByte(n + 3, n2 >>> 24 & 0xFF);
    }

    @Override
    public int ioPortReadWord(int n) {
        return this.ioPortReadByte(n) | this.ioPortReadByte(n + 1) << 8;
    }

    @Override
    public int ioPortReadLong(int n) {
        return this.ioPortReadByte(n) | this.ioPortReadByte(n + 1) << 8 | this.ioPortReadByte(n + 2) << 16 | this.ioPortReadByte(n + 3) << 24;
    }

    @Override
    public void ioPortWriteByte(int n, int n2) {
        if (n == 513) {
            long l = this.clock.getTime();
            for (int i = 0; i < 4; ++i) {
                this.axisExpiry[i] = l + this.axisHold[i];
            }
        }
    }

    public boolean buttonState(int n, boolean bl) {
        if (bl) {
            return this.buttonV[n];
        }
        return this.button[n];
    }

    public long axisHoldTime(int n, boolean bl) {
        if (bl) {
            return this.axisHoldV[n];
        }
        return this.axisHold[n];
    }

    public void setButton(int n, boolean bl) throws IOException {
        String string = "0";
        if (bl) {
            string = "1";
        }
        this.rec.addEvent(0L, this.getClass(), new String[]{"BUTTON" + CHAN_IDS[n], string});
        this.buttonV[n] = bl;
    }

    public void setAxis(int n, long l) throws IOException {
        this.rec.addEvent(0L, this.getClass(), new String[]{"AXIS" + CHAN_IDS[n], "" + l});
        this.axisHoldV[n] = l;
    }

    @Override
    public int ioPortReadByte(int n) {
        if (n == 513) {
            int n2 = 240;
            long l = this.clock.getTime();
            for (int i = 0; i < 4; ++i) {
                if (this.button[i]) {
                    n2 &= ~(1 << 4 + i);
                }
                if (l >= this.axisExpiry[i]) continue;
                n2 |= 1 << i;
            }
            return n2;
        }
        return -1;
    }

    @Override
    public void reset() {
    }

    @Override
    public void setEventRecorder(EventRecorder eventRecorder) {
        this.rec = eventRecorder;
    }

    @Override
    public void startEventCheck() {
        for (int i = 0; i < 4; ++i) {
            this.axisHoldV[i] = 10000L;
            this.axisHold[i] = 10000L;
            this.buttonV[i] = false;
            this.button[i] = false;
        }
    }

    @Override
    public void endEventCheck() throws IOException {
    }

    @Override
    public long getEventTimeLowBound(long l, String[] stringArray) throws IOException {
        return -1L;
    }

    @Override
    public void doEvent(long l, String[] stringArray, int n) throws IOException {
        int n2 = -1;
        long l2 = 0L;
        if (stringArray == null || stringArray.length != 2) {
            throw new IOException("Joystick events must have two elements");
        }
        try {
            l2 = Long.parseLong(stringArray[1]);
        }
        catch (Exception exception) {
            throw new IOException("Can't parse numeric argument to joystick event");
        }
        if ("AXISA".equals(stringArray[0])) {
            n2 = 0;
        } else if ("AXISB".equals(stringArray[0])) {
            n2 = 1;
        } else if ("AXISC".equals(stringArray[0])) {
            n2 = 2;
        } else if ("AXISD".equals(stringArray[0])) {
            n2 = 3;
        } else if ("BUTTONA".equals(stringArray[0])) {
            n2 = 4;
        } else if ("BUTTONB".equals(stringArray[0])) {
            n2 = 5;
        } else if ("BUTTONC".equals(stringArray[0])) {
            n2 = 6;
        } else if ("BUTTOND".equals(stringArray[0])) {
            n2 = 7;
        } else {
            throw new IOException("Bad joystick event type '" + stringArray[0] + "'");
        }
        if ((n2 & 4) != 0) {
            if (l2 != 0L && l2 != 1L) {
                throw new IOException("Bad joystick event value '" + stringArray[1] + "' for button event");
            }
        } else if (l2 < 0L) {
            throw new IOException("Bad joystick event value '" + stringArray[1] + "' for axis event");
        }
        if (n == 2 || n == 3) {
            switch (n2) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    this.axisHold[n2] = l2;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    boolean bl = this.button[n2 - 4] = l2 != 0L;
                }
            }
        }
        if (n == 2 || n == 1) {
            switch (n2) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    this.axisHoldV[n2] = l2;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    this.buttonV[n2 - 4] = l2 != 0L;
                }
            }
        }
    }

    static {
        Joystick.CHAN_IDS[0] = "A";
        Joystick.CHAN_IDS[1] = "B";
        Joystick.CHAN_IDS[2] = "C";
        Joystick.CHAN_IDS[3] = "D";
    }
}

