/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.output;

import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.jpc.emulator.SRDumpable;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;
import org.jpc.output.OutputChannel;
import org.jpc.output.OutputFrame;
import org.jpc.output.OutputStatic;

public class Output
implements SRDumpable {
    private long timeAdjust = 0L;
    private OutputStatic staticOutput = null;
    private boolean channelTableUpdated = true;
    private Map<Short, OutputChannel> channels = new TreeMap<Short, OutputChannel>();

    public Output() {
    }

    public void newChannel(OutputChannel outputChannel) {
        this.channelTableUpdated = true;
        short s = 0;
        for (Map.Entry<Short, OutputChannel> entry : this.channels.entrySet()) {
            if (entry.getKey() != s) continue;
            s = (short)(s + 1);
        }
        this.channels.put(new Short(s), outputChannel);
        outputChannel.setChan(s);
    }

    public void addFrame(OutputChannel outputChannel, OutputFrame outputFrame, boolean bl) {
        outputFrame.adjustTime(this.timeAdjust);
        short s = outputChannel.getChan();
        if (this.staticOutput != null) {
            if (this.channelTableUpdated) {
                this.staticOutput.updateChannelTable(this.channels);
                this.channelTableUpdated = false;
            }
            this.staticOutput.addFrame(s, outputFrame, bl);
        }
    }

    public void setStaticOutput(OutputStatic outputStatic, long l) {
        this.timeAdjust = l;
        this.staticOutput = outputStatic;
        this.channelTableUpdated = true;
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        for (Map.Entry<Short, OutputChannel> entry : this.channels.entrySet()) {
            sRDumper.dumpBoolean(true);
            sRDumper.dumpObject(entry.getValue());
        }
        sRDumper.dumpBoolean(false);
    }

    public void dumpStatusPartial(StatusDumper statusDumper) {
        for (Map.Entry<Short, OutputChannel> entry : this.channels.entrySet()) {
            statusDumper.println("\tchannels[" + entry.getKey() + "] <object #" + statusDumper.objectNumber(entry.getValue()) + ">");
            if (entry.getValue() == null) continue;
            entry.getValue().dumpStatus(statusDumper);
        }
    }

    public Output(SRLoader sRLoader) throws IOException {
        this();
        sRLoader.objectCreated(this);
        while (sRLoader.loadBoolean()) {
            OutputChannel outputChannel = (OutputChannel)sRLoader.loadObject();
            this.channels.put(new Short(outputChannel.getChan()), outputChannel);
        }
        this.channelTableUpdated = true;
    }

    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": Output:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }
}

