/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.plugins;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.jpc.Misc;
import org.jpc.emulator.PC;
import org.jpc.modules.Joystick;
import org.jpc.pluginsbase.Plugin;
import org.jpc.pluginsbase.Plugins;

public class JoystickInput
implements ActionListener,
Plugin {
    private JFrame window;
    private JPanel panel;
    private Joystick joy;
    private Plugins pluginManager;
    private int nativeWidth;
    private int nativeHeight;
    private JTextField[] axisInput;
    private JLabel[] axisValue;
    private JButton[] updateAxis;
    private JToggleButton[] buttons;

    public void eci_joystickinput_setwinpos(Integer n, Integer n2) {
        Misc.moveWindow(this.window, n, n2, this.nativeWidth, this.nativeHeight);
    }

    public JoystickInput(Plugins plugins) {
        this.pluginManager = plugins;
        this.window = new JFrame("Joystick input" + Misc.emuname);
        GridLayout gridLayout = new GridLayout(0, 4);
        this.panel = new JPanel(gridLayout);
        this.window.add(this.panel);
        this.axisInput = new JTextField[4];
        this.axisValue = new JLabel[4];
        this.updateAxis = new JButton[4];
        this.buttons = new JToggleButton[4];
        for (int i = 0; i < 4; ++i) {
            this.axisValue[i] = new JLabel("<N/A>       ");
            this.panel.add(this.axisValue[i]);
            this.axisInput[i] = new JTextField("10000", 10);
            this.panel.add(this.axisInput[i]);
            this.updateAxis[i] = new JButton("Update");
            this.updateAxis[i].setActionCommand("A" + i);
            this.updateAxis[i].setEnabled(false);
            this.updateAxis[i].addActionListener(this);
            this.panel.add(this.updateAxis[i]);
            this.buttons[i] = new JToggleButton("Button");
            this.buttons[i].setActionCommand("B" + i);
            this.buttons[i].addActionListener(this);
            this.buttons[i].setSelected(false);
            this.buttons[i].setEnabled(false);
            this.panel.add(this.buttons[i]);
        }
        this.window.pack();
        this.window.setDefaultCloseOperation(0);
        Dimension dimension = this.window.getSize();
        this.nativeWidth = dimension.width;
        this.nativeHeight = dimension.height;
        this.window.setVisible(true);
    }

    public void resetButtons() {
        if (this.joy != null) {
            for (int i = 0; i < 4; ++i) {
                this.axisValue[i].setText("" + this.joy.axisHoldTime(i, true));
                this.updateAxis[i].setEnabled(true);
                this.buttons[i].setEnabled(true);
                this.buttons[i].setSelected(this.joy.buttonState(i, true));
            }
        } else {
            for (int i = 0; i < 4; ++i) {
                this.axisValue[i].setText("<N/A>");
                this.updateAxis[i].setEnabled(false);
                this.buttons[i].setSelected(false);
                this.buttons[i].setEnabled(false);
            }
        }
    }

    @Override
    public void main() {
    }

    @Override
    public boolean systemShutdown() {
        return true;
    }

    @Override
    public void pcStarting() {
    }

    @Override
    public void pcStopping() {
        if (this.pluginManager.isShuttingDown()) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Thread(){

                    @Override
                    public void run() {
                        JoystickInput.this.resetButtons();
                    }
                });
            }
            catch (Exception exception) {}
        } else {
            this.resetButtons();
        }
    }

    @Override
    public void reconnect(PC pC) {
        this.joy = pC != null ? (Joystick)pC.getComponent(Joystick.class) : null;
        this.pcStopping();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        if (this.joy == null) {
            return;
        }
        String string = actionEvent.getActionCommand();
        if (string == null) {
            return;
        }
        if (string.startsWith("A")) {
            try {
                n = Integer.parseInt(string.substring(1));
                this.joy.setAxis(n, Long.parseLong(this.axisInput[n].getText()));
            }
            catch (Exception exception) {
                Misc.errorDialog(new IOException("Can't set joystick Axis"), "Can't send event", null, "Dismiss");
            }
        }
        if (string.startsWith("B")) {
            try {
                n = Integer.parseInt(string.substring(1));
                this.joy.setButton(n, this.buttons[n].isSelected());
            }
            catch (Exception exception) {
                Misc.errorDialog(new IOException("Can't set joystick Button"), "Can't send event", null, "Dismiss");
            }
        }
        this.resetButtons();
    }
}

