/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.plugins;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.jpc.Misc;
import org.jpc.emulator.PC;
import org.jpc.output.OutputClient;
import org.jpc.output.OutputFrame;
import org.jpc.output.OutputFrameImage;
import org.jpc.output.OutputStatic;
import org.jpc.pluginsaux.HUDRenderer;
import org.jpc.pluginsbase.Plugin;
import org.jpc.pluginsbase.Plugins;

public class RAWDumper
implements Plugin {
    private volatile OutputClient videoOut;
    private volatile OutputStatic connector;
    private volatile boolean shuttingDown;
    private volatile boolean shutDown;
    private volatile boolean pcRunStatus;
    private PC pc;
    private Thread worker;
    private OutputStream rawOutputStream;
    private DumpFrameFilter filter;
    private HUDRenderer renderer;

    public RAWDumper(Plugins plugins, String string) throws IOException {
        Map<String, String> map = Misc.parseStringToComponents(string);
        String string2 = map.get("rawoutput");
        if (string2 == null) {
            throw new IOException("Raw output setting (rawoutput) required for PNGDumper");
        }
        if (string2 != null) {
            try {
                this.rawOutputStream = new FileOutputStream(string2);
            }
            catch (Exception exception) {
                System.err.println("Error: Failed to open raw output file.");
                throw new IOException("Can't open dumpfile '" + string2 + "':" + exception.getMessage());
            }
        }
        this.shuttingDown = false;
        this.shutDown = false;
        this.pcRunStatus = false;
        this.connector = plugins.getOutputConnector();
        this.videoOut = new OutputClient(this.connector);
        this.filter = new DumpFrameFilter();
        this.renderer = new HUDRenderer(2);
        plugins.addRenderer(this.renderer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean systemShutdown() {
        if (this.pcRunStatus) {
            return false;
        }
        this.shuttingDown = true;
        if (this.worker != null) {
            RAWDumper rAWDumper = this;
            synchronized (rAWDumper) {
                this.worker.interrupt();
                while (!this.shutDown) {
                    try {
                        this.wait();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return true;
    }

    @Override
    public void reconnect(PC pC) {
        this.pcRunStatus = false;
        this.pc = pC;
    }

    @Override
    public void pcStarting() {
        this.pcRunStatus = true;
    }

    @Override
    public void pcStopping() {
        this.pcRunStatus = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void main() {
        RAWDumper rAWDumper;
        int n = 0;
        this.worker = Thread.currentThread();
        boolean bl = true;
        while (!this.shuttingDown && !this.shuttingDown) {
            if (!this.videoOut.aquire()) continue;
            rAWDumper = this;
            synchronized (rAWDumper) {
                try {
                    if (bl) {
                        this.rawOutputStream.write(this.connector.makeChannelTable());
                    }
                    bl = false;
                    long l = this.connector.writeFrames(this.rawOutputStream, this.filter);
                    OutputFrameImage outputFrameImage = this.filter.lastVideoFrame;
                    if (outputFrameImage == null) {
                        this.videoOut.releaseWaitAll();
                        continue;
                    }
                    int n2 = outputFrameImage.getWidth();
                    int n3 = outputFrameImage.getHeight();
                    this.renderer.setBackground(outputFrameImage.getImageData(), n2, n3);
                    this.videoOut.releaseWaitAll();
                    n2 = this.renderer.getRenderWidth();
                    n3 = this.renderer.getRenderHeight();
                    int[] nArray = this.renderer.getFinishedAndReset();
                    ++n;
                    long l2 = this.filter.lastTimestamp;
                    if (l > l2) {
                        l2 = l;
                    }
                    outputFrameImage = new OutputFrameImage(l2, (short)n2, (short)n3, nArray);
                    this.rawOutputStream.write(outputFrameImage.dump(this.filter.videoChannel, l));
                    System.err.println("Informational: Saved frame #" + n + ": " + n2 + "x" + n3 + " <" + l2 + ">.");
                }
                catch (IOException iOException) {
                    System.err.println("Warning: Failed to save screenshot image!");
                    Misc.errorDialog(iOException, "Failed to save screenshot", null, "Dismiss");
                }
            }
        }
        try {
            if (this.filter.gotFrame) {
                this.connector.writeFrames(this.rawOutputStream, null);
            }
        }
        catch (IOException iOException) {
            System.err.println("Warning: Failed to close video output stream!");
            Misc.errorDialog(iOException, "Failed to close video output", null, "Dismiss");
        }
        if (this.videoOut != null) {
            this.videoOut.detach();
        }
        if (this.rawOutputStream != null) {
            try {
                this.rawOutputStream.flush();
                this.rawOutputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("Warning: Failed to close video output stream!");
                Misc.errorDialog(iOException, "Failed to close video output", null, "Dismiss");
            }
        }
        rAWDumper = this;
        synchronized (rAWDumper) {
            this.shutDown = true;
            this.notifyAll();
        }
    }

    class DumpFrameFilter
    implements OutputStatic.FrameFilter {
        OutputFrameImage lastVideoFrame;
        short videoChannel;
        boolean gotFrame;
        long lastTimestamp;

        @Override
        public OutputFrame doFilter(OutputFrame outputFrame, short s) {
            this.gotFrame = true;
            this.lastTimestamp = outputFrame.getTime();
            if (!(outputFrame instanceof OutputFrameImage)) {
                return outputFrame;
            }
            this.lastVideoFrame = (OutputFrameImage)outputFrame;
            this.videoChannel = s;
            return null;
        }
    }
}

