/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.plugins;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.basic.BasicToggleButtonUI;
import org.jpc.Misc;
import org.jpc.emulator.KeyboardStatusListener;
import org.jpc.emulator.PC;
import org.jpc.emulator.peripheral.Keyboard;
import org.jpc.jrsr.UTFInputLineStream;
import org.jpc.pluginsaux.ConstantTableLayout;
import org.jpc.pluginsbase.Plugin;
import org.jpc.pluginsbase.Plugins;

public class VirtualKeyboard
implements ActionListener,
Plugin,
KeyboardStatusListener {
    private JFrame window;
    private JPanel panel;
    private HashMap<String, Integer> commandToKey;
    private HashMap<String, JToggleButton> commandToButton;
    private JToggleButton capsLock;
    private JToggleButton numLock;
    private JToggleButton scrollLock;
    private Font keyFont;
    private Font smallKeyFont;
    private Border keyBorder;
    private Border smallKeyBorder;
    private Border classicBorder;
    private boolean nativeButtons;
    private static String DEFAULT_KEYBOARD_FILENAME = "datafiles/keyboards/default";
    private Keyboard keyboard;
    private int keyNo;
    private boolean[] cachedState;
    private Plugins pluginManager;
    private int nativeWidth;
    private int nativeHeight;

    public JToggleButton addKey(String string, String string2, int n, int n2, int n3, int n4, int n5, char c, boolean bl) {
        String string3 = string + "-" + this.keyNo++;
        String string4 = string;
        if (string2 != null) {
            string4 = "<html>" + string2 + "<br>" + string + "</html>";
        } else if (string4.indexOf(38) >= 0) {
            string4 = "<html>" + string + "</html>";
        }
        JToggleButton jToggleButton = new JToggleButton(string4, false);
        if (c == 'N') {
            jToggleButton.setFont(this.keyFont);
            jToggleButton.setBorder(this.keyBorder);
        } else if (c == 'S') {
            jToggleButton.setFont(this.smallKeyFont);
            jToggleButton.setBorder(this.smallKeyBorder);
        } else if (c == 'C' && !this.nativeButtons) {
            jToggleButton.setBorder(this.classicBorder);
        }
        jToggleButton.setRolloverEnabled(false);
        if (bl) {
            jToggleButton.setEnabled(false);
            jToggleButton.setVisible(false);
        } else {
            this.commandToKey.put(string3, new Integer(n));
            this.commandToButton.put(string3, jToggleButton);
            jToggleButton.setActionCommand(string3);
            jToggleButton.addActionListener(this);
        }
        if (!this.nativeButtons) {
            jToggleButton.setUI(new KeyboardButtonUI());
        }
        this.panel.add((Component)jToggleButton, new ConstantTableLayout.Placement(n2, n3, n4, n5));
        return jToggleButton;
    }

    public void eci_virtualkeyboard_setwinpos(Integer n, Integer n2) {
        Misc.moveWindow(this.window, n, n2, this.nativeWidth, this.nativeHeight);
    }

    public VirtualKeyboard(Plugins plugins) throws IOException {
        this(plugins, "");
    }

    public VirtualKeyboard(Plugins plugins, String string) throws IOException {
        Serializable serializable;
        this.pluginManager = plugins;
        Map<String, String> map = Misc.parseStringToComponents(string);
        String string2 = map.get("keyboard");
        this.nativeButtons = "native".equalsIgnoreCase(map.get("style")) || string2 == null;
        this.keyNo = 0;
        this.keyboard = null;
        this.commandToKey = new HashMap();
        this.commandToButton = new HashMap();
        this.window = new JFrame("Virtual Keyboard" + Misc.emuname);
        ConstantTableLayout constantTableLayout = new ConstantTableLayout();
        this.cachedState = new boolean[256];
        this.panel = new JPanel(constantTableLayout);
        this.keyFont = new Font("SanSerif", 0, 11);
        this.smallKeyFont = this.keyFont.deriveFont(9.0f);
        if (this.nativeButtons) {
            this.keyBorder = new EmptyBorder(0, 5, 0, 5);
            this.smallKeyBorder = new EmptyBorder(0, 1, 0, 1);
        } else {
            serializable = new CompoundBorder(new EmptyBorder(1, 1, 0, 0), new SimpleButtonBorder(false));
            this.keyBorder = new CompoundBorder((Border)((Object)serializable), new EmptyBorder(0, 3, 0, 3));
            this.smallKeyBorder = new CompoundBorder((Border)((Object)serializable), new EmptyBorder(0, 1, 0, 1));
            this.classicBorder = new SimpleButtonBorder(true);
        }
        this.window.add(this.panel);
        this.parseKeyboardFile(string2);
        this.window.pack();
        this.window.setDefaultCloseOperation(0);
        serializable = this.window.getSize();
        this.nativeWidth = ((Dimension)serializable).width;
        this.nativeHeight = ((Dimension)serializable).height;
        this.window.setVisible(true);
    }

    private static int parseCoord(String string, int n) {
        if ("-".equals(string)) {
            return n;
        }
        return Integer.valueOf(string);
    }

    private void parseKeyboardFile(String string) throws IOException {
        String[] stringArray;
        InputStream inputStream = Misc.openStream(string, DEFAULT_KEYBOARD_FILENAME);
        inputStream = Misc.openStream(string, DEFAULT_KEYBOARD_FILENAME);
        if (inputStream == null) {
            throw new IOException("Neither primary keyboard file nor fallback file exists.");
        }
        UTFInputLineStream uTFInputLineStream = new UTFInputLineStream(inputStream);
        int n = 0;
        int n2 = 0;
        while ((stringArray = Misc.nextParseLine(uTFInputLineStream)) != null) {
            if (stringArray.length <= 1) continue;
            if (stringArray.length == 7 || stringArray.length == 8) {
                int n3;
                int n4;
                int n5;
                block8: {
                    n5 = VirtualKeyboard.parseCoord(stringArray[1], n);
                    n4 = VirtualKeyboard.parseCoord(stringArray[2], n2);
                    n3 = Integer.parseInt(stringArray[3]);
                    int n6 = Integer.parseInt(stringArray[4]);
                    char c = stringArray[5].charAt(0);
                    String string2 = stringArray[6];
                    String string3 = null;
                    if (stringArray.length == 8) {
                        string3 = stringArray[7];
                    }
                    try {
                        int n7 = Integer.parseInt(stringArray[0]);
                        this.addKey(string2, string3, n7, n5, n4, n3, n6, c, false);
                    }
                    catch (NumberFormatException numberFormatException) {
                        String string4 = stringArray[0];
                        JToggleButton jToggleButton = this.addKey(string2, null, 0, n5, n4, n3, n6, c, true);
                        if (string4.equalsIgnoreCase("numlock")) {
                            this.numLock = jToggleButton;
                        }
                        if (string4.equalsIgnoreCase("capslock")) {
                            this.capsLock = jToggleButton;
                        }
                        if (!string4.equalsIgnoreCase("scrolllock")) break block8;
                        this.scrollLock = jToggleButton;
                    }
                }
                n = n5 + n3;
                n2 = n4;
                continue;
            }
            throw new IOException("Invalid line in keyboard layout.");
        }
    }

    private void updateLEDs(int n) {
        if (n < 0) {
            this.numLock.setVisible(false);
            this.numLock.setSelected(false);
            this.capsLock.setVisible(false);
            this.capsLock.setSelected(false);
            this.scrollLock.setVisible(false);
            this.scrollLock.setSelected(false);
        } else {
            this.numLock.setVisible((n & 2) != 0);
            this.capsLock.setVisible((n & 4) != 0);
            this.scrollLock.setVisible((n & 1) != 0);
        }
    }

    public void resetButtons() {
        for (Map.Entry<String, Integer> entry : this.commandToKey.entrySet()) {
            int n = entry.getValue();
            JToggleButton jToggleButton = this.commandToButton.get(entry.getKey());
            if (this.keyboard.getKeyStatus((byte)n) == this.cachedState[n]) continue;
            this.cachedState[n] = this.keyboard.getKeyStatus((byte)n);
            jToggleButton.setSelected(this.cachedState[n]);
        }
        this.updateLEDs(this.keyboard.getLEDStatus());
    }

    private void keyStatusChangeEventThread(int n, boolean bl) {
    }

    @Override
    public void keyExecStatusChange(int n, boolean bl) {
    }

    @Override
    public void keyStatusChange(int n, boolean bl) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                final int n2 = n;
                final boolean bl2 = bl;
                SwingUtilities.invokeLater(new Thread(){

                    @Override
                    public void run() {
                        VirtualKeyboard.this.keyStatusChangeEventThread(n2, bl2);
                    }
                });
            }
            catch (Exception exception) {}
        } else {
            this.keyStatusChangeEventThread(n, bl);
        }
    }

    @Override
    public void keyStatusReload() {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeLater(new Thread(){

                    @Override
                    public void run() {
                        VirtualKeyboard.this.resetButtons();
                    }
                });
            }
            catch (Exception exception) {}
        } else {
            this.resetButtons();
        }
    }

    @Override
    public void ledStatusChange(int n) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                final int n2 = n;
                SwingUtilities.invokeLater(new Thread(){

                    @Override
                    public void run() {
                        VirtualKeyboard.this.updateLEDs(n2);
                    }
                });
            }
            catch (Exception exception) {}
        } else {
            this.updateLEDs(n);
        }
    }

    @Override
    public void mouseButtonsChange(int n) {
    }

    @Override
    public void mouseExecButtonsChange(int n) {
    }

    @Override
    public void main() {
    }

    @Override
    public boolean systemShutdown() {
        return true;
    }

    @Override
    public void pcStarting() {
    }

    @Override
    public void pcStopping() {
        if (this.pluginManager.isShuttingDown()) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Thread(){

                    @Override
                    public void run() {
                        VirtualKeyboard.this.resetButtons();
                    }
                });
            }
            catch (Exception exception) {}
        } else {
            this.resetButtons();
        }
    }

    @Override
    public void reconnect(PC pC) {
        if (this.keyboard != null) {
            this.keyboard.removeStatusListener(this);
        }
        if (pC != null) {
            Keyboard keyboard;
            this.keyboard = keyboard = (Keyboard)pC.getComponent(Keyboard.class);
            this.keyboard.addStatusListener(this);
            this.keyStatusReload();
        } else {
            this.keyboard = null;
            for (Map.Entry<String, Integer> entry : this.commandToKey.entrySet()) {
                String string = entry.getKey();
                Integer n = entry.getValue();
                this.cachedState[n.intValue()] = false;
                this.commandToButton.get(string).setSelected(false);
                this.ledStatusChange(-1);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl;
        if (this.keyboard == null) {
            return;
        }
        String string = actionEvent.getActionCommand();
        JToggleButton jToggleButton = this.commandToButton.get(string);
        int n = this.commandToKey.get(string);
        boolean bl2 = bl = n != 255 && (actionEvent.getModifiers() & 1) != 0;
        if (jToggleButton.isSelected()) {
            if (bl) {
                System.err.println("Informational: Keyhit on key " + n + ".");
            } else {
                System.err.println("Informational: Keydown on key " + n + ".");
            }
        } else if (bl) {
            System.err.println("Informational: Keyupdown on key " + n + ".");
        } else {
            System.err.println("Informational: Keyup on key " + n + ".");
        }
        try {
            this.keyboard.sendEdge(n);
            if (bl) {
                this.keyboard.sendEdge(n);
            }
        }
        catch (Exception exception) {
            System.err.println("Error: Sending command failed: " + exception);
            Misc.errorDialog(exception, "Failed to send keyboard key edge", null, "Dismiss");
        }
        if (!bl) {
            this.cachedState[n] = !this.cachedState[n];
        }
        jToggleButton.setSelected(this.cachedState[n]);
    }

    protected static class SimpleButtonBorder
    extends LineBorder {
        private static final long serialVersionUID = 1L;
        protected static Color nwColor = new Color(240, 240, 240);
        protected static Color seColor = new Color(130, 130, 130);
        protected static Color pressedColor = new Color(160, 160, 160);
        protected boolean thin;

        public SimpleButtonBorder(boolean bl) {
            super(Color.BLACK, 1, true);
            this.thin = bl;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            int n5;
            Color color = graphics.getColor();
            JToggleButton jToggleButton = (JToggleButton)component;
            ButtonModel buttonModel = jToggleButton.getModel();
            int n6 = n5 = this.thin ? 0 : 1;
            if (buttonModel.isSelected() || buttonModel.isPressed()) {
                graphics.setColor(seColor);
                graphics.drawRect(n + 1, n2 + 1, n3 - 2, 0);
                graphics.drawRect(n + 1, n2 + 1, 0, n4 - 2);
            } else {
                graphics.setColor(nwColor);
                graphics.drawRect(n + 1, n2 + 1, n3 - 2, n5);
                graphics.drawRect(n + 1, n2 + 1, n5, n4 - 2);
                graphics.setColor(seColor);
                graphics.drawRect(n + 1, n2 + n4 - 2, n3 - 2, 0);
                graphics.drawRect(n + n3 - 2, n2 + 1, 0, n4 - 2);
                if (!this.thin) {
                    graphics.drawRect(n + 2, n2 + n4 - 3, n3 - 3, 0);
                    graphics.drawRect(n + n3 - 3, n2 + 2, 0, n4 - 3);
                }
            }
            graphics.setColor(buttonModel.isPressed() ? pressedColor : this.lineColor);
            graphics.drawRoundRect(n, n2, n3 - 1, n4 - 1, 2, 2);
            graphics.setColor(color);
        }
    }

    protected static class KeyboardButtonUI
    extends BasicToggleButtonUI {
        protected static Color highlightColor = new Color(200, 200, 200);
        protected static Color backgroundColor = new Color(220, 220, 220);

        protected KeyboardButtonUI() {
        }

        protected void simplePaint(Graphics graphics, JComponent jComponent, Color color) {
            Insets insets;
            Rectangle rectangle = new Rectangle(jComponent.getSize());
            try {
                CompoundBorder compoundBorder = (CompoundBorder)jComponent.getBorder();
                insets = compoundBorder.getOutsideBorder().getBorderInsets(jComponent);
            }
            catch (ClassCastException classCastException) {
                insets = jComponent.getBorder().getBorderInsets(jComponent);
            }
            graphics.setColor(color);
            graphics.fillRect(rectangle.x + insets.left, rectangle.y + insets.top, rectangle.width - (insets.left + insets.right), rectangle.height - (insets.top + insets.bottom));
        }

        @Override
        protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
            this.simplePaint(graphics, abstractButton, highlightColor);
        }

        @Override
        public void paint(Graphics graphics, JComponent jComponent) {
            this.simplePaint(graphics, jComponent, backgroundColor);
            super.paint(graphics, jComponent);
        }
    }
}

