/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.pluginsaux;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;

public class AuthorsDialog
implements ActionListener,
WindowListener {
    private JFrame window = new JFrame("Change run authors");
    private JTable table;
    private Response response = null;
    private boolean answerReady = false;
    private AuthorModel model;
    private JButton removeButton;

    public AuthorsDialog(AuthorElement[] authorElementArray) {
        JPanel jPanel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(jPanel, 1);
        jPanel.setLayout(boxLayout);
        this.model = new AuthorModel(authorElementArray);
        this.table = new JTable(this.model);
        this.table.getSelectionModel().addListSelectionListener(new SelectionListener());
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jPanel.add(jScrollPane);
        this.window.add(jPanel);
        this.window.addWindowListener(this);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel.add(jPanel2);
        JButton jButton = new JButton("Add");
        jButton.setActionCommand("ADD");
        jButton.addActionListener(this);
        jButton.setMnemonic(65);
        this.removeButton = new JButton("Remove");
        this.removeButton.setActionCommand("REMOVE");
        this.removeButton.addActionListener(this);
        this.removeButton.setMnemonic(82);
        this.removeButton.setEnabled(false);
        JButton jButton2 = new JButton("Ok");
        jButton2.setActionCommand("CLOSE");
        jButton2.addActionListener(this);
        jButton2.setMnemonic(79);
        JButton jButton3 = new JButton("Cancel");
        jButton3.setActionCommand("CANCEL");
        jButton3.addActionListener(this);
        jButton3.setMnemonic(67);
        jPanel2.add(jButton);
        jPanel2.add(this.removeButton);
        jPanel2.add(jButton2);
        jPanel2.add(jButton3);
        Dimension dimension = jPanel2.getPreferredSize();
        dimension.height = (int)((double)dimension.width * 0.5);
        jScrollPane.setPreferredSize(dimension);
        this.window.pack();
        this.window.setVisible(true);
        this.window.setDefaultCloseOperation(0);
    }

    public synchronized Response waitClose() {
        if (this.answerReady) {
            this.answerReady = false;
            return this.response;
        }
        while (!this.answerReady) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.answerReady = false;
        return this.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "ADD") {
            AuthorElement authorElement = new AuthorElement();
            authorElement.nickName = "";
            authorElement.fullName = "";
            this.model.addAuthor(authorElement);
            int n = this.model.getRowCount() - 1;
            this.table.editCellAt(n, 0);
            this.table.setRowSelectionInterval(n, n);
            this.table.requestFocus();
        } else if (string == "REMOVE") {
            int n = this.table.getSelectedRow();
            n = this.table.convertRowIndexToModel(n);
            this.model.removeAuthor(n);
        } else {
            if (string == "CLOSE") {
                TableCellEditor tableCellEditor = this.table.getCellEditor();
                if (tableCellEditor != null) {
                    tableCellEditor.stopCellEditing();
                }
                this.response = new Response();
                this.response.authors = this.model.toArray();
                this.window.setVisible(false);
                this.window.dispose();
                AuthorsDialog authorsDialog = this;
                synchronized (authorsDialog) {
                    this.answerReady = true;
                    this.notifyAll();
                }
            }
            if (string == "CANCEL") {
                this.window.setVisible(false);
                this.window.dispose();
                AuthorsDialog authorsDialog = this;
                synchronized (authorsDialog) {
                    this.response = null;
                    this.answerReady = true;
                    this.notifyAll();
                }
            }
        }
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.window.setVisible(false);
        AuthorsDialog authorsDialog = this;
        synchronized (authorsDialog) {
            this.response = null;
            this.answerReady = true;
            this.notifyAll();
        }
    }

    public static AuthorElement[] readAuthorsFromHeaders(String[][] stringArray) {
        int n;
        if (stringArray == null) {
            stringArray = new String[1][];
        }
        int n2 = 0;
        for (String[] stringArray2 : stringArray) {
            int n3 = 0;
            boolean bl = true;
            if (stringArray2 == null || stringArray2.length == 0) continue;
            if (stringArray2[0].equals("AUTHORS")) {
                n3 = 1;
            }
            if (stringArray2[0].equals("AUTHORNICKS")) {
                n3 = 1;
            }
            if (stringArray2[0].equals("AUTHORFULL")) {
                n3 = 1;
                bl = false;
            }
            if (n3 == 0) continue;
            if (bl) {
                n2 += stringArray2.length - 1;
                continue;
            }
            ++n2;
        }
        String[][] stringArray3 = new AuthorElement[n2];
        for (n = 0; n < stringArray3.length; ++n) {
            stringArray3[n] = new AuthorElement();
        }
        n = 0;
        for (String[] stringArray4 : stringArray) {
            int n4;
            boolean bl = false;
            if (stringArray4 == null || stringArray4.length == 0) continue;
            if (stringArray4[0].equals("AUTHORS")) {
                for (n4 = 1; n4 < stringArray4.length; ++n4) {
                    stringArray3[n].fullName = stringArray4[n4];
                    stringArray3[n].nickName = null;
                    ++n;
                }
            }
            if (stringArray4[0].equals("AUTHORNICKS")) {
                for (n4 = 1; n4 < stringArray4.length; ++n4) {
                    stringArray3[n].nickName = stringArray4[n4];
                    stringArray3[n].fullName = null;
                    ++n;
                }
            }
            if (!stringArray4[0].equals("AUTHORFULL")) continue;
            if (stringArray4.length != 3) {
                System.err.println("Warning: Skipping bad AUTHORFULL header");
                continue;
            }
            stringArray3[n].fullName = stringArray4[1];
            stringArray3[n].nickName = stringArray4[2];
            ++n;
        }
        return stringArray3;
    }

    public static String[][] rewriteHeaderAuthors(String[][] stringArray, AuthorElement[] authorElementArray) {
        int n;
        String[][] stringArray2;
        int n2;
        if (stringArray == null) {
            stringArray = new String[1][];
        }
        int n3 = 0;
        for (String[] stringArray3 : stringArray) {
            int n4 = 1;
            if (stringArray3 == null || stringArray3.length == 0) continue;
            if (stringArray3[0].equals("AUTHORS")) {
                n4 = 0;
            }
            if (stringArray3[0].equals("AUTHORNICKS")) {
                n4 = 0;
            }
            if (stringArray3[0].equals("AUTHORFULL")) {
                n4 = 0;
            }
            if (n4 == 0) continue;
            ++n3;
        }
        int n5 = 0;
        int n6 = 0;
        for (AuthorElement authorElement : authorElementArray) {
            if (authorElement.fullName != null && authorElement.nickName == null && n5++ == 0) {
                ++n3;
            }
            if (authorElement.fullName == null && authorElement.nickName != null && n6++ == 0) {
                ++n3;
            }
            if (authorElement.fullName == null || authorElement.nickName == null) continue;
            ++n3;
        }
        if (n3 == 0) {
            return null;
        }
        AuthorElement[] authorElementArray2 = new String[n3][];
        int n7 = 0;
        for (String[] stringArray4 : stringArray) {
            n2 = 1;
            if (stringArray4 == null || stringArray4.length == 0) continue;
            if (stringArray4[0].equals("AUTHORS")) {
                n2 = 0;
            }
            if (stringArray4[0].equals("AUTHORNICKS")) {
                n2 = 0;
            }
            if (stringArray4[0].equals("AUTHORFULL")) {
                n2 = 0;
            }
            if (n2 == 0) continue;
            authorElementArray2[n7++] = stringArray4;
        }
        if (n5 > 0) {
            stringArray2 = new String[n5 + 1];
            authorElementArray2[n7++] = stringArray2;
            stringArray2[0] = "AUTHORS";
            n = 1;
            AuthorElement[] authorElementArray3 = authorElementArray;
            int n8 = authorElementArray3.length;
            for (n2 = 0; n2 < n8; ++n2) {
                AuthorElement authorElement = authorElementArray3[n2];
                if (authorElement.fullName == null || authorElement.nickName != null) continue;
                stringArray2[n++] = authorElement.fullName;
            }
        }
        if (n6 > 0) {
            stringArray2 = new String[n6 + 1];
            authorElementArray2[n7++] = stringArray2;
            stringArray2[0] = "AUTHORNICKS";
            n = 1;
            for (AuthorElement authorElement : authorElementArray) {
                if (authorElement.fullName != null || authorElement.nickName == null) continue;
                stringArray2[n++] = authorElement.nickName;
            }
        }
        for (String[] stringArray5 : authorElementArray) {
            if (stringArray5.fullName == null || stringArray5.nickName == null) continue;
            String[] stringArray6 = new String[3];
            authorElementArray2[n7++] = stringArray6;
            stringArray6[0] = "AUTHORFULL";
            stringArray6[1] = stringArray5.fullName;
            stringArray6[2] = stringArray5.nickName;
        }
        return authorElementArray2;
    }

    private class AuthorModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private Vector<AuthorElement> authors = new Vector();

        private AuthorModel(AuthorElement[] authorElementArray) {
            if (authorElementArray != null) {
                for (AuthorElement authorElement : authorElementArray) {
                    AuthorElement authorElement2 = new AuthorElement();
                    authorElement2.fullName = authorElement.fullName;
                    if (authorElement2.fullName == null) {
                        authorElement2.fullName = "";
                    }
                    authorElement2.nickName = authorElement.nickName;
                    if (authorElement2.nickName == null) {
                        authorElement2.nickName = "";
                    }
                    this.authors.add(authorElement2);
                }
            }
        }

        public void addAuthor(AuthorElement authorElement) {
            this.authors.add(authorElement);
            int n = this.authors.size();
            this.fireTableRowsInserted(n, n);
        }

        public void removeAuthor(int n) {
            TableCellEditor tableCellEditor = AuthorsDialog.this.table.getCellEditor();
            if (tableCellEditor != null) {
                tableCellEditor.stopCellEditing();
            }
            int n2 = 0;
            this.authors.remove(n);
            this.fireTableRowsDeleted(n, n);
            n2 = n == this.authors.size() ? this.authors.size() - 1 : n;
            if (n2 >= 0) {
                AuthorsDialog.this.table.setRowSelectionInterval(n2, n2);
            }
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.authors.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return "Full name";
            }
            return "Nickname";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            AuthorElement authorElement = this.authors.get(n);
            if (n2 == 0) {
                return authorElement.fullName;
            }
            return authorElement.nickName;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            AuthorElement authorElement = null;
            if (n < this.authors.size()) {
                authorElement = this.authors.get(n);
            } else {
                authorElement = new AuthorElement();
                authorElement.nickName = "";
                authorElement.fullName = "";
            }
            if (n2 == 0) {
                authorElement.fullName = (String)object;
            } else {
                authorElement.nickName = (String)object;
            }
            this.authors.set(n, authorElement);
        }

        public AuthorElement[] toArray() {
            AuthorElement[] authorElementArray = new AuthorElement[this.authors.size()];
            int n = 0;
            for (AuthorElement authorElement : this.authors) {
                authorElementArray[n] = new AuthorElement();
                authorElementArray[n].fullName = authorElement.fullName.equals("") ? null : authorElement.fullName;
                authorElementArray[n].nickName = authorElement.nickName.equals("") ? null : authorElement.nickName;
                ++n;
            }
            return authorElementArray;
        }
    }

    private class SelectionListener
    implements ListSelectionListener {
        private SelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            boolean bl = AuthorsDialog.this.table.getSelectedRow() != -1;
            AuthorsDialog.this.removeButton.setEnabled(bl);
        }
    }

    public class Response {
        public AuthorElement[] authors;
    }

    public static class AuthorElement {
        String fullName;
        String nickName;
    }
}

