/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.pluginsaux;

import java.util.LinkedList;
import java.util.List;
import org.jpc.pluginsaux.VGAFont;

public class HUDRenderer {
    int[] backgroundBuffer;
    int elementsAllocated;
    int backgroundWidth;
    int backgroundHeight;
    int flags;
    volatile int lightAmp = 1;
    volatile int gapLeft;
    volatile int gapTop;
    volatile int gapBottom;
    volatile int gapRight;
    List<RenderObject> renderObjects = new LinkedList<RenderObject>();

    public HUDRenderer(int n) {
        this.flags = n;
    }

    public synchronized void setBackground(int[] nArray, int n, int n2) {
        if (this.elementsAllocated < n * n2) {
            this.backgroundBuffer = new int[n * n2];
            this.elementsAllocated = n * n2;
        }
        if (n * n2 > 0) {
            System.arraycopy(nArray, 0, this.backgroundBuffer, 0, n * n2);
        }
        this.backgroundWidth = n;
        this.backgroundHeight = n2;
    }

    public synchronized int getRenderWidth() {
        return this.gapLeft + this.backgroundWidth + this.gapRight;
    }

    public synchronized int getRenderHeight() {
        return this.gapTop + this.backgroundHeight + this.gapBottom;
    }

    public synchronized void REMOTE_left_gap(int n, int n2) {
        if ((n & this.flags) != this.flags) {
            return;
        }
        this.gapLeft = n2 > 0 ? n2 : 0;
    }

    public synchronized void REMOTE_top_gap(int n, int n2) {
        if ((n & this.flags) != this.flags) {
            return;
        }
        this.gapTop = n2 > 0 ? n2 : 0;
    }

    public synchronized void REMOTE_right_gap(int n, int n2) {
        if ((n & this.flags) != this.flags) {
            return;
        }
        this.gapRight = n2 > 0 ? n2 : 0;
    }

    public synchronized void REMOTE_bottom_gap(int n, int n2) {
        if ((n & this.flags) != this.flags) {
            return;
        }
        this.gapBottom = n2 > 0 ? n2 : 0;
    }

    public synchronized void setLightAmplification(int n) {
        this.lightAmp = n;
    }

    public synchronized int[] getFinishedAndReset() {
        int n;
        int n2;
        int[] nArray = null;
        int n3 = this.getRenderWidth();
        if (n3 * (n2 = this.getRenderHeight()) > 0) {
            nArray = new int[n3 * n2];
        }
        if (this.lightAmp == 1) {
            for (n = 0; n < this.backgroundHeight; ++n) {
                System.arraycopy(this.backgroundBuffer, n * this.backgroundWidth, nArray, (n + this.gapTop) * n3 + this.gapLeft, this.backgroundWidth);
            }
        } else {
            for (n = 0; n < this.backgroundHeight; ++n) {
                for (int i = 0; i < this.backgroundWidth; ++i) {
                    nArray[(n + this.gapTop) * n3 + this.gapLeft + i] = this.backgroundBuffer[n * this.backgroundWidth + i] * this.lightAmp;
                }
            }
        }
        for (RenderObject renderObject : this.renderObjects) {
            if (nArray == null) continue;
            renderObject.render(nArray, n3, n2);
        }
        this.renderObjects.clear();
        this.gapBottom = 0;
        this.gapTop = 0;
        this.gapRight = 0;
        this.gapLeft = 0;
        return nArray;
    }

    final void renderPixel(int[] nArray, int n, int n2, int n3, int n4, boolean bl, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        if (n3 < 0 || n4 < 0 || n3 >= n || n4 >= n2) {
            return;
        }
        int n13 = n5;
        int n14 = n6;
        int n15 = n7;
        int n16 = n8;
        if (bl) {
            n13 = n9;
            n14 = n10;
            n15 = n11;
            n16 = n12;
        }
        n13 &= 0xFF;
        n14 &= 0xFF;
        n15 &= 0xFF;
        if ((n16 &= 0xFF) != 0) {
            if (n16 == 255) {
                nArray[n4 * n + n3] = n13 << 16 | n14 << 8 | n15;
            } else {
                int n17 = nArray[n4 * n + n3];
                float f = n17 >>> 16 & 0xFF;
                float f2 = n17 >>> 8 & 0xFF;
                float f3 = n17 & 0xFF;
                float f4 = (float)n16 / 255.0f;
                n13 = (int)((float)n13 * f4 + f * (1.0f - f4));
                n14 = (int)((float)n14 * f4 + f2 * (1.0f - f4));
                n15 = (int)((float)n15 * f4 + f3 * (1.0f - f4));
                nArray[n4 * n + n3] = n13 << 16 | n14 << 8 | n15;
            }
        }
    }

    public synchronized void REMOTE_white_solid_box(int n, int n2, int n3, int n4, int n5) {
        if ((n & this.flags) != this.flags) {
            return;
        }
        this.renderObjects.add(new WhiteSolidBox(n2, n3, n4, n5));
    }

    public synchronized void REMOTE_box(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14) {
        if ((n & this.flags) != this.flags) {
            return;
        }
        this.renderObjects.add(new Box(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14));
    }

    public synchronized void REMOTE_circle(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13) {
        if ((n & this.flags) != this.flags) {
            return;
        }
        this.renderObjects.add(new Circle(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13));
    }

    public synchronized void REMOTE_bitmap(int n, int n2, int n3, String string, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        if ((n & this.flags) != this.flags) {
            return;
        }
        this.renderObjects.add(new Bitmap(n2, n3, string, n4, n5, n6, n7, n8, n9, n10, n11));
    }

    public synchronized void REMOTE_bitmap_binary(int n, int n2, int n3, String string, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        if ((n & this.flags) != this.flags) {
            return;
        }
        this.renderObjects.add(new Bitmap(n2, n3, string, n4, n5, n6, n7, n8, n9, n10, n11, true));
    }

    public synchronized void REMOTE_vga_chargen(int n, int n2, int n3, String string, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, boolean bl) {
        if ((n & this.flags) != this.flags) {
            return;
        }
        this.renderObjects.add(new VGAChargen(n2, n3, string, n4, n5, n6, n7, n8, n9, n10, n11, bl));
    }

    private class VGAChargen
    extends RenderObject {
        int x;
        int y;
        int stride;
        boolean multiline;
        String vgaChargenString;
        int lineR;
        int lineG;
        int lineB;
        int lineA;
        int fillR;
        int fillG;
        int fillB;
        int fillA;

        VGAChargen(int n, int n2, String string, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, boolean bl) {
            this.x = n;
            this.y = n2;
            this.lineR = n3;
            this.lineG = n4;
            this.lineB = n5;
            this.lineA = n6;
            this.fillR = n7;
            this.fillG = n8;
            this.fillB = n9;
            this.fillA = n10;
            this.vgaChargenString = string;
            this.multiline = bl;
        }

        final void renderPartial(int[] nArray, int n, int n2, int n3, int n4, long l) {
            for (int i = 0; i < 64; ++i) {
                HUDRenderer.this.renderPixel(nArray, n, n2, n3 + 7 - i % 8, n4 + i / 8, (l >>> i & 1L) != 0L, this.fillR, this.fillG, this.fillB, this.fillA, this.lineR, this.lineG, this.lineB, this.lineA);
            }
        }

        @Override
        void render(int[] nArray, int n, int n2) {
            int n3 = this.x;
            int n4 = this.y;
            int n5 = this.vgaChargenString.length();
            for (int i = 0; i < n5; ++i) {
                int n6 = this.vgaChargenString.charAt(i) & 0xFF;
                if (this.multiline && (n6 == 13 || n6 == 10)) {
                    n4 += 16;
                    n3 = this.x;
                }
                if (n3 >= -7 && n4 >= -15 && n3 < n && n4 < n2) {
                    this.renderPartial(nArray, n, n2, n3, this.y, VGAFont.vgaFontData[2 * n6 + 0]);
                    this.renderPartial(nArray, n, n2, n3, this.y + 8, VGAFont.vgaFontData[2 * n6 + 1]);
                }
                n3 += 8;
            }
        }
    }

    private class Bitmap
    extends RenderObject {
        private static final int PIXELS_PER_ELEMENT = 31;
        int x;
        int y;
        int w;
        int h;
        int stride;
        int[] bitmapData;
        int lineR;
        int lineG;
        int lineB;
        int lineA;
        int fillR;
        int fillG;
        int fillB;
        int fillA;

        Bitmap(int n, int n2, String string, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, boolean bl) {
            int n11 = 0;
            this.x = n;
            this.y = n2;
            this.lineR = n3;
            this.lineG = n4;
            this.lineB = n5;
            this.lineA = n6;
            this.fillR = n7;
            this.fillG = n8;
            this.fillB = n9;
            this.fillA = n10;
            this.w = 0;
            this.h = 0;
            try {
                this.w = string.charAt(n11++);
                if (this.w > 127) {
                    this.w = this.w & 0x7F | string.charAt(n11++) << 7;
                }
                this.stride = (this.w + 31 - 1) / 31;
                int n12 = 4 * (this.w / 31);
                this.h = (string.length() - n11) / (n12 += (this.w % 31 + 7) / 8);
                this.bitmapData = new int[this.h * this.stride + 2];
                for (int i = 0; i < this.h; ++i) {
                    for (int j = 0; j < n12; ++j) {
                        int n13 = i * this.stride + j / 4;
                        this.bitmapData[n13] = this.bitmapData[n13] | string.charAt(n11++) << 8 * (j % 4);
                    }
                }
            }
            catch (Exception exception) {
                System.err.println("Bitmap: Failed to parse bitmap: " + exception.getMessage());
                exception.printStackTrace();
            }
        }

        Bitmap(int n, int n2, String string, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
            char c;
            int n11;
            this.x = n;
            this.y = n2;
            this.lineR = n3;
            this.lineG = n4;
            this.lineB = n5;
            this.lineA = n6;
            this.fillR = n7;
            this.fillG = n8;
            this.fillB = n9;
            this.fillA = n10;
            int n12 = 0;
            int n13 = 0;
            boolean bl = true;
            block7: for (n11 = 0; n11 < string.length(); ++n11) {
                c = string.charAt(n11);
                switch (c) {
                    case '\n': 
                    case '\r': {
                        if (!bl) {
                            ++n13;
                        }
                        n12 = 0;
                        bl = true;
                        continue block7;
                    }
                    default: {
                        bl = false;
                        if (n13 >= this.h) {
                            this.h = n13 + 1;
                        }
                        if (n12 >= this.w) {
                            this.w = n12 + 1;
                        }
                        ++n12;
                    }
                }
            }
            this.stride = (this.w + 31 - 1) / 31;
            this.bitmapData = new int[this.h * this.stride + 2];
            n12 = 0;
            n13 = 0;
            bl = true;
            block8: for (n11 = 0; n11 < string.length(); ++n11) {
                c = string.charAt(n11);
                switch (c) {
                    case '\n': 
                    case '\r': {
                        if (!bl) {
                            ++n13;
                        }
                        n12 = 0;
                        bl = true;
                        continue block8;
                    }
                    case ' ': 
                    case '.': {
                        bl = false;
                        ++n12;
                        continue block8;
                    }
                    default: {
                        int n14 = n13 * this.stride + n12 / 31;
                        this.bitmapData[n14] = this.bitmapData[n14] | 1 << n12 % 31;
                        bl = false;
                        ++n12;
                    }
                }
            }
        }

        @Override
        void render(int[] nArray, int n, int n2) {
            if (this.bitmapData == null) {
                return;
            }
            int n3 = 0;
            int n4 = this.bitmapData[n3];
            int n5 = 0;
            for (int i = this.y; i < this.y + this.h && i < n2; ++i) {
                for (int j = this.x; j < this.x + this.w; ++j) {
                    HUDRenderer.this.renderPixel(nArray, n, n2, j, i, (n4 >> n5 & 1) != 0, this.fillR, this.fillG, this.fillB, this.fillA, this.lineR, this.lineG, this.lineB, this.lineA);
                    if (++n5 != 31) continue;
                    n4 = this.bitmapData[++n3];
                    n5 = 0;
                }
                if (n5 <= 0) continue;
                n4 = this.bitmapData[++n3];
                n5 = 0;
            }
        }
    }

    private class Circle
    extends RenderObject {
        int x;
        int y;
        int r;
        long r2inner;
        long r2outer;
        int lineR;
        int lineG;
        int lineB;
        int lineA;
        int fillR;
        int fillG;
        int fillB;
        int fillA;

        Circle(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
            this.x = n;
            this.y = n2;
            this.r = n3;
            this.r2outer = (long)n3 * (long)n3;
            this.r2inner = n3 < n4 ? 0L : (long)(n3 - n4) * (long)(n3 - n4);
            this.lineR = n5;
            this.lineG = n6;
            this.lineB = n7;
            this.lineA = n8;
            this.fillR = n9;
            this.fillG = n10;
            this.fillB = n11;
            this.fillA = n12;
        }

        @Override
        void render(int[] nArray, int n, int n2) {
            for (int i = this.y - this.r; i < this.y + this.r && i < n2; ++i) {
                if (i < 0 || i >= n2) continue;
                for (int j = this.x - this.r; j < this.x + this.r && j < n; ++j) {
                    long l;
                    long l2;
                    long l3;
                    if (j < 0 || j >= n || (l3 = (l2 = (long)(j - this.x)) * l2 + (l = (long)(i - this.y)) * l) > this.r2outer) continue;
                    HUDRenderer.this.renderPixel(nArray, n, n2, j, i, l3 >= this.r2inner, this.fillR, this.fillG, this.fillB, this.fillA, this.lineR, this.lineG, this.lineB, this.lineA);
                }
            }
        }
    }

    private class Box
    extends RenderObject {
        int x;
        int y;
        int w;
        int h;
        int thick;
        int lineR;
        int lineG;
        int lineB;
        int lineA;
        int fillR;
        int fillG;
        int fillB;
        int fillA;

        Box(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13) {
            this.x = n;
            this.y = n2;
            this.w = n3;
            this.h = n4;
            this.thick = n5;
            this.lineR = n6;
            this.lineG = n7;
            this.lineB = n8;
            this.lineA = n9;
            this.fillR = n10;
            this.fillG = n11;
            this.fillB = n12;
            this.fillA = n13;
        }

        @Override
        void render(int[] nArray, int n, int n2) {
            for (int i = this.y; i < this.y + this.h && i < n2; ++i) {
                if (i < 0 || i >= n2) continue;
                for (int j = this.x; j < this.x + this.w && j < n; ++j) {
                    int n3 = j - this.x;
                    if (i - this.y < n3) {
                        n3 = i - this.y;
                    }
                    if (this.x + this.w - j - 1 < n3) {
                        n3 = this.x + this.w - j - 1;
                    }
                    if (this.y + this.h - i - 1 < n3) {
                        n3 = this.y + this.h - i - 1;
                    }
                    HUDRenderer.this.renderPixel(nArray, n, n2, j, i, n3 < this.thick, this.fillR, this.fillG, this.fillB, this.fillA, this.lineR, this.lineG, this.lineB, this.lineA);
                }
            }
        }
    }

    private class WhiteSolidBox
    extends RenderObject {
        int x;
        int y;
        int w;
        int h;

        WhiteSolidBox(int n, int n2, int n3, int n4) {
            this.x = n;
            this.y = n2;
            this.w = n3;
            this.h = n4;
        }

        @Override
        void render(int[] nArray, int n, int n2) {
            for (int i = this.y; i < this.y + this.h; ++i) {
                if (i < 0 || i >= n2) continue;
                for (int j = this.x; j < this.x + this.w; ++j) {
                    if (j < 0 || j >= n) continue;
                    nArray[i * n + j] = 0xFFFFFF;
                }
            }
        }
    }

    private abstract class RenderObject {
        private RenderObject() {
        }

        abstract void render(int[] var1, int var2, int var3);
    }
}

