/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.pluginsaux;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.jpc.Misc;

public class MenuManager
implements ActionListener {
    private static final long serialVersionUID = 9L;
    private JMenuBar menuBar = new JMenuBar();
    private Map<String, JMenu> menus = new HashMap<String, JMenu>();
    private Map<String, Integer> menuSubItems = new HashMap<String, Integer>();
    private Map<String, JMenuItem> menuItems = new HashMap<String, JMenuItem>();
    private Map<String, JCheckBoxMenuItem> selectableMenuItems = new HashMap<String, JCheckBoxMenuItem>();
    private Map<String, Object> cbObjects = new HashMap<String, Object>();
    private Map<String, Method> cbMethods = new HashMap<String, Method>();
    private Map<String, Object[]> cbArgs = new HashMap<String, Object[]>();
    private Map<String, Long> profiles = new HashMap<String, Long>();
    private long currentProfile = 0L;

    public void enable(String string) {
        this.setEnabled(string, true);
    }

    public void disable(String string) {
        this.setEnabled(string, false);
    }

    public void setEnabled(String string, boolean bl) {
        if (this.menuItems.containsKey(string)) {
            this.menuItems.get(string).setEnabled(bl);
        } else if (this.selectableMenuItems.containsKey(string)) {
            this.selectableMenuItems.get(string).setEnabled(bl);
        } else {
            System.err.println("Error: No such menu item " + string + ".");
        }
    }

    public boolean isEnabled(String string) {
        if (this.menuItems.containsKey(string)) {
            return this.menuItems.get(string).isEnabled();
        }
        if (this.selectableMenuItems.containsKey(string)) {
            return this.selectableMenuItems.get(string).isEnabled();
        }
        System.err.println("Error: No such menu item " + string + ".");
        return false;
    }

    public void select(String string) {
        this.setSelected(string, true);
    }

    public void unselect(String string) {
        this.setSelected(string, false);
    }

    public void setSelected(String string, boolean bl) {
        if (this.selectableMenuItems.containsKey(string)) {
            this.selectableMenuItems.get(string).setSelected(bl);
        } else {
            System.err.println("Error: No such selectable menu item " + string + ".");
        }
    }

    public void setAccel(String string, KeyStroke keyStroke) {
        if (this.menuItems.containsKey(string)) {
            this.menuItems.get(string).setAccelerator(keyStroke);
        } else {
            System.err.println("Error: No such menu item " + string + ".");
        }
    }

    public boolean isSelected(String string) {
        if (this.selectableMenuItems.containsKey(string)) {
            return this.selectableMenuItems.get(string).isSelected();
        }
        System.err.println("Error: No such selectable menu item " + string + ".");
        return false;
    }

    public void setProfile(long l) {
        long l2;
        Iterator<Map.Entry<String, JMenuItem>> iterator = this.menuItems.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, JMenuItem> entry;
            entry.getValue().setEnabled((l & (l2 = this.profiles.get((entry = iterator.next()).getKey()).longValue())) == l2);
        }
        for (Map.Entry<String, JMenuItem> entry : this.selectableMenuItems.entrySet()) {
            l2 = this.profiles.get(entry.getKey());
            ((JCheckBoxMenuItem)entry.getValue()).setEnabled((l & l2) == l2);
        }
        this.currentProfile = l;
    }

    public void removeMenuItem(String string) {
        String string2 = this.upperForItem(string);
        if (this.menuItems.containsKey(string)) {
            this.menus.get(string2).remove(this.menuItems.get(string));
            this.decrementCounter(string2);
            this.menuItems.remove(string);
        } else if (this.selectableMenuItems.containsKey(string)) {
            this.menus.get(string2).remove(this.selectableMenuItems.get(string));
            this.decrementCounter(string2);
            this.selectableMenuItems.remove(string);
        } else {
            System.err.println("Error: No such removable menu item " + string + ".");
        }
    }

    public void addMenuItem(String string, Object object, String string2, Object[] objectArray, long l, KeyStroke keyStroke) throws Exception {
        this.createItem(string);
        this.addCallback(string, object, string2, objectArray, l);
        this.setEnabled(string, (this.currentProfile & l) == l);
        if (keyStroke != null) {
            this.setAccel(string, keyStroke);
        }
    }

    public void addMenuItem(String string, Object object, String string2, Object[] objectArray, long l) throws Exception {
        this.addMenuItem(string, object, string2, objectArray, l, null);
    }

    public void addSelectableMenuItem(String string, Object object, String string2, Object[] objectArray, boolean bl, long l) throws Exception {
        this.createSelectableItem(string);
        this.addCallback(string, object, string2, objectArray, l);
        this.setEnabled(string, (this.currentProfile & l) == l);
        if (bl) {
            this.select(string);
        }
    }

    private void addCallback(String string, Object object, String string2, Object[] objectArray, long l) throws Exception {
        Object[] objectArray2 = new Object[1];
        Method method = object.getClass().getMethod(string2, String.class, objectArray2.getClass());
        this.cbObjects.put(string, object);
        this.cbMethods.put(string, method);
        this.cbArgs.put(string, objectArray);
        if (this.menuItems.containsKey(string)) {
            this.menuItems.get(string).addActionListener(this);
        } else if (this.selectableMenuItems.containsKey(string)) {
            this.selectableMenuItems.get(string).addActionListener(this);
        }
        this.profiles.put(string, new Long(l));
    }

    private void decrementCounter(String string) {
        String string2 = this.upperForItem(string);
        int n = this.menuSubItems.get(string) - 1;
        this.menuSubItems.put(string, new Integer(n));
        if (n == 0 && string2 != null) {
            this.menus.get(string2).remove(this.menus.get(string));
            this.menus.remove(string);
            this.decrementCounter(string2);
        }
    }

    private void createItem(String string) throws Exception {
        JMenuItem jMenuItem = null;
        String string2 = this.upperForItem(string);
        if (this.menuItems.containsKey(string) || this.selectableMenuItems.containsKey(string) || this.menus.containsKey(string)) {
            throw new Exception("Error: createItem: Conflicting item " + string + "!");
        }
        this._createNeededMenus(string2);
        jMenuItem = new JMenuItem(this.lastComponent(string));
        this.menus.get(string2).add(jMenuItem);
        this.incrementCounter(string2);
        this.menuItems.put(string, jMenuItem);
    }

    private void createSelectableItem(String string) throws Exception {
        JCheckBoxMenuItem jCheckBoxMenuItem = null;
        String string2 = this.upperForItem(string);
        if (this.menuItems.containsKey(string) || this.selectableMenuItems.containsKey(string) || this.menus.containsKey(string)) {
            throw new Exception("Error: createItem: Conflicting item " + string + "!");
        }
        this._createNeededMenus(string2);
        jCheckBoxMenuItem = new JCheckBoxMenuItem(this.lastComponent(string));
        this.menus.get(string2).add(jCheckBoxMenuItem);
        this.incrementCounter(string2);
        this.selectableMenuItems.put(string, jCheckBoxMenuItem);
    }

    private void _createNeededMenus(String string) throws Exception {
        JMenu jMenu = null;
        if (string == null) {
            throw new Exception("_createNeededMenus: item is NULL!");
        }
        if (this.menuItems.containsKey(string) || this.selectableMenuItems.containsKey(string)) {
            throw new Exception("Error: _createNeededMenus: Conflicting item " + string + "!");
        }
        if (this.menus.containsKey(string)) {
            return;
        }
        String string2 = this.upperForItem(string);
        if (string2 == null) {
            jMenu = new JMenu(this.lastComponent(string));
            this.menuBar.add(jMenu);
        } else {
            this._createNeededMenus(string2);
            jMenu = new JMenu(this.lastComponent(string));
            this.menus.get(string2).add(jMenu);
            this.incrementCounter(string2);
        }
        this.menuSubItems.put(string, new Integer(0));
        this.menus.put(string, jMenu);
    }

    private void incrementCounter(String string) {
        this.menuSubItems.put(string, new Integer(this.menuSubItems.get(string) + 1));
    }

    private String upperForItem(String string) {
        int n = string.lastIndexOf(8594);
        if (n < 0) {
            return null;
        }
        String string2 = string.substring(0, n);
        return string2;
    }

    private String lastComponent(String string) {
        int n = string.lastIndexOf(8594);
        if (n < 0) {
            return string;
        }
        String string2 = string.substring(n + 1);
        return string2;
    }

    public JMenuBar getMainBar() {
        return this.menuBar;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block8: {
            String string = null;
            for (Map.Entry<String, JMenuItem> entry : this.menuItems.entrySet()) {
                if (entry.getValue() != actionEvent.getSource()) continue;
                string = entry.getKey();
            }
            for (Map.Entry<String, JMenuItem> entry : this.selectableMenuItems.entrySet()) {
                if (entry.getValue() != actionEvent.getSource()) continue;
                string = entry.getKey();
            }
            if (this.cbMethods.containsKey(string)) {
                try {
                    if (this.cbObjects.get(string) == null) {
                        System.err.println("Warning: Dispatch menu to NULL object!");
                    }
                    this.cbMethods.get(string).invoke(this.cbObjects.get(string), string, this.cbArgs.get(string));
                }
                catch (Exception exception) {
                    if (exception != null && exception.getCause() != null) {
                        Misc.errorDialog(exception.getCause(), "Can't dispatch menu event", null, "Dismiss");
                        break block8;
                    }
                    Misc.errorDialog(exception, "Can't dispatch menu event", null, "Dismiss");
                }
            } else {
                System.err.println("actionPerformed on unknown object " + string + ".");
            }
        }
    }
}

