/*
 * Decompiled with CFR 0.152.
 */
package exceptiondefs;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

class ExceptionDefProcessor {
    private static Map<Class<?>, String> classes;

    ExceptionDefProcessor() {
    }

    private static char identity(char c) {
        return c;
    }

    private static String deriveLogFormat(String string) {
        String string2 = "$";
        return string.replaceFirst("\\" + string2 + "Format:([^" + string2 + "]*)\\" + string2 + ".*", "--pretty=format:$1");
    }

    private static String getRevision() throws IOException {
        String string = "1c00be7 by Ilari Liusvaara on 2010-10-09 21:49:14 +0300";
        if (ExceptionDefProcessor.identity(string.charAt(0)) != '$') {
            System.err.println("Detected revision: " + string + ".");
            return string;
        }
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command("git", "log", ExceptionDefProcessor.deriveLogFormat(string), "-1");
        Process process = processBuilder.start();
        InputStream inputStream = process.getInputStream();
        while (true) {
            try {
                if (process.waitFor() != 0) {
                    throw new IOException("Git subprocess failed");
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        string = bufferedReader.readLine();
        bufferedReader.close();
        System.err.println("Detected revision: " + string + ".");
        return string;
    }

    private static String getRelease() throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("VERSIONINFO"), "UTF-8"));
        String string = bufferedReader.readLine();
        bufferedReader.close();
        System.err.println("Detected release: " + string + ".");
        return string;
    }

    private static String escapeString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                stringBuffer.append("\"");
                continue;
            }
            if (c == '\\') {
                stringBuffer.append("\\");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static void doClass(String string) {
        Class<?> clazz;
        int n = string.indexOf(32);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        try {
            clazz = Class.forName(string2);
        }
        catch (Exception exception) {
            System.err.println("Warning: Can't find class \"" + string2 + "\", dropping.");
            return;
        }
        classes.put(clazz, string3);
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] stringArray) {
        void var4_12;
        Object object;
        Object object3;
        Object object4;
        classes = new HashMap();
        if (stringArray == null || stringArray.length < 1) {
            System.err.println("Syntax: java ExceptionDefProcessor <inputfile>");
            System.exit(1);
        }
        String string = stringArray[0];
        try {
            object4 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "UTF-8"));
            while ((object3 = ((BufferedReader)object4).readLine()) != null) {
                if (((String)object3).equals("")) continue;
                ExceptionDefProcessor.doClass((String)object3);
            }
        }
        catch (Exception exception) {
            System.err.println("Failed to load exception defintions: " + exception.getMessage());
        }
        object4 = null;
        block9: do {
            if (object4 != null) {
                classes.put((Class<?>)object4, ((Class)object4).getName());
            }
            object4 = null;
            for (Map.Entry object22 : classes.entrySet()) {
                object = ((Class)object22.getKey()).getSuperclass();
                if (((Class)object22.getKey()).getName().equals("java.lang.Error") || ((Class)object22.getKey()).getName().equals("java.lang.RuntimeException") || classes.containsKey(object)) continue;
                System.err.println("Warning: Missing superclass \"" + ((Class)object).getName() + "\" for \"" + ((Class)object22.getKey()).getName() + "\".");
                object4 = object;
                continue block9;
            }
        } while (object4 != null);
        object3 = null;
        try {
            object3 = new UTFStream("org/jpc/Exceptions.java");
        }
        catch (Exception exception) {
            System.err.println("Can't open org/jpc/Exceptions.java: " + exception.getMessage());
            System.exit(1);
        }
        ((UTFStream)object3).println("package org.jpc;");
        ((UTFStream)object3).println("import java.util.*;");
        ((UTFStream)object3).println("class Exceptions {");
        ((UTFStream)object3).println("public static Map<String,String> classes;");
        ((UTFStream)object3).println("static {");
        ((UTFStream)object3).println("classes = new HashMap<String,String>();");
        Object var4_8 = null;
        object = null;
        block11: do {
            void var4_9;
            if (var4_9 != null) {
                classes.remove(var4_9);
                ((UTFStream)object3).println("classes.put(\"" + var4_9.getName() + "\", \"" + object + "\");");
            }
            Object var4_10 = null;
            for (Map.Entry<Class<?>, String> entry : classes.entrySet()) {
                Class<?> clazz = entry.getKey().getSuperclass();
                if (classes.containsKey(clazz)) continue;
                Class<?> clazz2 = entry.getKey();
                object = entry.getValue();
                continue block11;
            }
        } while (var4_12 != null);
        ((UTFStream)object3).println("}}");
        ((UTFStream)object3).close();
        try {
            object3 = new UTFStream("org/jpc/Revision.java");
        }
        catch (Exception exception) {
            System.err.println("Can't open org/jpc/Revision.java: " + exception.getMessage());
            System.exit(1);
        }
        ((UTFStream)object3).println("package org.jpc;");
        ((UTFStream)object3).println("public class Revision {");
        ((UTFStream)object3).println("public static String getRevision() {");
        try {
            ((UTFStream)object3).println("return \"" + ExceptionDefProcessor.escapeString(ExceptionDefProcessor.getRevision()) + "\";");
            ((UTFStream)object3).println("}\npublic static String getRelease() {");
            ((UTFStream)object3).println("return \"" + ExceptionDefProcessor.escapeString(ExceptionDefProcessor.getRelease()) + "\";");
        }
        catch (Exception exception) {
            System.err.println("Can't get revision: " + exception.getMessage());
            System.exit(1);
        }
        ((UTFStream)object3).println("}}");
        ((UTFStream)object3).close();
    }

    static class UTFStream {
        FileOutputStream stream;

        UTFStream(String string) throws IOException {
            this.stream = new FileOutputStream(string);
        }

        void println(String string) {
            try {
                ByteBuffer byteBuffer = Charset.forName("UTF-8").newEncoder().encode(CharBuffer.wrap(string));
                byte[] byArray = new byte[byteBuffer.remaining() + 1];
                byteBuffer.get(byArray, 0, byteBuffer.remaining());
                byArray[byArray.length - 1] = 10;
                this.stream.write(byArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        void close() {
            try {
                this.stream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

