/*
 * Decompiled with CFR 0.152.
 */
package mnj.lua;

import java.io.PrintStream;
import java.util.Enumeration;
import mnj.lua.BaseLibReader;
import mnj.lua.Debug;
import mnj.lua.DumpedInput;
import mnj.lua.Lua;
import mnj.lua.LuaFunction;
import mnj.lua.LuaJavaCallback;
import mnj.lua.LuaTable;

public final class BaseLib
extends LuaJavaCallback {
    private static final int ASSERT = 1;
    private static final int COLLECTGARBAGE = 2;
    private static final int DOFILE = 3;
    private static final int ERROR = 4;
    private static final int GETFENV = 6;
    private static final int GETMETATABLE = 7;
    private static final int LOADFILE = 8;
    private static final int LOAD = 9;
    private static final int LOADSTRING = 10;
    private static final int NEXT = 11;
    private static final int PCALL = 12;
    private static final int PRINT = 13;
    private static final int RAWEQUAL = 14;
    private static final int RAWGET = 15;
    private static final int RAWSET = 16;
    private static final int SELECT = 17;
    private static final int SETFENV = 18;
    private static final int SETMETATABLE = 19;
    private static final int TONUMBER = 20;
    private static final int TOSTRING = 21;
    private static final int TYPE = 22;
    private static final int UNPACK = 23;
    private static final int XPCALL = 24;
    private static final int IPAIRS = 25;
    private static final int PAIRS = 26;
    private static final int IPAIRS_AUX = 27;
    private static final int PAIRS_AUX = 28;
    private static final int CREATE = 50;
    private static final int RESUME = 51;
    private static final int RUNNING = 52;
    private static final int STATUS = 53;
    private static final int WRAP = 54;
    private static final int YIELD = 55;
    private static final int WRAP_AUX = 56;
    private static final Object IPAIRS_AUX_FUN = new BaseLib(27);
    private static final Object PAIRS_AUX_FUN = new BaseLib(28);
    private int which;
    private Lua thread;
    private static final String[] CGOPTS = new String[]{"stop", "restart", "collect", "count", "step", "setpause", "setstepmul"};
    private static final int[] CGOPTSNUM = new int[]{0, 1, 2, 3, 5, 6, 7};
    static final PrintStream OUT = System.out;

    private BaseLib(int n) {
        this.which = n;
    }

    private BaseLib(Lua lua) {
        this(56);
        this.thread = lua;
    }

    @Override
    public int luaFunction(Lua lua) {
        switch (this.which) {
            case 1: {
                return BaseLib.assertFunction(lua);
            }
            case 2: {
                return BaseLib.collectgarbage(lua);
            }
            case 3: {
                return BaseLib.dofile(lua);
            }
            case 4: {
                return BaseLib.error(lua);
            }
            case 6: {
                return BaseLib.getfenv(lua);
            }
            case 7: {
                return BaseLib.getmetatable(lua);
            }
            case 25: {
                return BaseLib.ipairs(lua);
            }
            case 9: {
                return BaseLib.load(lua);
            }
            case 8: {
                return BaseLib.loadfile(lua);
            }
            case 10: {
                return BaseLib.loadstring(lua);
            }
            case 11: {
                return BaseLib.next(lua);
            }
            case 26: {
                return BaseLib.pairs(lua);
            }
            case 12: {
                return BaseLib.pcall(lua);
            }
            case 13: {
                return BaseLib.print(lua);
            }
            case 14: {
                return BaseLib.rawequal(lua);
            }
            case 15: {
                return BaseLib.rawget(lua);
            }
            case 16: {
                return BaseLib.rawset(lua);
            }
            case 17: {
                return BaseLib.select(lua);
            }
            case 18: {
                return BaseLib.setfenv(lua);
            }
            case 19: {
                return BaseLib.setmetatable(lua);
            }
            case 20: {
                return BaseLib.tonumber(lua);
            }
            case 21: {
                return BaseLib.tostring(lua);
            }
            case 22: {
                return BaseLib.type(lua);
            }
            case 23: {
                return BaseLib.unpack(lua);
            }
            case 24: {
                return BaseLib.xpcall(lua);
            }
            case 27: {
                return BaseLib.ipairsaux(lua);
            }
            case 28: {
                return BaseLib.pairsaux(lua);
            }
            case 50: {
                return BaseLib.create(lua);
            }
            case 51: {
                return BaseLib.resume(lua);
            }
            case 52: {
                return BaseLib.running(lua);
            }
            case 53: {
                return BaseLib.status(lua);
            }
            case 54: {
                return BaseLib.wrap(lua);
            }
            case 55: {
                return BaseLib.yield(lua);
            }
            case 56: {
                return this.wrapaux(lua);
            }
        }
        return 0;
    }

    public static void open(Lua lua) {
        lua.setGlobal("_G", lua.getGlobals());
        lua.setGlobal("_VERSION", "Lua 5.1 (Jill 1.0.1)");
        BaseLib.r(lua, "assert", 1);
        BaseLib.r(lua, "collectgarbage", 2);
        BaseLib.r(lua, "dofile", 3);
        BaseLib.r(lua, "error", 4);
        BaseLib.r(lua, "getfenv", 6);
        BaseLib.r(lua, "getmetatable", 7);
        BaseLib.r(lua, "ipairs", 25);
        BaseLib.r(lua, "loadfile", 8);
        BaseLib.r(lua, "load", 9);
        BaseLib.r(lua, "loadstring", 10);
        BaseLib.r(lua, "next", 11);
        BaseLib.r(lua, "pairs", 26);
        BaseLib.r(lua, "pcall", 12);
        BaseLib.r(lua, "print", 13);
        BaseLib.r(lua, "rawequal", 14);
        BaseLib.r(lua, "rawget", 15);
        BaseLib.r(lua, "rawset", 16);
        BaseLib.r(lua, "select", 17);
        BaseLib.r(lua, "setfenv", 18);
        BaseLib.r(lua, "setmetatable", 19);
        BaseLib.r(lua, "tonumber", 20);
        BaseLib.r(lua, "tostring", 21);
        BaseLib.r(lua, "type", 22);
        BaseLib.r(lua, "unpack", 23);
        BaseLib.r(lua, "xpcall", 24);
        lua.register("coroutine");
        BaseLib.c(lua, "create", 50);
        BaseLib.c(lua, "resume", 51);
        BaseLib.c(lua, "running", 52);
        BaseLib.c(lua, "status", 53);
        BaseLib.c(lua, "wrap", 54);
        BaseLib.c(lua, "yield", 55);
    }

    private static void r(Lua lua, String string, int n) {
        BaseLib baseLib = new BaseLib(n);
        lua.setGlobal(string, baseLib);
    }

    private static void c(Lua lua, String string, int n) {
        BaseLib baseLib = new BaseLib(n);
        lua.setField(lua.getGlobal("coroutine"), string, baseLib);
    }

    private static int assertFunction(Lua lua) {
        lua.checkAny(1);
        if (!lua.toBoolean(lua.value(1))) {
            lua.error(lua.optString(2, "assertion failed!"));
        }
        return lua.getTop();
    }

    private static int collectgarbage(Lua lua) {
        int n = lua.checkOption(1, "collect", CGOPTS);
        int n2 = lua.optInt(2, 0);
        int n3 = lua.gc(CGOPTSNUM[n], n2);
        switch (CGOPTSNUM[n]) {
            case 3: {
                int n4 = lua.gc(4, 0);
                lua.pushNumber((double)n3 + (double)n4 / 1024.0);
                return 1;
            }
            case 5: {
                lua.pushBoolean(n3 != 0);
                return 1;
            }
        }
        lua.pushNumber(n3);
        return 1;
    }

    private static int dofile(Lua lua) {
        String string = lua.optString(1, null);
        int n = lua.getTop();
        if (lua.loadFile(string) != 0) {
            lua.error(lua.value(-1));
        }
        lua.call(0, -1);
        return lua.getTop() - n;
    }

    private static int error(Lua lua) {
        int n = lua.optInt(2, 1);
        lua.setTop(1);
        if (Lua.isString(lua.value(1)) && n > 0) {
            lua.insert(lua.where(n), 1);
            lua.concat(2);
        }
        lua.error(lua.value(1));
        return 0;
    }

    private static Object getfunc(Lua lua) {
        Object object = lua.value(1);
        if (Lua.isFunction(object)) {
            return object;
        }
        int n = lua.optInt(1, 1);
        lua.argCheck(n >= 0, 1, "level must be non-negative");
        Debug debug = lua.getStack(n);
        if (debug == null) {
            lua.argRaiseError(1, "invalid level");
        }
        lua.getInfo("f", debug);
        object = lua.value(-1);
        if (Lua.isNil(object)) {
            lua.error("no function environment for tail call at level " + n);
        }
        lua.pop(1);
        return object;
    }

    private static int getfenv(Lua lua) {
        Object object = BaseLib.getfunc(lua);
        if (Lua.isJavaFunction(object)) {
            lua.push(lua.getGlobals());
        } else {
            LuaFunction luaFunction = (LuaFunction)object;
            lua.push(luaFunction.getEnv());
        }
        return 1;
    }

    private static int getmetatable(Lua lua) {
        lua.checkAny(1);
        LuaTable luaTable = lua.getMetatable(lua.value(1));
        if (luaTable == null) {
            lua.pushNil();
            return 1;
        }
        Object object = lua.getMetafield(lua.value(1), "__metatable");
        if (Lua.isNil(object)) {
            lua.push(luaTable);
        } else {
            lua.push(object);
        }
        return 1;
    }

    private static int load(Lua lua) {
        String string = lua.optString(2, "=(load)");
        lua.checkType(1, 6);
        BaseLibReader baseLibReader = new BaseLibReader(lua, lua.value(1));
        int n = lua.load(baseLibReader, string);
        return BaseLib.load_aux(lua, n);
    }

    private static int loadfile(Lua lua) {
        String string = lua.optString(1, null);
        return BaseLib.load_aux(lua, lua.loadFile(string));
    }

    private static int loadstring(Lua lua) {
        String string = lua.checkString(1);
        String string2 = lua.optString(2, string);
        if (string.startsWith("\u001b")) {
            return BaseLib.load_aux(lua, lua.load(new DumpedInput(string), string2));
        }
        return BaseLib.load_aux(lua, lua.loadString(string, string2));
    }

    private static int load_aux(Lua lua, int n) {
        if (n == 0) {
            return 1;
        }
        lua.insert(Lua.NIL, -1);
        return 2;
    }

    private static int next(Lua lua) {
        lua.checkType(1, 5);
        lua.setTop(2);
        if (lua.next(1)) {
            return 2;
        }
        lua.push(Lua.NIL);
        return 1;
    }

    private static int ipairs(Lua lua) {
        lua.checkType(1, 5);
        lua.push(IPAIRS_AUX_FUN);
        lua.pushValue(1);
        lua.pushNumber(0.0);
        return 3;
    }

    private static int ipairsaux(Lua lua) {
        int n = lua.checkInt(2);
        lua.checkType(1, 5);
        Object object = Lua.rawGetI(lua.value(1), ++n);
        if (Lua.isNil(object)) {
            return 0;
        }
        lua.pushNumber(n);
        lua.push(object);
        return 2;
    }

    private static int pairs(Lua lua) {
        lua.checkType(1, 5);
        lua.push(PAIRS_AUX_FUN);
        LuaTable luaTable = (LuaTable)lua.value(1);
        lua.push(new Object[]{luaTable, luaTable.keys()});
        lua.push(Lua.NIL);
        return 3;
    }

    private static int pairsaux(Lua lua) {
        Object[] objectArray = (Object[])lua.value(1);
        LuaTable luaTable = (LuaTable)objectArray[0];
        Enumeration enumeration = (Enumeration)objectArray[1];
        if (!enumeration.hasMoreElements()) {
            return 0;
        }
        Object e = enumeration.nextElement();
        lua.push(e);
        lua.push(luaTable.getlua(e));
        return 2;
    }

    private static int pcall(Lua lua) {
        lua.checkAny(1);
        int n = lua.pcall(lua.getTop() - 1, -1, null);
        boolean bl = n == 0;
        lua.insert(Lua.valueOfBoolean(bl), 1);
        return lua.getTop();
    }

    private static int print(Lua lua) {
        int n = lua.getTop();
        Object object = lua.getGlobal("tostring");
        for (int i = 1; i <= n; ++i) {
            lua.push(object);
            lua.pushValue(i);
            lua.call(1, 1);
            String string = lua.toString(lua.value(-1));
            if (string == null) {
                return lua.error("'tostring' must return a string to 'print'");
            }
            if (i > 1) {
                OUT.print('\t');
            }
            OUT.print(string);
            lua.pop(1);
        }
        OUT.println();
        return 0;
    }

    private static int rawequal(Lua lua) {
        lua.checkAny(1);
        lua.checkAny(2);
        lua.pushBoolean(Lua.rawEqual(lua.value(1), lua.value(2)));
        return 1;
    }

    private static int rawget(Lua lua) {
        lua.checkType(1, 5);
        lua.checkAny(2);
        lua.push(Lua.rawGet(lua.value(1), lua.value(2)));
        return 1;
    }

    private static int rawset(Lua lua) {
        lua.checkType(1, 5);
        lua.checkAny(2);
        lua.checkAny(3);
        lua.rawSet(lua.value(1), lua.value(2), lua.value(3));
        return 0;
    }

    private static int select(Lua lua) {
        int n = lua.getTop();
        if (lua.type(1) == 4 && "#".equals(lua.toString(lua.value(1)))) {
            lua.pushNumber(n - 1);
            return 1;
        }
        int n2 = lua.checkInt(1);
        if (n2 < 0) {
            n2 = n + n2;
        } else if (n2 > n) {
            n2 = n;
        }
        lua.argCheck(1 <= n2, 1, "index out of range");
        return n - n2;
    }

    private static int setfenv(Lua lua) {
        lua.checkType(2, 5);
        Object object = BaseLib.getfunc(lua);
        Object object2 = lua.value(1);
        if (Lua.isNumber(object2) && lua.toNumber(object2) == 0.0) {
            return 0;
        }
        if (Lua.isJavaFunction(object) || !lua.setFenv(object, lua.value(2))) {
            lua.error("'setfenv' cannot change environment of given object");
        }
        lua.push(object);
        return 1;
    }

    private static int setmetatable(Lua lua) {
        lua.checkType(1, 5);
        int n = lua.type(2);
        lua.argCheck(n == 0 || n == 5, 2, "nil or table expected");
        if (!Lua.isNil(lua.getMetafield(lua.value(1), "__metatable"))) {
            lua.error("cannot change a protected metatable");
        }
        lua.setMetatable(lua.value(1), lua.value(2));
        lua.setTop(1);
        return 1;
    }

    private static int tonumber(Lua lua) {
        int n = lua.optInt(2, 10);
        if (n == 10) {
            lua.checkAny(1);
            Object object = lua.value(1);
            if (Lua.isNumber(object)) {
                lua.pushNumber(lua.toNumber(object));
                return 1;
            }
        } else {
            String string = lua.checkString(1);
            lua.argCheck(2 <= n && n <= 36, 2, "base out of range");
            try {
                int n2 = Integer.parseInt(string, n);
                lua.pushNumber(n2);
                return 1;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        lua.push(Lua.NIL);
        return 1;
    }

    private static int tostring(Lua lua) {
        lua.checkAny(1);
        Object object = lua.value(1);
        if (lua.callMeta(1, "__tostring")) {
            return 1;
        }
        switch (lua.type(1)) {
            case 3: {
                lua.push(lua.toString(object));
                break;
            }
            case 4: {
                lua.push(object);
                break;
            }
            case 1: {
                if (lua.toBoolean(object)) {
                    lua.pushLiteral("true");
                    break;
                }
                lua.pushLiteral("false");
                break;
            }
            case 0: {
                lua.pushLiteral("nil");
                break;
            }
            default: {
                lua.push(object.toString());
            }
        }
        return 1;
    }

    private static int type(Lua lua) {
        lua.checkAny(1);
        lua.push(lua.typeNameOfIndex(1));
        return 1;
    }

    private static int unpack(Lua lua) {
        int n;
        lua.checkType(1, 5);
        LuaTable luaTable = (LuaTable)lua.value(1);
        int n2 = lua.optInt(3, luaTable.getn());
        int n3 = n2 - n + 1;
        if (n3 <= 0) {
            return 0;
        }
        for (n = lua.optInt(2, 1); n <= n2; ++n) {
            lua.push(luaTable.getnum(n));
        }
        return n3;
    }

    private static int xpcall(Lua lua) {
        lua.checkAny(2);
        Object object = lua.value(2);
        lua.setTop(1);
        int n = lua.pcall(0, -1, object);
        lua.insert(Lua.valueOfBoolean(n == 0), 1);
        return lua.getTop();
    }

    private static int create(Lua lua) {
        Lua lua2 = lua.newThread();
        Object object = lua.value(1);
        lua.argCheck(Lua.isFunction(object) && !Lua.isJavaFunction(object), 1, "Lua function expected");
        lua.setTop(1);
        lua.xmove(lua2, 1);
        lua.push(lua2);
        return 1;
    }

    private static int resume(Lua lua) {
        Lua lua2 = lua.toThread(lua.value(1));
        lua.argCheck(lua2 != null, 1, "coroutine expected");
        int n = BaseLib.auxresume(lua, lua2, lua.getTop() - 1);
        if (n < 0) {
            lua.insert(Lua.valueOfBoolean(false), -1);
            return 2;
        }
        lua.insert(Lua.valueOfBoolean(true), lua.getTop() - (n - 1));
        return n + 1;
    }

    private static int running(Lua lua) {
        if (lua.isMain()) {
            return 0;
        }
        lua.push(lua);
        return 1;
    }

    private static int status(Lua lua) {
        Lua lua2 = lua.toThread(lua.value(1));
        lua.argCheck(lua2 != null, 1, "coroutine expected");
        if (lua == lua2) {
            lua.pushLiteral("running");
        } else {
            switch (lua2.status()) {
                case 1: {
                    lua.pushLiteral("suspended");
                    break;
                }
                case 0: {
                    Debug debug = lua2.getStack(0);
                    if (debug != null) {
                        lua.pushLiteral("normal");
                        break;
                    }
                    if (lua2.getTop() == 0) {
                        lua.pushLiteral("dead");
                        break;
                    }
                    lua.pushLiteral("suspended");
                    break;
                }
                default: {
                    lua.pushLiteral("dead");
                }
            }
        }
        return 1;
    }

    private static int wrap(Lua lua) {
        BaseLib.create(lua);
        lua.push(BaseLib.wrapit(lua.toThread(lua.value(-1))));
        return 1;
    }

    private static LuaJavaCallback wrapit(Lua lua) {
        return new BaseLib(lua);
    }

    private int wrapaux(Lua lua) {
        Lua lua2 = this.thread;
        int n = BaseLib.auxresume(lua, lua2, lua.getTop());
        if (n < 0) {
            if (Lua.isString(lua.value(-1))) {
                String string = lua.where(1);
                lua.insert(string, -1);
                lua.concat(2);
            }
            lua.error(lua.value(-1));
        }
        return n;
    }

    private static int auxresume(Lua lua, Lua lua2, int n) {
        if (lua2.status() == 0 && lua2.getTop() == 0) {
            lua.pushLiteral("cannot resume dead coroutine");
            return -1;
        }
        lua.xmove(lua2, n);
        int n2 = lua2.resume(n);
        if (n2 == 0 || n2 == 1) {
            int n3 = lua2.getTop();
            lua2.xmove(lua, n3);
            return n3;
        }
        lua2.xmove(lua, 1);
        return -1;
    }

    private static int yield(Lua lua) {
        return lua.yield(lua.getTop());
    }
}

