/*
 * Decompiled with CFR 0.152.
 */
package mnj.lua;

import mnj.lua.Lua;
import mnj.lua.Syntax;

final class FormatItem {
    private Lua L;
    private boolean left;
    private boolean sign;
    private boolean space;
    private boolean alt;
    private boolean zero;
    private int width;
    private int precision = -1;
    private char type;
    private int length;
    static char E_LOWER = (char)69;
    static char E_UPPER = (char)69;

    FormatItem(Lua lua, String string) {
        this.L = lua;
        int n = 0;
        int n2 = string.length();
        block14: while (true) {
            if (n >= n2) {
                lua.error("invalid format");
            }
            switch (string.charAt(n)) {
                case '-': {
                    this.left = true;
                    break;
                }
                case '+': {
                    this.sign = true;
                    break;
                }
                case ' ': {
                    this.space = true;
                    break;
                }
                case '#': {
                    this.alt = true;
                    break;
                }
                case '0': {
                    this.zero = true;
                    break;
                }
                default: {
                    break block14;
                }
            }
            ++n;
        }
        int n3 = n;
        while (true) {
            if (n >= n2) {
                lua.error("invalid format");
            }
            if (!Syntax.isdigit(string.charAt(n))) break;
            ++n;
        }
        if (n3 < n) {
            try {
                this.width = Integer.parseInt(string.substring(n3, n));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (string.charAt(n) == '.') {
            int n4 = ++n;
            while (true) {
                if (n >= n2) {
                    lua.error("invalid format");
                }
                if (!Syntax.isdigit(string.charAt(n))) break;
                ++n;
            }
            if (n4 < n) {
                try {
                    this.precision = Integer.parseInt(string.substring(n4, n));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        switch (string.charAt(n)) {
            case 'E': 
            case 'G': 
            case 'X': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': 
            case 'g': 
            case 'i': 
            case 'o': 
            case 'q': 
            case 's': 
            case 'u': 
            case 'x': {
                this.type = string.charAt(n);
                this.length = n + 1;
                return;
            }
        }
        lua.error("invalid option to 'format'");
    }

    int length() {
        return this.length;
    }

    int type() {
        return this.type;
    }

    private void format(StringBuffer stringBuffer, String string) {
        int n = string.length();
        if (n >= this.width) {
            stringBuffer.append(string);
            return;
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        while (n < this.width) {
            stringBuffer2.append(' ');
            ++n;
        }
        if (this.left) {
            stringBuffer.append(string);
            stringBuffer.append(stringBuffer2);
        } else {
            stringBuffer.append(stringBuffer2);
            stringBuffer.append(string);
        }
    }

    void formatChar(StringBuffer stringBuffer, char c) {
        String string = String.valueOf(c);
        this.format(stringBuffer, string);
    }

    void formatInteger(StringBuffer stringBuffer, long l) {
        if (this.left) {
            this.zero = false;
        }
        if (this.precision >= 0) {
            this.zero = false;
        }
        int n = 10;
        switch (this.type) {
            case 'o': {
                n = 8;
                break;
            }
            case 'd': 
            case 'i': 
            case 'u': {
                n = 10;
                break;
            }
            case 'X': 
            case 'x': {
                n = 16;
                break;
            }
            default: {
                this.L.error("invalid format");
            }
        }
        String string = Long.toString(l, n);
        if (this.type == 'X') {
            string = string.toUpperCase();
        }
        if (this.precision == 0 && string.equals("0")) {
            string = "";
        }
        String string2 = "";
        if (string.startsWith("-")) {
            string2 = "-";
            string = string.substring(1);
        }
        if (this.alt && n == 16) {
            string2 = "0x";
        }
        if (string2 == "") {
            if (this.sign) {
                string2 = "+";
            } else if (this.space) {
                string2 = " ";
            }
        }
        if (this.alt && n == 8 && !string.startsWith("0")) {
            string = "0" + string;
        }
        int n2 = string.length();
        if (this.zero) {
            this.precision = this.width - string2.length();
            this.width = 0;
        }
        if (n2 < this.precision) {
            StringBuffer stringBuffer2 = new StringBuffer();
            while (n2 < this.precision) {
                stringBuffer2.append('0');
                ++n2;
            }
            stringBuffer2.append(string);
            string = stringBuffer2.toString();
        }
        string = string2 + string;
        this.format(stringBuffer, string);
    }

    void formatFloat(StringBuffer stringBuffer, double d) {
        switch (this.type) {
            case 'G': 
            case 'g': {
                this.formatFloatG(stringBuffer, d);
                return;
            }
            case 'f': {
                this.formatFloatF(stringBuffer, d);
                return;
            }
            case 'E': 
            case 'e': {
                this.formatFloatE(stringBuffer, d);
                return;
            }
        }
    }

    private void formatFloatE(StringBuffer stringBuffer, double d) {
        String string = this.formatFloatRawE(d);
        this.format(stringBuffer, string);
    }

    private String formatFloatRawE(double d) {
        int n;
        double d2 = Math.abs(d);
        int n2 = 0;
        if (d2 >= 0.001 && d2 < 1.0E7) {
            d *= 1.0E10;
            n2 = 10;
        }
        String string = Double.toString(d);
        StringBuffer stringBuffer = new StringBuffer(string);
        if (d == 0.0) {
            n = 0;
        } else {
            int n3 = string.indexOf(69);
            n = Integer.parseInt(string.substring(n3 + 1));
            stringBuffer.delete(n3, Integer.MAX_VALUE);
        }
        this.precisionTrim(stringBuffer);
        n -= n2;
        if (Character.isLowerCase(this.type)) {
            stringBuffer.append(E_LOWER);
        } else {
            stringBuffer.append(E_UPPER);
        }
        if (n >= 0) {
            stringBuffer.append('+');
        }
        stringBuffer.append(Integer.toString(n));
        this.zeroPad(stringBuffer);
        return stringBuffer.toString();
    }

    private void formatFloatF(StringBuffer stringBuffer, double d) {
        String string = this.formatFloatRawF(d);
        this.format(stringBuffer, string);
    }

    private String formatFloatRawF(double d) {
        String string = Double.toString(d);
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = string.indexOf(46);
        int n2 = string.indexOf(69);
        if (n2 >= 0) {
            int n3;
            stringBuffer.delete(n2, Integer.MAX_VALUE);
            int n4 = Integer.parseInt(string.substring(n2 + 1));
            StringBuffer stringBuffer2 = new StringBuffer();
            for (n3 = 0; n3 < Math.abs(n4); ++n3) {
                stringBuffer2.append('0');
            }
            if (n4 > 0) {
                stringBuffer.deleteCharAt(n);
                stringBuffer.append(stringBuffer2);
                stringBuffer.insert(n + n4, '.');
            } else {
                stringBuffer.deleteCharAt(n);
                n3 = stringBuffer.charAt(0) == '-' ? 1 : 0;
                stringBuffer.insert(n3, stringBuffer2);
                stringBuffer.insert(n, '.');
            }
        }
        this.precisionTrim(stringBuffer);
        this.zeroPad(stringBuffer);
        return stringBuffer.toString();
    }

    private void formatFloatG(StringBuffer stringBuffer, double d) {
        String string;
        double d2;
        if (this.precision == 0) {
            this.precision = 1;
        }
        if (this.precision < 0) {
            this.precision = 6;
        }
        if ((d2 = Math.abs(d)) == 0.0) {
            string = "0";
        } else if (d2 < 1.0E-4 || d2 >= Lua.iNumpow(10.0, this.precision)) {
            --this.precision;
            string = this.formatFloatRawE(d);
            int n = string.indexOf(46);
            if (n >= 0) {
                int n2 = string.indexOf(69);
                if (n2 < 0) {
                    n2 = string.indexOf(101);
                }
                int n3 = n2 - 1;
                while (string.charAt(n3) == '0') {
                    --n3;
                }
                if (string.charAt(n3) != '.') {
                    ++n3;
                }
                StringBuffer stringBuffer2 = new StringBuffer(string);
                stringBuffer2.delete(n3, n2);
                string = stringBuffer2.toString();
            }
        } else {
            int n = this.precision;
            this.precision += 3;
            string = this.formatFloatRawF(d);
            int n4 = 0;
            while (string.charAt(n4) == '0' || string.charAt(n4) == '.') {
                ++n4;
            }
            StringBuffer stringBuffer3 = new StringBuffer(string);
            stringBuffer3.delete(n4 + n, Integer.MAX_VALUE);
            if (string.indexOf(46) < stringBuffer3.length()) {
                int n5 = stringBuffer3.length() - 1;
                while (stringBuffer3.charAt(n5) == '0') {
                    stringBuffer3.deleteCharAt(n5);
                    --n5;
                }
                if (stringBuffer3.charAt(n5) == '.') {
                    stringBuffer3.deleteCharAt(n5);
                }
            }
            string = stringBuffer3.toString();
        }
        this.format(stringBuffer, string);
    }

    void formatString(StringBuffer stringBuffer, String string) {
        String string2 = string;
        if (this.precision >= 0 && this.precision < string.length()) {
            string2 = string.substring(0, this.precision);
        }
        this.format(stringBuffer, string2);
    }

    private void precisionTrim(StringBuffer stringBuffer) {
        int n;
        if (this.precision < 0) {
            this.precision = 6;
        }
        String string = stringBuffer.toString();
        int n2 = string.indexOf(46);
        if (0 == this.precision) {
            stringBuffer.delete(n2, Integer.MAX_VALUE);
        } else if (n > n2 + this.precision) {
            stringBuffer.delete(n2 + this.precision + 1, Integer.MAX_VALUE);
        } else {
            for (n = stringBuffer.length(); n <= n2 + this.precision; ++n) {
                stringBuffer.append('0');
            }
        }
    }

    private void zeroPad(StringBuffer stringBuffer) {
        if (this.zero && stringBuffer.length() < this.width) {
            int n;
            int n2 = n = stringBuffer.charAt(0) == '-' ? 1 : 0;
            while (stringBuffer.length() < this.width) {
                stringBuffer.insert(n, '0');
            }
        }
    }
}

