/*
 * Decompiled with CFR 0.152.
 */
package mnj.lua;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import mnj.lua.LocVar;
import mnj.lua.Lua;
import mnj.lua.Proto;
import mnj.lua.Slot;

final class Loader {
    private boolean bigendian;
    private InputStream in;
    private byte[] intbuf = new byte[4];
    private byte[] longbuf = new byte[8];
    private static final int HEADERSIZE = 12;
    static final byte[] HEADER = new byte[]{27, 76, 117, 97, 81, 0, 99, 4, 4, 4, 8, 0};

    Loader(InputStream inputStream, String string) {
        if (null == inputStream) {
            throw new NullPointerException();
        }
        this.in = inputStream;
    }

    Proto undump() throws IOException {
        this.header();
        return this.function(null);
    }

    private void block(byte[] byArray) throws IOException {
        int n = this.in.read(byArray);
        if (n != byArray.length) {
            throw new EOFException();
        }
    }

    private int byteLoad() throws IOException {
        int n = this.in.read();
        if (n == -1) {
            throw new EOFException();
        }
        return n & 0xFF;
    }

    private int[] code() throws IOException {
        int n = this.intLoad();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.intLoad();
        }
        return nArray;
    }

    private Slot[] constant() throws IOException {
        int n = this.intLoad();
        Slot[] slotArray = new Slot[n];
        block6: for (int i = 0; i < n; ++i) {
            int n2 = this.byteLoad();
            switch (n2) {
                case 0: {
                    slotArray[i] = new Slot(Lua.NIL);
                    continue block6;
                }
                case 1: {
                    int n3 = this.byteLoad();
                    if (n3 > 1) {
                        throw new IOException();
                    }
                    slotArray[i] = new Slot(Lua.valueOfBoolean(n3 != 0));
                    continue block6;
                }
                case 3: {
                    slotArray[i] = new Slot(this.number());
                    continue block6;
                }
                case 4: {
                    slotArray[i] = new Slot(this.string());
                    continue block6;
                }
                default: {
                    throw new IOException();
                }
            }
        }
        return slotArray;
    }

    private void debug(Proto proto) throws IOException {
        int n = this.intLoad();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.intLoad();
        }
        n = this.intLoad();
        LocVar[] locVarArray = new LocVar[n];
        for (int i = 0; i < n; ++i) {
            String string = this.string();
            int n2 = this.intLoad();
            int n3 = this.intLoad();
            locVarArray[i] = new LocVar(string, n2, n3);
        }
        n = this.intLoad();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.string();
        }
        proto.debug(nArray, locVarArray, stringArray);
    }

    private Proto function(String string) throws IOException {
        String string2 = this.string();
        if (null == string2) {
            string2 = string;
        }
        int n = this.intLoad();
        int n2 = this.intLoad();
        int n3 = this.byteLoad();
        int n4 = this.byteLoad();
        int n5 = this.byteLoad();
        if (n5 < 0 || n5 > 3) {
            throw new IOException();
        }
        boolean bl = 0 != n5;
        int n6 = this.byteLoad();
        int[] nArray = this.code();
        Slot[] slotArray = this.constant();
        Proto[] protoArray = this.proto(string2);
        Proto proto = new Proto(slotArray, nArray, protoArray, n3, n4, bl, n6);
        proto.setSource(string2);
        proto.setLinedefined(n);
        proto.setLastlinedefined(n2);
        this.debug(proto);
        return proto;
    }

    private void header() throws IOException {
        byte[] byArray = new byte[12];
        this.block(byArray);
        Loader.HEADER[6] = byArray[6];
        if (byArray[6] < 0 || byArray[6] > 1 || !Loader.arrayEquals(HEADER, byArray)) {
            throw new IOException();
        }
        this.bigendian = byArray[6] == 0;
    }

    private int intLoad() throws IOException {
        this.block(this.intbuf);
        int n = this.bigendian ? (this.intbuf[0] & 0xFF) << 24 | (this.intbuf[1] & 0xFF) << 16 | (this.intbuf[2] & 0xFF) << 8 | this.intbuf[3] & 0xFF : (this.intbuf[3] & 0xFF) << 24 | (this.intbuf[2] & 0xFF) << 16 | (this.intbuf[1] & 0xFF) << 8 | this.intbuf[0] & 0xFF;
        return n;
    }

    private Object number() throws IOException {
        this.block(this.longbuf);
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            l = this.bigendian ? l << 8 | (long)(this.longbuf[i] & 0xFF) : l >>> 8 | (long)(this.longbuf[i] & 0xFF) << 56;
        }
        double d = Double.longBitsToDouble(l);
        return Lua.valueOfNumber(d);
    }

    private Proto[] proto(String string) throws IOException {
        int n = this.intLoad();
        Proto[] protoArray = new Proto[n];
        for (int i = 0; i < n; ++i) {
            protoArray[i] = this.function(string);
        }
        return protoArray;
    }

    private String string() throws IOException {
        int n = this.intLoad();
        if (n == 0) {
            return null;
        }
        byte[] byArray = new byte[n - 1];
        this.block(byArray);
        if (this.in.read() == -1) {
            throw new EOFException();
        }
        return new String(byArray, "UTF-8").intern();
    }

    private static boolean arrayEquals(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }
}

