/*
 * Decompiled with CFR 0.152.
 */
package mnj.lua;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import mnj.lua.CallInfo;
import mnj.lua.Debug;
import mnj.lua.DumpState;
import mnj.lua.FormatItem;
import mnj.lua.Hook;
import mnj.lua.LuaError;
import mnj.lua.LuaFunction;
import mnj.lua.LuaInternal;
import mnj.lua.LuaJavaCallback;
import mnj.lua.LuaTable;
import mnj.lua.LuaUserdata;
import mnj.lua.Proto;
import mnj.lua.Slot;
import mnj.lua.StringReader;
import mnj.lua.UpVal;

public final class Lua {
    public static final String VERSION = "Lua 5.1 (Jill 1.0.1)";
    private LuaTable global;
    private LuaTable registry;
    private Lua main;
    private Slot[] stack = new Slot[0];
    int stackhighwater;
    private int stackSize;
    private int base;
    int nCcalls;
    private int savedpc;
    private Stack<Object> civ = new Stack();
    private Vector<Object> openupval;
    int hookcount;
    int basehookcount;
    boolean allowhook;
    Hook hook;
    int hookmask;
    static final int LFIELDS_PER_FLUSH = 50;
    private static final int MAXTAGLOOP = 100;
    private Object errfunc;
    private int status;
    private LuaTable[] metatable;
    static final int MAXVARS = 200;
    static final int MAXSTACK = 250;
    static final int MAXUPVALUES = 60;
    static final Object NUMBER = new Object();
    private static final Slot SPARE_SLOT = new Slot();
    static final String LOADED = "_LOADED";
    public static final int MULTRET = -1;
    public static final Object NIL = new Object();
    public static final int TNONE = -1;
    public static final int TNIL = 0;
    public static final int TBOOLEAN = 1;
    public static final int TNUMBER = 3;
    public static final int TSTRING = 4;
    public static final int TTABLE = 5;
    public static final int TFUNCTION = 6;
    public static final int TUSERDATA = 7;
    public static final int TTHREAD = 8;
    private static final int NUM_TAGS = 9;
    private static final String[] TYPENAME = new String[]{"nil", "boolean", "userdata", "number", "string", "table", "function", "userdata", "thread"};
    public static final int MINSTACK = 20;
    public static final int YIELD = 1;
    public static final int ERRRUN = 2;
    public static final int ERRSYNTAX = 3;
    private static final int ERRMEM = 4;
    public static final int ERRERR = 5;
    public static final int ERRFILE = 6;
    public static final int GCSTOP = 0;
    public static final int GCRESTART = 1;
    public static final int GCCOLLECT = 2;
    public static final int GCCOUNT = 3;
    public static final int GCCOUNTB = 4;
    public static final int GCSTEP = 5;
    public static final int GCSETPAUSE = 6;
    public static final int GCSETSTEPMUL = 7;
    private static final int HOOKLINE = 2;
    public static final int HOOKCOUNT = 3;
    private static final int HOOKTAILRET = 4;
    private static final int MASKLINE = 4;
    public static final int MASKCOUNT = 8;
    private static final String MEMERRMSG = "not enough memory";
    private static final int IDSIZE = 60;
    private static final int PCRLUA = 0;
    private static final int PCRJ = 1;
    private static final int PCRYIELD = 2;
    static final int NO_REG = 255;
    static final int OP_MOVE = 0;
    static final int OP_LOADK = 1;
    static final int OP_LOADBOOL = 2;
    static final int OP_LOADNIL = 3;
    static final int OP_GETUPVAL = 4;
    static final int OP_GETGLOBAL = 5;
    static final int OP_GETTABLE = 6;
    static final int OP_SETGLOBAL = 7;
    static final int OP_SETUPVAL = 8;
    static final int OP_SETTABLE = 9;
    static final int OP_NEWTABLE = 10;
    static final int OP_SELF = 11;
    static final int OP_ADD = 12;
    static final int OP_SUB = 13;
    static final int OP_MUL = 14;
    static final int OP_DIV = 15;
    static final int OP_MOD = 16;
    static final int OP_POW = 17;
    static final int OP_UNM = 18;
    static final int OP_NOT = 19;
    static final int OP_LEN = 20;
    static final int OP_CONCAT = 21;
    static final int OP_JMP = 22;
    static final int OP_EQ = 23;
    static final int OP_LT = 24;
    static final int OP_LE = 25;
    static final int OP_TEST = 26;
    static final int OP_TESTSET = 27;
    static final int OP_CALL = 28;
    static final int OP_TAILCALL = 29;
    static final int OP_RETURN = 30;
    static final int OP_FORLOOP = 31;
    static final int OP_FORPREP = 32;
    static final int OP_TFORLOOP = 33;
    static final int OP_SETLIST = 34;
    static final int OP_CLOSE = 35;
    static final int OP_CLOSURE = 36;
    static final int OP_VARARG = 37;
    static final int SIZE_C = 9;
    static final int SIZE_B = 9;
    static final int SIZE_Bx = 18;
    static final int SIZE_A = 8;
    static final int SIZE_OP = 6;
    static final int POS_OP = 0;
    static final int POS_A = 6;
    static final int POS_C = 14;
    static final int POS_B = 23;
    static final int POS_Bx = 14;
    static final int MAXARG_Bx = 262143;
    static final int MAXARG_sBx = 131071;
    static final int MAXARG_A = 255;
    static final int MAXARG_B = 511;
    static final int MAXARG_C = 511;
    static final int BITRK = 256;
    static final int MAXINDEXRK = 255;
    private static final double[] NUMOP = new double[2];
    private static final String NUMBER_FMT = ".14g";

    private CallInfo ci() {
        return (CallInfo)this.civ.lastElement();
    }

    private Lua(Lua lua) {
        this.civ.addElement(new CallInfo());
        this.openupval = new Vector();
        this.allowhook = true;
        this.global = lua.global;
        this.registry = lua.registry;
        this.metatable = lua.metatable;
        this.main = lua;
    }

    public Lua() {
        this.civ.addElement(new CallInfo());
        this.openupval = new Vector();
        this.allowhook = true;
        this.global = new LuaTable();
        this.registry = new LuaTable();
        this.metatable = new LuaTable[9];
        this.main = this;
    }

    public void call(int n, int n2) {
        this.apiChecknelems(n + 1);
        int n3 = this.stackSize - (n + 1);
        this.vmCall(n3, n2);
    }

    public void close() {
    }

    public void concat(int n) {
        this.apiChecknelems(n);
        if (n >= 2) {
            this.vmConcat(n, this.stackSize - this.base - 1);
            this.pop(n - 1);
        } else if (n == 0) {
            this.push("");
        }
    }

    public LuaTable createTable(int n, int n2) {
        return new LuaTable(n, n2);
    }

    public static void dump(Object object, OutputStream outputStream) throws IOException {
        if (!(object instanceof LuaFunction)) {
            throw new IOException("Cannot dump " + Lua.typeName(Lua.type(object)));
        }
        LuaFunction luaFunction = (LuaFunction)object;
        Lua.uDump(luaFunction.proto(), outputStream, false);
    }

    public boolean equal(Object object, Object object2) {
        if (object instanceof Double) {
            return object.equals(object2);
        }
        return this.vmEqualRef(object, object2);
    }

    public int error(Object object) {
        return this.gErrormsg(object);
    }

    public int gc(int n, int n2) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: 
            case 2: 
            case 5: {
                System.gc();
                return 0;
            }
            case 3: {
                Runtime runtime = Runtime.getRuntime();
                return (int)((runtime.totalMemory() - runtime.freeMemory()) / 1024L);
            }
            case 4: {
                Runtime runtime = Runtime.getRuntime();
                return (int)((runtime.totalMemory() - runtime.freeMemory()) % 1024L);
            }
            case 6: 
            case 7: {
                return 0;
            }
        }
        return 0;
    }

    public LuaTable getFenv(Object object) {
        if (object instanceof LuaFunction) {
            LuaFunction luaFunction = (LuaFunction)object;
            return luaFunction.getEnv();
        }
        if (object instanceof LuaJavaCallback) {
            return null;
        }
        if (object instanceof LuaUserdata) {
            LuaUserdata luaUserdata = (LuaUserdata)object;
            return luaUserdata.getEnv();
        }
        if (object instanceof Lua) {
            Lua lua = (Lua)object;
            return lua.global;
        }
        return null;
    }

    public Object getField(Object object, String string) {
        return this.getTable(object, string);
    }

    public Object getGlobal(String string) {
        return this.getField(this.global, string);
    }

    public LuaTable getGlobals() {
        return this.global;
    }

    public LuaTable getMetatable(Object object) {
        LuaTable luaTable;
        if (object instanceof LuaTable) {
            LuaTable luaTable2 = (LuaTable)object;
            luaTable = luaTable2.getMetatable();
        } else if (object instanceof LuaUserdata) {
            LuaUserdata luaUserdata = (LuaUserdata)object;
            luaTable = luaUserdata.getMetatable();
        } else {
            luaTable = this.metatable[Lua.type(object)];
        }
        return luaTable;
    }

    public LuaTable getRegistry() {
        return this.registry;
    }

    public Object getTable(Object object, Object object2) {
        Slot slot = new Slot(object2);
        Slot slot2 = new Slot();
        this.vmGettable(object, slot, slot2);
        return slot2.asObject();
    }

    public int getTop() {
        return this.stackSize - this.base;
    }

    public void insert(Object object, int n) {
        n = this.absIndexUnclamped(n);
        this.stackInsertAt(object, n);
    }

    public static boolean isBoolean(Object object) {
        return object instanceof Boolean;
    }

    public static boolean isJavaFunction(Object object) {
        return object instanceof LuaJavaCallback;
    }

    public static boolean isFunction(Object object) {
        return object instanceof LuaFunction || object instanceof LuaJavaCallback;
    }

    public boolean isMain() {
        return this == this.main;
    }

    public static boolean isNil(Object object) {
        return NIL == object;
    }

    public static boolean isNumber(Object object) {
        SPARE_SLOT.setObject(object);
        return Lua.tonumber(SPARE_SLOT, NUMOP);
    }

    public static boolean isString(Object object) {
        return object instanceof String || object instanceof Double;
    }

    public static boolean isTable(Object object) {
        return object instanceof LuaTable;
    }

    public static boolean isThread(Object object) {
        return object instanceof Lua;
    }

    public static boolean isUserdata(Object object) {
        return object instanceof LuaUserdata;
    }

    public static boolean isValue(Object object) {
        return object == NIL || object instanceof Boolean || object instanceof String || object instanceof Double || object instanceof LuaFunction || object instanceof LuaJavaCallback || object instanceof LuaTable || object instanceof LuaUserdata;
    }

    public boolean lessThan(Object object, Object object2) {
        Slot slot = new Slot(object);
        Slot slot2 = new Slot(object2);
        return this.vmLessthan(slot, slot2);
    }

    public int load(InputStream inputStream, String string) {
        this.push(new LuaInternal(inputStream, string));
        return this.pcall(0, 1, null);
    }

    public int load(Reader reader, String string) {
        this.push(new LuaInternal(reader, string));
        return this.pcall(0, 1, null);
    }

    public boolean next(int n) {
        Object object = this.value(n);
        LuaTable luaTable = (LuaTable)object;
        Object object2 = this.value(-1);
        this.pop(1);
        Enumeration<Object> enumeration = luaTable.keys();
        if (object2 == NIL) {
            if (enumeration.hasMoreElements()) {
                object2 = enumeration.nextElement();
                this.push(object2);
                this.push(luaTable.getlua(object2));
                return true;
            }
            return false;
        }
        while (enumeration.hasMoreElements()) {
            Object object3 = enumeration.nextElement();
            if (!object3.equals(object2)) continue;
            if (enumeration.hasMoreElements()) {
                object2 = enumeration.nextElement();
                this.push(object2);
                this.push(luaTable.getlua(object2));
                return true;
            }
            return false;
        }
        return false;
    }

    public LuaTable newTable() {
        return new LuaTable();
    }

    public Lua newThread() {
        return new Lua(this);
    }

    public LuaUserdata newUserdata(Object object) {
        return new LuaUserdata(object);
    }

    public static int objLen(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            return string.length();
        }
        if (object instanceof LuaTable) {
            LuaTable luaTable = (LuaTable)object;
            return luaTable.getn();
        }
        if (object instanceof Double) {
            return Lua.vmTostring(object).length();
        }
        return 0;
    }

    public int pcall(int n, int n2, Object object) {
        this.apiChecknelems(n + 1);
        int n3 = this.stackSize - (n + 1);
        int n4 = this.civ.size();
        int n5 = this.nCcalls;
        Object object2 = this.errfunc;
        this.errfunc = object;
        boolean bl = this.allowhook;
        int n6 = 0;
        try {
            this.call(n, n2);
        }
        catch (LuaError luaError) {
            this.fClose(n3);
            this.dSeterrorobj(luaError.errorStatus, n3);
            this.nCcalls = n5;
            this.civ.setSize(n4);
            CallInfo callInfo = this.ci();
            this.base = callInfo.base();
            this.savedpc = callInfo.savedpc();
            this.allowhook = bl;
            n6 = luaError.errorStatus;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.fClose(n3);
            this.dSeterrorobj(4, n3);
            this.nCcalls = n5;
            this.civ.setSize(n4);
            CallInfo callInfo = this.ci();
            this.base = callInfo.base();
            this.savedpc = callInfo.savedpc();
            this.allowhook = bl;
            n6 = 4;
        }
        this.errfunc = object2;
        return n6;
    }

    public void pop(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.stacksetsize(this.stackSize - n);
    }

    public void push(Object object) {
        this.stackAdd(object);
    }

    public void pushBoolean(boolean bl) {
        this.push(Lua.valueOfBoolean(bl));
    }

    public void pushLiteral(String string) {
        this.push(string);
    }

    public void pushNil() {
        this.push(NIL);
    }

    public void pushNumber(double d) {
        this.push(new Double(d));
    }

    public void pushString(String string) {
        this.push(string);
    }

    public void pushValue(int n) {
        this.push(this.value(n));
    }

    public static boolean rawEqual(Object object, Object object2) {
        return Lua.oRawequal(object, object2);
    }

    public static Object rawGet(Object object, Object object2) {
        LuaTable luaTable = (LuaTable)object;
        return luaTable.getlua(object2);
    }

    public static Object rawGetI(Object object, int n) {
        LuaTable luaTable = (LuaTable)object;
        return luaTable.getnum(n);
    }

    public void rawSet(Object object, Object object2, Object object3) {
        LuaTable luaTable = (LuaTable)object;
        luaTable.putlua(this, object2, object3);
    }

    public void rawSetI(Object object, int n, Object object2) {
        this.apiCheck(object instanceof LuaTable);
        LuaTable luaTable = (LuaTable)object;
        luaTable.putnum(n, object2);
    }

    public void register(String string, LuaJavaCallback luaJavaCallback) {
        this.setGlobal(string, luaJavaCallback);
    }

    public int resume(int n) {
        block11: {
            if (this.status != 1) {
                if (this.status != 0) {
                    return this.resume_error("cannot resume dead coroutine");
                }
                if (this.civ.size() != 1) {
                    return this.resume_error("cannot resume non-suspended coroutine");
                }
            }
            try {
                int n2 = this.stackSize - n;
                if (this.status == 0) {
                    if (this.vmPrecall(n2 - 1, -1) != 0) {
                        break block11;
                    }
                } else {
                    this.status = 0;
                    if (!this.isLua(this.ci())) {
                        if (this.vmPoscall(n2)) {
                            this.stacksetsize(this.ci().top());
                        }
                    } else {
                        this.base = this.ci().base();
                    }
                }
                this.vmExecute(this.civ.size() - 1);
            }
            catch (LuaError luaError) {
                this.status = luaError.errorStatus;
                this.dSeterrorobj(luaError.errorStatus, this.stackSize);
                this.ci().setTop(this.stackSize);
            }
        }
        return this.status;
    }

    public boolean setFenv(Object object, Object object2) {
        LuaTable luaTable = (LuaTable)object2;
        if (object instanceof LuaFunction) {
            LuaFunction luaFunction = (LuaFunction)object;
            luaFunction.setEnv(luaTable);
            return true;
        }
        if (object instanceof LuaJavaCallback) {
            return false;
        }
        if (object instanceof LuaUserdata) {
            LuaUserdata luaUserdata = (LuaUserdata)object;
            luaUserdata.setEnv(luaTable);
            return true;
        }
        if (object instanceof Lua) {
            Lua lua = (Lua)object;
            lua.global = luaTable;
            return true;
        }
        return false;
    }

    public void setField(Object object, String string, Object object2) {
        Slot slot = new Slot(string);
        this.vmSettable(object, slot, object2);
    }

    public void setMetatable(Object object, Object object2) {
        if (Lua.isNil(object2)) {
            object2 = null;
        } else {
            this.apiCheck(object2 instanceof LuaTable);
        }
        LuaTable luaTable = (LuaTable)object2;
        if (object instanceof LuaTable) {
            LuaTable luaTable2 = (LuaTable)object;
            luaTable2.setMetatable(luaTable);
        } else if (object instanceof LuaUserdata) {
            LuaUserdata luaUserdata = (LuaUserdata)object;
            luaUserdata.setMetatable(luaTable);
        } else {
            this.metatable[Lua.type((Object)object)] = luaTable;
        }
    }

    public void setGlobal(String string, Object object) {
        Slot slot = new Slot(string);
        this.vmSettable(this.global, slot, object);
    }

    public void setTable(Object object, Object object2, Object object3) {
        Slot slot = new Slot(object2);
        this.vmSettable(object, slot, object3);
    }

    public void setTop(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.stacksetsize(this.base + n);
    }

    public int status() {
        return this.status;
    }

    public Enumeration<Object> tableKeys(Object object) {
        if (!(object instanceof LuaTable)) {
            this.error("table required");
        }
        return ((LuaTable)object).keys();
    }

    public boolean toBoolean(Object object) {
        return object != NIL && !Boolean.FALSE.equals(object);
    }

    public int toInteger(Object object) {
        return (int)this.toNumber(object);
    }

    public double toNumber(Object object) {
        SPARE_SLOT.setObject(object);
        if (Lua.tonumber(SPARE_SLOT, NUMOP)) {
            return NUMOP[0];
        }
        return 0.0;
    }

    public String toString(Object object) {
        return Lua.vmTostring(object);
    }

    public Lua toThread(Object object) {
        if (!(object instanceof Lua)) {
            return null;
        }
        return (Lua)object;
    }

    public LuaUserdata toUserdata(Object object) {
        if (object instanceof LuaUserdata) {
            return (LuaUserdata)object;
        }
        return null;
    }

    public int type(int n) {
        if ((n = this.absIndex(n)) < 0) {
            return -1;
        }
        return this.type(this.stack[n]);
    }

    private int type(Slot slot) {
        if (slot.r == NUMBER) {
            return 3;
        }
        return Lua.type(slot.r);
    }

    public static int type(Object object) {
        if (object == NIL) {
            return 0;
        }
        if (object instanceof Double) {
            return 3;
        }
        if (object instanceof Boolean) {
            return 1;
        }
        if (object instanceof String) {
            return 4;
        }
        if (object instanceof LuaTable) {
            return 5;
        }
        if (object instanceof LuaFunction || object instanceof LuaJavaCallback) {
            return 6;
        }
        if (object instanceof LuaUserdata) {
            return 7;
        }
        if (object instanceof Lua) {
            return 8;
        }
        return -1;
    }

    public static String typeName(int n) {
        if (-1 == n) {
            return "no value";
        }
        return TYPENAME[n];
    }

    public Object value(int n) {
        if ((n = this.absIndex(n)) < 0) {
            return NIL;
        }
        return this.stack[n].asObject();
    }

    public static Object valueOfBoolean(boolean bl) {
        if (bl) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Object valueOfNumber(double d) {
        return new Double(d);
    }

    public void xmove(Lua lua, int n) {
        if (this == lua) {
            return;
        }
        this.apiChecknelems(n);
        for (int i = 0; i < n; ++i) {
            lua.push(this.value(-n + i));
        }
        this.pop(n);
    }

    public int yield(int n) {
        if (this.nCcalls > 0) {
            this.gRunerror("attempt to yield across metamethod/Java-call boundary");
        }
        this.base = this.stackSize - n;
        this.status = 1;
        return -1;
    }

    private int absIndex(int n) {
        int n2 = this.stackSize;
        if (n == 0) {
            return -1;
        }
        if (n > 0) {
            if (n + this.base > n2) {
                return -1;
            }
            return this.base + n - 1;
        }
        if (n2 + n < this.base) {
            return -1;
        }
        return n2 + n;
    }

    private int absIndexUnclamped(int n) {
        if (n == 0) {
            return -1;
        }
        if (n > 0) {
            return this.base + n - 1;
        }
        return this.stackSize + n;
    }

    private void apiCheck(boolean bl) {
        if (!bl) {
            throw new IllegalArgumentException();
        }
    }

    private void apiChecknelems(int n) {
        this.apiCheck(n <= this.stackSize - this.base);
    }

    public void argCheck(boolean bl, int n, String string) {
        if (bl) {
            return;
        }
        this.argRaiseError(n, string);
    }

    public void argRaiseError(int n, String string) {
        this.error("bad argument " + n + " (" + string + ")");
    }

    public boolean callMeta(int n, String string) {
        Object object = this.value(n);
        Object object2 = this.getMetafield(object, string);
        if (object2 == NIL) {
            return false;
        }
        this.push(object2);
        this.push(object);
        this.call(1, 1);
        return true;
    }

    public void checkAny(int n) {
        if (this.type(n) == -1) {
            this.argRaiseError(n, "value expected");
        }
    }

    public int checkInt(int n) {
        return (int)this.checkNumber(n);
    }

    public double checkNumber(int n) {
        Object object = this.value(n);
        double d = this.toNumber(object);
        if (d == 0.0 && !Lua.isNumber(object)) {
            this.tagError(n, 3);
        }
        return d;
    }

    public int checkOption(int n, String string, String[] stringArray) {
        String string2 = string == null ? this.checkString(n) : this.optString(n, string);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string2)) continue;
            return i;
        }
        this.argRaiseError(n, "invalid option '" + string2 + "'");
        return 0;
    }

    public String checkString(int n) {
        String string = this.toString(this.value(n));
        if (string == null) {
            this.tagError(n, 4);
        }
        return string;
    }

    public void checkType(int n, int n2) {
        if (this.type(n) != n2) {
            this.tagError(n, n2);
        }
    }

    public int doString(String string) {
        int n = this.load(Lua.stringReader(string), string);
        if (n == 0) {
            n = this.pcall(0, -1, null);
        }
        return n;
    }

    private int errfile(String string, String string2, Exception exception) {
        this.push("cannot " + string + " " + string2 + ": " + exception.toString());
        return 6;
    }

    String findTable(LuaTable luaTable, String string, int n) {
        int n2 = 0;
        int n3 = 0;
        do {
            String string2;
            Object object;
            if (Lua.isNil(object = Lua.rawGet(luaTable, string2 = (n2 = string.indexOf(46, n3)) < 0 ? string.substring(n3) : string.substring(n3, n2)))) {
                object = this.createTable(0, n2 >= 0 ? 1 : n);
                this.setTable(luaTable, string2, object);
            } else if (!Lua.isTable(object)) {
                return string2;
            }
            luaTable = (LuaTable)object;
            n3 = n2 + 1;
        } while (n2 >= 0);
        this.push(luaTable);
        return null;
    }

    public Object getMetafield(Object object, String string) {
        LuaTable luaTable = this.getMetatable(object);
        if (luaTable == null) {
            return NIL;
        }
        return luaTable.getlua(string);
    }

    boolean isNoneOrNil(int n) {
        return this.type(n) <= 0;
    }

    public int loadFile(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        if (inputStream == null) {
            return this.errfile("open", string, new IOException());
        }
        int n = 0;
        try {
            inputStream.mark(1);
            int n2 = inputStream.read();
            if (n2 == 35) {
                // empty if block
            }
            inputStream.reset();
            n = this.load(inputStream, "@" + string);
        }
        catch (IOException iOException) {
            return this.errfile("read", string, iOException);
        }
        return n;
    }

    public int loadString(String string, String string2) {
        return this.load(Lua.stringReader(string), string2);
    }

    public int optInt(int n, int n2) {
        if (this.isNoneOrNil(n)) {
            return n2;
        }
        return this.checkInt(n);
    }

    public double optNumber(int n, double d) {
        if (this.isNoneOrNil(n)) {
            return d;
        }
        return this.checkNumber(n);
    }

    public String optString(int n, String string) {
        if (this.isNoneOrNil(n)) {
            return string;
        }
        return this.checkString(n);
    }

    LuaTable register(String string) {
        this.findTable(this.getRegistry(), LOADED, 1);
        Object object = this.value(-1);
        this.pop(1);
        Object object2 = this.getField(object, string);
        if (!Lua.isTable(object2)) {
            if (this.findTable(this.getGlobals(), string, 0) != null) {
                this.error("name conflict for module '" + string + "'");
            }
            object2 = this.value(-1);
            this.pop(1);
            this.setField(object, string, object2);
        }
        return (LuaTable)object2;
    }

    private void tagError(int n, int n2) {
        this.typerror(n, Lua.typeName(n2));
    }

    public String typeNameOfIndex(int n) {
        return TYPENAME[this.type(n)];
    }

    public void typerror(int n, String string) {
        this.argRaiseError(n, string + " expected, got " + this.typeNameOfIndex(n));
    }

    public String where(int n) {
        Debug debug = this.getStack(n);
        if (debug != null) {
            this.getInfo("Sl", debug);
            if (debug.currentline() > 0) {
                return debug.shortsrc() + ":" + debug.currentline() + ": ";
            }
        }
        return "";
    }

    public static Reader stringReader(String string) {
        return new StringReader(string);
    }

    boolean getInfo(String string, Debug debug) {
        Object object = null;
        CallInfo callInfo = null;
        if (debug.ici() > 0) {
            callInfo = (CallInfo)this.civ.elementAt(debug.ici());
            object = this.stack[callInfo.function()].r;
        }
        boolean bl = this.auxgetinfo(string, debug, object, callInfo);
        if (string.indexOf(102) >= 0) {
            if (object == null) {
                this.push(NIL);
            } else {
                this.push(object);
            }
        }
        return bl;
    }

    Debug getStack(int n) {
        int n2;
        for (n2 = this.civ.size() - 1; n > 0 && n2 > 0; --n2) {
            CallInfo callInfo = (CallInfo)this.civ.elementAt(n2);
            --n;
            if (!this.isLua(callInfo)) continue;
            n -= callInfo.tailcalls();
        }
        if (n == 0 && n2 > 0) {
            return new Debug(n2);
        }
        if (n < 0) {
            return new Debug(0);
        }
        return null;
    }

    public void setHook(Hook hook, int n, int n2) {
        if (hook == null || n == 0) {
            n = 0;
            hook = null;
        }
        this.hook = hook;
        this.basehookcount = n2;
        this.resethookcount();
        this.hookmask = n;
    }

    private boolean auxgetinfo(String string, Debug debug, Object object, CallInfo callInfo) {
        boolean bl = true;
        if (object == null) {
            return bl;
        }
        block5: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case 'S': {
                    this.funcinfo(debug, object);
                    continue block5;
                }
                case 'l': {
                    debug.setCurrentline(callInfo != null ? this.currentline(callInfo) : -1);
                    continue block5;
                }
                case 'f': {
                    continue block5;
                }
                default: {
                    bl = false;
                }
            }
        }
        return bl;
    }

    private int currentline(CallInfo callInfo) {
        int n = this.currentpc(callInfo);
        if (n < 0) {
            return -1;
        }
        Object object = this.stack[callInfo.function()].r;
        LuaFunction luaFunction = (LuaFunction)object;
        return luaFunction.proto().getline(n);
    }

    private int currentpc(CallInfo callInfo) {
        if (!this.isLua(callInfo)) {
            return -1;
        }
        if (callInfo == this.ci()) {
            callInfo.setSavedpc(this.savedpc);
        }
        return Lua.pcRel(callInfo.savedpc());
    }

    private void funcinfo(Debug debug, Object object) {
        if (object instanceof LuaJavaCallback) {
            debug.setSource("=[Java]");
            debug.setLinedefined(-1);
            debug.setLastlinedefined(-1);
            debug.setWhat("Java");
        } else {
            Proto proto = ((LuaFunction)object).proto();
            debug.setSource(proto.source());
            debug.setLinedefined(proto.linedefined());
            debug.setLastlinedefined(proto.lastlinedefined());
            debug.setWhat(debug.linedefined() == 0 ? "main" : "Lua");
        }
    }

    private boolean isLua(CallInfo callInfo) {
        Object object = this.stack[callInfo.function()].r;
        return object instanceof LuaFunction;
    }

    private static int pcRel(int n) {
        return n - 1;
    }

    private void dCallhook(int n, int n2) {
        Hook hook = this.hook;
        if (hook != null && this.allowhook) {
            int n3 = this.stackSize;
            int n4 = this.ci().top();
            int n5 = this.civ.size() - 1;
            if (n == 4) {
                n5 = 0;
            }
            Debug debug = new Debug(n5);
            debug.setEvent(n);
            debug.setCurrentline(n2);
            this.ci().setTop(this.stackSize);
            this.allowhook = false;
            hook.luaHook(this, debug);
            this.allowhook = true;
            this.ci().setTop(n4);
            this.stacksetsize(n3);
        }
    }

    private void dSeterrorobj(int n, int n2) {
        Object object = this.objectAt(this.stackSize - 1);
        if (this.stackSize == n2) {
            this.stacksetsize(n2 + 1);
        }
        switch (n) {
            case 4: {
                this.stack[n2].r = MEMERRMSG;
                break;
            }
            case 5: {
                this.stack[n2].r = "error in error handling";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                this.setObjectAt(object, n2);
            }
        }
        this.stacksetsize(n2 + 1);
    }

    void dThrow(int n) {
        throw new LuaError(n);
    }

    private void fClose(int n) {
        UpVal upVal;
        int n2 = this.openupval.size();
        while (--n2 >= 0 && (upVal = (UpVal)this.openupval.elementAt(n2)).offset() >= n) {
            upVal.close();
        }
        this.openupval.setSize(n2 + 1);
    }

    private UpVal fFindupval(int n) {
        UpVal upVal;
        int n2 = this.openupval.size();
        while (--n2 >= 0) {
            upVal = (UpVal)this.openupval.elementAt(n2);
            if (upVal.offset() == n) {
                return upVal;
            }
            if (upVal.offset() >= n) continue;
            break;
        }
        upVal = new UpVal(n, this.stack[n]);
        this.openupval.insertElementAt(upVal, n2 + 1);
        return upVal;
    }

    private void gAritherror(Slot slot, Slot slot2) {
        if (!Lua.tonumber(slot, NUMOP)) {
            slot2 = slot;
        }
        this.gTypeerror(slot2, "perform arithmetic on");
    }

    private void gConcaterror(int n, int n2) {
        if (this.stack[n].r instanceof String) {
            n = n2;
        }
        this.gTypeerror(this.stack[n], "concatenate");
    }

    boolean gCheckcode(Proto proto) {
        return true;
    }

    private int gErrormsg(Object object) {
        this.push(object);
        if (this.errfunc != null) {
            if (!Lua.isFunction(this.errfunc)) {
                this.dThrow(5);
            }
            this.insert(this.errfunc, this.getTop());
            this.vmCall(this.stackSize - 2, 1);
        }
        this.dThrow(2);
        return 0;
    }

    private boolean gOrdererror(Slot slot, Slot slot2) {
        String string = Lua.typeName(this.type(slot));
        String string2 = Lua.typeName(this.type(slot2));
        if (string.charAt(2) == string2.charAt(2)) {
            this.gRunerror("attempt to compare two " + string + "values");
        } else {
            this.gRunerror("attempt to compare " + string + " with " + string2);
        }
        return false;
    }

    void gRunerror(String string) {
        this.gErrormsg(string);
    }

    private void gTypeerror(Object object, String string) {
        String string2 = Lua.typeName(Lua.type(object));
        this.gRunerror("attempt to " + string + " a " + string2 + " value");
    }

    private void gTypeerror(Slot slot, String string) {
        this.gTypeerror(slot.asObject(), string);
    }

    static String oChunkid(String string) {
        int n = 60;
        if (string.startsWith("=")) {
            if (string.length() < 61) {
                return string.substring(1);
            }
            return string.substring(1, 1 + n);
        }
        if (string.startsWith("@")) {
            int n2 = (string = string.substring(1)).length();
            if (n2 > (n -= " '...' ".length())) {
                return "..." + string.substring(string.length() - n, string.length());
            }
            return string;
        }
        int n3 = string.indexOf(10);
        if (n3 == -1) {
            n3 = string.length();
        }
        if (n3 > (n -= " [string \"...\"] ".length())) {
            n3 = n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[string \"");
        stringBuffer.append(string.substring(0, n3));
        if (string.length() > n3) {
            stringBuffer.append("...");
        }
        stringBuffer.append("\"]");
        return stringBuffer.toString();
    }

    private static int oFb2int(int n) {
        int n2 = n >>> 3 & 0x1F;
        if (n2 == 0) {
            return n;
        }
        return (n & 7) + 8 << n2 - 1;
    }

    private static boolean oRawequal(Object object, Object object2) {
        if (NIL == object) {
            return NIL == object2;
        }
        return object.equals(object2);
    }

    private static boolean oStr2d(String string, double[] dArray) {
        try {
            dArray[0] = Double.parseDouble(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                string = string.trim().toUpperCase();
                if (string.startsWith("0X")) {
                    string = string.substring(2);
                } else if (string.startsWith("-0X")) {
                    string = "-" + string.substring(3);
                } else {
                    return false;
                }
                dArray[0] = Integer.parseInt(string, 16);
                return true;
            }
            catch (NumberFormatException numberFormatException2) {
                return false;
            }
        }
    }

    static int OPCODE(int n) {
        return n & 0x3F;
    }

    static int SET_OPCODE(int n, int n2) {
        return n & 0xFFFFFFC0 | n2 & 0x3F;
    }

    static int ARGA(int n) {
        return n >>> 6 & 0xFF;
    }

    static int SETARG_A(int n, int n2) {
        return n & 0xFFFFC03F | (n2 & 0xFF) << 6;
    }

    static int ARGB(int n) {
        return n >>> 23;
    }

    static int SETARG_B(int n, int n2) {
        return n & 0x7FFFFF | (n2 & 0x1FF) << 23;
    }

    static int ARGC(int n) {
        return n >>> 14 & 0x1FF;
    }

    static int SETARG_C(int n, int n2) {
        return n & 0xFF803FFF | (n2 & 0x1FF) << 14;
    }

    static int ARGBx(int n) {
        return n >>> 14;
    }

    static int SETARG_Bx(int n, int n2) {
        return n & 0x3FFF | n2 << 14;
    }

    static int ARGsBx(int n) {
        return (n >>> 14) - 131071;
    }

    static int SETARG_sBx(int n, int n2) {
        return n & 0x3FFF | n2 + 131071 << 14;
    }

    static boolean ISK(int n) {
        return n >= 256;
    }

    private Slot RK(Slot[] slotArray, int n) {
        if (Lua.ISK(n)) {
            return slotArray[n & 0xFF];
        }
        return this.stack[this.base + n];
    }

    static int CREATE_ABC(int n, int n2, int n3, int n4) {
        return n | n2 << 6 | n3 << 23 | n4 << 14;
    }

    static int CREATE_ABx(int n, int n2, int n3) {
        return n | n2 << 6 | n3 << 14;
    }

    private void vmCall(int n, int n2) {
        ++this.nCcalls;
        if (this.vmPrecall(n, n2) == 0) {
            this.vmExecute(1);
        }
        --this.nCcalls;
    }

    private void vmConcat(int n, int n2) {
        int n3;
        do {
            int n4 = this.base + n2 + 1;
            n3 = 2;
            if (!this.tostring(n4 - 2) || !this.tostring(n4 - 1)) {
                if (!this.call_binTM(this.stack[n4 - 2], this.stack[n4 - 1], this.stack[n4 - 2], "__concat")) {
                    this.gConcaterror(n4 - 2, n4 - 1);
                }
            } else if (((String)this.stack[n4 - 1].r).length() > 0) {
                int n5 = ((String)this.stack[n4 - 1].r).length();
                for (n3 = 1; n3 < n && this.tostring(n4 - n3 - 1); ++n3) {
                    if ((n5 += ((String)this.stack[n4 - n3 - 1].r).length()) >= 0) continue;
                    this.gRunerror("string length overflow");
                }
                StringBuffer stringBuffer = new StringBuffer(n5);
                for (int i = n3; i > 0; --i) {
                    stringBuffer.append(this.stack[n4 - i].r);
                }
                this.stack[n4 - n3].r = stringBuffer.toString();
            }
            n2 -= n3 - 1;
        } while ((n -= n3 - 1) > 1);
    }

    private boolean vmEqual(Slot slot, Slot slot2) {
        if (NUMBER == slot.r) {
            if (NUMBER != slot2.r) {
                return false;
            }
            return slot.d == slot2.d;
        }
        return this.vmEqualRef(slot.r, slot2.r);
    }

    private boolean vmEqualRef(Object object, Object object2) {
        if (object.equals(object2)) {
            return true;
        }
        if (object.getClass() != object2.getClass()) {
            return false;
        }
        if (object instanceof LuaJavaCallback || object instanceof LuaTable) {
            Object object3 = this.get_compTM(this.getMetatable(object), this.getMetatable(object2), "__eq");
            if (NIL == object3) {
                return false;
            }
            Slot slot = new Slot();
            this.callTMres(slot, object3, object, object2);
            return !this.isFalse(slot.r);
        }
        return false;
    }

    private void vmExecute(int n) {
        block48: while (true) {
            LuaFunction luaFunction = (LuaFunction)this.stack[this.ci().function()].r;
            Proto proto = luaFunction.proto();
            int[] nArray = proto.code();
            Slot[] slotArray = proto.constant();
            int n2 = this.savedpc;
            block49: while (true) {
                int n3 = nArray[n2++];
                if ((this.hookmask & 8) != 0 && --this.hookcount == 0) {
                    this.traceexec(n2);
                    if (this.status == 1) {
                        this.savedpc = n2 - 1;
                        return;
                    }
                }
                int n4 = Lua.ARGA(n3);
                switch (Lua.OPCODE(n3)) {
                    case 0: {
                        this.stack[this.base + n4].r = this.stack[this.base + Lua.ARGB((int)n3)].r;
                        this.stack[this.base + n4].d = this.stack[this.base + Lua.ARGB((int)n3)].d;
                        continue block49;
                    }
                    case 1: {
                        this.stack[this.base + n4].r = slotArray[Lua.ARGBx((int)n3)].r;
                        this.stack[this.base + n4].d = slotArray[Lua.ARGBx((int)n3)].d;
                        continue block49;
                    }
                    case 2: {
                        this.stack[this.base + n4].r = Lua.valueOfBoolean(Lua.ARGB(n3) != 0);
                        if (Lua.ARGC(n3) == 0) continue block49;
                        ++n2;
                        continue block49;
                    }
                    case 3: {
                        int n5 = this.base + Lua.ARGB(n3);
                        do {
                            this.stack[n5--].r = NIL;
                        } while (n5 >= this.base + n4);
                        continue block49;
                    }
                    case 4: {
                        int n6 = Lua.ARGB(n3);
                        this.setObjectAt(luaFunction.upVal(n6).getValue(), this.base + n4);
                        continue block49;
                    }
                    case 5: {
                        Slot slot = slotArray[Lua.ARGBx(n3)];
                        this.savedpc = n2;
                        this.vmGettable(luaFunction.getEnv(), slot, this.stack[this.base + n4]);
                        continue block49;
                    }
                    case 6: {
                        this.savedpc = n2;
                        Object object = this.stack[this.base + Lua.ARGB(n3)].asObject();
                        this.vmGettable(object, this.RK(slotArray, Lua.ARGC(n3)), this.stack[this.base + n4]);
                        continue block49;
                    }
                    case 8: {
                        UpVal upVal = luaFunction.upVal(Lua.ARGB(n3));
                        upVal.setValue(this.objectAt(this.base + n4));
                        continue block49;
                    }
                    case 7: {
                        this.savedpc = n2;
                        this.vmSettable(luaFunction.getEnv(), slotArray[Lua.ARGBx(n3)], this.objectAt(this.base + n4));
                        continue block49;
                    }
                    case 9: {
                        this.savedpc = n2;
                        Object object = this.stack[this.base + n4].asObject();
                        this.vmSettable(object, this.RK(slotArray, Lua.ARGB(n3)), this.RK(slotArray, Lua.ARGC(n3)).asObject());
                        continue block49;
                    }
                    case 10: {
                        int n7 = Lua.ARGB(n3);
                        int n8 = Lua.ARGC(n3);
                        this.stack[this.base + n4].r = new LuaTable(Lua.oFb2int(n7), Lua.oFb2int(n8));
                        continue block49;
                    }
                    case 11: {
                        int n9 = Lua.ARGB(n3);
                        Slot slot = this.stack[this.base + n9];
                        this.stack[this.base + n4 + 1].r = slot.r;
                        this.stack[this.base + n4 + 1].d = slot.d;
                        this.savedpc = n2;
                        this.vmGettable(slot.asObject(), this.RK(slotArray, Lua.ARGC(n3)), this.stack[this.base + n4]);
                        continue block49;
                    }
                    case 12: {
                        Slot slot = this.RK(slotArray, Lua.ARGB(n3));
                        Slot slot2 = this.RK(slotArray, Lua.ARGC(n3));
                        if (slot.r == NUMBER && slot2.r == NUMBER) {
                            double d;
                            this.stack[this.base + n4].d = d = slot.d + slot2.d;
                            this.stack[this.base + n4].r = NUMBER;
                            continue block49;
                        }
                        if (Lua.toNumberPair(slot, slot2, NUMOP)) {
                            double d;
                            this.stack[this.base + n4].d = d = NUMOP[0] + NUMOP[1];
                            this.stack[this.base + n4].r = NUMBER;
                            continue block49;
                        }
                        if (this.call_binTM(slot, slot2, this.stack[this.base + n4], "__add")) continue block49;
                        this.gAritherror(slot, slot2);
                        continue block49;
                    }
                    case 13: {
                        Slot slot = this.RK(slotArray, Lua.ARGB(n3));
                        Slot slot2 = this.RK(slotArray, Lua.ARGC(n3));
                        if (slot.r == NUMBER && slot2.r == NUMBER) {
                            double d;
                            this.stack[this.base + n4].d = d = slot.d - slot2.d;
                            this.stack[this.base + n4].r = NUMBER;
                            continue block49;
                        }
                        if (Lua.toNumberPair(slot, slot2, NUMOP)) {
                            double d;
                            this.stack[this.base + n4].d = d = NUMOP[0] - NUMOP[1];
                            this.stack[this.base + n4].r = NUMBER;
                            continue block49;
                        }
                        if (this.call_binTM(slot, slot2, this.stack[this.base + n4], "__sub")) continue block49;
                        this.gAritherror(slot, slot2);
                        continue block49;
                    }
                    case 14: {
                        Slot slot = this.RK(slotArray, Lua.ARGB(n3));
                        Slot slot2 = this.RK(slotArray, Lua.ARGC(n3));
                        if (slot.r == NUMBER && slot2.r == NUMBER) {
                            double d;
                            this.stack[this.base + n4].d = d = slot.d * slot2.d;
                            this.stack[this.base + n4].r = NUMBER;
                            continue block49;
                        }
                        if (Lua.toNumberPair(slot, slot2, NUMOP)) {
                            double d;
                            this.stack[this.base + n4].d = d = NUMOP[0] * NUMOP[1];
                            this.stack[this.base + n4].r = NUMBER;
                            continue block49;
                        }
                        if (this.call_binTM(slot, slot2, this.stack[this.base + n4], "__mul")) continue block49;
                        this.gAritherror(slot, slot2);
                        continue block49;
                    }
                    case 15: {
                        Slot slot = this.RK(slotArray, Lua.ARGB(n3));
                        Slot slot2 = this.RK(slotArray, Lua.ARGC(n3));
                        if (slot.r == NUMBER && slot2.r == NUMBER) {
                            double d;
                            this.stack[this.base + n4].d = d = slot.d / slot2.d;
                            this.stack[this.base + n4].r = NUMBER;
                            continue block49;
                        }
                        if (Lua.toNumberPair(slot, slot2, NUMOP)) {
                            double d;
                            this.stack[this.base + n4].d = d = NUMOP[0] / NUMOP[1];
                            this.stack[this.base + n4].r = NUMBER;
                            continue block49;
                        }
                        if (this.call_binTM(slot, slot2, this.stack[this.base + n4], "__div")) continue block49;
                        this.gAritherror(slot, slot2);
                        continue block49;
                    }
                    case 16: {
                        Slot slot = this.RK(slotArray, Lua.ARGB(n3));
                        Slot slot2 = this.RK(slotArray, Lua.ARGC(n3));
                        if (slot.r == NUMBER && slot2.r == NUMBER) {
                            double d;
                            this.stack[this.base + n4].d = d = Lua.modulus(slot.d, slot2.d);
                            this.stack[this.base + n4].r = NUMBER;
                            continue block49;
                        }
                        if (Lua.toNumberPair(slot, slot2, NUMOP)) {
                            double d;
                            this.stack[this.base + n4].d = d = Lua.modulus(NUMOP[0], NUMOP[1]);
                            this.stack[this.base + n4].r = NUMBER;
                            continue block49;
                        }
                        if (this.call_binTM(slot, slot2, this.stack[this.base + n4], "__mod")) continue block49;
                        this.gAritherror(slot, slot2);
                        continue block49;
                    }
                    case 17: {
                        Slot slot = this.RK(slotArray, Lua.ARGB(n3));
                        Slot slot2 = this.RK(slotArray, Lua.ARGC(n3));
                        if (slot.r == NUMBER && slot2.r == NUMBER) {
                            double d;
                            this.stack[this.base + n4].d = d = Lua.iNumpow(slot.d, slot2.d);
                            this.stack[this.base + n4].r = NUMBER;
                            continue block49;
                        }
                        if (Lua.toNumberPair(slot, slot2, NUMOP)) {
                            double d;
                            this.stack[this.base + n4].d = d = Lua.iNumpow(NUMOP[0], NUMOP[1]);
                            this.stack[this.base + n4].r = NUMBER;
                            continue block49;
                        }
                        if (this.call_binTM(slot, slot2, this.stack[this.base + n4], "__pow")) continue block49;
                        this.gAritherror(slot, slot2);
                        continue block49;
                    }
                    case 18: {
                        Slot slot = this.stack[this.base + Lua.ARGB(n3)];
                        if (slot.r == NUMBER) {
                            this.stack[this.base + n4].d = -slot.d;
                            this.stack[this.base + n4].r = NUMBER;
                            continue block49;
                        }
                        if (Lua.tonumber(slot, NUMOP)) {
                            this.stack[this.base + n4].d = -NUMOP[0];
                            this.stack[this.base + n4].r = NUMBER;
                            continue block49;
                        }
                        if (this.call_binTM(slot, slot, this.stack[this.base + n4], "__unm")) continue block49;
                        this.gAritherror(slot, slot);
                        continue block49;
                    }
                    case 19: {
                        Object object = this.stack[this.base + Lua.ARGB((int)n3)].r;
                        this.stack[this.base + n4].r = Lua.valueOfBoolean(this.isFalse(object));
                        continue block49;
                    }
                    case 20: {
                        Slot slot = this.stack[this.base + Lua.ARGB(n3)];
                        if (slot.r instanceof LuaTable) {
                            LuaTable luaTable = (LuaTable)slot.r;
                            this.stack[this.base + n4].d = luaTable.getn();
                            this.stack[this.base + n4].r = NUMBER;
                            continue block49;
                        }
                        if (slot.r instanceof String) {
                            String string = (String)slot.r;
                            this.stack[this.base + n4].d = string.length();
                            this.stack[this.base + n4].r = NUMBER;
                            continue block49;
                        }
                        this.savedpc = n2;
                        if (this.call_binTM(slot, slot, this.stack[this.base + n4], "__len")) continue block49;
                        this.gTypeerror(slot, "get length of");
                        continue block49;
                    }
                    case 21: {
                        int n10 = Lua.ARGB(n3);
                        int n8 = Lua.ARGC(n3);
                        this.savedpc = n2;
                        this.vmConcat(n8 - n10 + 1, n8);
                        this.stack[this.base + n4].r = this.stack[this.base + n10].r;
                        this.stack[this.base + n4].d = this.stack[this.base + n10].d;
                        continue block49;
                    }
                    case 22: {
                        n2 += Lua.ARGsBx(n3);
                        continue block49;
                    }
                    case 23: {
                        Slot slot = this.RK(slotArray, Lua.ARGB(n3));
                        Slot slot2 = this.RK(slotArray, Lua.ARGC(n3));
                        if (this.vmEqual(slot, slot2) == (n4 != 0)) {
                            n2 += Lua.ARGsBx(nArray[n2]);
                        }
                        ++n2;
                        continue block49;
                    }
                    case 24: {
                        Slot slot = this.RK(slotArray, Lua.ARGB(n3));
                        Slot slot2 = this.RK(slotArray, Lua.ARGC(n3));
                        this.savedpc = n2;
                        if (this.vmLessthan(slot, slot2) == (n4 != 0)) {
                            n2 += Lua.ARGsBx(nArray[n2]);
                        }
                        ++n2;
                        continue block49;
                    }
                    case 25: {
                        Slot slot = this.RK(slotArray, Lua.ARGB(n3));
                        Slot slot2 = this.RK(slotArray, Lua.ARGC(n3));
                        this.savedpc = n2;
                        if (this.vmLessequal(slot, slot2) == (n4 != 0)) {
                            n2 += Lua.ARGsBx(nArray[n2]);
                        }
                        ++n2;
                        continue block49;
                    }
                    case 26: {
                        if (this.isFalse(this.stack[this.base + n4].r) != (Lua.ARGC(n3) != 0)) {
                            n2 += Lua.ARGsBx(nArray[n2]);
                        }
                        ++n2;
                        continue block49;
                    }
                    case 27: {
                        Slot slot = this.stack[this.base + Lua.ARGB(n3)];
                        if (this.isFalse(slot.r) != (Lua.ARGC(n3) != 0)) {
                            this.stack[this.base + n4].r = slot.r;
                            this.stack[this.base + n4].d = slot.d;
                            n2 += Lua.ARGsBx(nArray[n2]);
                        }
                        ++n2;
                        continue block49;
                    }
                    case 28: {
                        int n11 = Lua.ARGB(n3);
                        int n8 = Lua.ARGC(n3) - 1;
                        if (n11 != 0) {
                            this.stacksetsize(this.base + n4 + n11);
                        }
                        this.savedpc = n2;
                        switch (this.vmPrecall(this.base + n4, n8)) {
                            case 0: {
                                ++n;
                                continue block48;
                            }
                            case 1: {
                                if (n8 < 0) continue block49;
                                this.stacksetsize(this.ci().top());
                                continue block49;
                            }
                        }
                        return;
                    }
                    case 29: {
                        int n11 = Lua.ARGB(n3);
                        if (n11 != 0) {
                            this.stacksetsize(this.base + n4 + n11);
                        }
                        this.savedpc = n2;
                        switch (this.vmPrecall(this.base + n4, -1)) {
                            case 0: {
                                CallInfo callInfo = (CallInfo)this.civ.elementAt(this.civ.size() - 2);
                                int n12 = callInfo.function();
                                CallInfo callInfo2 = this.ci();
                                int n13 = callInfo2.function();
                                this.fClose(callInfo.base());
                                this.base = n12 + (callInfo2.base() - n13);
                                int n14 = 0;
                                while (n13 + n14 < this.stackSize) {
                                    this.stack[n12 + n14].r = this.stack[n13 + n14].r;
                                    this.stack[n12 + n14].d = this.stack[n13 + n14].d;
                                    ++n14;
                                }
                                this.stacksetsize(n12 + n14);
                                callInfo.tailcall(this.base, this.stackSize);
                                this.dec_ci();
                                continue block48;
                            }
                            case 1: {
                                continue block49;
                            }
                        }
                        return;
                    }
                    case 30: {
                        int n8;
                        this.fClose(this.base);
                        int n11 = Lua.ARGB(n3);
                        if (n11 != 0) {
                            n8 = n4 + n11 - 1;
                            this.stacksetsize(this.base + n8);
                        }
                        this.savedpc = n2;
                        n8 = this.vmPoscall(this.base + n4) ? 1 : 0;
                        if (--n == 0) {
                            return;
                        }
                        if (n8 == 0) continue block48;
                        this.stacksetsize(this.ci().top());
                        continue block48;
                    }
                    case 31: {
                        double d = this.stack[this.base + n4 + 2].d;
                        double d2 = this.stack[this.base + n4].d + d;
                        double d3 = this.stack[this.base + n4 + 1].d;
                        if (!(0.0 < d && d2 <= d3) && (!(d <= 0.0) || !(d3 <= d2))) continue block49;
                        n2 += Lua.ARGsBx(n3);
                        this.stack[this.base + n4].d = d2;
                        this.stack[this.base + n4].r = NUMBER;
                        this.stack[this.base + n4 + 3].d = d2;
                        this.stack[this.base + n4 + 3].r = NUMBER;
                        continue block49;
                    }
                    case 32: {
                        double d;
                        int n15 = this.base + n4;
                        int n8 = this.base + n4 + 1;
                        int n16 = this.base + n4 + 2;
                        this.savedpc = n2;
                        if (!this.tonumber(n15)) {
                            this.gRunerror("'for' initial value must be a number");
                        } else if (!this.tonumber(n8)) {
                            this.gRunerror("'for' limit must be a number");
                        } else if (!this.tonumber(n16)) {
                            this.gRunerror("'for' step must be a number");
                        }
                        double d4 = this.stack[n16].d;
                        this.stack[n15].d = d = this.stack[n15].d - d4;
                        this.stack[n15].r = NUMBER;
                        n2 += Lua.ARGsBx(n3);
                        continue block49;
                    }
                    case 33: {
                        int n17 = this.base + n4 + 3;
                        this.stack[n17 + 2].r = this.stack[this.base + n4 + 2].r;
                        this.stack[n17 + 2].d = this.stack[this.base + n4 + 2].d;
                        this.stack[n17 + 1].r = this.stack[this.base + n4 + 1].r;
                        this.stack[n17 + 1].d = this.stack[this.base + n4 + 1].d;
                        this.stack[n17].r = this.stack[this.base + n4].r;
                        this.stack[n17].d = this.stack[this.base + n4].d;
                        this.stacksetsize(n17 + 3);
                        this.savedpc = n2;
                        this.vmCall(n17, Lua.ARGC(n3));
                        this.stacksetsize(this.ci().top());
                        if (NIL != this.stack[n17].r) {
                            this.stack[n17 - 1].r = this.stack[n17].r;
                            this.stack[n17 - 1].d = this.stack[n17].d;
                            n2 += Lua.ARGsBx(nArray[n2]);
                        }
                        ++n2;
                        continue block49;
                    }
                    case 34: {
                        int n18 = Lua.ARGB(n3);
                        int n8 = Lua.ARGC(n3);
                        boolean bl = false;
                        if (0 == n18) {
                            n18 = this.stackSize - (this.base + n4) - 1;
                            bl = true;
                        }
                        if (0 == n8) {
                            n8 = nArray[n2++];
                        }
                        LuaTable luaTable = (LuaTable)this.stack[this.base + n4].r;
                        int n19 = (n8 - 1) * 50 + n18;
                        while (n18 > 0) {
                            Object object = this.objectAt(this.base + n4 + n18);
                            luaTable.putnum(n19--, object);
                            --n18;
                        }
                        if (!bl) continue block49;
                        this.stacksetsize(this.ci().top());
                        continue block49;
                    }
                    case 35: {
                        this.fClose(this.base + n4);
                        continue block49;
                    }
                    case 36: {
                        Proto proto2 = luaFunction.proto().proto()[Lua.ARGBx(n3)];
                        int n8 = proto2.nups();
                        UpVal[] upValArray = new UpVal[n8];
                        int n20 = 0;
                        while (n20 < n8) {
                            int n21 = nArray[n2];
                            upValArray[n20] = Lua.OPCODE(n21) == 4 ? luaFunction.upVal(Lua.ARGB(n21)) : this.fFindupval(this.base + Lua.ARGB(n21));
                            ++n20;
                            ++n2;
                        }
                        LuaFunction luaFunction2 = new LuaFunction(proto2, upValArray, luaFunction.getEnv());
                        this.stack[this.base + n4].r = luaFunction2;
                        continue block49;
                    }
                    case 37: {
                        int n22 = Lua.ARGB(n3) - 1;
                        int n8 = this.base - this.ci().function() - luaFunction.proto().numparams() - 1;
                        if (n22 == -1) {
                            n22 = n8;
                            this.stacksetsize(this.base + n4 + n8);
                        }
                        int n23 = 0;
                        while (true) {
                            if (n23 >= n22) continue block49;
                            if (n23 < n8) {
                                Slot slot = this.stack[this.base - n8 + n23];
                                this.stack[this.base + n4 + n23].r = slot.r;
                                this.stack[this.base + n4 + n23].d = slot.d;
                            } else {
                                this.stack[this.base + n4 + n23].r = NIL;
                            }
                            ++n23;
                        }
                    }
                }
            }
            break;
        }
    }

    static double iNumpow(double d, double d2) {
        boolean bl;
        boolean bl2 = bl = d2 < 0.0;
        if (bl) {
            d2 = -d2;
        }
        if (d == 0.0) {
            return bl ? Double.NaN : d;
        }
        double d3 = 1.0;
        int n = (int)d2;
        d2 -= (double)n;
        double d4 = d;
        while (n > 0) {
            if ((n & 1) != 0) {
                d3 *= d4;
            }
            n >>= 1;
            d4 *= d4;
        }
        if (d2 != 0.0) {
            if (d < 0.0) {
                return Double.NaN;
            }
            d4 = Math.sqrt(d);
            double d5 = 0.5;
            while (d2 > 0.0) {
                if (d2 >= d5) {
                    d3 *= d4;
                    d2 -= d5;
                }
                d2 += d2;
                if ((d4 = Math.sqrt(d4)) != 1.0) continue;
            }
        }
        return bl ? 1.0 / d3 : d3;
    }

    private void vmGettable(Object object, Slot slot, Slot slot2) {
        for (int i = 0; i < 100; ++i) {
            Object object2;
            if (object instanceof LuaTable) {
                LuaTable luaTable = (LuaTable)object;
                luaTable.getlua(slot, SPARE_SLOT);
                if (Lua.SPARE_SLOT.r != NIL) {
                    slot2.r = Lua.SPARE_SLOT.r;
                    slot2.d = Lua.SPARE_SLOT.d;
                    return;
                }
                object2 = this.tagmethod(luaTable, "__index");
                if (object2 == NIL) {
                    slot2.r = NIL;
                    return;
                }
            } else {
                object2 = this.tagmethod(object, "__index");
                if (object2 == NIL) {
                    this.gTypeerror(object, "index");
                }
            }
            if (Lua.isFunction(object2)) {
                SPARE_SLOT.setObject(object);
                this.callTMres(slot2, object2, SPARE_SLOT, slot);
                return;
            }
            object = object2;
        }
        this.gRunerror("loop in gettable");
    }

    private boolean vmLessthan(Slot slot, Slot slot2) {
        if (slot.r.getClass() != slot2.r.getClass()) {
            this.gOrdererror(slot, slot2);
        } else {
            if (slot.r == NUMBER) {
                return slot.d < slot2.d;
            }
            if (slot.r instanceof String) {
                return ((String)slot.r).compareTo((String)slot2.r) < 0;
            }
        }
        int n = this.call_orderTM(slot, slot2, "__lt");
        if (n >= 0) {
            return n != 0;
        }
        return this.gOrdererror(slot, slot2);
    }

    private boolean vmLessequal(Slot slot, Slot slot2) {
        if (slot.r.getClass() != slot2.r.getClass()) {
            this.gOrdererror(slot, slot2);
        } else {
            if (slot.r == NUMBER) {
                return slot.d <= slot2.d;
            }
            if (slot.r instanceof String) {
                return ((String)slot.r).compareTo((String)slot2.r) <= 0;
            }
        }
        int n = this.call_orderTM(slot, slot2, "__le");
        if (n >= 0) {
            return n != 0;
        }
        n = this.call_orderTM(slot2, slot, "__lt");
        if (n >= 0) {
            return n == 0;
        }
        return this.gOrdererror(slot, slot2);
    }

    private boolean vmPoscall(int n) {
        int n2;
        CallInfo callInfo = this.dec_ci();
        int n3 = callInfo.res();
        int n4 = callInfo.nresults();
        CallInfo callInfo2 = this.ci();
        this.base = callInfo2.base();
        this.savedpc = callInfo2.savedpc();
        int n5 = this.stackSize;
        for (n2 = n4; n2 != 0 && n < n5; ++n, --n2) {
            this.stack[n3].r = this.stack[n].r;
            this.stack[n3].d = this.stack[n].d;
            ++n3;
        }
        if (n2 > 0) {
            this.stacksetsize(n3 + n2);
        }
        while (n2-- > 0) {
            this.stack[n3++].r = NIL;
        }
        this.stacksetsize(n3);
        return n4 != -1;
    }

    private int vmPrecall(int n, int n2) {
        Object object = this.stack[n].r;
        if (!Lua.isFunction(object)) {
            object = this.tryfuncTM(n);
        }
        this.ci().setSavedpc(this.savedpc);
        if (object instanceof LuaFunction) {
            int n3;
            LuaFunction luaFunction = (LuaFunction)object;
            Proto proto = luaFunction.proto();
            if (!proto.isVararg()) {
                this.base = n + 1;
                if (this.stackSize > this.base + proto.numparams()) {
                    this.stacksetsize(this.base + proto.numparams());
                }
            } else {
                n3 = this.stackSize - n - 1;
                this.base = this.adjust_varargs(proto, n3);
            }
            n3 = this.base + proto.maxstacksize();
            this.inc_ci(n, this.base, n3, n2);
            this.savedpc = 0;
            this.stacksetsize(n3);
            return 0;
        }
        if (object instanceof LuaJavaCallback) {
            LuaJavaCallback luaJavaCallback = (LuaJavaCallback)object;
            this.base = n + 1;
            this.inc_ci(n, this.base, this.stackSize + 20, n2);
            int n4 = 99;
            try {
                n4 = luaJavaCallback.luaFunction(this);
            }
            catch (LuaError luaError) {
                throw luaError;
            }
            catch (RuntimeException runtimeException) {
                this.yield(0);
                throw runtimeException;
            }
            if (n4 < 0) {
                return 2;
            }
            this.vmPoscall(this.stackSize - n4);
            return 1;
        }
        throw new IllegalArgumentException();
    }

    private void vmSettable(Object object, Slot slot, Object object2) {
        for (int i = 0; i < 100; ++i) {
            Object object3;
            if (object instanceof LuaTable) {
                LuaTable luaTable = (LuaTable)object;
                luaTable.getlua(slot, SPARE_SLOT);
                if (Lua.SPARE_SLOT.r != NIL) {
                    luaTable.putlua(this, slot, object2);
                    return;
                }
                object3 = this.tagmethod(luaTable, "__newindex");
                if (object3 == NIL) {
                    luaTable.putlua(this, slot, object2);
                    return;
                }
            } else {
                object3 = this.tagmethod(object, "__newindex");
                if (object3 == NIL) {
                    this.gTypeerror(object, "index");
                }
            }
            if (Lua.isFunction(object3)) {
                this.callTM(object3, object, slot, object2);
                return;
            }
            object = object3;
        }
        this.gRunerror("loop in settable");
    }

    private static String vmTostring(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        if (!(object instanceof Double)) {
            return null;
        }
        FormatItem formatItem = new FormatItem(null, NUMBER_FMT);
        StringBuffer stringBuffer = new StringBuffer();
        Double d = (Double)object;
        formatItem.formatFloat(stringBuffer, d);
        return stringBuffer.toString();
    }

    private int adjust_varargs(Proto proto, int n) {
        int n2 = proto.numparams();
        while (n < n2) {
            this.stackAdd(NIL);
            ++n;
        }
        int n3 = this.stackSize - n;
        int n4 = this.stackSize;
        for (int i = 0; i < n2; ++i) {
            this.push(this.stack[n3 + i]);
            this.stack[n3 + i].r = NIL;
        }
        return n4;
    }

    private boolean call_binTM(Slot slot, Slot slot2, Slot slot3, String string) {
        Object object = this.tagmethod(slot.asObject(), string);
        if (Lua.isNil(object)) {
            object = this.tagmethod(slot2.asObject(), string);
        }
        if (!Lua.isFunction(object)) {
            return false;
        }
        this.callTMres(slot3, object, slot, slot2);
        return true;
    }

    private int call_orderTM(Slot slot, Slot slot2, String string) {
        Object object = this.tagmethod(slot.asObject(), string);
        if (object == NIL) {
            return -1;
        }
        Object object2 = this.tagmethod(slot2.asObject(), string);
        if (!Lua.oRawequal(object, object2)) {
            return -1;
        }
        Slot slot3 = new Slot();
        this.callTMres(slot3, object, slot, slot2);
        return this.isFalse(slot3.r) ? 0 : 1;
    }

    private void callTM(Object object, Object object2, Slot slot, Object object3) {
        this.push(object);
        this.push(object2);
        this.push(slot);
        this.push(object3);
        this.vmCall(this.stackSize - 4, 0);
    }

    private void callTMres(Slot slot, Object object, Slot slot2, Slot slot3) {
        this.push(object);
        this.push(slot2);
        this.push(slot3);
        this.vmCall(this.stackSize - 3, 1);
        slot.r = this.stack[this.stackSize - 1].r;
        slot.d = this.stack[this.stackSize - 1].d;
        this.pop(1);
    }

    private void callTMres(Slot slot, Object object, Object object2, Object object3) {
        this.push(object);
        this.push(object2);
        this.push(object3);
        this.vmCall(this.stackSize - 3, 1);
        slot.r = this.stack[this.stackSize - 1].r;
        slot.d = this.stack[this.stackSize - 1].d;
        this.pop(1);
    }

    private Object get_compTM(LuaTable luaTable, LuaTable luaTable2, String string) {
        if (luaTable == null) {
            return NIL;
        }
        Object object = luaTable.getlua(string);
        if (Lua.isNil(object)) {
            return NIL;
        }
        if (luaTable == luaTable2) {
            return object;
        }
        if (luaTable2 == null) {
            return NIL;
        }
        Object object2 = luaTable2.getlua(string);
        if (Lua.isNil(object2)) {
            return NIL;
        }
        if (Lua.oRawequal(object, object2)) {
            return object;
        }
        return NIL;
    }

    private Object tagmethod(Object object, String string) {
        return this.getMetafield(object, string);
    }

    private static double modulus(double d, double d2) {
        return d - Math.floor(d / d2) * d2;
    }

    private void stacksetsize(int n) {
        int n2;
        int n3 = this.stackSize;
        if (n > this.stack.length) {
            n2 = Math.max(n, 2 * this.stack.length);
            Slot[] slotArray = new Slot[n2];
            int n4 = this.stack.length;
            System.arraycopy(this.stack, 0, slotArray, 0, n4);
            this.stack = slotArray;
        }
        this.stackSize = n;
        if (n <= n3) {
            for (n2 = n; n2 < n3; ++n2) {
                this.stack[n2].r = NIL;
            }
        }
        if (n > this.stackhighwater) {
            for (n2 = this.stackhighwater; n2 < n; ++n2) {
                this.stack[n2] = new Slot();
                this.stack[n2].r = NIL;
            }
            this.stackhighwater = n;
        }
    }

    private void stackAdd(Object object) {
        int n = this.stackSize;
        this.stacksetsize(n + 1);
        this.stack[n].setObject(object);
    }

    private void push(Slot slot) {
        int n = this.stackSize;
        this.stacksetsize(n + 1);
        this.stack[n].r = slot.r;
        this.stack[n].d = slot.d;
    }

    private void stackInsertAt(Object object, int n) {
        int n2 = this.stackSize - n;
        this.stacksetsize(this.stackSize + 1);
        for (int i = n2; i >= 1; --i) {
            this.stack[n + i].r = this.stack[n + i - 1].r;
            this.stack[n + i].d = this.stack[n + i - 1].d;
        }
        this.stack[n].setObject(object);
    }

    private void resethookcount() {
        this.hookcount = this.basehookcount;
    }

    private void traceexec(int n) {
        int n2 = this.hookmask;
        this.savedpc = n;
        if (n2 > 4 && this.hookcount == 0) {
            this.resethookcount();
            this.dCallhook(3, -1);
        }
    }

    private static boolean tonumber(Slot slot, double[] dArray) {
        if (slot.r == NUMBER) {
            dArray[0] = slot.d;
            return true;
        }
        if (!(slot.r instanceof String)) {
            return false;
        }
        return Lua.oStr2d((String)slot.r, dArray);
    }

    private boolean tonumber(int n) {
        if (Lua.tonumber(this.stack[n], NUMOP)) {
            this.stack[n].d = NUMOP[0];
            this.stack[n].r = NUMBER;
            return true;
        }
        return false;
    }

    private static boolean toNumberPair(Slot slot, Slot slot2, double[] dArray) {
        if (Lua.tonumber(slot2, dArray)) {
            dArray[1] = dArray[0];
            if (Lua.tonumber(slot, dArray)) {
                return true;
            }
        }
        return false;
    }

    private boolean tostring(int n) {
        Object object = this.objectAt(n);
        String string = Lua.vmTostring(object);
        if (string == null) {
            return false;
        }
        this.stack[n].r = string;
        return true;
    }

    private Object tryfuncTM(int n) {
        Object object = this.tagmethod(this.stack[n].asObject(), "__call");
        if (!Lua.isFunction(object)) {
            this.gTypeerror(this.stack[n], "call");
        }
        this.stackInsertAt(object, n);
        return object;
    }

    private boolean isFalse(Object object) {
        return object == NIL || object == Boolean.FALSE;
    }

    private CallInfo inc_ci(int n, int n2, int n3, int n4) {
        CallInfo callInfo = new CallInfo(n, n2, n3, n4);
        this.civ.addElement(callInfo);
        return callInfo;
    }

    private CallInfo dec_ci() {
        CallInfo callInfo = (CallInfo)this.civ.pop();
        return callInfo;
    }

    private int resume_error(String string) {
        this.stacksetsize(this.ci().base());
        this.stackAdd(string);
        return 2;
    }

    private Object objectAt(int n) {
        Object object = this.stack[n].r;
        if (object != NUMBER) {
            return object;
        }
        return new Double(this.stack[n].d);
    }

    private void setObjectAt(Object object, int n) {
        if (object instanceof Double) {
            this.stack[n].r = NUMBER;
            this.stack[n].d = (Double)object;
            return;
        }
        this.stack[n].r = object;
    }

    static int uDump(Proto proto, OutputStream outputStream, boolean bl) throws IOException {
        DumpState dumpState = new DumpState(new DataOutputStream(outputStream), bl);
        dumpState.DumpHeader();
        dumpState.DumpFunction(proto, null);
        dumpState.writer.flush();
        return 0;
    }
}

