/*
 * Decompiled with CFR 0.152.
 */
package mnj.lua;

import java.util.Enumeration;
import java.util.Hashtable;
import mnj.lua.Enum;
import mnj.lua.Lua;
import mnj.lua.Slot;

public final class LuaTable
extends Hashtable<Object, Object> {
    private static final long serialVersionUID = 3628936893896L;
    private static final int MAXBITS = 26;
    private static final int MAXASIZE = 0x4000000;
    private LuaTable metatable;
    private static final Object[] ZERO = new Object[0];
    Object[] array = ZERO;
    int sizeArray;
    private boolean inrehash;
    private static final byte[] LOG2 = new byte[]{0, 1, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};

    LuaTable() {
        super(1);
    }

    LuaTable(int n, int n2) {
        super(n2);
        this.array = new Object[n];
        for (int i = 0; i < n; ++i) {
            this.array[i] = Lua.NIL;
        }
        this.sizeArray = n;
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    private static int arrayindex(Object object) {
        double d;
        int n;
        if (object instanceof Double && (double)(n = (int)(d = ((Double)object).doubleValue())) == d) {
            return n;
        }
        return -1;
    }

    private static int computesizes(int[] nArray, int[] nArray2) {
        int n = nArray2[0];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 1;
        int n6 = 0;
        while (n5 / 2 < n) {
            if (nArray[n6] > 0 && (n2 += nArray[n6]) > n5 / 2) {
                n4 = n5;
                n3 = n2;
            }
            if (n2 == n) break;
            n5 *= 2;
            ++n6;
        }
        nArray2[0] = n4;
        return n3;
    }

    private int countint(Object object, int[] nArray) {
        int n = LuaTable.arrayindex(object);
        if (0 < n && n <= 0x4000000) {
            int n2 = LuaTable.ceillog2(n);
            nArray[n2] = nArray[n2] + 1;
            return 1;
        }
        return 0;
    }

    private int numusearray(int[] nArray) {
        int n = 0;
        int n2 = 1;
        int n3 = 1;
        int n4 = 0;
        while (n4 <= 26) {
            int n5 = 0;
            int n6 = n3;
            if (n6 > this.sizeArray && n2 > (n6 = this.sizeArray)) break;
            while (n2 <= n6) {
                if (this.array[n2 - 1] != Lua.NIL) {
                    ++n5;
                }
                ++n2;
            }
            int n7 = n4++;
            nArray[n7] = nArray[n7] + n5;
            n += n5;
            n3 *= 2;
        }
        return n;
    }

    private int numusehash(int[] nArray, int[] nArray2) {
        int n = 0;
        int n2 = 0;
        Enumeration enumeration = super.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            n2 += this.countint(k, nArray);
            ++n;
        }
        nArray2[0] = nArray2[0] + n2;
        return n;
    }

    private void resize(int n) {
        Double d;
        int n2;
        if (n == this.sizeArray) {
            return;
        }
        Object[] objectArray = new Object[n];
        if (n > this.sizeArray) {
            System.arraycopy(this.array, 0, objectArray, 0, this.array.length);
            for (n2 = this.array.length; n2 < n; ++n2) {
                d = new Double(n2 + 1);
                Object object = super.remove(d);
                if (object == null) {
                    object = Lua.NIL;
                }
                objectArray[n2] = object;
            }
        }
        if (n < this.sizeArray) {
            for (n2 = n; n2 < this.sizeArray; ++n2) {
                if (this.array[n2] == Lua.NIL) continue;
                d = new Double(n2 + 1);
                super.put(d, this.array[n2]);
            }
            System.arraycopy(this.array, 0, objectArray, 0, objectArray.length);
        }
        this.array = objectArray;
        this.sizeArray = this.array.length;
    }

    @Override
    protected void rehash() {
        boolean bl = this.inrehash;
        this.inrehash = true;
        if (!bl) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[27];
            nArray[0] = this.numusearray(nArray2);
            int n = nArray[0];
            n += this.numusehash(nArray2, nArray);
            LuaTable.computesizes(nArray2, nArray);
            this.resize(nArray[0]);
        }
        super.rehash();
        this.inrehash = bl;
    }

    LuaTable getMetatable() {
        return this.metatable;
    }

    void setMetatable(LuaTable luaTable) {
        this.metatable = luaTable;
    }

    int getn() {
        int n = this.sizeArray;
        if (n > 0 && this.array[n - 1] == Lua.NIL) {
            int n2 = 0;
            while (n - n2 > 1) {
                int n3 = (n2 + n) / 2;
                if (this.array[n3 - 1] == Lua.NIL) {
                    n = n3;
                    continue;
                }
                n2 = n3;
            }
            return n2;
        }
        int n4 = 0;
        n = 1;
        while (this.getnum(n) != Lua.NIL) {
            n4 = n;
            if ((n *= 2) >= 0) continue;
            n4 = 1;
            while (this.getnum(n4) != Lua.NIL) {
                ++n4;
            }
            return n4 - 1;
        }
        while (n - n4 > 1) {
            int n5 = (n4 + n) / 2;
            if (this.getnum(n5) == Lua.NIL) {
                n = n5;
                continue;
            }
            n4 = n5;
        }
        return n4;
    }

    Object getlua(Object object) {
        int n;
        double d;
        if (object instanceof Double && (d = ((Double)object).doubleValue()) <= (double)this.sizeArray && d >= 1.0 && (double)(n = (int)d) == d) {
            return this.array[n - 1];
        }
        Object object2 = super.get(object);
        if (object2 == null) {
            object2 = Lua.NIL;
        }
        return object2;
    }

    void getlua(Slot slot, Slot slot2) {
        int n;
        double d;
        if (slot.r == Lua.NUMBER && (d = slot.d) <= (double)this.sizeArray && d >= 1.0 && (double)(n = (int)d) == d) {
            slot2.setObject(this.array[n - 1]);
            return;
        }
        Object object = super.get(slot.asObject());
        if (object == null) {
            object = Lua.NIL;
        }
        slot2.setObject(object);
    }

    Object getnum(int n) {
        if (n <= this.sizeArray && n >= 1) {
            return this.array[n - 1];
        }
        Object v = super.get(new Double(n));
        if (v == null) {
            return Lua.NIL;
        }
        return v;
    }

    void putlua(Lua lua, Object object, Object object2) {
        double d = 0.0;
        int n = Integer.MAX_VALUE;
        if (object == Lua.NIL) {
            lua.gRunerror("table index is nil");
        }
        if (object instanceof Double) {
            d = (Double)object;
            int n2 = (int)d;
            if ((double)n2 == d && n2 >= 1 && (n = n2) <= this.sizeArray) {
                this.array[n - 1] = object2;
                return;
            }
            if (Double.isNaN(d)) {
                lua.gRunerror("table index is NaN");
            }
        }
        if (object2 == Lua.NIL) {
            this.remove(object);
            return;
        }
        super.put(object, object2);
        if (n <= this.sizeArray) {
            this.remove(object);
            this.array[n - 1] = object2;
        }
    }

    void putlua(Lua lua, Slot slot, Object object) {
        int n = Integer.MAX_VALUE;
        if (slot.r == Lua.NUMBER) {
            int n2 = (int)slot.d;
            if ((double)n2 == slot.d && n2 >= 1 && (n = n2) <= this.sizeArray) {
                this.array[n - 1] = object;
                return;
            }
            if (Double.isNaN(slot.d)) {
                lua.gRunerror("table index is NaN");
            }
        }
        Object object2 = slot.asObject();
        if (object == Lua.NIL) {
            this.remove(object2);
            return;
        }
        super.put(object2, object);
        if (n <= this.sizeArray) {
            this.remove(object2);
            this.array[n - 1] = object;
        }
    }

    void putnum(int n, Object object) {
        if (n <= this.sizeArray && n >= 1) {
            this.array[n - 1] = object;
            return;
        }
        this.putlua(null, new Double(n), object);
    }

    @Override
    public Object get(Object object) {
        throw new IllegalArgumentException();
    }

    @Override
    public Enumeration<Object> keys() {
        return new Enum(this, super.keys());
    }

    @Override
    public Object put(Object object, Object object2) {
        throw new IllegalArgumentException();
    }

    private static int oLog2(int n) {
        int n2 = -1;
        while (n >= 256) {
            n2 += 8;
            n >>>= 8;
        }
        return n2 + LOG2[n];
    }

    private static int ceillog2(int n) {
        return LuaTable.oLog2(n - 1) + 1;
    }
}

