/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.diskimages;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.jpc.diskimages.BlockDevice;
import org.jpc.diskimages.ImageLibrary;
import org.jpc.diskimages.ImageMaker;
import org.jpc.emulator.SRDumpable;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;

public class DiskImage
implements SRDumpable {
    private boolean readOnly;
    private boolean busy;
    private boolean used;
    private BlockDevice.Type type;
    private long totalSectors;
    private int heads;
    private int cylinders;
    private int sectors;
    private String imageFileName;
    private String imageName;
    private int[] sectorOffsetMap;
    private byte[][] copyOnWriteData;
    private byte[] blankPage;
    private byte[] diskID;
    private RandomAccessFile image;
    private static ImageLibrary library;

    public static void setLibrary(ImageLibrary imageLibrary) {
        library = imageLibrary;
    }

    public static ImageLibrary getLibrary() {
        return library;
    }

    public void finalize() {
        try {
            if (this.image != null) {
                this.image.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void dumpStatusPartial(StatusDumper statusDumper) {
        statusDumper.println("\treadOnly " + this.readOnly + " busy " + this.busy + " used " + this.used + " type " + (Object)((Object)this.type));
        statusDumper.println("\ttotalSectors " + this.totalSectors + " heads " + this.heads + " cylinders " + this.cylinders);
        statusDumper.println("\tsectors " + this.sectors + " imageFileName " + this.imageFileName);
        statusDumper.println("\timageName " + this.imageName);
    }

    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": DiskImage:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        int n;
        System.err.println("Informational: Dumping disk image...");
        sRDumper.dumpArray(this.diskID);
        int n2 = 0;
        if (this.copyOnWriteData != null) {
            for (n = 0; n < this.copyOnWriteData.length; ++n) {
                if (this.copyOnWriteData[n] == null) continue;
                ++n2;
            }
        }
        sRDumper.dumpInt(n2);
        if (this.copyOnWriteData != null) {
            for (n = 0; n < this.copyOnWriteData.length; ++n) {
                if (this.copyOnWriteData[n] == null) continue;
                sRDumper.dumpInt(n);
                sRDumper.dumpArray(this.copyOnWriteData[n]);
            }
        }
        System.err.println("Informational: Disk image dumped (" + n2 + " cow entries).");
        sRDumper.dumpBoolean(this.used);
        sRDumper.dumpBoolean(this.busy);
        sRDumper.dumpString(this.imageName);
    }

    private void commonConstructor(String string) throws IOException {
        ImageMaker.ParsedImage parsedImage = new ImageMaker.ParsedImage(string);
        if (parsedImage.typeCode == 0) {
            this.type = BlockDevice.Type.FLOPPY;
            this.readOnly = false;
        } else if (parsedImage.typeCode == 1) {
            this.type = BlockDevice.Type.HARDDRIVE;
            this.readOnly = false;
        } else if (parsedImage.typeCode == 2) {
            this.type = BlockDevice.Type.CDROM;
            this.readOnly = true;
        } else {
            throw new IOException("Can't load " + string + ": Image of unknown type!");
        }
        this.imageName = string;
        this.busy = false;
        this.used = false;
        this.totalSectors = parsedImage.totalSectors;
        this.heads = parsedImage.sides;
        this.cylinders = parsedImage.tracks;
        this.sectors = parsedImage.sectors;
        this.imageFileName = string;
        this.sectorOffsetMap = parsedImage.sectorOffsetMap;
        if (this.type != BlockDevice.Type.CDROM) {
            this.copyOnWriteData = new byte[(int)this.totalSectors][];
        } else {
            this.cylinders = 2;
            this.heads = 16;
            this.sectors = 63;
        }
        this.diskID = parsedImage.diskID;
        this.blankPage = new byte[512];
        this.image = new RandomAccessFile(string, "r");
    }

    public byte[] getImageID() {
        return this.diskID;
    }

    public DiskImage(SRLoader sRLoader) throws IOException {
        sRLoader.objectCreated(this);
        byte[] byArray = sRLoader.loadArrayByte();
        String string = library.lookupFileName(byArray);
        if (string == null) {
            throw new IOException("No disk with ID " + new ImageLibrary.ByteArray(byArray) + " found.");
        }
        this.commonConstructor(string);
        int n = sRLoader.loadInt();
        for (int i = 0; i < n; ++i) {
            int n2 = sRLoader.loadInt();
            this.copyOnWriteData[n2] = sRLoader.loadArrayByte();
        }
        this.used = sRLoader.loadBoolean();
        this.busy = sRLoader.loadBoolean();
        this.imageName = sRLoader.loadString();
    }

    public DiskImage(String string, boolean bl) throws IOException {
        String string2 = library.searchFileName(string);
        if (string2 == null) {
            throw new IOException(string + ": No such image in Library.");
        }
        this.commonConstructor(string2);
    }

    public int read(long l, byte[] byArray, int n) {
        if (l + (long)n > this.totalSectors) {
            System.err.println("Warning: Trying to read invalid sector range " + l + "-" + (l + (long)n - 1L) + ".");
            return -1;
        }
        for (int i = 0; i < n; ++i) {
            if (this.copyOnWriteData != null && this.copyOnWriteData[(int)l] != null) {
                System.arraycopy(this.copyOnWriteData[(int)l], 0, byArray, 512 * i, 512);
            } else if (l < (long)this.sectorOffsetMap.length && this.sectorOffsetMap[(int)l] > 0) {
                try {
                    this.image.seek(this.sectorOffsetMap[(int)l]);
                    this.image.read(byArray, 512 * i, 512);
                }
                catch (IOException iOException) {
                    System.err.println("Error: Failed to read sector " + l + ".");
                    return -1;
                }
            } else {
                System.arraycopy(this.blankPage, 0, byArray, 512 * i, 512);
            }
            ++l;
        }
        return 0;
    }

    public int write(long l, byte[] byArray, int n) {
        if (this.readOnly) {
            return -1;
        }
        if (l + (long)n > this.totalSectors) {
            System.err.println("Warning: Trying to write invalid sector range " + l + "-" + (l + (long)n - 1L) + ".");
            return -1;
        }
        for (int i = 0; i < n; ++i) {
            if (this.copyOnWriteData[(int)l] == null) {
                this.copyOnWriteData[(int)l] = new byte[512];
            }
            System.arraycopy(byArray, 512 * i, this.copyOnWriteData[(int)l], 0, 512);
            ++l;
        }
        return 512 * n;
    }

    public void use() throws IOException {
        if (this.busy) {
            throw new IOException("Trying to use busy disk!");
        }
        this.busy = true;
        this.used = true;
    }

    public void unuse() {
        this.busy = false;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public BlockDevice.Type getType() {
        return this.type;
    }

    public long getTotalSectors() {
        return this.totalSectors;
    }

    public int getHeads() {
        return this.heads;
    }

    public int getCylinders() {
        return this.cylinders;
    }

    public int getSectors() {
        return this.sectors;
    }

    public String getImageFileName() {
        return this.imageFileName;
    }

    public void setWP(boolean bl) {
        if (this.type == BlockDevice.Type.FLOPPY) {
            this.readOnly = bl;
        }
    }

    public String getName() {
        return this.imageName;
    }

    public void setName(String string) {
        this.imageName = string;
    }
}

