/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.diskimages;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jpc.diskimages.TreeFile;
import org.jpc.diskimages.TreeRegularFile;

public class TreeDirectoryFile
extends TreeFile {
    protected TreeMap<String, TreeFile> entries = new TreeMap();
    protected String volumeName = null;
    private int dosTime;
    private String _timestamp;
    protected int cachedPosition = 0;
    protected String cachedKey = null;

    private static byte convertCodepoint(int n) throws IOException {
        if (n == 33 || n >= 35 && n <= 41 || n == 45 || n == 125 || n == 126) {
            return (byte)n;
        }
        if (n >= 48 && n <= 57) {
            return (byte)n;
        }
        if (n >= 64 && n <= 90) {
            return (byte)n;
        }
        if (n >= 97 && n <= 122) {
            return (byte)(n - 32);
        }
        if (n >= 94 && n <= 123) {
            return (byte)n;
        }
        if (n >= 160 && n <= 255) {
            return (byte)n;
        }
        throw new IOException("Character " + (char)n + " not allowed in filename.");
    }

    public static void writeEntryName(byte[] byArray, String string, int n, boolean bl) throws IOException {
        int n2;
        int n3;
        for (n3 = 0; n3 < 11; ++n3) {
            byArray[n + n3] = 32;
        }
        n3 = string.indexOf(".");
        if (!bl ? n3 >= 0 && (n3 < 1 || n3 > 8 || string.length() > n3 + 4) || n3 < 0 && string.length() > 8 : string.length() < 1 || string.length() > 11) {
            throw new IOException("Illegal file name " + string + ".");
        }
        if (n3 < 0) {
            n3 = string.length();
        }
        String string2 = string.substring(0, n3);
        String string3 = n3 > 0 && n3 < string.length() ? string.substring(n3 + 1) : "";
        for (n2 = 0; n2 < string2.length(); ++n2) {
            byArray[n + n2] = TreeDirectoryFile.convertCodepoint(string2.charAt(n2));
        }
        for (n2 = 0; n2 < string3.length(); ++n2) {
            byArray[n + 8 + n2] = TreeDirectoryFile.convertCodepoint(string3.charAt(n2));
        }
    }

    public TreeDirectoryFile(String string, String string2) throws IOException {
        super(string);
        if (string2 == null) {
            string2 = "19900101000000";
        }
        this._timestamp = string2;
        this.dosTime = TreeDirectoryFile.dosFormatTimeStamp(string2);
    }

    public TreeDirectoryFile(String string, String string2, String string3) throws IOException {
        this(string, string3);
        this.volumeName = string2;
    }

    @Override
    public void setClusterZeroOffset(int n) {
        this.doSetClusterZeroOffset(n);
        Map.Entry<String, TreeFile> entry = this.entries.firstEntry();
        while (entry != null) {
            entry.getValue().setClusterZeroOffset(n);
            entry = this.entries.higherEntry(entry.getKey());
        }
    }

    @Override
    public void setClusterSize(int n) {
        this.doSetClusterSize(n);
        Map.Entry<String, TreeFile> entry = this.entries.firstEntry();
        while (entry != null) {
            entry.getValue().setClusterSize(n);
            entry = this.entries.higherEntry(entry.getKey());
        }
    }

    @Override
    public int getSize() {
        int n = 0;
        if (this.volumeName != null) {
            n = 1;
        }
        return 32 * this.entries.size() + n;
    }

    public static int dosFormatTimeStamp(String string) throws IOException {
        if (string.length() != 14) {
            throw new IOException("Invalid timestamp " + string + ".");
        }
        try {
            long l = Long.parseLong(string, 10);
            if (l < 19800101000000L || l > 21071231235959L) {
                throw new IOException("Invalid timestamp " + string + ".");
            }
            int n = (int)(l / 10000000000L) - 1980;
            int n2 = (int)(l % 10000000000L / 100000000L);
            int n3 = (int)(l % 100000000L / 1000000L);
            int n4 = (int)(l % 1000000L / 10000L);
            int n5 = (int)(l % 10000L / 100L);
            int n6 = (int)(l % 100L) / 2;
            if (n2 < 1 || n2 > 12 || n3 < 0 || n3 > 31 || n4 > 23 || n5 > 59 || n6 > 59) {
                throw new IOException("Invalid timestamp " + string + ".");
            }
            if (n3 == 30 && (n2 == 2 || n2 == 4 || n2 == 6 || n2 == 9 || n2 == 11)) {
                throw new IOException("Invalid timestamp " + string + ".");
            }
            if (n3 == 29 && n2 == 2 && (n % 4 != 0 || n == 120)) {
                throw new IOException("Invalid timestamp " + string + ".");
            }
            return n * 0x2000000 + n2 * 0x200000 + n3 * 65536 + n4 * 2048 + n5 * 32 + n6;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Invalid timestamp " + string + ".");
        }
    }

    @Override
    public void readSector(int n, byte[] byArray) throws IOException {
        int n2 = 0;
        if (this.volumeName != null) {
            ++n2;
        }
        if (n >= (this.entries.size() + n2 + 15) / 16) {
            for (int i = 0; i < 512; ++i) {
                byArray[i] = 0;
            }
            return;
        }
        if (this.cachedKey == null || this.cachedPosition > 16 * n) {
            this.cachedPosition = n2;
            try {
                this.cachedKey = this.entries.firstKey();
            }
            catch (Exception exception) {
                this.cachedKey = null;
            }
        }
        while (this.cachedPosition < 16 * n) {
            ++this.cachedPosition;
            this.cachedKey = this.entries.higherKey(this.cachedKey);
        }
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 32; ++j) {
                byArray[32 * i + j] = 0;
            }
            byArray[32 * i + 22] = (byte)(this.dosTime & 0xFF);
            byArray[32 * i + 23] = (byte)(this.dosTime >> 8 & 0xFF);
            byArray[32 * i + 24] = (byte)(this.dosTime >> 16 & 0xFF);
            byArray[32 * i + 25] = (byte)(this.dosTime >> 24 & 0xFF);
            if (this.volumeName != null && n == 0 && i == 0) {
                TreeDirectoryFile.writeEntryName(byArray, this.volumeName, 32 * i, true);
                byArray[32 * i + 11] = 8;
                continue;
            }
            if (this.cachedKey == null) continue;
            TreeFile treeFile = this.entries.get(this.cachedKey);
            TreeDirectoryFile.writeEntryName(byArray, this.cachedKey, 32 * i, false);
            byArray[32 * i + 11] = treeFile instanceof TreeDirectoryFile ? 16 : 0;
            int n3 = treeFile.getSize();
            int n4 = treeFile.getStartCluster();
            if (n3 == 0) {
                n4 = 0;
            }
            byArray[32 * i + 26] = (byte)(n4 & 0xFF);
            byArray[32 * i + 27] = (byte)(n4 >>> 8 & 0xFF);
            byArray[32 * i + 28] = (byte)(n3 & 0xFF);
            byArray[32 * i + 29] = (byte)(n3 >>> 8 & 0xFF);
            byArray[32 * i + 30] = (byte)(n3 >>> 16 & 0xFF);
            byArray[32 * i + 31] = (byte)(n3 >>> 24 & 0xFF);
            ++this.cachedPosition;
            this.cachedKey = this.entries.higherKey(this.cachedKey);
        }
    }

    @Override
    public void readSectorEnd() {
    }

    @Override
    public int assignCluster(int n) {
        this.setStartCluster(n);
        if ((n += this.getSizeInClusters()) < 2) {
            n = 2;
        }
        Map.Entry<String, TreeFile> entry = this.entries.firstEntry();
        while (entry != null) {
            n = entry.getValue().assignCluster(n);
            entry = this.entries.higherEntry(entry.getKey());
        }
        return n;
    }

    @Override
    public TreeFile nextFile() {
        Map.Entry<String, TreeFile> entry = this.entries.firstEntry();
        if (entry == null) {
            if (this.parent == null) {
                return null;
            }
            return this.parent.nextFile(this.selfName);
        }
        return entry.getValue();
    }

    @Override
    protected TreeFile nextFile(String string) {
        Map.Entry<String, TreeFile> entry = this.entries.higherEntry(string);
        if (entry == null) {
            if (this.parent == null) {
                return null;
            }
            return this.parent.nextFile(this.selfName);
        }
        return entry.getValue();
    }

    @Override
    public void addFile(TreeFile treeFile) throws IOException {
        this.entries.put(treeFile.getSelfName(), treeFile);
        treeFile.parentTo(this);
    }

    public TreeDirectoryFile pathToDirectory(String string, String string2, String string3) throws IOException {
        TreeFile treeFile;
        String string4;
        String string5;
        if (string == null || "".equals(string)) {
            return this;
        }
        int n = string.indexOf(47);
        if (n == -1) {
            string5 = string;
            string4 = "";
        } else {
            string5 = string.substring(0, n);
            string4 = string.substring(n + 1);
        }
        string2 = string2 != null && string2 != "" ? string2 + "/" + string5 : string5;
        if (!this.entries.containsKey(string5)) {
            this.addFile(new TreeDirectoryFile(string5, string3));
        }
        if ((treeFile = this.entries.get(string5)) == null) {
            throw new IOException("What? Didn't I create " + string2 + "???");
        }
        if (!(treeFile instanceof TreeDirectoryFile)) {
            throw new IOException("Conflicting types for " + string2 + ". Was regular file, now should be directory?");
        }
        TreeDirectoryFile treeDirectoryFile = (TreeDirectoryFile)treeFile;
        return treeDirectoryFile.pathToDirectory(string4, string2, string3);
    }

    public static void importTree(File file, String string, TreeDirectoryFile treeDirectoryFile, String string2) throws IOException {
        TreeDirectoryFile treeDirectoryFile2 = treeDirectoryFile.pathToDirectory(string, null, string2);
        if (!file.isDirectory()) {
            throw new IOException("Okay, who passed non-directory " + file.getAbsolutePath() + " to importTree()?");
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            throw new IOException("Can't read directory " + file.getAbsolutePath() + ".");
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                if (string == null) {
                    TreeDirectoryFile.importTree(fileArray[i], fileArray[i].getName(), treeDirectoryFile, string2);
                    continue;
                }
                TreeDirectoryFile.importTree(fileArray[i], string + "/" + fileArray[i].getName(), treeDirectoryFile, string2);
                continue;
            }
            treeDirectoryFile2.addFile(new TreeRegularFile(fileArray[i].getName(), fileArray[i].getAbsolutePath()));
        }
    }

    public static TreeDirectoryFile importTree(String string, String string2, String string3) throws IOException {
        TreeDirectoryFile treeDirectoryFile = new TreeDirectoryFile("", string2, string3);
        TreeDirectoryFile.importTree(new File(string), null, treeDirectoryFile, string3);
        return treeDirectoryFile;
    }

    private String nformatwidth(int n, int n2) {
        String string = new Integer(n).toString();
        while (string.length() < n2) {
            string = " " + string;
        }
        return string;
    }

    @Override
    public List<String> getComments(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string2 == null) {
            string2 = "N/A           ";
        }
        String string3 = "N/A                             ";
        arrayList.add("Entry: " + string2 + " " + string3 + " " + this.nformatwidth(this.entries.size(), 10) + " " + string + "/");
        if (this.volumeName != null) {
            arrayList.add("Vname: " + this._timestamp + " " + string3 + " " + this.nformatwidth(0, 10) + " " + this.volumeName);
        }
        Map.Entry<String, TreeFile> entry = this.entries.firstEntry();
        while (entry != null) {
            List<String> list = entry.getValue().getComments(string + "/" + entry.getKey(), this._timestamp);
            arrayList.addAll(list);
            entry = this.entries.higherEntry(entry.getKey());
        }
        return arrayList;
    }
}

