/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.diskimages;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.jpc.diskimages.ImageMaker;
import org.jpc.diskimages.RawDiskImage;
import org.jpc.diskimages.TreeDirectoryFile;
import org.jpc.diskimages.TreeFile;

public class TreeRawDiskImage
implements RawDiskImage {
    String volumeLabel;
    TreeFile root;
    ImageMaker.IFormat diskGeometry;
    int partitionStart;
    int primaryFATStart;
    int secondaryFATStart;
    int rootDirectoryStart;
    int dataAreaStart;
    int sectorsTotal;
    int sectorsPartition;
    int fatSize;
    int rootDirectorySize;
    int rootDirectoryClusters;
    int clusterSize;
    int usableClusters;
    int reservedSectors;
    int fatType;
    int mbrSector;
    int superBlockSector;
    int firstUnusedCluster;
    int sectorLimit;
    int[] fat;
    HashMap<Integer, TreeFile> clusterToFile;
    TreeFile lastCached;
    private static final int MAX_FAT16_CLUSTERS = 65518;
    private static final int MAX_FAT12_CLUSTERS = 4078;

    private void computeParameters(ImageMaker.IFormat iFormat, TreeFile treeFile, int n, int n2) throws Exception {
        this.clusterSize = n;
        this.fatType = n2;
        this.root = treeFile;
        this.diskGeometry = iFormat;
        this.rootDirectorySize = this.root.getSizeInSectors();
        if (this.rootDirectorySize < 32) {
            this.rootDirectorySize = 32;
        }
        this.rootDirectorySize = (this.rootDirectorySize + this.clusterSize - 1) / this.clusterSize * this.clusterSize;
        if (iFormat.typeCode == 1) {
            this.superBlockSector = this.partitionStart = iFormat.sides * iFormat.sectors;
            this.sectorsTotal = iFormat.sides * iFormat.sectors * iFormat.tracks;
            this.sectorsPartition = this.sectorsTotal - iFormat.sides * iFormat.sectors;
            this.mbrSector = 0;
        } else {
            this.partitionStart = 0;
            this.superBlockSector = 0;
            this.sectorsTotal = this.sectorsPartition = iFormat.sides * iFormat.sectors * iFormat.tracks;
            this.mbrSector = -1;
        }
        this.reservedSectors = this.sectorsPartition - this.rootDirectorySize - 1;
        if (this.reservedSectors < 2 + this.clusterSize) {
            throw new Exception("Specified parameters for FAT are impossible to satisfy.");
        }
        if (n2 == 0) {
            if (this.reservedSectors > 2 + 254 * this.clusterSize) {
                this.usableClusters = 254;
                this.reservedSectors -= 2 + 254 * this.clusterSize;
                this.usableClusters += 256 * this.reservedSectors / (2 + 256 * this.clusterSize);
                this.reservedSectors %= 2 + 256 * this.clusterSize;
                if (this.reservedSectors >= 2 + this.clusterSize) {
                    this.usableClusters += (this.reservedSectors - 2) / this.clusterSize;
                    this.reservedSectors = (this.reservedSectors - 2) % this.clusterSize;
                }
            } else {
                this.usableClusters = (this.reservedSectors - 2) / this.clusterSize;
                this.reservedSectors = (this.reservedSectors - 2) % this.clusterSize;
            }
            if (this.usableClusters > 65518) {
                throw new Exception("Specified parameters for FAT are impossible to satisfy.");
            }
            this.fatSize = (this.usableClusters + 257) / 256;
        } else if (n2 == 1) {
            if (this.reservedSectors > 6 + 1022 * this.clusterSize) {
                this.usableClusters = 1022;
                this.reservedSectors -= 6 + 1022 * this.clusterSize;
                this.usableClusters += 1024 * (this.reservedSectors / (6 + 1024 * this.clusterSize));
                this.reservedSectors %= 6 + 1024 * this.clusterSize;
                int n3 = this.reservedSectors / this.clusterSize;
                while (n3 * this.clusterSize + 2 * ((3 * n3 + 1023) / 1024) > this.reservedSectors) {
                    --n3;
                }
                this.usableClusters += n3;
                this.reservedSectors -= n3 * this.clusterSize + 2 * ((3 * n3 + 1023) / 1024);
            } else {
                int n4 = this.reservedSectors / this.clusterSize;
                while (n4 * this.clusterSize + 2 * ((3 * (n4 + 2) + 1023) / 1024) > this.reservedSectors) {
                    --n4;
                }
                this.usableClusters += n4;
                this.reservedSectors -= n4 * this.clusterSize + 2 * ((3 * n4 + 1023) / 1024);
            }
            if (this.usableClusters > 4078) {
                throw new Exception("Specified parameters for FAT are impossible to satisfy.");
            }
            this.fatSize = (3 * (this.usableClusters + 2) + 1023) / 1024;
        } else {
            throw new Exception("Invalid FAT type code " + n2 + ".");
        }
        this.rootDirectoryClusters = this.rootDirectorySize / this.clusterSize;
        this.primaryFATStart = this.partitionStart + 1 + this.reservedSectors;
        this.secondaryFATStart = this.primaryFATStart + this.fatSize;
        this.rootDirectoryStart = this.secondaryFATStart + this.fatSize;
        this.dataAreaStart = this.rootDirectoryStart + this.rootDirectorySize;
    }

    public TreeRawDiskImage(TreeFile treeFile, ImageMaker.IFormat iFormat, String string) throws IOException {
        int n = iFormat.tracks * iFormat.sides * iFormat.sectors;
        this.volumeLabel = string;
        if (iFormat.typeCode != 0 && iFormat.typeCode != 1) {
            throw new IOException("Unsupported image type. Only floppies and HDDs are supported.");
        }
        if (iFormat.typeCode == 1) {
            n -= iFormat.sides * iFormat.sectors;
        }
        int n2 = n < 65536 ? 1 : 0;
        boolean bl = false;
        int n3 = 1;
        while (!bl) {
            try {
                this.computeParameters(iFormat, treeFile, n3, n2);
                bl = true;
            }
            catch (Exception exception) {
                n3 = 2 * n3;
            }
        }
        this.root.setClusterSize(this.clusterSize);
        this.firstUnusedCluster = this.root.assignCluster(2 - this.rootDirectoryClusters);
        this.sectorLimit = this.dataAreaStart + (this.firstUnusedCluster - 2) * this.clusterSize;
        if (this.sectorLimit > this.sectorsTotal) {
            throw new IOException("Too much data to fit into given space.");
        }
        this.fat = new int[this.firstUnusedCluster + 350];
        this.clusterToFile = new HashMap();
        for (TreeFile treeFile2 = this.root.nextFile(); treeFile2 != null; treeFile2 = treeFile2.nextFile()) {
            int n4 = treeFile2.getStartCluster();
            int n5 = treeFile2.getEndCluster();
            for (int i = n4; i <= n5; ++i) {
                this.fat[i] = i == n5 ? 65535 : i + 1;
                this.clusterToFile.put(new Integer(i), treeFile2);
            }
        }
    }

    @Override
    public int getSectorCount() throws IOException {
        return this.sectorsTotal;
    }

    private void writeWord(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(n2 & 0xFF);
        byArray[n + 1] = (byte)(n2 >>> 8 & 0xFF);
    }

    private void writeDWord(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(n2 & 0xFF);
        byArray[n + 1] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n + 2] = (byte)(n2 >>> 16 & 0xFF);
        byArray[n + 3] = (byte)(n2 >>> 24 & 0xFF);
    }

    private void writeGeometry(byte[] byArray, int n, int n2, int n3, int n4) {
        byArray[n] = (byte)(n3 & 0xFF);
        byArray[n + 1] = (byte)(n4 + ((n2 & 0x300) >>> 2));
        byArray[n + 2] = (byte)(n2 & 0xFF);
    }

    @Override
    public boolean readSector(int n, byte[] byArray) throws IOException {
        byte[] byArray2 = new byte[512];
        System.arraycopy(byArray2, 0, byArray, 0, 512);
        if (this.isSectorEmpty(n)) {
            return false;
        }
        if (n == this.mbrSector) {
            this.writeWord(byArray, 0, 65259);
            byArray[446] = -128;
            this.writeGeometry(byArray, 447, 1, 0, 1);
            byArray[450] = this.fatType == 1 ? 1 : (this.sectorsPartition >= 65536 ? 6 : 2);
            this.writeGeometry(byArray, 451, this.diskGeometry.tracks - 1, this.diskGeometry.sides - 1, this.diskGeometry.sectors);
            this.writeDWord(byArray, 454, this.partitionStart);
            this.writeDWord(byArray, 458, this.sectorsPartition);
            this.writeWord(byArray, 510, 43605);
            return true;
        }
        if (n == this.superBlockSector) {
            this.writeWord(byArray, 0, 15595);
            byArray[2] = -112;
            this.writeDWord(byArray, 3, 1380143178);
            this.writeDWord(byArray, 7, 1145785682);
            this.writeWord(byArray, 11, 512);
            this.writeWord(byArray, 13, this.clusterSize);
            byArray[13] = (byte)this.clusterSize;
            this.writeWord(byArray, 14, this.reservedSectors + 1);
            byArray[16] = 2;
            this.writeWord(byArray, 17, this.rootDirectorySize * 16);
            if (this.sectorsPartition < 65536) {
                this.writeWord(byArray, 19, this.sectorsPartition);
            } else {
                this.writeWord(byArray, 19, 0);
            }
            byArray[21] = this.diskGeometry.typeCode == 1 ? -8 : -16;
            this.writeWord(byArray, 22, this.fatSize);
            this.writeWord(byArray, 24, this.diskGeometry.sectors);
            this.writeWord(byArray, 26, this.diskGeometry.sides);
            this.writeDWord(byArray, 28, 0);
            this.writeDWord(byArray, 32, this.sectorsPartition);
            this.writeWord(byArray, 36, 128);
            byArray[38] = 41;
            this.writeDWord(byArray, 39, -559038737);
            if (this.volumeLabel == null) {
                this.writeDWord(byArray, 43, 0);
                this.writeDWord(byArray, 47, 0);
                this.writeWord(byArray, 51, 0);
                byArray[53] = 0;
            } else {
                TreeDirectoryFile.writeEntryName(byArray, this.volumeLabel, 43, true);
            }
            this.writeDWord(byArray, 54, 827605318);
            if (this.fatType == 0) {
                this.writeDWord(byArray, 58, 538976310);
            } else {
                this.writeDWord(byArray, 58, 0x20202032);
            }
            this.writeWord(byArray, 62, 65259);
            this.writeWord(byArray, 510, 43605);
        } else if (n < this.rootDirectoryStart) {
            int n2 = (n - this.primaryFATStart) % this.fatSize;
            if (this.fatType == 0) {
                int n3 = 256 * n2;
                for (int i = 0; i < 256; ++i) {
                    this.writeWord(byArray, 2 * i, this.fat[n3 + i]);
                }
            } else {
                int n4 = 1024 * n2;
                for (int i = 0; i < 512; ++i) {
                    int n5 = n4 + 2 * i;
                    byte by = (byte)(this.fat[n5 / 3] >> 4 * (n5 % 3) & 0xF);
                    byte by2 = (byte)(this.fat[(n5 + 1) / 3] >> 4 * ((n5 + 1) % 3) & 0xF);
                    byArray[i] = (byte)(by2 << 4 | by);
                }
            }
        } else if (n < this.dataAreaStart) {
            this.root.readSector(n - this.rootDirectoryStart, byArray);
        } else {
            int n6 = 2 + (n - this.dataAreaStart) / this.clusterSize;
            TreeFile treeFile = this.clusterToFile.get(new Integer(n6));
            if (treeFile != this.lastCached && this.lastCached != null) {
                this.lastCached.readSectorEnd();
            }
            this.lastCached = treeFile;
            if (treeFile != null) {
                int n7 = this.dataAreaStart + (treeFile.getStartCluster() - 2) * this.clusterSize;
                treeFile.readSector(n - n7, byArray);
            }
        }
        return true;
    }

    @Override
    public boolean isSectorEmpty(int n) throws IOException {
        if (n == this.mbrSector || n == this.superBlockSector) {
            return false;
        }
        if (n < this.primaryFATStart) {
            return true;
        }
        if (n < this.rootDirectoryStart) {
            int n2 = (n - this.primaryFATStart) % this.fatSize;
            int n3 = this.fatType == 0 ? 2 + 256 * n2 : 2 + 1024 * n2 / 3;
            return n3 >= this.firstUnusedCluster + 2;
        }
        return n >= this.sectorLimit;
    }

    @Override
    public List<String> getComments() {
        List<String> list = this.root.getComments("", null);
        return list;
    }
}

