/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator;

import java.io.IOException;
import org.jpc.emulator.AbstractHardwareComponent;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.Timer;
import org.jpc.emulator.TimerPriorityQueue;
import org.jpc.emulator.TimerResponsive;

public class Clock
extends AbstractHardwareComponent {
    private TimerPriorityQueue timers;
    private long currentTime;
    private long lastUpdateAt;
    private long currentMillisecs;
    private long lastMillisecs;

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        super.dumpSRPartial(sRDumper);
        sRDumper.dumpObject(this.timers);
        sRDumper.dumpLong(this.currentTime);
    }

    public Clock(SRLoader sRLoader) throws IOException {
        super(sRLoader);
        this.timers = (TimerPriorityQueue)sRLoader.loadObject();
        this.currentTime = sRLoader.loadLong();
        this.currentMillisecs = 0L;
        this.lastMillisecs = 0L;
        this.lastUpdateAt = 0L;
    }

    public Clock() {
        this.timers = new TimerPriorityQueue();
        this.currentTime = 0L;
    }

    @Override
    public void dumpStatusPartial(StatusDumper statusDumper) {
        super.dumpStatusPartial(statusDumper);
        statusDumper.println("\tcurrentTime " + this.currentTime);
        statusDumper.println("\ttimers <object #" + statusDumper.objectNumber(this.timers) + ">");
        if (this.timers != null) {
            this.timers.dumpStatus(statusDumper);
        }
    }

    @Override
    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": Clock:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    public synchronized Timer newTimer(TimerResponsive timerResponsive) {
        Timer timer = new Timer(timerResponsive, this);
        return timer;
    }

    public synchronized void update(Timer timer) {
        this.timers.remove(timer);
        if (timer.enabled()) {
            this.timers.offer(timer);
        }
    }

    public long getTime() {
        return this.currentTime;
    }

    public long getTickRate() {
        return 1000000000L;
    }

    public void pause() {
        long l = System.currentTimeMillis();
        this.currentMillisecs += l - this.lastUpdateAt;
        this.lastUpdateAt = l;
    }

    public void resume() {
        this.lastUpdateAt = System.currentTimeMillis();
    }

    @Override
    public void reset() {
    }

    public String toString() {
        return "Clock";
    }

    public static long timePasses(Clock clock, int n) {
        Timer timer;
        if (clock.currentTime % 1000000000L > (clock.currentTime + (long)n) % 1000000000L) {
            long l = System.currentTimeMillis();
            clock.currentMillisecs += l - clock.lastUpdateAt;
            long l2 = clock.currentMillisecs - clock.lastMillisecs;
            if (l2 < 1L) {
                l2 = 1L;
            }
            clock.lastUpdateAt = l;
            System.err.println("Informational: Timer ticked " + (clock.currentTime + (long)n) + ", realtime: " + l2 + "ms, " + 100000L / l2 + "%," + " kips: " + (long)(1000000000 / n) / l2 + ".");
            clock.lastMillisecs = clock.currentMillisecs;
        }
        clock.currentTime += (long)n;
        while ((timer = clock.timers.peek()) != null && timer.check(clock.getTime())) {
        }
        if (timer == null || !timer.enabled()) {
            return -1L;
        }
        return timer.getExpiry();
    }

    public long getNextEventTime() {
        Timer timer = this.timers.peek();
        if (timer == null || !timer.enabled()) {
            return -1L;
        }
        return timer.getExpiry();
    }
}

