/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator;

import java.io.IOException;
import org.jpc.diskimages.BlockDevice;
import org.jpc.diskimages.GenericBlockDevice;
import org.jpc.emulator.AbstractHardwareComponent;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;

public class DriveSet
extends AbstractHardwareComponent {
    private BootType bootType;
    private BlockDevice[] ides;

    @Override
    public void dumpStatusPartial(StatusDumper statusDumper) {
        super.dumpStatusPartial(statusDumper);
        statusDumper.println("\tbootType " + (Object)((Object)this.bootType));
        for (int i = 0; i < this.ides.length; ++i) {
            statusDumper.println("\tides[" + i + "] <object #" + statusDumper.objectNumber(this.ides[i]) + ">");
            if (this.ides[i] == null) continue;
            this.ides[i].dumpStatus(statusDumper);
        }
    }

    @Override
    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": DriveSet:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        super.dumpSRPartial(sRDumper);
        sRDumper.dumpByte(BootType.toNumeric(this.bootType));
        sRDumper.dumpInt(this.ides.length);
        for (int i = 0; i < this.ides.length; ++i) {
            sRDumper.dumpObject(this.ides[i]);
        }
    }

    public DriveSet(SRLoader sRLoader) throws IOException {
        super(sRLoader);
        this.bootType = BootType.fromNumeric(sRLoader.loadByte());
        this.ides = new BlockDevice[sRLoader.loadInt()];
        for (int i = 0; i < this.ides.length; ++i) {
            this.ides[i] = (BlockDevice)sRLoader.loadObject();
        }
    }

    public DriveSet(BootType bootType, BlockDevice blockDevice, BlockDevice blockDevice2, BlockDevice blockDevice3, BlockDevice blockDevice4) {
        this.bootType = bootType;
        this.ides = new BlockDevice[4];
        this.ides[0] = blockDevice;
        this.ides[1] = blockDevice2;
        this.ides[2] = blockDevice3 == null ? new GenericBlockDevice(BlockDevice.Type.CDROM) : blockDevice3;
        this.ides[3] = blockDevice4;
    }

    public BlockDevice getHardDrive(int n) {
        return this.ides[n];
    }

    public void setHardDrive(int n, BlockDevice blockDevice) {
        this.ides[n] = blockDevice;
    }

    public BootType getBootType() {
        return this.bootType;
    }

    public static enum BootType {
        FLOPPY,
        HARD_DRIVE,
        CDROM;


        public static byte toNumeric(BootType bootType) {
            if (bootType == FLOPPY) {
                return 1;
            }
            if (bootType == HARD_DRIVE) {
                return 2;
            }
            if (bootType == CDROM) {
                return 3;
            }
            return 0;
        }

        public static BootType fromNumeric(byte by) {
            if (by == 1) {
                return FLOPPY;
            }
            if (by == 2) {
                return HARD_DRIVE;
            }
            if (by == 3) {
                return CDROM;
            }
            return null;
        }
    }
}

