/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator;

import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import org.jpc.Misc;
import org.jpc.emulator.Clock;
import org.jpc.emulator.EventDispatchTarget;
import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.PC;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.Timer;
import org.jpc.emulator.TimerResponsive;
import org.jpc.jrsr.UTFInputLineStream;
import org.jpc.jrsr.UTFOutputLineStream;

public class EventRecorder
implements TimerResponsive {
    private static final int EVENT_MAGIC_CLASS = 0;
    private static final int EVENT_MAGIC_SAVESTATE = 1;
    private static final int EVENT_MAGIC_NONE = -1;
    public static final int EVENT_TIMED = 0;
    public static final int EVENT_STATE_EFFECT_FUTURE = 1;
    public static final int EVENT_STATE_EFFECT = 2;
    public static final int EVENT_EXECUTE = 3;
    private Event first;
    private Event current;
    private Event last;
    private Event cache;
    private Event firstUndispatched;
    private Event lastUndispatched;
    private PC pc;
    private boolean directMode;
    private Clock sysClock;
    private Timer sysTimer;
    private long timerInvokeTime;
    private long savestateRerecordCount;
    private boolean dirtyFlag;
    private long cleanTime;
    private long attachTime;
    private String[][] headers;
    private long movieRerecordCount;

    private boolean isDirty() {
        return this.dirtyFlag || this.sysClock == null || this.cleanTime != this.sysClock.getTime();
    }

    private void setClean() {
        this.dirtyFlag = false;
        this.cleanTime = this.sysClock != null ? this.sysClock.getTime() : -1L;
    }

    public long getAttachTime() {
        return this.attachTime;
    }

    public long getRerecordCount() {
        return this.movieRerecordCount - this.savestateRerecordCount;
    }

    public void setRerecordCount(long l) {
        this.movieRerecordCount = l;
    }

    public String[][] getHeaders() {
        return this.headers;
    }

    public void setHeaders(String[][] stringArray) {
        if (stringArray == null) {
            this.headers = null;
            return;
        }
        String[][] stringArrayArray = new String[stringArray.length][];
        for (int i = 0; i < stringArrayArray.length; ++i) {
            if (stringArray[i] == null) continue;
            stringArrayArray[i] = Arrays.copyOf(stringArray[i], stringArray[i].length);
        }
        this.headers = stringArrayArray;
    }

    public void setTimer(long l) {
        if (this.directMode) {
            this.sysTimer.disable();
            return;
        }
        if (this.sysTimer.enabled() && this.timerInvokeTime <= l) {
            return;
        }
        this.timerInvokeTime = l;
        this.sysTimer.setExpiry(this.timerInvokeTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(long l, Class<? extends HardwareComponent> clazz, String[] stringArray) throws IOException {
        long l2 = this.sysClock.getTime();
        EventRecorder eventRecorder = this;
        synchronized (eventRecorder) {
            long l3 = l;
            if (this.last != null && l3 < this.last.timestamp) {
                l3 = this.last.timestamp;
            }
            if (l3 < l2) {
                l3 = l2;
            }
            HardwareComponent hardwareComponent = this.pc.getComponent(clazz);
            EventDispatchTarget eventDispatchTarget = (EventDispatchTarget)((Object)hardwareComponent);
            long l4 = -1L;
            try {
                l4 = eventDispatchTarget.getEventTimeLowBound(l3, stringArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (l3 < l4) {
                l3 = l4;
            }
            Event event = new Event();
            event.timestamp = l3;
            event.magic = 0;
            event.clazz = clazz;
            event.args = stringArray;
            if (this.firstUndispatched == null) {
                this.firstUndispatched = event;
            }
            if (this.lastUndispatched != null) {
                this.lastUndispatched.next = event;
            }
            event.prev = this.lastUndispatched;
            this.lastUndispatched = event;
        }
        if (this.directMode) {
            this.handleUndispatchedEvents();
        } else {
            this.setTimer(l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUndispatchedEvents() {
        long l = this.sysClock.getTime();
        EventRecorder eventRecorder = this;
        synchronized (eventRecorder) {
            Event event = this.firstUndispatched;
            while (event != null) {
                this.dirtyFlag = true;
                Event event2 = event.next;
                if (event.timestamp < l) {
                    event.timestamp = l;
                }
                if (this.last != null && event.timestamp < this.last.timestamp) {
                    event.timestamp = this.last.timestamp;
                }
                HardwareComponent hardwareComponent = this.pc.getComponent(event.clazz);
                EventDispatchTarget eventDispatchTarget = (EventDispatchTarget)((Object)hardwareComponent);
                long l2 = -1L;
                try {
                    l2 = eventDispatchTarget.getEventTimeLowBound(event.timestamp, event.args);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (event.timestamp < l2) {
                    event.timestamp = l2;
                }
                try {
                    event.dispatch(this.pc, 0);
                }
                catch (Exception exception) {
                    System.err.println("Error: Event dispatch failed.");
                    Misc.errorDialog(exception, "Failed to dispatch event", null, "Dismiss");
                    event = null;
                }
                if (event != null) {
                    event.sequenceNumber = this.last != null ? this.last.sequenceNumber + 1L : 0L;
                    event.next = null;
                    event.prev = this.last;
                    if (this.last != null) {
                        this.last.next = event;
                    }
                    this.last = event;
                    if (this.current == null) {
                        this.current = event;
                    }
                    if (this.first == null) {
                        this.first = event;
                    }
                }
                event = event2;
            }
            this.firstUndispatched = null;
            this.lastUndispatched = null;
        }
        while (this.current != null && this.current.timestamp <= l) {
            try {
                this.current.dispatch(this.pc, 3);
            }
            catch (Exception exception) {
                System.err.println("Error: Event dispatch failed.");
                Misc.errorDialog(exception, "Failed to dispatch event", null, "Dismiss");
            }
            this.current = this.current.next;
        }
        if (this.current != null) {
            this.setTimer(this.current.timestamp);
        }
    }

    public synchronized void setPCRunStatus(boolean bl) {
        boolean bl2 = this.directMode = !bl;
        if (this.directMode) {
            this.handleUndispatchedEvents();
        }
        if (this.current != null) {
            this.setTimer(this.current.timestamp);
        }
    }

    public void truncateEventStream() {
        if (this.current != null) {
            this.dirtyFlag = true;
            if (this.cache != null && this.current.sequenceNumber <= this.cache.sequenceNumber) {
                this.cache = null;
            }
            this.last = this.current.prev;
            this.current = null;
            if (this.last != null) {
                this.last.next = null;
            } else {
                this.first = null;
            }
            Event event = this.first;
            this.dispatchStart(this.pc);
            while (event != null) {
                try {
                    event.dispatch(this.pc, 2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                event = event.next;
            }
            try {
                this.dispatchEnd(this.pc);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.firstUndispatched = null;
        this.lastUndispatched = null;
    }

    private void dispatchStart(PC pC) {
        Set<HardwareComponent> set = pC.allComponents();
        for (HardwareComponent hardwareComponent : set) {
            if (!EventDispatchTarget.class.isAssignableFrom(hardwareComponent.getClass())) continue;
            EventDispatchTarget eventDispatchTarget = (EventDispatchTarget)((Object)hardwareComponent);
            eventDispatchTarget.setEventRecorder(this);
            eventDispatchTarget.startEventCheck();
        }
    }

    private void dispatchEnd(PC pC) throws IOException {
        Set<HardwareComponent> set = pC.allComponents();
        for (HardwareComponent hardwareComponent : set) {
            if (!EventDispatchTarget.class.isAssignableFrom(hardwareComponent.getClass())) continue;
            EventDispatchTarget eventDispatchTarget = (EventDispatchTarget)((Object)hardwareComponent);
            eventDispatchTarget.endEventCheck();
        }
    }

    public EventRecorder() {
        this.first = null;
        this.current = null;
        this.last = null;
        this.cache = null;
        this.firstUndispatched = null;
        this.lastUndispatched = null;
        this.directMode = true;
        this.dirtyFlag = true;
        this.cleanTime = -1L;
    }

    private static boolean isReservedName(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z') continue;
            return false;
        }
        return true;
    }

    public EventRecorder(UTFInputLineStream uTFInputLineStream) throws IOException {
        boolean bl = false;
        long l = 0L;
        this.dirtyFlag = true;
        this.cleanTime = -1L;
        String[] stringArray = Misc.nextParseLine(uTFInputLineStream);
        while (stringArray != null) {
            long l2;
            Event event = new Event();
            if (stringArray.length < 2) {
                throw new IOException("Malformed event line");
            }
            try {
                if (bl) {
                    l2 = l = Long.parseLong(stringArray[0]) + l;
                    event.timestamp = l;
                } else {
                    l2 = l = Long.parseLong(stringArray[0]);
                    event.timestamp = l;
                }
                if (l2 < 0L) {
                    throw new IOException("Negative timestamp value " + l2 + " not allowed");
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("Invalid timestamp value \"" + stringArray[0] + "\"");
            }
            if (this.last != null && l2 < this.last.timestamp) {
                throw new IOException("Timestamp order violation: " + l2 + "<" + this.last.timestamp);
            }
            String string = stringArray[1];
            if (string.equals("SAVESTATE")) {
                if (stringArray.length < 3 || stringArray.length > 4) {
                    throw new IOException("Malformed SAVESTATE line");
                }
                event.magic = 1;
                event.clazz = null;
                event.args = stringArray.length == 3 ? new String[]{stringArray[2], "0"} : new String[]{stringArray[2], stringArray[3]};
            } else if (string.equals("OPTION")) {
                if (stringArray.length != 3) {
                    throw new IOException("Malformed OPTION line");
                }
                if ("RELATIVE".equals(stringArray[2])) {
                    bl = true;
                } else if ("ABSOLUTE".equals(stringArray[2])) {
                    bl = false;
                } else {
                    throw new IOException("Unknown OPTION: '" + stringArray[2] + "'");
                }
                event.magic = -1;
            } else {
                Class<?> clazz;
                if (EventRecorder.isReservedName(string)) {
                    throw new IOException("Unknown special event type: '" + string + "'");
                }
                event.magic = 0;
                try {
                    clazz = Class.forName(string);
                    if (!EventDispatchTarget.class.isAssignableFrom(clazz)) {
                        throw new Exception("bad class");
                    }
                    if (!HardwareComponent.class.isAssignableFrom(clazz)) {
                        throw new Exception("bad class");
                    }
                }
                catch (Exception exception) {
                    throw new IOException("\"" + string + "\" is not valid event target");
                }
                event.clazz = clazz.asSubclass(HardwareComponent.class);
                if (stringArray.length == 2) {
                    event.args = null;
                } else {
                    event.args = new String[stringArray.length - 2];
                    System.arraycopy(stringArray, 2, event.args, 0, event.args.length);
                }
            }
            if (event.magic != -1) {
                event.prev = this.last;
                long l3 = event.sequenceNumber = this.last != null ? this.last.sequenceNumber + 1L : 0L;
                if (this.last == null) {
                    this.first = event;
                } else {
                    this.last.next = event;
                }
                this.last = event;
            }
            stringArray = Misc.nextParseLine(uTFInputLineStream);
        }
        this.firstUndispatched = null;
        this.lastUndispatched = null;
        this.directMode = true;
    }

    private void iterateIncrementSequence(Event event) {
        while (event != null) {
            ++event.sequenceNumber;
            event = event.next;
        }
    }

    public void markSave(String string, long l) throws IOException {
        if (!this.isDirty()) {
            l = this.savestateRerecordCount;
        } else {
            this.savestateRerecordCount = l;
        }
        Event event = new Event();
        event.timestamp = this.sysClock.getTime();
        event.magic = 1;
        event.clazz = null;
        event.args = new String[]{string, new Long(l).toString()};
        event.next = this.current;
        if (this.current != null) {
            event.sequenceNumber = this.current.sequenceNumber;
            this.iterateIncrementSequence(this.current);
            event.prev = this.current.prev;
            if (event.prev != null) {
                event.prev.next = event;
            }
            this.current.prev = event;
            event.next = this.current;
        } else {
            event.sequenceNumber = this.last != null ? this.last.sequenceNumber + 1L : 0L;
            event.prev = this.last;
            if (this.last != null) {
                this.last.next = event;
            }
            this.last = event;
        }
        if (event.prev == null) {
            this.first = event;
        }
        this.setClean();
    }

    public void attach(PC pC, String string) throws IOException {
        Event event;
        Event event2 = this.current;
        Clock clock = (Clock)pC.getComponent(Clock.class);
        long l = clock.getTime();
        long l2 = 0L;
        if (string == null) {
            this.current = this.first;
        } else {
            event = this.first;
            while (event != null) {
                if (event.magic == 1 && event.args[0].equals(string)) {
                    try {
                        if (event.args.length > 1) {
                            l2 = Long.parseLong(event.args[1]);
                        }
                        if (l2 < 0L) {
                            throw new NumberFormatException("Negative rerecord count not allowed");
                        }
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IOException("Savestate rerecord count invalid");
                    }
                }
                event = event.next;
            }
            if (event == null) {
                throw new IOException("Savestate not compatible with event stream");
            }
            if (event.timestamp != l) {
                throw new IOException("Incorrect savestate event timestamp");
            }
            this.current = event;
        }
        try {
            event = this.first;
            this.dispatchStart(pC);
            boolean bl = false;
            while (event != null) {
                if (event == this.current) {
                    bl = true;
                }
                if (bl) {
                    event.dispatch(pC, 1);
                } else {
                    event.dispatch(pC, 2);
                }
                event = event.next;
            }
            this.dispatchEnd(pC);
        }
        catch (IOException iOException) {
            this.current = event2;
            throw iOException;
        }
        this.pc = pC;
        this.sysClock = clock;
        this.sysTimer = this.sysClock.newTimer(this);
        this.directMode = true;
        this.timerInvokeTime = -1L;
        this.savestateRerecordCount = l2;
        this.attachTime = l;
        this.setClean();
        this.handleUndispatchedEvents();
    }

    public void saveEvents(UTFOutputLineStream uTFOutputLineStream) throws IOException {
        Event event = this.first;
        long l = 0L;
        uTFOutputLineStream.encodeLine("0", "OPTION", "RELATIVE");
        while (event != null) {
            if (event.magic == 1) {
                uTFOutputLineStream.encodeLine(event.timestamp - l, "SAVESTATE", event.args[0], event.args[1]);
            } else {
                int n = event.args != null ? event.args.length : 0;
                Object[] objectArray = new Object[2 + n];
                objectArray[0] = new Long(event.timestamp - l);
                objectArray[1] = event.clazz.getName();
                if (n > 0) {
                    System.arraycopy(event.args, 0, objectArray, 2, n);
                }
                uTFOutputLineStream.encodeLine(objectArray);
            }
            l = event.timestamp;
            event = event.next;
        }
    }

    public long getLastEventTime() {
        Event event = this.first;
        long l = 0L;
        while (event != null) {
            if (event.magic == 0) {
                l = event.timestamp;
            }
            event = event.next;
        }
        return l;
    }

    public boolean isAtMovieEnd() {
        return this.current == null;
    }

    public synchronized long getEventCount() {
        return this.last != null ? this.last.sequenceNumber + 1L : 0L;
    }

    public synchronized long getEventCurrentSequence() {
        return this.current != null ? this.current.sequenceNumber : -1L;
    }

    private String getReturnClass(Event event) {
        if (event.magic == 0) {
            return event.clazz.getName();
        }
        if (event.magic == 1) {
            return "SAVESTATE";
        }
        return "<BAD EVENT TYPE>";
    }

    private ReturnEvent convertToReturn(Event event) {
        ReturnEvent returnEvent = new ReturnEvent();
        returnEvent.timestamp = event.timestamp;
        if (event.args == null) {
            returnEvent.eventData = new String[1];
        } else {
            returnEvent.eventData = new String[1 + event.args.length];
            System.arraycopy(event.args, 0, returnEvent.eventData, 1, event.args.length);
        }
        returnEvent.eventData[0] = this.getReturnClass(event);
        return returnEvent;
    }

    private int sMinFour(long l, long l2, long l3, long l4) {
        long l5 = l;
        l5 = l2 > l5 ? l2 : l5;
        l5 = l3 > l5 ? l3 : l5;
        long l6 = l5 = l4 > l5 ? l4 : l5;
        if (l5 < 0L) {
            return -1;
        }
        l = l >= 0L ? l : l5 + 1L;
        l2 = l2 >= 0L ? l2 : l5 + 1L;
        l3 = l3 >= 0L ? l3 : l5 + 1L;
        l4 = l4 >= 0L ? l4 : l5 + 1L;
        long l7 = l;
        int n = 0;
        if (l2 < l7) {
            l7 = l2;
            n = 1;
        }
        if (l3 < l7) {
            l7 = l3;
            n = 2;
        }
        if (l4 < l7) {
            l7 = l4;
            n = 2;
        }
        return n;
    }

    public synchronized ReturnEvent getEventBySequence(long l) {
        if (l < 0L || this.last == null || l > this.last.sequenceNumber) {
            return null;
        }
        long l2 = -1L;
        long l3 = -1L;
        long l4 = -1L;
        long l5 = -1L;
        l2 = Math.abs(this.first.sequenceNumber - l);
        l3 = Math.abs(this.first.sequenceNumber - l);
        if (this.current != null) {
            l4 = Math.abs(this.current.sequenceNumber - l);
        }
        if (this.cache != null) {
            l5 = Math.abs(this.cache.sequenceNumber - l);
        }
        switch (this.sMinFour(l2, l3, l4, l5)) {
            case 0: {
                this.cache = this.first;
                break;
            }
            case 1: {
                this.cache = this.last;
                break;
            }
            case 2: {
                this.cache = this.current;
                break;
            }
            case 3: {
                break;
            }
            default: {
                return null;
            }
        }
        while (l < this.cache.sequenceNumber) {
            this.cache = this.cache.prev;
        }
        while (l > this.cache.sequenceNumber) {
            this.cache = this.cache.next;
        }
        return this.convertToReturn(this.cache);
    }

    @Override
    public void callback() {
        this.handleUndispatchedEvents();
    }

    @Override
    public int getTimerType() {
        return 17;
    }

    @Override
    public void dumpStatus(StatusDumper statusDumper) {
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) {
    }

    public class Event {
        public long timestamp;
        public long sequenceNumber;
        public int magic;
        public Class<? extends HardwareComponent> clazz;
        public String[] args;
        public Event prev;
        public Event next;

        public void dispatch(PC pC, int n) throws IOException {
            if (this.magic != 0) {
                return;
            }
            HardwareComponent hardwareComponent = pC.getComponent(this.clazz);
            if (hardwareComponent == null) {
                throw new IOException("Invalid event target \"" + this.clazz.getName() + "\": no component of such type");
            }
            EventDispatchTarget eventDispatchTarget = (EventDispatchTarget)((Object)hardwareComponent);
            eventDispatchTarget.doEvent(this.timestamp, this.args, n);
        }
    }

    public class ReturnEvent {
        public long timestamp;
        public String[] eventData;
    }
}

